/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.converter.SurjectiveConverter;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.OperationResult;
import org.apache.sis.feature.Property;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

final class StringJoinOperation
extends AbstractOperation {
    private static final long serialVersionUID = 2303047827010821381L;
    static final char ESCAPE = '\\';
    private static final ParameterDescriptorGroup EMPTY_PARAMS = StringJoinOperation.parameters("StringJoin", new ParameterDescriptor[0]);
    private final String[] attributeNames;
    private final ObjectConverter<? super String, ?>[] converters;
    private volatile transient Set<String> dependencies;
    private final DefaultAttributeType<String> resultType;
    final String prefix;
    final String suffix;
    final String delimiter;

    StringJoinOperation(Map<String, ?> identification, String delimiter, String prefix, String suffix, AbstractIdentifiedType[] singleAttributes, StringJoinOperation inheritFrom) {
        super(identification);
        this.attributeNames = new String[singleAttributes.length];
        this.converters = new ObjectConverter[singleAttributes.length];
        for (int i = 0; i < singleAttributes.length; ++i) {
            Object converter;
            AbstractIdentifiedType propertyType = singleAttributes[i];
            if (inheritFrom == null) {
                ArgumentChecks.ensureNonNullElement((String)"singleAttributes", (int)i, (Object)propertyType);
            } else if (propertyType == null) {
                this.attributeNames[i] = inheritFrom.attributeNames[i];
                this.converters[i] = inheritFrom.converters[i];
                continue;
            }
            GenericName name = propertyType.getName();
            int maximumOccurs = 0;
            IllegalArgumentException cause = null;
            boolean isAssociation = propertyType instanceof DefaultAssociationRole;
            if (isAssociation) {
                DefaultAssociationRole role = (DefaultAssociationRole)propertyType;
                DefaultFeatureType ft = role.getValueType();
                maximumOccurs = role.getMaximumOccurs();
                try {
                    propertyType = ft.getProperty("sis:identifier");
                }
                catch (IllegalArgumentException e) {
                    cause = e;
                }
            }
            if (propertyType instanceof AbstractOperation) {
                propertyType = ((AbstractOperation)propertyType).getResult();
            }
            if (!(propertyType instanceof DefaultAttributeType)) {
                Class[] inf = Classes.getLeafInterfaces((Class)Classes.getClass((Object)propertyType), AbstractIdentifiedType.class);
                throw new IllegalArgumentException(Resources.forProperties(identification).getString((short)29, name, inf.length != 0 ? inf[0] : null), cause);
            }
            if ((maximumOccurs |= ((DefaultAttributeType)propertyType).getMaximumOccurs()) > 1) {
                throw new IllegalArgumentException(Resources.forProperties(identification).getString((short)53, name));
            }
            this.attributeNames[i] = name.toString();
            Class valueClass = ((DefaultAttributeType)propertyType).getValueClass();
            try {
                converter = ObjectConverters.find(String.class, valueClass);
            }
            catch (UnconvertibleObjectException e) {
                throw new UnconvertibleObjectException(Resources.forProperties(identification).getString((short)29, name, valueClass), (Throwable)e);
            }
            if (isAssociation) {
                converter = new ForFeature((ObjectConverter<? super String, ?>)converter);
            }
            this.converters[i] = converter;
        }
        this.resultType = inheritFrom != null ? inheritFrom.resultType : (DefaultAttributeType)FeatureOperations.POOL.unique(new DefaultAttributeType<Object>(this.resultIdentification(identification), String.class, 1, 1, null, new DefaultAttributeType[0]));
        this.delimiter = delimiter;
        this.prefix = prefix == null ? "" : prefix;
        this.suffix = suffix == null ? "" : suffix;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return EMPTY_PARAMS;
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.resultType;
    }

    final List<String> getAttributeNames() {
        return UnmodifiableArrayList.wrap((Object[])this.attributeNames);
    }

    @Override
    public Set<String> getDependencies() {
        Set cached = this.dependencies;
        if (cached == null) {
            this.dependencies = cached = CollectionsExt.immutableSet((boolean)true, (Object[])this.attributeNames);
        }
        return cached;
    }

    @Override
    public AbstractOperation updateDependencies(Map<String, AbstractIdentifiedType> dependencies) {
        boolean hasNonNull = false;
        AbstractIdentifiedType[] singleAttributes = new AbstractIdentifiedType[this.attributeNames.length];
        for (int i = 0; i < singleAttributes.length; ++i) {
            singleAttributes[i] = dependencies.get(this.attributeNames[i]);
            hasNonNull |= singleAttributes[i] != null;
        }
        if (hasNonNull) {
            StringJoinOperation op = new StringJoinOperation(this.inherit(), this.delimiter, this.prefix, this.suffix, singleAttributes, this);
            if (!Arrays.equals(op.attributeNames, this.attributeNames) || !Arrays.equals(op.converters, this.converters)) {
                return (AbstractOperation)FeatureOperations.POOL.unique((Object)op);
            }
        }
        return this;
    }

    static <S> Object format(ObjectConverter<S, ?> converter, Object value) {
        return converter.apply(converter.getSourceClass().cast(value));
    }

    @Override
    public Property apply(AbstractFeature feature, ParameterValueGroup parameters) {
        return new Result(Objects.requireNonNull(feature));
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.attributeNames) + 37 * Objects.hash(this.delimiter, this.prefix, this.suffix);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            StringJoinOperation that = (StringJoinOperation)obj;
            return Arrays.equals(this.attributeNames, that.attributeNames) && Arrays.equals(this.converters, that.converters) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.suffix, that.suffix);
        }
        return false;
    }

    @Override
    void formatResultFormula(Appendable buffer) throws IOException {
        String escape = "\\" + this.delimiter;
        if (this.prefix != null) {
            buffer.append(this.prefix);
        }
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (i != 0) {
                buffer.append(this.delimiter);
            }
            buffer.append(this.attributeNames[i].replace(this.delimiter, escape));
        }
        if (this.suffix != null) {
            buffer.append(this.suffix);
        }
    }

    private static final class ForFeature
    extends SurjectiveConverter<Object, Object>
    implements Serializable {
        private static final long serialVersionUID = 2208230611402221572L;
        final ObjectConverter<? super String, ?> converter;

        ForFeature(ObjectConverter<? super String, ?> converter) {
            this.converter = converter;
        }

        public ObjectConverter<Object, Object> inverse() {
            return this;
        }

        public Class<Object> getSourceClass() {
            return Object.class;
        }

        public Class<Object> getTargetClass() {
            return Object.class;
        }

        public Object apply(Object f) {
            return f != null ? StringJoinOperation.format(this.converter.inverse(), ((AbstractFeature)f).getPropertyValue("sis:identifier")) : null;
        }
    }

    private final class Result
    extends OperationResult<String> {
        private static final long serialVersionUID = -555025854115540108L;

        Result(AbstractFeature feature) {
            super(StringJoinOperation.this.resultType, feature);
        }

        @Override
        public String getValue() throws UnconvertibleObjectException {
            StringBuilder sb = new StringBuilder();
            String sep = StringJoinOperation.this.prefix;
            String name = null;
            Object value = null;
            try {
                for (int i = 0; i < StringJoinOperation.this.attributeNames.length; ++i) {
                    name = StringJoinOperation.this.attributeNames[i];
                    value = this.feature.getPropertyValue(name);
                    value = StringJoinOperation.format(StringJoinOperation.this.converters[i].inverse(), value);
                    sb.append(sep);
                    sep = StringJoinOperation.this.delimiter;
                    if (value == null) continue;
                    int startAt = sb.length();
                    int j = sb.append(value).length();
                    while (--j >= startAt) {
                        if (sb.charAt(j) != '\\') continue;
                        sb.insert(j, '\\');
                    }
                    j = startAt;
                    while ((j = sb.indexOf(sep, j)) >= 0) {
                        sb.insert(j, '\\');
                        j += sep.length() + 1;
                    }
                }
            }
            catch (ClassCastException e) {
                if (value == null) {
                    throw e;
                }
                throw new UnconvertibleObjectException(Errors.format((short)81, name), (Throwable)e);
            }
            return sb.append(StringJoinOperation.this.suffix).toString();
        }

        @Override
        public void setValue(String value) throws IllegalArgumentException {
            int lower;
            int endAt = value.length() - StringJoinOperation.this.suffix.length();
            boolean prefixMatches = value.startsWith(StringJoinOperation.this.prefix);
            if (!prefixMatches || !value.endsWith(StringJoinOperation.this.suffix)) {
                throw new IllegalArgumentException(Errors.format((short)167, (Object)this.getName(), (Object)(prefixMatches ? 1 : 0), (Object)(prefixMatches ? StringJoinOperation.this.suffix : StringJoinOperation.this.prefix), (Object)(prefixMatches ? value.substring(Math.max(0, endAt)) : CharSequences.token((CharSequence)value, (int)0))));
            }
            Object[] values = new Object[StringJoinOperation.this.attributeNames.length];
            int upper = lower = StringJoinOperation.this.prefix.length();
            int count = 0;
            boolean done = false;
            do {
                if ((upper = value.indexOf(StringJoinOperation.this.delimiter, upper)) >= 0 && upper < endAt) {
                    int escape;
                    for (escape = upper; escape != 0 && value.charAt(escape - 1) == '\\'; --escape) {
                    }
                    if ((upper - escape & 1) != 0) {
                        upper += StringJoinOperation.this.delimiter.length() + 1;
                        continue;
                    }
                } else {
                    upper = endAt;
                    done = true;
                }
                String element = value.substring(lower, upper);
                int i = 0;
                while ((i = element.indexOf(92, i)) >= 0) {
                    if (i >= (element = new StringBuilder(element.length() - 1).append(element, 0, i).append(element, i + 1, element.length()).toString()).length()) continue;
                    if (element.charAt(i) == '\\') {
                        ++i;
                        continue;
                    }
                    assert (element.startsWith(StringJoinOperation.this.delimiter, i)) : element;
                    i += StringJoinOperation.this.delimiter.length();
                }
                if (!element.isEmpty() && count < values.length) {
                    ObjectConverter<? super String, ?> converter = StringJoinOperation.this.converters[count];
                    if (converter instanceof ForFeature) {
                        converter = ((ForFeature)converter).converter;
                    }
                    try {
                        values[count] = converter.apply((Object)element);
                    }
                    catch (UnconvertibleObjectException e) {
                        throw new IllegalArgumentException(Errors.format((short)8, (Object)StringJoinOperation.this.attributeNames[count], (Object)element), e);
                    }
                }
                ++count;
                lower = upper += StringJoinOperation.this.delimiter.length();
            } while (!done);
            if (values.length != count) {
                throw new IllegalArgumentException(Resources.format((short)68, this.getName(), value, values.length, count));
            }
            for (int i = 0; i < values.length; ++i) {
                AbstractFeature f = this.feature;
                String name = StringJoinOperation.this.attributeNames[i];
                if (StringJoinOperation.this.converters[i] instanceof ForFeature) {
                    f = (AbstractFeature)f.getPropertyValue(name);
                    name = "sis:identifier";
                }
                f.setPropertyValue(name, values[i]);
            }
        }
    }
}

