/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl;

import java.util.Map;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.distribution.component.impl.DistributionConfigurationManager;
import org.apache.sling.distribution.resources.impl.DistributionConfigurationResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={ResourceProviderFactory.class}, property={"webconsole.configurationFactory.nameHint=Resource kind: {kind}", "provider.ownsRoots=true"})
@Designate(ocd=Config.class, factory=true)
public class DistributionConfigurationResourceProviderFactory
implements ResourceProviderFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private DistributionConfigurationManager configurationManager;
    private String resourceRoot;
    private String kind;

    @Activate
    public void activate(BundleContext context, Config conf) {
        this.log.debug("activating resource provider with config {}", (Object)conf);
        this.resourceRoot = conf.provider_roots();
        this.kind = conf.kind();
    }

    @Deactivate
    public void deactivate(BundleContext context) {
    }

    public ResourceProvider getResourceProvider(Map<String, Object> authenticationInfo) throws LoginException {
        return new DistributionConfigurationResourceProvider(this.configurationManager, this.kind, this.resourceRoot);
    }

    public ResourceProvider getAdministrativeResourceProvider(Map<String, Object> authenticationInfo) throws LoginException {
        return this.getResourceProvider(authenticationInfo);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Resources - Configuration Resource Provider Factory", description="Distribution Configuration Resource Provider Factory")
    public static @interface Config {
        @AttributeDefinition
        public String provider_roots();

        @AttributeDefinition
        public String kind();
    }
}

