/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.extensions.webconsolesecurityprovider.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.apache.sling.extensions.webconsolesecurityprovider.internal.SlingWebConsoleSecurityProvider;
import org.apache.sling.extensions.webconsolesecurityprovider.internal.SlingWebConsoleSecurityProvider2;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesListener {
    private static final String AUTH_SUPPORT_CLASS = "org.apache.sling.auth.core.AuthenticationSupport";
    private static final String AUTHENTICATOR_CLASS = "org.apache.sling.api.auth.Authenticator";
    private static final String REPO_CLASS = "javax.jcr.Repository";
    protected static final String WEBCONSOLE_AUTH_TYPE = "sling.webconsole.authType";
    protected static final String JCR_AUTH = "jcrAuth";
    protected static final String SLING_AUTH = "slingAuth";
    private final BundleContext bundleContext;
    private final Listener repositoryListener;
    private final Listener authSupportListener;
    private final Listener authListener;
    private final Object lock = new Object();
    private volatile State registrationState = State.NONE;
    private ServiceRegistration<?> providerReg;
    private ServiceRegistration<?> provider2Reg;
    final AuthType authType;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ServicesListener(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.authType = this.getAuthType();
        this.authSupportListener = new Listener(AUTH_SUPPORT_CLASS);
        this.repositoryListener = new Listener(REPO_CLASS);
        this.authListener = new Listener(AUTHENTICATOR_CLASS);
        this.authSupportListener.start();
        this.repositoryListener.start();
        this.authListener.start();
    }

    AuthType getAuthType() {
        String webConsoleAuthType = this.bundleContext.getProperty(WEBCONSOLE_AUTH_TYPE);
        if (webConsoleAuthType != null) {
            if (webConsoleAuthType.equals(JCR_AUTH)) {
                return AuthType.JCR;
            }
            if (webConsoleAuthType.equals(SLING_AUTH)) {
                return AuthType.SLING;
            }
            this.logger.error("Ignoring invalid auth type for webconsole security provider {}", (Object)this.authType);
        }
        return AuthType.DEFAULT;
    }

    State getTargetState(boolean slingAvailable, boolean jcrAvailable) {
        if (!slingAvailable && !jcrAvailable) {
            return State.NONE;
        }
        if (this.authType == AuthType.JCR && jcrAvailable) {
            return State.PROVIDER_JCR;
        }
        if (this.authType == AuthType.SLING && slingAvailable) {
            return State.PROVIDER_SLING;
        }
        if (this.authType == AuthType.DEFAULT) {
            return slingAvailable ? State.PROVIDER_SLING : State.PROVIDER_JCR;
        }
        return State.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange() {
        Object object = this.lock;
        synchronized (object) {
            Object authSupport = this.authSupportListener.getService();
            Object authenticator = this.authListener.getService();
            Object repository = this.repositoryListener.getService();
            State targetState = this.getTargetState(authSupport != null && authenticator != null, repository != null);
            if (this.registrationState != targetState) {
                if (targetState != State.PROVIDER_JCR) {
                    this.unregisterProviderJcr();
                }
                if (targetState != State.PROVIDER_SLING) {
                    this.unregisterProviderSling();
                }
                if (targetState == State.PROVIDER_JCR) {
                    this.registerProviderJcr(repository);
                } else if (targetState == State.PROVIDER_SLING) {
                    this.registerProviderSling(authSupport, authenticator);
                }
                this.registrationState = targetState;
            }
        }
    }

    private void unregisterProviderSling() {
        if (this.provider2Reg != null) {
            this.provider2Reg.unregister();
            this.provider2Reg = null;
        }
    }

    private void unregisterProviderJcr() {
        if (this.providerReg != null) {
            this.providerReg.unregister();
            this.providerReg = null;
        }
    }

    private void registerProviderSling(Object authSupport, Object authenticator) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", SlingWebConsoleSecurityProvider.class.getName());
        ((Dictionary)props).put("service.description", "Apache Sling Web Console Security Provider 2");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("webconsole.security.provider.id", "org.apache.sling.extensions.webconsolesecurityprovider2");
        this.provider2Reg = this.bundleContext.registerService(new String[]{ManagedService.class.getName(), WebConsoleSecurityProvider.class.getName()}, (Object)new SlingWebConsoleSecurityProvider2(authSupport, authenticator), props);
    }

    private void registerProviderJcr(Object repository) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", SlingWebConsoleSecurityProvider.class.getName());
        ((Dictionary)props).put("service.description", "Apache Sling Web Console Security Provider");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("webconsole.security.provider.id", "org.apache.sling.extensions.webconsolesecurityprovider");
        this.providerReg = this.bundleContext.registerService(new String[]{ManagedService.class.getName(), WebConsoleSecurityProvider.class.getName()}, (Object)new SlingWebConsoleSecurityProvider(repository), props);
    }

    public void deactivate() {
        this.repositoryListener.deactivate();
        this.authSupportListener.deactivate();
        this.authListener.deactivate();
        this.unregisterProviderJcr();
        this.unregisterProviderSling();
    }

    protected final class Listener
    implements ServiceListener {
        private final String serviceName;
        private volatile ServiceReference<?> reference;
        private volatile Object service;

        public Listener(String serviceName) {
            this.serviceName = serviceName;
        }

        public void start() {
            try {
                ServicesListener.this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + this.serviceName + ")");
            }
            catch (InvalidSyntaxException ise) {
                throw new RuntimeException("Unexpected exception occured.", ise);
            }
            ServiceReference ref = ServicesListener.this.bundleContext.getServiceReference(this.serviceName);
            if (ref != null) {
                this.retainService(ref);
            }
        }

        public void deactivate() {
            ServicesListener.this.bundleContext.removeServiceListener((ServiceListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getService() {
            Object object = ServicesListener.this.lock;
            synchronized (object) {
                return this.service;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void retainService(ServiceReference<?> ref) {
            Object object = ServicesListener.this.lock;
            synchronized (object) {
                int result;
                boolean getService;
                boolean hadService = this.service != null;
                boolean bl = getService = this.reference == null;
                if (!getService && (result = this.reference.compareTo(ref)) < 0) {
                    ServicesListener.this.bundleContext.ungetService(this.reference);
                    this.service = null;
                    getService = true;
                }
                if (getService) {
                    this.reference = ref;
                    this.service = ServicesListener.this.bundleContext.getService(this.reference);
                    if (this.service == null) {
                        this.reference = null;
                    } else {
                        ServicesListener.this.notifyChange();
                    }
                }
                if (hadService && this.service == null) {
                    ServicesListener.this.notifyChange();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseService(ServiceReference<?> ref) {
            Object object = ServicesListener.this.lock;
            synchronized (object) {
                if (this.reference != null && this.reference.compareTo(ref) == 0) {
                    this.service = null;
                    ServicesListener.this.bundleContext.ungetService(this.reference);
                    this.reference = null;
                    ServicesListener.this.notifyChange();
                }
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                this.retainService(event.getServiceReference());
            } else if (event.getType() == 4) {
                this.releaseService(event.getServiceReference());
            } else if (event.getType() == 2) {
                ServicesListener.this.notifyChange();
            }
        }
    }

    static enum AuthType {
        DEFAULT,
        JCR,
        SLING;

    }

    static enum State {
        NONE,
        PROVIDER_JCR,
        PROVIDER_SLING;

    }
}

