/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.archive;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.io.json.FeatureJSONWriter;

public class ArchiveWriter {
    public static final String VERSION_HEADER = "Feature-Archive-Version";
    public static final String CONTENTS_HEADER = "Feature-Archive-Contents";
    public static final int ARCHIVE_VERSION = 1;

    public static JarOutputStream write(OutputStream out, Manifest baseManifest, ArtifactProvider provider, Feature ... features) throws IOException {
        Manifest manifest = baseManifest == null ? new Manifest() : new Manifest(baseManifest);
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue(VERSION_HEADER, String.valueOf(1));
        manifest.getMainAttributes().putValue(CONTENTS_HEADER, String.join((CharSequence)",", Arrays.asList(features).stream().map(feature -> feature.getId().toMvnId()).collect(Collectors.toList())));
        HashSet<ArtifactId> artifacts = new HashSet<ArtifactId>();
        byte[] buffer = new byte[0x10000000];
        JarOutputStream jos = new JarOutputStream(out, manifest);
        jos.setLevel(0);
        for (Feature feature2 : features) {
            ArchiveWriter.writeFeature(artifacts, feature2, provider, jos, buffer);
        }
        for (Feature feature2 : features) {
            for (Artifact a : feature2.getBundles()) {
                ArchiveWriter.writeArtifact(artifacts, provider, a, jos, buffer);
            }
            for (Extension e : feature2.getExtensions()) {
                if (e.getType() != ExtensionType.ARTIFACTS) continue;
                boolean isFeature = "assembled-features".equals(e.getName());
                for (Artifact a : e.getArtifacts()) {
                    if (isFeature) {
                        ArchiveWriter.writeFeature(artifacts, provider, a.getId(), jos, buffer);
                        continue;
                    }
                    ArchiveWriter.writeArtifact(artifacts, provider, a, jos, buffer);
                }
            }
        }
        return jos;
    }

    private static void writeFeature(Set<ArtifactId> artifacts, Feature feature, ArtifactProvider provider, JarOutputStream jos, byte[] buffer) throws IOException {
        if (artifacts.add(feature.getId())) {
            JarEntry entry = new JarEntry(feature.getId().toMvnPath());
            jos.putNextEntry(entry);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)jos, StandardCharsets.UTF_8);
            FeatureJSONWriter.write(writer, feature);
            ((Writer)writer).flush();
            jos.closeEntry();
            if (feature.getPrototype() != null) {
                ArchiveWriter.writeFeature(artifacts, provider, feature.getPrototype().getId(), jos, buffer);
            }
        }
    }

    private static void writeFeature(Set<ArtifactId> artifacts, ArtifactProvider provider, ArtifactId featureId, JarOutputStream jos, byte[] buffer) throws IOException {
        if (!artifacts.contains(featureId)) {
            URL url = provider.provide(featureId);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 InputStream is = url.openStream();){
                int l = 0;
                while ((l = is.read(buffer)) > 0) {
                    baos.write(buffer, 0, l);
                }
                String contents = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                try (StringReader reader = new StringReader(contents);){
                    Feature feature = FeatureJSONReader.read(reader, featureId.toMvnId());
                    ArchiveWriter.writeFeature(artifacts, feature, provider, jos, buffer);
                }
            }
        }
    }

    private static void writeArtifact(Set<ArtifactId> artifacts, ArtifactProvider provider, Artifact artifact, JarOutputStream jos, byte[] buffer) throws IOException {
        if (artifacts.add(artifact.getId())) {
            JarEntry artifactEntry = new JarEntry(artifact.getId().toMvnPath());
            jos.putNextEntry(artifactEntry);
            URL url = provider.provide(artifact.getId());
            if (url == null) {
                throw new IOException("Unable to find artifact " + artifact.getId().toMvnId());
            }
            try (InputStream is = url.openStream();){
                int l = 0;
                while ((l = is.read(buffer)) > 0) {
                    jos.write(buffer, 0, l);
                }
            }
            jos.closeEntry();
        }
    }
}

