/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.maintenance.internal;

import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.jcr.maintenance.VersionCleanupPathConfig;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={VersionCleanupPath.class}, immediate=true)
@Designate(ocd=VersionCleanupPathConfig.class, factory=true)
public class VersionCleanupPath
implements Comparable<VersionCleanupPath> {
    private static final Logger log = LoggerFactory.getLogger(VersionCleanupPath.class);
    private final boolean keepVersions;
    private final int limit;
    private final String path;

    @Activate
    public VersionCleanupPath(VersionCleanupPathConfig config) {
        this.keepVersions = config.keepVersions();
        this.limit = config.limit();
        this.path = config.path();
    }

    @Override
    public int compareTo(VersionCleanupPath o) {
        return this.path.compareTo(o.path) * -1;
    }

    public boolean isKeepVersions() {
        return this.keepVersions;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getPath() {
        return this.path;
    }

    public static final VersionCleanupPath getMatchingConfiguration(List<VersionCleanupPath> versionCleanupConfigs, String path) throws RepositoryException {
        log.trace("Evaluating configurations {} for path {}", versionCleanupConfigs, (Object)path);
        return versionCleanupConfigs.stream().filter(c -> path.startsWith(c.getPath())).findFirst().orElseThrow(() -> new RepositoryException("Failed to find version cleanup configuration for " + path));
    }

    public String toString() {
        return "VersionCleanupPath [keepVersions=" + this.keepVersions + ", limit=" + this.limit + ", path=" + this.path + "]";
    }
}

