/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.jexl3.internal.introspection.AbstractExecutor;
import org.apache.commons.jexl3.internal.introspection.Introspector;

public final class DuckSetExecutor
extends AbstractExecutor.Set {
    private final Object property;

    public static DuckSetExecutor discover(Introspector is, Class<?> clazz, Object key, Object value) {
        Method method = is.getMethod(clazz, "set", DuckSetExecutor.makeArgs(key, value));
        if (method == null) {
            method = is.getMethod(clazz, "put", DuckSetExecutor.makeArgs(key, value));
        }
        return method == null ? null : new DuckSetExecutor(clazz, method, key);
    }

    private DuckSetExecutor(Class<?> clazz, Method method, Object key) {
        super(clazz, method);
        this.property = key;
    }

    @Override
    public Object getTargetProperty() {
        return this.property;
    }

    @Override
    public Object invoke(Object obj, Object value) throws IllegalAccessException, InvocationTargetException {
        Object[] pargs = new Object[]{this.property, value};
        if (this.method != null) {
            this.method.invoke(obj, pargs);
        }
        return value;
    }

    @Override
    public Object tryInvoke(Object obj, Object key, Object value) {
        if (obj != null && this.method != null && this.property.equals(key) && this.objectClass.equals(obj.getClass())) {
            try {
                Object[] args = new Object[]{this.property, value};
                this.method.invoke(obj, args);
                return value;
            }
            catch (InvocationTargetException xinvoke) {
                return TRY_FAILED;
            }
            catch (IllegalAccessException xill) {
                return TRY_FAILED;
            }
            catch (IllegalArgumentException xarg) {
                return TRY_FAILED;
            }
        }
        return TRY_FAILED;
    }
}

