/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal.inputstream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.AbstractInputStreamPipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPipe
extends AbstractInputStreamPipe {
    private static Logger logger = LoggerFactory.getLogger(JsonPipe.class);
    public static final String JSON_KEY = "json";
    public static final String RESOURCE_TYPE = "slingPipes/json";
    protected static final String PN_VALUEPATH = "valuePath";
    protected static final String PN_RAW = "raw";
    protected static final String JSONPATH_ROOT = "$";
    protected static final String ARRAY_START = "[";
    protected static final String OBJ_START = ".";
    protected static final String INDEX_SUFFIX = "_index";
    protected static final Pattern JSONPATH_FIRSTTOKEN = Pattern.compile("^\\$([\\.\\[])([^\\.\\]\\[]+)\\]?");
    JsonBindingIterator internalIterator;

    public JsonPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
    }

    boolean isRaw() {
        if (this.properties.containsKey((Object)PN_RAW)) {
            Object raw = this.bindings.instantiateObject((String)this.properties.get(PN_RAW, String.class));
            if (raw instanceof Boolean) {
                return (Boolean)raw;
            }
            return Boolean.parseBoolean((String)raw);
        }
        return false;
    }

    @Override
    public Iterator<Resource> getOutput(InputStream is) {
        JsonBindingIterator output = EMPTY_ITERATOR;
        JsonBindingIterator inputSingletonIterator = Collections.singleton(this.getInput()).iterator();
        try {
            String jsonString = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isNotBlank((CharSequence)jsonString)) {
                JsonStructure json = JsonUtil.parse(jsonString);
                if (json == null) {
                    this.binding = jsonString.trim();
                    output = inputSingletonIterator;
                } else {
                    String valuePath = (String)this.properties.get(PN_VALUEPATH, String.class);
                    if (StringUtils.isNotBlank((CharSequence)valuePath)) {
                        json = this.getValue(json, this.bindings.instantiateExpression(valuePath));
                    }
                    if (this.isRaw() || json.getValueType() != JsonValue.ValueType.ARRAY && json.getValueType() != JsonValue.ValueType.OBJECT) {
                        this.binding = JsonUtil.unbox((JsonValue)json);
                        output = inputSingletonIterator;
                    } else {
                        this.binding = json;
                        output = this.internalIterator = new JsonBindingIterator(json, this.getInput());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return output;
    }

    protected JsonStructure getValue(JsonStructure json, String valuePath) {
        Matcher matcher = JSONPATH_FIRSTTOKEN.matcher(valuePath);
        if (matcher.find()) {
            String firstChar = matcher.group(1);
            String content = matcher.group(2);
            logger.trace("first char is {}, content is {}", (Object)firstChar, (Object)content);
            if (ARRAY_START.equals(firstChar)) {
                JsonArray array = (JsonArray)json;
                int index = Integer.parseInt(content);
                json = (JsonStructure)array.get(index);
            } else if (OBJ_START.equals(firstChar)) {
                JsonObject object = (JsonObject)json;
                json = (JsonStructure)object.get((Object)content);
            }
            valuePath = StringUtils.removeStart((String)valuePath, (String)matcher.group(0));
            if (StringUtils.isNotBlank((CharSequence)valuePath)) {
                valuePath = JSONPATH_ROOT + valuePath;
                return this.getValue(json, valuePath);
            }
        }
        return json;
    }

    class JsonBindingIterator
    implements Iterator<Resource> {
        Collection<Object> jsonValues;
        Iterator<Object> internal;
        final Resource inputResource;
        int index = 0;

        JsonBindingIterator(JsonStructure json, Resource inputResource) {
            this.jsonValues = json.getValueType() == JsonValue.ValueType.ARRAY ? (Collection)((JsonArray)json).stream().map(JsonUtil::unbox).collect(Collectors.toList()) : (Collection)((JsonObject)json).entrySet().stream().map(e -> new DefaultKeyValue(e.getKey(), JsonUtil.unbox((JsonValue)e.getValue()))).collect(Collectors.toList());
            this.internal = this.jsonValues.iterator();
            this.inputResource = inputResource;
        }

        @Override
        public boolean hasNext() {
            return this.internal.hasNext();
        }

        @Override
        public Resource next() {
            if (!this.internal.hasNext()) {
                throw new NoSuchElementException();
            }
            JsonPipe.this.binding = this.internal.next();
            JsonPipe.this.getBindings().addBinding(JsonPipe.this.getName() + JsonPipe.INDEX_SUFFIX, this.index++);
            return this.inputResource;
        }
    }
}

