/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum ExpressionContext {
    PLUGIN_DATA_SLY_USE(Collections.emptySet()),
    PLUGIN_DATA_SLY_TEXT(Collections.emptySet()),
    PLUGIN_DATA_SLY_ATTRIBUTE(Collections.emptySet()),
    PLUGIN_DATA_SLY_ELEMENT(Collections.emptySet()),
    PLUGIN_DATA_SLY_TEST(Collections.emptySet()),
    PLUGIN_DATA_SLY_SET(Collections.emptySet()),
    PLUGIN_DATA_SLY_LIST(new HashSet<String>(Arrays.asList("begin", "step", "end"))),
    PLUGIN_DATA_SLY_REPEAT(new HashSet<String>(Arrays.asList("begin", "step", "end"))),
    PLUGIN_DATA_SLY_INCLUDE(new HashSet<String>(Arrays.asList("appendPath", "prependPath", "file", "requestAttributes"))),
    PLUGIN_DATA_SLY_RESOURCE(new HashSet<String>(Arrays.asList("appendPath", "prependPath", "file", "selectors", "addSelectors", "removeSelectors", "resourceType", "requestAttributes"))),
    PLUGIN_DATA_SLY_TEMPLATE(Collections.emptySet()),
    PLUGIN_DATA_SLY_CALL(Collections.emptySet()),
    PLUGIN_DATA_SLY_UNWRAP(Collections.emptySet()),
    ELEMENT(Collections.emptySet()),
    TEXT(Collections.emptySet()),
    ATTRIBUTE(Collections.emptySet());

    private static final String PLUGIN_PREFIX = "PLUGIN_DATA_SLY_";
    private final Set<String> options;

    private ExpressionContext(Set<String> options) {
        this.options = options;
    }

    public static ExpressionContext getContextForPlugin(String pluginName) {
        return ExpressionContext.valueOf(PLUGIN_PREFIX + pluginName.toUpperCase());
    }

    public Set<String> getOptions() {
        return this.options;
    }
}

