/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.sling.commons.compiler.source.JavaEscapeHelper;
import org.apache.sling.scripting.sightly.compiler.util.VariableTracker;
import org.apache.sling.scripting.sightly.java.compiler.SightlyJavaCompilerException;
import org.apache.sling.scripting.sightly.java.compiler.impl.Type;
import org.apache.sling.scripting.sightly.java.compiler.impl.VariableDescriptor;
import org.apache.sling.scripting.sightly.java.compiler.impl.VariableScope;

public class VariableAnalyzer {
    private final VariableTracker<VariableDescriptor> tracker = new VariableTracker();
    private final List<VariableDescriptor> variables = new ArrayList<VariableDescriptor>();
    private final HashMap<String, VariableDescriptor> dynamicVariables = new HashMap();
    private final HashMap<String, VariableDescriptor> staticVariables = new HashMap();
    private static final String DYNAMIC_PREFIX = "_dynamic_";
    private static final String GLOBAL_PREFIX = "_global_";

    public VariableDescriptor declareVariable(String originalName, Type type) {
        originalName = originalName.toLowerCase();
        String safeName = this.findSafeName(originalName);
        VariableDescriptor descriptor = new VariableDescriptor(originalName, JavaEscapeHelper.getJavaIdentifier((String)safeName), type, VariableScope.SCOPED);
        this.tracker.pushVariable(originalName, (Object)descriptor);
        this.variables.add(descriptor);
        return descriptor;
    }

    public VariableDescriptor declareGlobal(String originalName) {
        VariableDescriptor descriptor = this.staticVariables.get(originalName = originalName.toLowerCase());
        if (descriptor == null) {
            String assignedName = this.findGlobalName(originalName);
            descriptor = new VariableDescriptor(originalName, assignedName, Type.UNKNOWN, VariableScope.GLOBAL);
            this.variables.add(descriptor);
            this.staticVariables.put(originalName, descriptor);
        }
        return descriptor;
    }

    public VariableDescriptor declareTemplate(String originalName) {
        originalName = originalName.toLowerCase();
        VariableDescriptor descriptor = this.dynamicDescriptor(originalName);
        descriptor.markAsTemplate();
        return descriptor;
    }

    public VariableDescriptor endVariable() {
        VariableDescriptor descriptor = (VariableDescriptor)this.tracker.peek().getValue();
        this.tracker.popVariable();
        return descriptor;
    }

    public VariableDescriptor descriptor(String name) {
        String lowerName = name.toLowerCase();
        VariableDescriptor descriptor = (VariableDescriptor)this.tracker.get(lowerName);
        if (descriptor == null) {
            descriptor = this.staticVariables.get(lowerName);
        }
        if (descriptor == null) {
            descriptor = this.dynamicDescriptor(lowerName);
        }
        return descriptor;
    }

    public Collection<VariableDescriptor> allVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public String assignedName(String original) {
        return this.descriptor(original).getAssignedName();
    }

    private VariableDescriptor dynamicDescriptor(String original) {
        VariableDescriptor descriptor = this.dynamicVariables.get(original);
        if (descriptor == null) {
            String dynamicName = this.findDynamicName(this.validName(original));
            descriptor = new VariableDescriptor(original, dynamicName, Type.UNKNOWN, VariableScope.DYNAMIC);
            this.dynamicVariables.put(original, descriptor);
            this.variables.add(descriptor);
        }
        return descriptor;
    }

    private String findDynamicName(String original) {
        return DYNAMIC_PREFIX + JavaEscapeHelper.getJavaIdentifier((String)original);
    }

    private String findGlobalName(String original) {
        return GLOBAL_PREFIX + JavaEscapeHelper.getJavaIdentifier((String)original);
    }

    private String validName(String name) {
        if (name == null || name.contains("-")) {
            throw new SightlyJavaCompilerException("Unsupported identifier name: " + name);
        }
        return name.toLowerCase();
    }

    private String findSafeName(String original) {
        int occurrenceCount = this.tracker.getOccurrenceCount(original);
        String syntaxSafe = JavaEscapeHelper.getJavaIdentifier((String)original);
        if (occurrenceCount == 0) {
            return syntaxSafe;
        }
        return original + "_" + occurrenceCount;
    }
}

