/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tenant.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.tenant.Tenant;
import org.apache.sling.tenant.TenantManager;
import org.apache.sling.tenant.TenantProvider;
import org.apache.sling.tenant.internal.TenantAdapterFactory;
import org.apache.sling.tenant.internal.TenantImpl;
import org.apache.sling.tenant.internal.console.WebConsolePlugin;
import org.apache.sling.tenant.spi.TenantCustomizer;
import org.apache.sling.tenant.spi.TenantManagerHook;
import org.apache.sling.xss.XSSAPI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={TenantProvider.class, TenantManager.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Apache Sling Tenant Provider"}, immediate=true, reference={@Reference(name="tenantSetup", service=TenantCustomizer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindTenantSetup", unbind="unbindTenantSetup"), @Reference(name="hook", service=TenantManagerHook.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindHook", unbind="unbindHook")})
@Designate(ocd=Configuration.class)
public class TenantProviderImpl
implements TenantProvider,
TenantManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String RESOURCE_TENANT_ROOT = "/etc/tenants";
    private SortedMap<Comparable<Object>, TenantCustomizer> registeredTenantHandlers = new TreeMap(Collections.reverseOrder());
    private SortedMap<Comparable<Object>, TenantManagerHook> registeredHooks = new TreeMap(Collections.reverseOrder());
    private String tenantRootPath = "/etc/tenants";
    private final ResourceResolverFactory factory;
    private TenantAdapterFactory adapterFactory;
    private WebConsolePlugin plugin;

    @Activate
    public TenantProviderImpl(BundleContext bundleContext, @Reference(policyOption=ReferencePolicyOption.GREEDY) XSSAPI xss, @Reference ResourceResolverFactory resourceResolverFactory, Configuration configuration) {
        this.factory = resourceResolverFactory;
        this.tenantRootPath = configuration.tenant_root();
        this.adapterFactory = new TenantAdapterFactory(bundleContext, this, configuration.tenant_path_matcher());
        this.plugin = new WebConsolePlugin(bundleContext, this, xss);
    }

    @Deactivate
    protected void deactivate() {
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
            this.adapterFactory = null;
        }
        if (this.plugin != null) {
            this.plugin.dispose();
            this.plugin = null;
        }
    }

    private synchronized void bindTenantSetup(TenantCustomizer action, ServiceReference<TenantCustomizer> ref) {
        this.registeredTenantHandlers.put((Comparable<Object>)ref, action);
    }

    private synchronized void unbindTenantSetup(TenantCustomizer action, ServiceReference<TenantCustomizer> ref) {
        this.registeredTenantHandlers.remove(ref);
    }

    private synchronized Collection<TenantCustomizer> getTenantHandlers() {
        return this.registeredTenantHandlers.values();
    }

    private synchronized void bindHook(TenantManagerHook action, ServiceReference<TenantCustomizer> ref) {
        this.registeredHooks.put((Comparable<Object>)ref, action);
    }

    private synchronized void unbindHook(TenantManagerHook action, ServiceReference<TenantCustomizer> ref) {
        this.registeredHooks.remove(ref);
    }

    private synchronized Collection<TenantManagerHook> getHooks() {
        return this.registeredHooks.values();
    }

    @Override
    public Tenant getTenant(final String tenantId) {
        if (tenantId != null && tenantId.length() > 0) {
            return this.call(new ResourceResolverTask<Tenant>(){

                @Override
                public Tenant call(ResourceResolver resolver) {
                    Resource tenantRes = TenantProviderImpl.this.getTenantResource(resolver, tenantId);
                    return tenantRes != null ? new TenantImpl(tenantRes) : null;
                }
            });
        }
        return null;
    }

    @Override
    public Iterator<Tenant> getTenants() {
        return this.getTenants(null);
    }

    @Override
    public Iterator<Tenant> getTenants(String tenantFilter) {
        Filter filter;
        if (tenantFilter != null && tenantFilter.length() > 0) {
            try {
                filter = FrameworkUtil.createFilter((String)tenantFilter);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        } else {
            filter = null;
        }
        Iterator<Tenant> result = this.call(new ResourceResolverTask<Iterator<Tenant>>(){

            @Override
            public Iterator<Tenant> call(ResourceResolver resolver) {
                Resource tenantRootRes = resolver.getResource(TenantProviderImpl.this.tenantRootPath);
                if (tenantRootRes != null) {
                    ArrayList<TenantImpl> tenantList = new ArrayList<TenantImpl>();
                    Iterator tenantResourceList = tenantRootRes.listChildren();
                    while (tenantResourceList.hasNext()) {
                        Resource tenantRes = (Resource)tenantResourceList.next();
                        if (filter != null && !filter.matches((Map)ResourceUtil.getValueMap((Resource)tenantRes))) continue;
                        TenantImpl tenant = new TenantImpl(tenantRes);
                        tenantList.add(tenant);
                    }
                    return tenantList.iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        });
        if (result == null) {
            result = Collections.emptyList().iterator();
        }
        return result;
    }

    @Override
    public Tenant create(final String tenantId, final Map<String, Object> properties) {
        return this.call(new ResourceResolverTask<Tenant>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Tenant call(ResourceResolver adminResolver) {
                try {
                    Resource tenantRes = TenantProviderImpl.this.createTenantResource(adminResolver, tenantId, properties);
                    TenantImpl tenant = new TenantImpl(tenantRes);
                    TenantProviderImpl.this.customizeTenant(tenantRes, tenant, true);
                    adminResolver.commit();
                    tenant.loadProperties(tenantRes);
                    TenantImpl tenantImpl = tenant;
                    return tenantImpl;
                }
                catch (PersistenceException e) {
                    TenantProviderImpl.this.log.error("create: Failed creating Tenant {}", (Object)tenantId, (Object)e);
                }
                finally {
                    adminResolver.close();
                }
                return null;
            }
        });
    }

    @Override
    public void remove(final Tenant tenant) {
        this.call(new ResourceResolverTask<Void>(){

            @Override
            public Void call(ResourceResolver resolver) {
                try {
                    Resource tenantRes = TenantProviderImpl.this.getTenantResource(resolver, tenant.getId());
                    if (tenantRes != null) {
                        for (Object ts : TenantProviderImpl.this.getTenantHandlers()) {
                            try {
                                ts.remove(tenant, resolver);
                            }
                            catch (Exception e) {
                                TenantProviderImpl.this.log.info("removeTenant: Unexpected problem calling TenantCustomizer " + ts, (Throwable)e);
                            }
                        }
                        for (Object ts : TenantProviderImpl.this.getHooks()) {
                            try {
                                ts.remove(tenant);
                            }
                            catch (Exception e) {
                                TenantProviderImpl.this.log.info("removeTenant: Unexpected problem calling TenantManagerHook " + ts, (Throwable)e);
                            }
                        }
                        resolver.delete(tenantRes);
                        resolver.commit();
                    }
                }
                catch (PersistenceException e) {
                    TenantProviderImpl.this.log.error("remove({}): Cannot persist Tenant removal", (Object)tenant.getId(), (Object)e);
                }
                return null;
            }
        });
    }

    @Override
    public void setProperty(Tenant tenant, final String name, final Object value) {
        this.updateProperties(tenant, new PropertiesUpdater(){

            @Override
            public void update(ModifiableValueMap properties) {
                if (value != null) {
                    properties.put((Object)name, value);
                } else {
                    properties.remove((Object)name);
                }
            }
        });
    }

    @Override
    public void setProperties(Tenant tenant, final Map<String, Object> properties) {
        this.updateProperties(tenant, new PropertiesUpdater(){

            @Override
            public void update(ModifiableValueMap vm) {
                for (Map.Entry entry : properties.entrySet()) {
                    if (entry.getValue() != null) {
                        vm.put((Object)((String)entry.getKey()), entry.getValue());
                        continue;
                    }
                    vm.remove(entry.getKey());
                }
            }
        });
    }

    @Override
    public void removeProperties(Tenant tenant, final String ... propertyNames) {
        this.updateProperties(tenant, new PropertiesUpdater(){

            @Override
            public void update(ModifiableValueMap properties) {
                for (String name : propertyNames) {
                    properties.remove((Object)name);
                }
            }
        });
    }

    private Resource createTenantResource(ResourceResolver resolver, String tenantId, Map<String, Object> properties) throws PersistenceException {
        if (this.getTenantResource(resolver, tenantId) != null) {
            throw new PersistenceException("Tenant '" + tenantId + "' already exists");
        }
        Resource tenantRoot = resolver.getResource(this.tenantRootPath);
        if (tenantRoot == null) {
            String[] segments;
            Resource current = resolver.getResource("/");
            if (current == null) {
                throw new PersistenceException("Cannot get root Resource");
            }
            for (String segment : segments = this.tenantRootPath.split("/")) {
                Resource child = current.getChild(segment);
                if (child == null) {
                    child = resolver.create(current, segment, (Map)new HashMap<String, Object>(){
                        {
                            this.put("jcr:primaryType", "sling:Folder");
                        }
                    });
                }
                current = child;
            }
            tenantRoot = current;
        }
        return resolver.create(tenantRoot, tenantId, properties);
    }

    private Resource getTenantResource(ResourceResolver resolver, String tenantId) {
        Resource rsrc = resolver.getResource(this.tenantRootPath + "/" + tenantId);
        if (rsrc == null) {
            for (Resource r : resolver.getResource(this.tenantRootPath).getChildren()) {
                if (!tenantId.equals(r.getName())) continue;
                rsrc = r;
                break;
            }
        }
        return rsrc;
    }

    private void customizeTenant(Resource tenantRes, Tenant tenant, boolean isCreate) {
        Map<String, Object> props;
        HashMap<String, Object> tenantProps = (HashMap<String, Object>)tenantRes.adaptTo(ModifiableValueMap.class);
        if (tenantProps == null) {
            this.log.warn("create({}): Cannot get ModifiableValueMap for new tenant; will not store changed properties of TenantCustomizers", (Object)tenant.getId());
            tenantProps = new HashMap<String, Object>();
        }
        for (TenantCustomizer tenantCustomizer : this.getTenantHandlers()) {
            try {
                props = tenantCustomizer.setup(tenant, tenantRes.getResourceResolver());
                if (props == null) continue;
                tenantProps.putAll(props);
            }
            catch (Exception e) {
                this.log.info("addTenant/updateTenant: Unexpected problem calling TenantCustomizer " + tenantCustomizer, (Throwable)e);
            }
        }
        for (TenantManagerHook tenantManagerHook : this.getHooks()) {
            try {
                props = isCreate ? tenantManagerHook.setup(tenant) : tenantManagerHook.change(tenant);
                if (props == null) continue;
                tenantProps.putAll(props);
            }
            catch (Exception e) {
                this.log.info("addTenant/updateTenant: Unexpected problem calling TenantManagerHook " + tenantManagerHook, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T call(ResourceResolverTask<T> task) {
        T result = null;
        try (ResourceResolver resolver = null;){
            resolver = this.factory.getServiceResourceResolver(null);
            result = task.call(resolver);
        }
        return result;
    }

    private void updateProperties(final Tenant tenant, final PropertiesUpdater updater) {
        this.call(new ResourceResolverTask<Void>(){

            @Override
            public Void call(ResourceResolver resolver) {
                try {
                    Resource tenantRes = TenantProviderImpl.this.getTenantResource(resolver, tenant.getId());
                    if (tenantRes != null) {
                        updater.update((ModifiableValueMap)tenantRes.adaptTo(ModifiableValueMap.class));
                        if (tenant instanceof TenantImpl) {
                            ((TenantImpl)tenant).loadProperties(tenantRes);
                        }
                        TenantProviderImpl.this.customizeTenant(tenantRes, tenant, false);
                        resolver.commit();
                        if (tenant instanceof TenantImpl) {
                            ((TenantImpl)tenant).loadProperties(tenantRes);
                        }
                    }
                }
                catch (PersistenceException pe) {
                    TenantProviderImpl.this.log.error("setProperty({}): Cannot persist Tenant removal", (Object)tenant.getId(), (Object)pe);
                }
                return null;
            }
        });
    }

    @ObjectClassDefinition(name="Apache Sling Tenant Provider", description="Service responsible for providing Tenants.")
    public static @interface Configuration {
        @AttributeDefinition(name="Tenants Root Path", description="Defines tenants root path")
        public String tenant_root() default "/etc/tenants";

        @AttributeDefinition(name="Tenants Path Matcher", description="Defines tenants path matcher i.e. /content/sample/([^/]+)/*, used while resolving path to tenant")
        public String[] tenant_path_matcher() default {};
    }

    private static interface ResourceResolverTask<T> {
        public T call(ResourceResolver var1);
    }

    private static interface PropertiesUpdater {
        public void update(ModifiableValueMap var1);
    }
}

