/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.caconfig;

import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.management.ConfigurationManager;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationPersistenceStrategyMultiplexer;
import org.apache.sling.caconfig.spi.ConfigurationCollectionPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistData;
import org.apache.sling.testing.mock.caconfig.ConfigurationDataParts;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.jetbrains.annotations.NotNull;

class ConfigurationPersistHelper {
    private final ConfigurationManager configManager;
    private final ConfigurationPersistenceStrategyMultiplexer configurationPersistenceStrategy;
    private final Resource contextResource;

    ConfigurationPersistHelper(@NotNull SlingContextImpl context, @NotNull String contextPath) {
        this.configManager = (ConfigurationManager)context.getService(ConfigurationManager.class);
        this.configurationPersistenceStrategy = (ConfigurationPersistenceStrategyMultiplexer)context.getService(ConfigurationPersistenceStrategyMultiplexer.class);
        this.contextResource = context.resourceResolver().getResource(contextPath);
        if (this.contextResource == null) {
            throw new IllegalArgumentException("No resource found at" + contextPath);
        }
    }

    void writeConfiguration(@NotNull String configName, @NotNull Map<String, Object> values) {
        ConfigurationDataParts parts = new ConfigurationDataParts(values);
        this.configManager.persistConfiguration(this.contextResource, configName, new ConfigurationPersistData(parts.getValues()));
        for (Map.Entry<String, Map<String, Object>> entry : parts.getMaps().entrySet()) {
            this.writeConfiguration(this.getNestedConfigName(configName, entry.getKey()), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : parts.getCollections().entrySet()) {
            this.writeConfigurationCollection(this.getNestedConfigName(configName, entry.getKey()), (Collection)entry.getValue());
        }
    }

    void writeConfigurationCollection(@NotNull String configName, @NotNull @NotNull Collection<@NotNull Map<String, Object>> values) {
        LinkedHashMap<CallSite, ConfigurationDataParts> partsCollection = new LinkedHashMap<CallSite, ConfigurationDataParts>();
        int index = 0;
        for (Map<String, Object> map : values) {
            partsCollection.put((CallSite)((Object)("item" + index++)), new ConfigurationDataParts(map));
        }
        List items = partsCollection.entrySet().stream().map(entry -> new ConfigurationPersistData(((ConfigurationDataParts)entry.getValue()).getValues()).collectionItemName((String)entry.getKey())).collect(Collectors.toList());
        this.configManager.persistConfigurationCollection(this.contextResource, configName, new ConfigurationCollectionPersistData(items));
        for (Map.Entry entry2 : partsCollection.entrySet()) {
            String itemName = (String)entry2.getKey();
            ConfigurationDataParts parts = (ConfigurationDataParts)entry2.getValue();
            for (Map.Entry<String, Map<String, Object>> entry3 : parts.getMaps().entrySet()) {
                this.writeConfiguration(this.getNestedCollectionItemConfigName(configName, itemName, entry3.getKey()), entry3.getValue());
            }
            for (Map.Entry<String, Object> entry4 : parts.getCollections().entrySet()) {
                this.writeConfigurationCollection(this.getNestedCollectionItemConfigName(configName, itemName, entry4.getKey()), (Collection)entry4.getValue());
            }
        }
    }

    private String getConfigName(@NotNull String configName) {
        return StringUtils.defaultString((String)this.configurationPersistenceStrategy.getConfigName(configName, null), (String)configName);
    }

    private String getCollectionParentConfigName(@NotNull String configName) {
        return StringUtils.defaultString((String)this.configurationPersistenceStrategy.getCollectionParentConfigName(configName, null), (String)configName);
    }

    private String getCollectionItemConfigName(@NotNull String configName) {
        return StringUtils.defaultString((String)this.configurationPersistenceStrategy.getCollectionItemConfigName(configName, null), (String)configName);
    }

    private String getNestedConfigName(@NotNull String configName, @NotNull String key) {
        return this.getConfigName(configName) + "/" + key;
    }

    private String getNestedCollectionItemConfigName(@NotNull String configName, @NotNull String itemName, @NotNull String key) {
        return this.getCollectionItemConfigName(this.getCollectionParentConfigName(configName) + "/" + itemName) + "/" + key;
    }
}

