/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.constraint;

import java.util.function.Predicate;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.core.GuavaDeprecation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanConstraint
implements Predicate<Value>,
sling-mock-oak.com.google.common.base.Predicate<Value> {
    private static final Logger log = LoggerFactory.getLogger(BooleanConstraint.class);
    private final Boolean requiredValue;

    public BooleanConstraint(String definition) {
        if ("true".equals(definition)) {
            this.requiredValue = true;
        } else if ("false".equals(definition)) {
            this.requiredValue = false;
        } else {
            this.requiredValue = null;
            log.warn('\'' + definition + "' is not a valid value constraint format for boolean values");
        }
    }

    @Override
    public boolean test(Value value) {
        try {
            return value != null && this.requiredValue != null && value.getBoolean() == this.requiredValue.booleanValue();
        }
        catch (RepositoryException e) {
            log.warn("Error checking boolean constraint " + this, (Throwable)e);
            return false;
        }
    }

    @Override
    @Deprecated
    public boolean apply(Value value) {
        GuavaDeprecation.handleCall("OAK-8874");
        return this.test(value);
    }

    public String toString() {
        return "'" + this.requiredValue + '\'';
    }
}

