/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import org.apache.jackrabbit.oak.api.jmx.QueryEngineSettingsMBean;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class QueryEngineSettingsService {
    private static final int DEFAULT_QUERY_LIMIT_IN_MEMORY = 500000;
    static final String QUERY_LIMIT_IN_MEMORY = "queryLimitInMemory";
    private static final int DEFAULT_QUERY_LIMIT_READS = 100000;
    static final String QUERY_LIMIT_READS = "queryLimitReads";
    private static final boolean DEFAULT_QUERY_FAIL_TRAVERSAL = false;
    static final String QUERY_FAIL_TRAVERSAL = "queryFailTraversal";
    static final String QUERY_FAST_QUERY_SIZE = "fastQuerySize";
    static final String DISABLED_STRICT_PATH_RESTRICTION = "DISABLE";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private QueryEngineSettingsMBean queryEngineSettings;

    @Activate
    private void activate(BundleContext context, Configuration config) {
        if (System.getProperty("oak.queryLimitInMemory") == null) {
            int queryLimitInMemory = config.queryLimitInMemory();
            this.queryEngineSettings.setLimitInMemory(queryLimitInMemory);
        } else {
            this.logMsg(QUERY_LIMIT_IN_MEMORY, "oak.queryLimitInMemory");
        }
        if (System.getProperty("oak.queryLimitReads") == null) {
            int queryLimitReads = config.queryLimitReads();
            this.queryEngineSettings.setLimitReads(queryLimitReads);
        } else {
            this.logMsg(QUERY_LIMIT_IN_MEMORY, "oak.queryLimitReads");
        }
        if (System.getProperty("oak.queryFailTraversal") == null) {
            boolean failTraversal = config.queryFailTraversal();
            this.queryEngineSettings.setFailTraversal(failTraversal);
        } else {
            this.logMsg(QUERY_FAIL_TRAVERSAL, "oak.queryFailTraversal");
        }
        boolean fastQuerySizeSysProp = QueryEngineSettings.DEFAULT_FAST_QUERY_SIZE;
        boolean fastQuerySizeFromConfig = config.fastQuerySize();
        this.queryEngineSettings.setFastQuerySize(fastQuerySizeFromConfig || fastQuerySizeSysProp);
        this.queryEngineSettings.setStrictPathRestriction(config.getStrictPathRestrictionsForIndexes());
        this.log.info("Initialize QueryEngine settings {}", (Object)this.queryEngineSettings);
    }

    private void logMsg(String key, String sysPropKey) {
        this.log.info("For {} using value {} defined via system property {}", new Object[]{key, System.getProperty(sysPropKey), sysPropKey});
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Query Engine Settings Service", description="Various settings exposed by Oak QueryEngine. Note that settings done by system property supersedes the one defined via OSGi config")
    static @interface Configuration {
        @AttributeDefinition(name="In memory limit", description="Maximum number of entries that can be held in memory while evaluating any query")
        public int queryLimitInMemory() default 500000;

        @AttributeDefinition(name="In memory read limit", description="Maximum number of results which can be read by any query")
        public int queryLimitReads() default 100000;

        @AttributeDefinition(name="Fail traversal", description="If enabled any query execution which results in traversal would fail.")
        public boolean queryFailTraversal() default false;

        @AttributeDefinition(name="Fast result size", description="Whether the query result size (QueryResult.getSize()) should return an estimation for queries that return many nodes. The estimate will be larger or equal the actual result size, as it includes unindexed properties and nodes that are not accessible. If disabled, for such cases -1 is returned. Note: even if enabled, getSize may still return -1 if the index used does not support the feature.")
        public boolean fastQuerySize() default false;

        @AttributeDefinition(name="Enable Strict Path restrictions for indexes to be used", description="Whether path restrictions of indexes (excludedPaths / includedPaths) are taken intoaccount during query execution, for Lucene indexes. When enabled, only indexes are considered ifthe index path restriction is compatible with the query path restrictions. When disabled, onlythe queryPaths of the index is taken into account.")
        public String getStrictPathRestrictionsForIndexes() default "DISABLE";
    }
}

