/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.sling;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.sling.testing.tools.http.RequestBuilder;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.apache.sling.testing.tools.jarexec.JarExecutor;
import org.apache.sling.testing.tools.junit.TestDescriptionInterceptor;
import org.apache.sling.testing.tools.osgi.WebconsoleClient;
import org.apache.sling.testing.tools.sling.BundlesInstaller;
import org.apache.sling.testing.tools.sling.SlingInstance;
import org.apache.sling.testing.tools.sling.SlingInstanceState;
import org.apache.sling.testing.tools.sling.TimeoutsProvider;
import org.junit.After;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingTestBase
implements SlingInstance {
    public static final String TEST_SERVER_URL_PROP = "test.server.url";
    public static final String TEST_SERVER_USERNAME = "test.server.username";
    public static final String TEST_SERVER_PASSWORD = "test.server.password";
    public static final String SERVER_READY_TIMEOUT_PROP = "server.ready.timeout.seconds";
    public static final String SERVER_READY_PROP_PREFIX = "server.ready.path";
    public static final String KEEP_JAR_RUNNING_PROP = "keepJarRunning";
    public static final String SERVER_HOSTNAME_PROP = "test.server.hostname";
    public static final String ADDITONAL_BUNDLES_PATH = "additional.bundles.path";
    public static final String ADDITONAL_BUNDLES_UNINSTALL = "additional.bundles.uninstall";
    public static final String BUNDLE_TO_INSTALL_PREFIX = "sling.additional.bundle";
    public static final String START_BUNDLES_TIMEOUT_SECONDS = "start.bundles.timeout.seconds";
    public static final String BUNDLE_INSTALL_TIMEOUT_SECONDS = "bundle.install.timeout.seconds";
    public static final String ADMIN = "admin";
    private final boolean keepJarRunning;
    private final boolean uninstallAdditionalBundles;
    private final String serverUsername;
    private final String serverPassword;
    private final SlingInstanceState slingTestState;
    private final Properties systemProperties;
    private RequestBuilder builder;
    private DefaultHttpClient httpClient = new DefaultHttpClient();
    private RequestExecutor executor = new RequestExecutor(this.httpClient);
    private WebconsoleClient webconsoleClient;
    private BundlesInstaller bundlesInstaller;
    private boolean serverStartedByThisClass;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public SlingTestBase() {
        this(SlingInstanceState.getInstance("default"), System.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlingTestBase(SlingInstanceState slingTestState, Properties systemProperties) {
        this.slingTestState = slingTestState;
        this.systemProperties = systemProperties;
        this.keepJarRunning = "true".equals(systemProperties.getProperty(KEEP_JAR_RUNNING_PROP));
        this.httpClient.addRequestInterceptor((HttpRequestInterceptor)new TestDescriptionInterceptor());
        String configuredUrl = systemProperties.getProperty(TEST_SERVER_URL_PROP, systemProperties.getProperty("launchpad.http.server.url"));
        if (configuredUrl != null && configuredUrl.trim().length() > 0) {
            slingTestState.setServerBaseUrl(configuredUrl);
            slingTestState.setServerStarted(true);
            this.uninstallAdditionalBundles = "true".equals(systemProperties.getProperty(ADDITONAL_BUNDLES_UNINSTALL));
        } else {
            SlingInstanceState slingInstanceState = this.slingTestState;
            synchronized (slingInstanceState) {
                try {
                    if (slingTestState.getJarExecutor() == null) {
                        slingTestState.setJarExecutor(new JarExecutor(systemProperties));
                    }
                }
                catch (Exception e) {
                    this.log.error("JarExecutor setup failed", (Throwable)e);
                    Assert.fail((String)("JarExecutor setup failed: " + e));
                }
            }
            String serverHost = systemProperties.getProperty(SERVER_HOSTNAME_PROP);
            if (serverHost == null || serverHost.trim().length() == 0) {
                serverHost = "localhost";
            }
            slingTestState.setServerBaseUrl("http://" + serverHost + ":" + slingTestState.getJarExecutor().getServerPort());
            this.uninstallAdditionalBundles = false;
        }
        String configuredUsername = systemProperties.getProperty(TEST_SERVER_USERNAME);
        this.serverUsername = configuredUsername != null && configuredUsername.trim().length() > 0 ? configuredUsername : ADMIN;
        String configuredPassword = systemProperties.getProperty(TEST_SERVER_PASSWORD);
        this.serverPassword = configuredPassword != null && configuredPassword.trim().length() > 0 ? configuredPassword : ADMIN;
        this.builder = new RequestBuilder(slingTestState.getServerBaseUrl());
        this.webconsoleClient = new WebconsoleClient(slingTestState.getServerBaseUrl(), this.serverUsername, this.serverPassword);
        this.builder = new RequestBuilder(slingTestState.getServerBaseUrl());
        this.bundlesInstaller = new BundlesInstaller(this.webconsoleClient);
        if (!slingTestState.isServerInfoLogged()) {
            this.log.info("Server base URL={}", (Object)slingTestState.getServerBaseUrl());
            slingTestState.setServerInfoLogged(true);
        }
    }

    @After
    public void uninstallAdditionalBundlesIfNecessary() {
        if (this.uninstallAdditionalBundles) {
            this.log.info("Uninstalling additional bundles...");
            this.uninstallAdditionalBundles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServerIfNeeded() {
        try {
            if (this.slingTestState.isServerStarted() && !this.serverStartedByThisClass && !this.slingTestState.isStartupInfoProvided()) {
                this.log.info("test.server.url was set: not starting server jar (" + this.slingTestState.getServerBaseUrl() + ")");
            }
            if (!this.slingTestState.isServerStarted()) {
                SlingInstanceState slingInstanceState = this.slingTestState;
                synchronized (slingInstanceState) {
                    if (!this.slingTestState.isServerStarted()) {
                        this.slingTestState.getJarExecutor().start();
                        this.serverStartedByThisClass = true;
                        if (!this.slingTestState.setServerStarted(true)) {
                            Assert.fail((String)("A server is already started at " + this.slingTestState.getServerBaseUrl()));
                        }
                    }
                }
            }
            this.slingTestState.setStartupInfoProvided(true);
            this.waitForServerReady();
            this.installAdditionalBundles();
            this.blockIfRequested();
        }
        catch (Exception e) {
            this.log.error("Exception in maybeStartServer()", (Throwable)e);
            Assert.fail((String)("maybeStartServer() failed: " + e));
        }
    }

    protected void installAdditionalBundles() {
        if (this.slingTestState.isInstallBundlesFailed()) {
            Assert.fail((String)"Bundles could not be installed, cannot run tests");
        } else if (!this.slingTestState.isExtraBundlesInstalled()) {
            List<File> toInstall = this.getBundlesToInstall();
            if (!toInstall.isEmpty()) {
                try {
                    this.bundlesInstaller.installBundles(toInstall, false);
                    LinkedList<String> symbolicNames = new LinkedList<String>();
                    for (File f : toInstall) {
                        symbolicNames.add(this.bundlesInstaller.getBundleSymbolicName(f));
                    }
                    this.bundlesInstaller.waitForBundlesInstalled(symbolicNames, TimeoutsProvider.getInstance().getTimeout(BUNDLE_INSTALL_TIMEOUT_SECONDS, 10));
                    this.bundlesInstaller.startAllBundles(symbolicNames, TimeoutsProvider.getInstance().getTimeout(START_BUNDLES_TIMEOUT_SECONDS, 30));
                }
                catch (AssertionError ae) {
                    this.log.info("Exception while installing additional bundles", (Throwable)((Object)ae));
                    this.slingTestState.setInstallBundlesFailed(true);
                }
                catch (Exception e) {
                    this.log.info("Exception while installing additional bundles", (Throwable)e);
                    this.slingTestState.setInstallBundlesFailed(true);
                }
                if (this.slingTestState.isInstallBundlesFailed()) {
                    Assert.fail((String)("Could not start all installed bundles:" + toInstall));
                }
            } else {
                this.log.info("Not installing additional bundles, probably System property {} not set", (Object)ADDITONAL_BUNDLES_PATH);
            }
        }
        this.slingTestState.setExtraBundlesInstalled(!this.slingTestState.isInstallBundlesFailed());
    }

    protected void uninstallAdditionalBundles() {
        try {
            this.bundlesInstaller.uninstallBundles(this.getBundlesToInstall());
        }
        catch (Exception e) {
            this.log.info("Exception while uninstalling additional bundles", (Throwable)e);
        }
    }

    @Override
    public RequestBuilder getRequestBuilder() {
        this.startServerIfNeeded();
        return this.builder;
    }

    @Override
    public String getServerBaseUrl() {
        this.startServerIfNeeded();
        return this.slingTestState.getServerBaseUrl();
    }

    @Override
    public String getServerUsername() {
        return this.serverUsername;
    }

    @Override
    public String getServerPassword() {
        return this.serverPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void blockIfRequested() {
        if (this.keepJarRunning) {
            this.log.info("keepJarRunning set to true - entering infinite loop so that runnable jar stays up. Kill this process to exit.");
            SlingInstanceState slingInstanceState = this.slingTestState;
            synchronized (slingInstanceState) {
                try {
                    this.slingTestState.wait();
                }
                catch (InterruptedException iex) {
                    this.log.info("InterruptedException in blockIfRequested");
                }
            }
        }
    }

    protected void waitForServerReady() throws Exception {
        if (this.slingTestState.isServerReady()) {
            return;
        }
        if (this.slingTestState.isServerReadyTestFailed()) {
            Assert.fail((String)"Server is not ready according to previous tests");
        }
        String sec = this.systemProperties.getProperty(SERVER_READY_TIMEOUT_PROP);
        int timeoutSec = TimeoutsProvider.getInstance().getTimeout(sec == null ? 60 : Integer.valueOf(sec));
        this.log.info("Will wait up to " + timeoutSec + " seconds for server to become ready");
        long endTime = System.currentTimeMillis() + (long)timeoutSec * 1000L;
        ArrayList<String> testPaths = new ArrayList<String>();
        TreeSet<Object> propertyNames = new TreeSet<Object>();
        propertyNames.addAll(this.systemProperties.keySet());
        for (Object e : propertyNames) {
            String key = (String)e;
            if (!key.startsWith(SERVER_READY_PROP_PREFIX)) continue;
            testPaths.add(this.systemProperties.getProperty(key));
        }
        this.log.info("Checking that GET requests return expected content (timeout={} seconds): {}", (Object)timeoutSec, testPaths);
        while (System.currentTimeMillis() < endTime) {
            boolean errors = false;
            for (String p : testPaths) {
                String[] s = p.split(":");
                String path = s[0];
                String pattern = s.length > 0 ? s[1] : "";
                try {
                    this.executor.execute(this.builder.buildGetRequest(path, new String[0]).withCredentials(this.serverUsername, this.serverPassword)).assertStatus(200).assertContentContains(pattern);
                }
                catch (AssertionError ae) {
                    errors = true;
                    this.log.debug("Request to {}@{}{} failed, will retry ({})", new Object[]{this.serverUsername, this.slingTestState.getServerBaseUrl(), path, ae});
                }
                catch (Exception e) {
                    errors = true;
                    this.log.debug("Request to {}@{}{} failed, will retry ({})", new Object[]{this.serverUsername, this.slingTestState.getServerBaseUrl(), path, pattern, e});
                }
            }
            if (!errors) {
                this.slingTestState.setServerReady(true);
                this.log.info("All {} paths return expected content, server ready", (Object)testPaths.size());
                break;
            }
            Thread.sleep(TimeoutsProvider.getInstance().getTimeout(1000L));
        }
        if (!this.slingTestState.isServerReady()) {
            this.slingTestState.setServerReadyTestFailed(true);
            String msg = "Server not ready after " + timeoutSec + " seconds, giving up";
            this.log.info(msg);
            Assert.fail((String)msg);
        }
    }

    protected List<File> getBundlesToInstall() {
        String[] allPaths;
        String paths = this.systemProperties.getProperty(ADDITONAL_BUNDLES_PATH);
        if (paths == null) {
            return Collections.emptyList();
        }
        ArrayList<File> toInstall = new ArrayList<File>();
        for (String path : allPaths = paths.split(",")) {
            toInstall.addAll(this.getBundlesToInstall(path.trim()));
        }
        return toInstall;
    }

    protected List<File> getBundlesToInstall(String additionalBundlesPath) {
        LinkedList<File> result = new LinkedList<File>();
        if (additionalBundlesPath == null) {
            return result;
        }
        File dir = new File(additionalBundlesPath);
        if (!dir.isDirectory() || !dir.canRead()) {
            this.log.info("Cannot read additional bundles directory {}, ignored", (Object)dir.getAbsolutePath());
            return result;
        }
        ArrayList<String> bundleNames = new ArrayList<String>();
        String[] files = dir.list();
        if (files != null) {
            for (String file : files) {
                if (!file.endsWith(".jar")) continue;
                bundleNames.add(file);
            }
        }
        ArrayList<String> sortedPropertyKeys = new ArrayList<String>();
        for (Object key : this.systemProperties.keySet()) {
            String str = key.toString();
            if (!str.startsWith(BUNDLE_TO_INSTALL_PREFIX)) continue;
            sortedPropertyKeys.add(str);
        }
        Collections.sort(sortedPropertyKeys);
        for (String key : sortedPropertyKeys) {
            String filenamePrefix = this.systemProperties.getProperty(key);
            for (String bundleFilename : bundleNames) {
                if (!bundleFilename.startsWith(filenamePrefix)) continue;
                result.add(new File(dir, bundleFilename));
            }
        }
        return result;
    }

    public boolean isServerStartedByThisClass() {
        return this.serverStartedByThisClass;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public RequestExecutor getRequestExecutor() {
        return this.executor;
    }

    public WebconsoleClient getWebconsoleClient() {
        this.startServerIfNeeded();
        return this.webconsoleClient;
    }
}

