/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

public enum ExpressionType {
    Add(" + ", false, 4, false),
    AddChecked(" + ", false, 4, false),
    And(" & ", false, 8, false),
    AndAlso(" && ", false, 11, false),
    ArrayLength,
    ArrayIndex,
    Call(".", false, 1, false),
    Coalesce,
    Conditional(" ? ", " : ", false, 13, true),
    Constant,
    Convert(null, false, 2, true),
    ConvertChecked,
    Divide(" / ", false, 3, false),
    Equal(" == ", false, 7, false),
    ExclusiveOr(" ^ ", false, 9, false),
    GreaterThan(" > ", false, 6, false),
    GreaterThanOrEqual(" >= ", false, 6, false),
    Invoke,
    Lambda,
    LeftShift(" << ", false, 5, false),
    LessThan(" < ", false, 6, false),
    LessThanOrEqual(" <= ", false, 6, false),
    ListInit,
    MemberAccess(".", false, 1, false),
    MemberInit,
    Modulo(" % ", false, 3, false),
    Multiply(" * ", false, 3, false),
    MultiplyChecked(" * ", false, 3, false),
    Negate("- ", false, 2, true),
    UnaryPlus("+ ", false, 2, true),
    NegateChecked("-", false, 2, true),
    New,
    NewArrayInit,
    NewArrayBounds,
    Not("!", false, 2, true),
    NotEqual(" != ", false, 7, false),
    Or(" | ", false, 10, false),
    OrElse(" || ", false, 12, false),
    Parameter,
    Power,
    Quote,
    RightShift(" >> ", false, 5, false),
    Subtract(" - ", false, 4, false),
    SubtractChecked(" - ", false, 4, false),
    TypeAs,
    TypeIs(" instanceof ", false, 6, false),
    Assign(" = ", null, false, 14, true, true),
    Block,
    DebugInfo,
    Decrement,
    Dynamic,
    Default,
    Extension,
    Goto,
    Increment,
    Index,
    Label,
    RuntimeVariables,
    Loop,
    Switch,
    Throw,
    Try,
    Unbox,
    AddAssign(" += ", null, false, 14, true, true),
    AndAssign(" &= ", null, false, 14, true, true),
    DivideAssign(" /= ", null, false, 14, true, true),
    ExclusiveOrAssign(" ^= ", null, false, 14, true, true),
    LeftShiftAssign(" <<= ", null, false, 14, true, true),
    ModuloAssign(" %= ", null, false, 14, true, true),
    MultiplyAssign(" *= ", null, false, 14, true, true),
    OrAssign(" |= ", null, false, 14, true, true),
    PowerAssign,
    RightShiftAssign(" >>= ", null, false, 14, true, true),
    SubtractAssign(" -= ", null, false, 14, true, true),
    AddAssignChecked(" += ", null, false, 14, true),
    MultiplyAssignChecked(" *= ", null, false, 14, true, true),
    SubtractAssignChecked(" -= ", null, false, 14, true, true),
    PreIncrementAssign("++", null, false, 2, true, true),
    PreDecrementAssign("--", null, false, 2, true, true),
    PostIncrementAssign("++", null, true, 2, true, true),
    PostDecrementAssign("--", null, true, 2, true, true),
    TypeEqual,
    OnesComplement("~", false, 2, true),
    IsTrue,
    IsFalse,
    Declaration,
    For,
    While;

    final String op;
    final String op2;
    final boolean postfix;
    final int lprec;
    final int rprec;
    final boolean modifiesLvalue;

    private ExpressionType() {
        this(null, false, 0, false);
    }

    private ExpressionType(String op, boolean postfix, int prec, boolean right) {
        this(op, null, postfix, prec, right);
    }

    private ExpressionType(String op, String op2, boolean postfix, int prec, boolean right) {
        this(op, op2, postfix, prec, right, false);
    }

    private ExpressionType(String op, String op2, boolean postfix, int prec, boolean right, boolean modifiesLvalue) {
        this.op = op;
        this.op2 = op2;
        this.postfix = postfix;
        this.modifiesLvalue = modifiesLvalue;
        this.lprec = (20 - prec) * 2 + (right ? 1 : 0);
        this.rprec = (20 - prec) * 2 + (right ? 0 : 1);
    }
}

