/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.check.http;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.health.check.http.HttpHealthResponse;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Response;
import java.time.Duration;
import java.util.Objects;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHealthCheck
extends HealthCheck {
    static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(2L);
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHealthCheck.class);
    private final @NonNull String url;
    private final @NonNull Client client;

    public HttpHealthCheck(@NonNull String url) {
        this(url, DEFAULT_TIMEOUT, DEFAULT_TIMEOUT);
    }

    public HttpHealthCheck(@NonNull String url, Duration readTimeout, Duration connectionTimeout) {
        this.url = Objects.requireNonNull(url);
        if (readTimeout.toMillis() <= 0L || connectionTimeout.toMillis() <= 0L) {
            throw new IllegalStateException();
        }
        this.client = JerseyClientBuilder.createClient().property("jersey.config.client.connectTimeout", (Object)((int)connectionTimeout.toMillis())).property("jersey.config.client.readTimeout", (Object)((int)readTimeout.toMillis()));
    }

    public HttpHealthCheck(@NonNull String url, @NonNull Client client) {
        this.url = Objects.requireNonNull(url);
        this.client = Objects.requireNonNull(client);
    }

    protected HealthCheck.Result check() {
        HttpHealthResponse httpHealthResponse = this.httpCheck(this.url);
        if (this.isHealthResponseValid(httpHealthResponse)) {
            LOGGER.debug("Health check against url={} successful", (Object)this.url);
            return HealthCheck.Result.healthy();
        }
        LOGGER.debug("Health check against url={} failed with response={}", (Object)this.url, (Object)httpHealthResponse);
        return HealthCheck.Result.unhealthy((String)"Http health check against url=%s failed with response=%s", (Object[])new Object[]{this.url, httpHealthResponse});
    }

    protected HttpHealthResponse httpCheck(String url) {
        Response response = this.client.target(url).request().get();
        String entityString = (String)response.readEntity(String.class);
        return new HttpHealthResponse(response.getStatus(), entityString);
    }

    protected boolean isHealthResponseValid(HttpHealthResponse httpHealthResponse) {
        Response.Status.Family statusFamily = Response.Status.Family.familyOf((int)httpHealthResponse.getStatus());
        return statusFamily == Response.Status.Family.SUCCESSFUL;
    }
}

