/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.SaslException;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.BufferCallBeforeInitHandler;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.CallEvent;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.FallbackDisallowedException;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcDuplexHandler;
import org.apache.hadoop.hbase.ipc.PreambleCallHandler;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcConnection;
import org.apache.hadoop.hbase.security.NettyHBaseRpcConnectionHeaderHandler;
import org.apache.hadoop.hbase.security.NettyHBaseSaslRpcClientHandler;
import org.apache.hadoop.hbase.security.SaslChallengeDecoder;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.NettyFutureUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.io.netty.bootstrap.Bootstrap;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufOutputStream;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFutureListener;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOption;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundInvoker;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslHandler;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.IdleStateHandler;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.ReadTimeoutHandler;
import org.apache.hbase.thirdparty.io.netty.util.ReferenceCountUtil;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Future;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.FutureListener;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.GenericFutureListener;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Promise;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class NettyRpcConnection
extends RpcConnection {
    private static final Logger LOG = LoggerFactory.getLogger(NettyRpcConnection.class);
    private static final ScheduledExecutorService RELOGIN_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Relogin-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
    private final NettyRpcClient rpcClient;
    private final EventLoop eventLoop;
    private ByteBuf connectionHeaderPreamble;
    private ByteBuf connectionHeaderWithLength;
    private volatile Channel channel;
    private boolean reloginInProgress;

    NettyRpcConnection(NettyRpcClient rpcClient, ConnectionId remoteId) throws IOException {
        super(rpcClient.conf, AbstractRpcClient.WHEEL_TIMER, remoteId, rpcClient.clusterId, rpcClient.userProvider.isHBaseSecurityEnabled(), rpcClient.codec, rpcClient.compressor, rpcClient.cellBlockBuilder, rpcClient.metrics, rpcClient.connectionAttributes);
        this.rpcClient = rpcClient;
        this.eventLoop = rpcClient.group.next();
        byte[] connectionHeaderPreamble = this.getConnectionHeaderPreamble();
        this.connectionHeaderPreamble = Unpooled.directBuffer((int)connectionHeaderPreamble.length).writeBytes(connectionHeaderPreamble);
        RPCProtos.ConnectionHeader header = this.getConnectionHeader();
        this.connectionHeaderWithLength = Unpooled.directBuffer((int)(4 + header.getSerializedSize()));
        this.connectionHeaderWithLength.writeInt(header.getSerializedSize());
        header.writeTo((OutputStream)new ByteBufOutputStream(this.connectionHeaderWithLength));
    }

    @Override
    protected void callTimeout(Call call) {
        IPCUtil.execute(this.eventLoop, () -> {
            if (this.channel != null) {
                this.channel.pipeline().fireUserEventTriggered((Object)new CallEvent(CallEvent.Type.TIMEOUT, call));
            }
        });
    }

    @Override
    public boolean isActive() {
        return this.channel != null;
    }

    private void shutdown0() {
        assert (this.eventLoop.inEventLoop());
        if (this.channel != null) {
            NettyFutureUtils.consume((Future)this.channel.close());
            this.channel = null;
        }
    }

    @Override
    public void shutdown() {
        IPCUtil.execute(this.eventLoop, this::shutdown0);
    }

    @Override
    public void cleanupConnection() {
        IPCUtil.execute(this.eventLoop, () -> {
            if (this.connectionHeaderPreamble != null) {
                ReferenceCountUtil.safeRelease((Object)this.connectionHeaderPreamble);
                this.connectionHeaderPreamble = null;
            }
            if (this.connectionHeaderWithLength != null) {
                ReferenceCountUtil.safeRelease((Object)this.connectionHeaderWithLength);
                this.connectionHeaderWithLength = null;
            }
        });
    }

    private void established(Channel ch) {
        assert (this.eventLoop.inEventLoop());
        ch.pipeline().addBefore("BufferCall", null, (ChannelHandler)new IdleStateHandler(0L, (long)this.rpcClient.minIdleTimeBeforeClose, 0L, TimeUnit.MILLISECONDS)).addBefore("BufferCall", null, (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4)).addBefore("BufferCall", null, (ChannelHandler)new NettyRpcDuplexHandler(this, this.rpcClient.cellBlockBuilder, this.codec, this.compressor)).fireUserEventTriggered((Object)BufferCallBeforeInitHandler.BufferCallEvent.success());
    }

    private void saslEstablished(Channel ch, String serverPrincipal) {
        this.saslNegotiationDone(serverPrincipal, true);
        this.established(ch);
    }

    private void scheduleRelogin(Throwable error) {
        assert (this.eventLoop.inEventLoop());
        if (error instanceof FallbackDisallowedException) {
            return;
        }
        if (!this.provider.canRetry()) {
            LOG.trace("SASL Provider does not support retries");
            return;
        }
        if (this.reloginInProgress) {
            return;
        }
        this.reloginInProgress = true;
        RELOGIN_EXECUTOR.schedule(() -> {
            try {
                this.provider.relogin();
            }
            catch (IOException e) {
                LOG.warn("Relogin failed", (Throwable)e);
            }
            this.eventLoop.execute(() -> {
                this.reloginInProgress = false;
            });
        }, (long)ThreadLocalRandom.current().nextInt(this.reloginMaxBackoff), TimeUnit.MILLISECONDS);
    }

    private void failInit(Channel ch, IOException e) {
        assert (this.eventLoop.inEventLoop());
        ch.pipeline().fireUserEventTriggered((Object)BufferCallBeforeInitHandler.BufferCallEvent.fail(e));
        this.shutdown0();
        this.rpcClient.failedServers.addToFailedServers(this.remoteId.getAddress(), e);
    }

    private void saslFailInit(Channel ch, String serverPrincipal, IOException error) {
        assert (this.eventLoop.inEventLoop());
        this.saslNegotiationDone(serverPrincipal, false);
        this.failInit(ch, error);
    }

    private void saslNegotiate(final Channel ch, final String serverPrincipal) {
        NettyHBaseSaslRpcClientHandler saslHandler;
        assert (this.eventLoop.inEventLoop());
        NettyFutureUtils.safeWriteAndFlush((ChannelOutboundInvoker)ch, (Object)this.connectionHeaderPreamble.retainedDuplicate());
        UserGroupInformation ticket = this.provider.getRealUser(this.remoteId.getTicket());
        if (ticket == null) {
            this.saslFailInit(ch, serverPrincipal, (IOException)((Object)new FatalConnectionException("ticket/user is null")));
            return;
        }
        Promise saslPromise = ch.eventLoop().newPromise();
        try {
            saslHandler = new NettyHBaseSaslRpcClientHandler((Promise<Boolean>)saslPromise, ticket, this.provider, (Token<? extends TokenIdentifier>)this.token, ((InetSocketAddress)ch.remoteAddress()).getAddress(), serverPrincipal, this.rpcClient.fallbackAllowed, this.rpcClient.conf);
        }
        catch (IOException e) {
            this.saslFailInit(ch, serverPrincipal, e);
            return;
        }
        ch.pipeline().addBefore("BufferCall", null, (ChannelHandler)new SaslChallengeDecoder()).addBefore("BufferCall", "SaslRpcClientHandler", (ChannelHandler)saslHandler);
        NettyFutureUtils.addListener((Future)saslPromise, (GenericFutureListener)new FutureListener<Boolean>(){

            public void operationComplete(Future<Boolean> future) throws Exception {
                if (future.isSuccess()) {
                    ChannelPipeline p = ch.pipeline();
                    if (saslHandler.isNeedProcessConnectionHeader()) {
                        Promise connectionHeaderPromise = ch.eventLoop().newPromise();
                        NettyHBaseRpcConnectionHeaderHandler chHandler = new NettyHBaseRpcConnectionHeaderHandler((Promise<Boolean>)connectionHeaderPromise, NettyRpcConnection.this.conf, NettyRpcConnection.this.connectionHeaderWithLength);
                        String readTimeoutHandlerName = "ReadTimeout";
                        p.addBefore("BufferCall", "ReadTimeout", (ChannelHandler)new ReadTimeoutHandler((long)((NettyRpcConnection)NettyRpcConnection.this).rpcClient.readTO, TimeUnit.MILLISECONDS)).addBefore("BufferCall", null, (ChannelHandler)chHandler);
                        NettyFutureUtils.addListener((Future)connectionHeaderPromise, (GenericFutureListener)new FutureListener<Boolean>(){

                            public void operationComplete(Future<Boolean> future) throws Exception {
                                if (future.isSuccess()) {
                                    ChannelPipeline p = ch.pipeline();
                                    p.remove("ReadTimeout");
                                    p.remove(NettyHBaseRpcConnectionHeaderHandler.class);
                                    NettyRpcConnection.this.saslEstablished(ch, serverPrincipal);
                                } else {
                                    Throwable error = future.cause();
                                    NettyRpcConnection.this.scheduleRelogin(error);
                                    NettyRpcConnection.this.saslFailInit(ch, serverPrincipal, IPCUtil.toIOE(error));
                                }
                            }
                        });
                    } else {
                        ch.write((Object)NettyRpcConnection.this.connectionHeaderWithLength.retainedDuplicate());
                        NettyRpcConnection.this.saslEstablished(ch, serverPrincipal);
                    }
                } else {
                    Throwable error = future.cause();
                    NettyRpcConnection.this.scheduleRelogin(error);
                    NettyRpcConnection.this.saslFailInit(ch, serverPrincipal, IPCUtil.toIOE(error));
                }
            }
        });
    }

    private void getConnectionRegistry(Channel ch, Call connectionRegistryCall) {
        assert (this.eventLoop.inEventLoop());
        PreambleCallHandler.setup(ch.pipeline(), this.rpcClient.readTO, this, RpcClient.REGISTRY_PREAMBLE_HEADER, connectionRegistryCall);
    }

    private void onSecurityPreambleError(Channel ch, Set<String> serverPrincipals, IOException error) {
        assert (this.eventLoop.inEventLoop());
        LOG.debug("Error when trying to do a security preamble call to {}", (Object)this.remoteId.address, (Object)error);
        if (ConnectionUtils.isUnexpectedPreambleHeaderException(error)) {
            return;
        }
        if (IPCUtil.isSecurityNotEnabledException(error)) {
            if (this.rpcClient.fallbackAllowed) {
                this.saslNegotiate(ch, serverPrincipals.iterator().next());
            } else {
                this.failInit(ch, (IOException)((Object)new FallbackDisallowedException()));
            }
            return;
        }
        this.saslNegotiate(ch, this.randomSelect(serverPrincipals));
    }

    private void onSecurityPreambleFinish(Channel ch, Set<String> serverPrincipals, Call securityPreambleCall) {
        String serverPrincipal;
        assert (this.eventLoop.inEventLoop());
        try {
            serverPrincipal = this.chooseServerPrincipal(serverPrincipals, securityPreambleCall);
        }
        catch (SaslException e) {
            this.failInit(ch, e);
            return;
        }
        this.saslNegotiate(ch, serverPrincipal);
    }

    private void saslNegotiate(Channel ch) throws IOException {
        assert (this.eventLoop.inEventLoop());
        Set<String> serverPrincipals = this.getServerPrincipals();
        if (serverPrincipals.size() == 1) {
            this.saslNegotiate(ch, serverPrincipals.iterator().next());
            return;
        }
        Call securityPreambleCall = this.createSecurityPreambleCall((RpcCallback<Call>)((RpcCallback)call -> {
            assert (this.eventLoop.inEventLoop());
            if (call.error != null) {
                this.onSecurityPreambleError(ch, serverPrincipals, call.error);
            } else {
                this.onSecurityPreambleFinish(ch, serverPrincipals, (Call)call);
            }
        }));
        PreambleCallHandler.setup(ch.pipeline(), this.rpcClient.readTO, this, RpcClient.SECURITY_PREAMBLE_HEADER, securityPreambleCall);
    }

    private void connect(final Call connectionRegistryCall) throws UnknownHostException {
        assert (this.eventLoop.inEventLoop());
        LOG.trace("Connecting to {}", (Object)this.remoteId.getAddress());
        InetSocketAddress remoteAddr = this.getRemoteInetAddress(this.rpcClient.metrics);
        this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.eventLoop)).channel(this.rpcClient.channelClass)).option(ChannelOption.TCP_NODELAY, (Object)this.rpcClient.isTcpNoDelay())).option(ChannelOption.SO_KEEPALIVE, (Object)this.rpcClient.tcpKeepAlive)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.rpcClient.connectTO)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                if (NettyRpcConnection.this.conf.getBoolean("hbase.client.netty.tls.enabled", false)) {
                    SslContext sslContext = NettyRpcConnection.this.rpcClient.getSslContext();
                    SslHandler sslHandler = sslContext.newHandler(ch.alloc(), NettyRpcConnection.this.remoteId.address.getHostName(), NettyRpcConnection.this.remoteId.address.getPort());
                    sslHandler.setHandshakeTimeoutMillis((long)NettyRpcConnection.this.conf.getInt("hbase.client.netty.tls.handshaketimeout", 5000));
                    ch.pipeline().addFirst(new ChannelHandler[]{sslHandler});
                    LOG.debug("SSL handler added with handshake timeout {} ms", (Object)sslHandler.getHandshakeTimeoutMillis());
                }
                ch.pipeline().addLast("BufferCall", (ChannelHandler)new BufferCallBeforeInitHandler());
            }
        })).localAddress(this.rpcClient.localAddr)).remoteAddress((SocketAddress)remoteAddr).connect().addListener((GenericFutureListener)new ChannelFutureListener(){

            private void succeed(Channel ch) throws IOException {
                if (connectionRegistryCall != null) {
                    NettyRpcConnection.this.getConnectionRegistry(ch, connectionRegistryCall);
                    return;
                }
                if (!NettyRpcConnection.this.useSasl) {
                    NettyFutureUtils.safeWrite((ChannelOutboundInvoker)ch, (Object)NettyRpcConnection.this.connectionHeaderPreamble.retainedDuplicate());
                    NettyFutureUtils.safeWrite((ChannelOutboundInvoker)ch, (Object)NettyRpcConnection.this.connectionHeaderWithLength.retainedDuplicate());
                    NettyRpcConnection.this.established(ch);
                } else {
                    NettyRpcConnection.this.saslNegotiate(ch);
                }
            }

            private void fail(Channel ch, Throwable error) {
                IOException ex = IPCUtil.toIOE(error);
                LOG.warn("Exception encountered while connecting to the server " + NettyRpcConnection.this.remoteId.getAddress(), (Throwable)ex);
                if (connectionRegistryCall != null) {
                    connectionRegistryCall.setException(ex);
                }
                NettyRpcConnection.this.failInit(ch, ex);
            }

            public void operationComplete(ChannelFuture future) throws Exception {
                Channel ch = future.channel();
                if (!future.isSuccess()) {
                    this.fail(ch, future.cause());
                    return;
                }
                SslHandler sslHandler = (SslHandler)ch.pipeline().get(SslHandler.class);
                if (sslHandler != null) {
                    NettyFutureUtils.addListener((Future)sslHandler.handshakeFuture(), f -> {
                        if (f.isSuccess()) {
                            this.succeed(ch);
                        } else {
                            this.fail(ch, f.cause());
                        }
                    });
                } else {
                    this.succeed(ch);
                }
            }
        }).channel();
    }

    private void sendRequest0(final Call call, HBaseRpcController hrc) throws IOException {
        assert (this.eventLoop.inEventLoop());
        if (call.isConnectionRegistryCall()) {
            this.connect(call);
            return;
        }
        if (this.reloginInProgress) {
            throw new IOException("Can not send request because relogin is in progress.");
        }
        hrc.notifyOnCancel(new RpcCallback<Object>(){

            public void run(Object parameter) {
                IPCUtil.setCancelled(call);
                if (NettyRpcConnection.this.channel != null) {
                    NettyRpcConnection.this.channel.pipeline().fireUserEventTriggered((Object)new CallEvent(CallEvent.Type.CANCELLED, call));
                }
            }
        }, new HBaseRpcController.CancellationCallback(){

            @Override
            public void run(boolean cancelled) throws IOException {
                if (cancelled) {
                    IPCUtil.setCancelled(call);
                } else {
                    if (NettyRpcConnection.this.channel == null) {
                        NettyRpcConnection.this.connect(null);
                    }
                    NettyRpcConnection.this.scheduleTimeoutTask(call);
                    NettyFutureUtils.addListener((Future)NettyRpcConnection.this.channel.writeAndFlush((Object)call), (GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                call.setException(IPCUtil.toIOE(future.cause()));
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void sendRequest(Call call, HBaseRpcController hrc) {
        IPCUtil.execute(this.eventLoop, () -> {
            try {
                this.sendRequest0(call, hrc);
            }
            catch (Exception e) {
                call.setException(IPCUtil.toIOE(e));
            }
        });
    }
}

