/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.tls;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.security.auth.Subject;
import javax.security.cert.X509Certificate;
import org.apache.storm.security.auth.ITransportPlugin;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.SingleUserPrincipal;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.security.auth.tls.ReloadableTsslTransportFactory;
import org.apache.storm.thrift.TException;
import org.apache.storm.thrift.TProcessor;
import org.apache.storm.thrift.protocol.TBinaryProtocol;
import org.apache.storm.thrift.protocol.TProtocol;
import org.apache.storm.thrift.protocol.TProtocolFactory;
import org.apache.storm.thrift.server.TServer;
import org.apache.storm.thrift.server.TThreadPoolServer;
import org.apache.storm.thrift.transport.TSSLTransportFactory;
import org.apache.storm.thrift.transport.TServerSocket;
import org.apache.storm.thrift.transport.TServerTransport;
import org.apache.storm.thrift.transport.TSocket;
import org.apache.storm.thrift.transport.TTransport;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.utils.ExtendedThreadPoolExecutor;
import org.apache.storm.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsTransportPlugin
implements ITransportPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(TlsTransportPlugin.class);
    protected ThriftConnectionType type;
    protected Map<String, Object> conf;
    private int port;
    private static TServerSocket serverTransport;
    private static TThreadPoolServer tThreadPoolServer;

    @Override
    public void prepare(ThriftConnectionType type, Map<String, Object> conf) {
        this.type = type;
        this.conf = conf;
    }

    @Override
    public TServer getServer(TProcessor processor) throws IOException, TTransportException {
        if (!this.type.isTlsEnabled()) {
            throw new UnsupportedEncodingException("Non-TLS connection is not supported");
        }
        int configuredPort = this.type.getPort(this.conf);
        Integer socketTimeout = this.type.getSocketTimeOut(this.conf);
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        if (this.type.getServerKeyStorePath(this.conf) == null || this.type.getServerKeyStorePassword(this.conf) == null) {
            throw new IllegalArgumentException("The server keystore is not configured properly");
        }
        params.setKeyStore(this.type.getServerKeyStorePath(this.conf), this.type.getServerKeyStorePassword(this.conf), null, SecurityUtils.inferKeyStoreTypeFromPath(this.type.getServerKeyStorePath(this.conf)));
        if (this.type.isClientAuthRequired(this.conf)) {
            if (this.type.getServerTrustStorePath(this.conf) != null && this.type.getServerTrustStorePassword(this.conf) != null) {
                params.setTrustStore(this.type.getServerTrustStorePath(this.conf), this.type.getServerTrustStorePassword(this.conf), null, SecurityUtils.inferKeyStoreTypeFromPath(this.type.getServerTrustStorePath(this.conf)));
                params.requireClientAuth(true);
            } else {
                throw new IllegalArgumentException("The server truststore is not configured properly");
            }
        }
        int clientTimeout = socketTimeout == null ? 0 : socketTimeout;
        TServerSocket serverTransport = null;
        try {
            serverTransport = ReloadableTsslTransportFactory.getServerSocket(configuredPort, clientTimeout, InetAddress.getLocalHost(), this.type, this.conf);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        ServerSocket socket = serverTransport.getServerSocket();
        socket.setReuseAddress(true);
        this.port = socket.getLocalPort();
        int numWorkerThreads = this.type.getNumThreads(this.conf);
        Integer queueSize = this.type.getQueueSize(this.conf);
        TThreadPoolServer.Args serverArgs = (TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)new TTlsWrapProcessor(processor))).minWorkerThreads(numWorkerThreads).maxWorkerThreads(numWorkerThreads).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(false, true));
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue();
        if (queueSize != null) {
            workQueue = new ArrayBlockingQueue(queueSize);
        }
        ExtendedThreadPoolExecutor executorService = new ExtendedThreadPoolExecutor(numWorkerThreads, numWorkerThreads, 60L, TimeUnit.SECONDS, workQueue);
        serverArgs.executorService((ExecutorService)executorService);
        tThreadPoolServer = new TThreadPoolServer(serverArgs);
        return tThreadPoolServer;
    }

    @Override
    public TTransport connect(TTransport transport, String serverHost, String asUser) throws IOException, TTransportException {
        return transport;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean areWorkerTokensSupported() {
        return false;
    }

    private static class TTlsWrapProcessor
    implements TProcessor {
        final TProcessor wrapped;

        TTlsWrapProcessor(TProcessor wrapped) {
            this.wrapped = wrapped;
        }

        public void process(TProtocol inProt, TProtocol outProt) throws TException {
            TTransport trans = inProt.getTransport();
            TSocket tsocket = (TSocket)trans;
            SSLSocket socket = (SSLSocket)tsocket.getSocket();
            String principalName = "CN=ANONYMOUS";
            try {
                X509Certificate[] x509CertificateArray = socket.getSession().getPeerCertificateChain();
                int n = x509CertificateArray.length;
                int n2 = 0;
                if (n2 < n) {
                    X509Certificate cert = x509CertificateArray[n2];
                    Principal principal = cert.getSubjectDN();
                    principalName = principal.getName();
                }
            }
            catch (SSLPeerUnverifiedException e) {
                LOG.debug("Client cert is not verified. Set principalName={}.", (Object)principalName, (Object)e);
            }
            LOG.debug("principalName : {} ", (Object)principalName);
            ReqContext reqContext = ReqContext.context();
            reqContext.setRemoteAddress(socket.getInetAddress());
            Subject remoteUser = new Subject();
            remoteUser.getPrincipals().add(new SingleUserPrincipal(principalName));
            reqContext.setSubject(remoteUser);
            this.wrapped.process(inProt, outProt);
        }
    }
}

