/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.zookeeper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.callback.WatcherCallBack;
import org.apache.storm.cluster.DaemonType;
import org.apache.storm.cluster.VersionedData;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.storm.shade.org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.storm.shade.org.apache.curator.framework.api.BackgroundPathable;
import org.apache.storm.shade.org.apache.curator.framework.api.CuratorEventType;
import org.apache.storm.shade.org.apache.curator.framework.api.Pathable;
import org.apache.storm.shade.org.apache.curator.framework.api.WatchPathable;
import org.apache.storm.shade.org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.storm.shade.org.apache.zookeeper.CreateMode;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.shade.org.apache.zookeeper.WatchedEvent;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.shade.org.apache.zookeeper.data.Stat;
import org.apache.storm.utils.CuratorUtils;
import org.apache.storm.utils.Utils;
import org.apache.storm.utils.ZookeeperAuthInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientZookeeper {
    private static final ClientZookeeper INSTANCE = new ClientZookeeper();
    private static Logger LOG = LoggerFactory.getLogger(ClientZookeeper.class);
    private static ClientZookeeper _instance = INSTANCE;

    public static void setInstance(ClientZookeeper u) {
        _instance = u;
    }

    public static void resetInstance() {
        _instance = INSTANCE;
    }

    public static void mkdirs(CuratorFramework zk, String path, List<ACL> acls) {
        _instance.mkdirsImpl(zk, path, acls);
    }

    public static CuratorFramework mkClient(Map<String, Object> conf, List<String> servers, Object port, String root, WatcherCallBack watcher, Map<String, Object> authConf, DaemonType type) {
        return _instance.mkClientImpl(conf, servers, port, root, watcher, authConf, type);
    }

    public static void deleteNodeBlobstore(CuratorFramework zk, String parentPath, String hostPortInfo) {
        String normalizedParentPath = ClientZookeeper.normalizePath(parentPath);
        List<String> childPathList = null;
        if (ClientZookeeper.existsNode(zk, normalizedParentPath, false)) {
            childPathList = ClientZookeeper.getChildren(zk, normalizedParentPath, false);
            for (String child : childPathList) {
                if (!child.startsWith(hostPortInfo)) continue;
                LOG.debug("deleteNode child {}", (Object)child);
                ClientZookeeper.deleteNode(zk, normalizedParentPath + "/" + child);
            }
        }
    }

    public static String createNode(CuratorFramework zk, String path, byte[] data, CreateMode mode, List<ACL> acls) {
        String ret = null;
        try {
            String npath = ClientZookeeper.normalizePath(path);
            ret = (String)((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)zk.create().creatingParentsIfNeeded().withMode(mode)).withACL(acls)).forPath(npath, data);
        }
        catch (Exception e) {
            throw Utils.wrapInRuntime(e);
        }
        return ret;
    }

    public static String createNode(CuratorFramework zk, String path, byte[] data, List<ACL> acls) {
        return ClientZookeeper.createNode(zk, path, data, CreateMode.PERSISTENT, acls);
    }

    public static List<String> tokenizePath(String path) {
        String[] toks = path.split("/");
        ArrayList<String> rtn = new ArrayList<String>();
        for (String str : toks) {
            if (str.isEmpty()) continue;
            rtn.add(str);
        }
        return rtn;
    }

    public static String toksToPath(List<String> toks) {
        StringBuffer buff = new StringBuffer();
        buff.append("/");
        int size = toks.size();
        for (int i = 0; i < size; ++i) {
            buff.append(toks.get(i));
            if (i >= size - 1) continue;
            buff.append("/");
        }
        return buff.toString();
    }

    public static String normalizePath(String path) {
        String rtn = ClientZookeeper.toksToPath(ClientZookeeper.tokenizePath(path));
        return rtn;
    }

    public static boolean existsNode(CuratorFramework zk, String path, boolean watch) {
        Stat stat = null;
        try {
            stat = watch ? (Stat)((BackgroundPathable)zk.checkExists().watched()).forPath(ClientZookeeper.normalizePath(path)) : (Stat)zk.checkExists().forPath(ClientZookeeper.normalizePath(path));
        }
        catch (Exception e) {
            throw Utils.wrapInRuntime(e);
        }
        return stat != null;
    }

    public static void deleteNode(CuratorFramework zk, String path) {
        try {
            String npath = ClientZookeeper.normalizePath(path);
            if (ClientZookeeper.existsNode(zk, npath, false)) {
                zk.delete().deletingChildrenIfNeeded().forPath(ClientZookeeper.normalizePath(path));
            }
        }
        catch (Exception e) {
            if (Utils.exceptionCauseIsInstanceOf(KeeperException.NodeExistsException.class, e)) {
                LOG.info("delete {} failed.", (Object)path, (Object)e);
            }
            throw Utils.wrapInRuntime(e);
        }
    }

    public static String parentPath(String path) {
        List<String> toks = ClientZookeeper.tokenizePath(path);
        int size = toks.size();
        if (size > 0) {
            toks.remove(size - 1);
        }
        return ClientZookeeper.toksToPath(toks);
    }

    public static boolean exists(CuratorFramework zk, String path, boolean watch) {
        return ClientZookeeper.existsNode(zk, path, watch);
    }

    public static Stat setData(CuratorFramework zk, String path, byte[] data) {
        try {
            String npath = ClientZookeeper.normalizePath(path);
            return (Stat)zk.setData().forPath(npath, data);
        }
        catch (Exception e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    public static Integer getVersion(CuratorFramework zk, String path, boolean watch) throws Exception {
        String npath = ClientZookeeper.normalizePath(path);
        Stat stat = null;
        if (ClientZookeeper.existsNode(zk, npath, watch)) {
            stat = watch ? (Stat)((BackgroundPathable)zk.checkExists().watched()).forPath(npath) : (Stat)zk.checkExists().forPath(npath);
        }
        return stat == null ? null : Integer.valueOf(stat.getVersion());
    }

    public static List<String> getChildren(CuratorFramework zk, String path, boolean watch) {
        try {
            String npath = ClientZookeeper.normalizePath(path);
            if (watch) {
                return (List)((BackgroundPathable)zk.getChildren().watched()).forPath(npath);
            }
            return (List)zk.getChildren().forPath(npath);
        }
        catch (Exception e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    public static byte[] getData(CuratorFramework zk, String path, boolean watch) {
        block4: {
            try {
                String npath = ClientZookeeper.normalizePath(path);
                if (ClientZookeeper.existsNode(zk, npath, watch)) {
                    if (watch) {
                        return (byte[])((BackgroundPathable)zk.getData().watched()).forPath(npath);
                    }
                    return (byte[])zk.getData().forPath(npath);
                }
            }
            catch (Exception e) {
                if (Utils.exceptionCauseIsInstanceOf(KeeperException.NoNodeException.class, e)) break block4;
                throw Utils.wrapInRuntime(e);
            }
        }
        return null;
    }

    public static VersionedData<byte[]> getDataWithVersion(CuratorFramework zk, String path, boolean watch) {
        VersionedData<byte[]> data;
        block3: {
            data = null;
            try {
                byte[] bytes = null;
                Stat stats = new Stat();
                String npath = ClientZookeeper.normalizePath(path);
                if (ClientZookeeper.existsNode(zk, npath, watch) && (bytes = watch ? (byte[])((Pathable)((WatchPathable)zk.getData().storingStatIn(stats)).watched()).forPath(npath) : (byte[])((WatchPathable)zk.getData().storingStatIn(stats)).forPath(npath)) != null) {
                    int version = stats.getVersion();
                    data = new VersionedData<byte[]>(version, bytes);
                }
            }
            catch (Exception e) {
                if (Utils.exceptionCauseIsInstanceOf(KeeperException.NoNodeException.class, e)) break block3;
                Utils.wrapInRuntime(e);
            }
        }
        return data;
    }

    public static void addListener(CuratorFramework zk, ConnectionStateListener listener) {
        zk.getConnectionStateListenable().addListener((Object)listener);
    }

    public static void syncPath(CuratorFramework zk, String path) {
        try {
            zk.sync().forPath(ClientZookeeper.normalizePath(path));
        }
        catch (Exception e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    public void mkdirsImpl(CuratorFramework zk, String path, List<ACL> acls) {
        String npath = ClientZookeeper.normalizePath(path);
        if (npath.equals("/")) {
            return;
        }
        if (ClientZookeeper.existsNode(zk, npath, false)) {
            return;
        }
        byte[] byteArray = new byte[]{7};
        try {
            ClientZookeeper.createNode(zk, npath, byteArray, CreateMode.PERSISTENT, acls);
        }
        catch (Exception e) {
            if (Utils.exceptionCauseIsInstanceOf(KeeperException.NodeExistsException.class, e)) {
                // empty if block
            }
        }
    }

    public CuratorFramework mkClientImpl(Map<String, Object> conf, List<String> servers, Object port, String root, WatcherCallBack watcher, Map<String, Object> authConf, DaemonType type) {
        CuratorFramework fk = authConf != null ? CuratorUtils.newCurator(conf, servers, port, root, new ZookeeperAuthInfo(authConf), type.getDefaultZkAcls(conf)) : CuratorUtils.newCurator(conf, servers, port, root, null, type.getDefaultZkAcls(conf));
        fk.getCuratorListenable().addListener((unused, e) -> {
            if (e.getType().equals((Object)CuratorEventType.WATCHED)) {
                WatchedEvent event = e.getWatchedEvent();
                watcher.execute(event.getState(), event.getType(), event.getPath());
            }
        });
        LOG.info("Starting ZK Curator");
        fk.start();
        return fk;
    }
}

