/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp.pollingtask;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ConsumerCancelledException;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.amqp.AMQPOutTransportInfo;
import org.apache.synapse.transport.amqp.AMQPTransportBuffers;
import org.apache.synapse.transport.amqp.AMQPTransportEndpoint;
import org.apache.synapse.transport.amqp.AMQPTransportException;
import org.apache.synapse.transport.amqp.AMQPTransportMessage;
import org.apache.synapse.transport.amqp.ha.AMQPTransportHABrokerEntry;
import org.apache.synapse.transport.amqp.ha.AMQPTransportHAEntry;
import org.apache.synapse.transport.amqp.ha.AMQPTransportReconnectHandler;

public class AMQPTransportPollingTask {
    private static Log log = LogFactory.getLog(AMQPTransportPollingTask.class);
    private String serviceName;
    private String exchangeName = null;
    private boolean isExchangeDurable = false;
    private boolean isExchangeAutoDelete = true;
    private String exchangeType = "direct";
    private boolean isInternalExchange = false;
    private String consumerExchangeName = null;
    private String[] bindingsKeys = null;
    private boolean isUseTx = false;
    private String queueName = null;
    private boolean isQueueDurable = false;
    private boolean isQueueRestricted = false;
    private boolean isQueueAutoDelete = true;
    private boolean isBlockingMode = false;
    private int noOfConcurrentConsumers = 2;
    private String connectionFactoryName;
    private String responseConnectionFactory = null;
    private long scheduledTaskInitialDelay = 0L;
    private long scheduledTaskDelay = 1L;
    private TimeUnit scheduledTaskTimeUnit = TimeUnit.MILLISECONDS;
    private int noOfDispatchingTask = 2;
    private ScheduledExecutorService pollingTaskScheduler = null;
    private AMQPTransportEndpoint endpoint = null;
    private AMQPTransportBuffers buffers = null;
    private Channel channel;
    private String configuredContentType = "application/xml";
    private List<ScheduledFuture<?>> taskFutureList = new ArrayList();
    private AMQPTransportReconnectHandler haHandler;

    public void setUseTx(boolean useTx) {
        this.isUseTx = useTx;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setConfiguredContentType(String configuredContentType) {
        this.configuredContentType = configuredContentType;
    }

    public void setBuffers(AMQPTransportBuffers buffers) {
        this.buffers = buffers;
    }

    public void setEndpoint(AMQPTransportEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public void setExchangeDurable(boolean isExchangeDurable) {
        this.isExchangeDurable = isExchangeDurable;
    }

    public void setExchangeAutoDelete(boolean exchangeAutoDelete) {
        this.isExchangeAutoDelete = exchangeAutoDelete;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public void setInternalExchange(boolean internalExchange) {
        this.isInternalExchange = internalExchange;
    }

    public void setConsumerExchangeName(String consumerExchangeName) {
        this.consumerExchangeName = consumerExchangeName;
    }

    public void setBindingsKeys(String[] bindingsKeys) {
        this.bindingsKeys = bindingsKeys;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setQueueDurable(boolean queueDurable) {
        this.isQueueDurable = queueDurable;
    }

    public void setQueueRestricted(boolean queueRestricted) {
        this.isQueueRestricted = queueRestricted;
    }

    public void setQueueAutoDelete(boolean queueAutoDelete) {
        this.isQueueAutoDelete = queueAutoDelete;
    }

    public void setBlockingMode(boolean blockingMode) {
        this.isBlockingMode = blockingMode;
    }

    public void setNoOfConcurrentConsumers(int noOfConcurrentConsumers) {
        this.noOfConcurrentConsumers = noOfConcurrentConsumers;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public void setScheduledTaskInitialDelay(int scheduledTaskInitialDelay) {
        this.scheduledTaskInitialDelay = scheduledTaskInitialDelay;
    }

    public void setScheduledTaskDelay(int scheduledTaskDelay) {
        this.scheduledTaskDelay = scheduledTaskDelay;
    }

    public void setScheduledTaskTimeUnit(TimeUnit scheduledTaskTimeUnit) {
        this.scheduledTaskTimeUnit = scheduledTaskTimeUnit;
    }

    public void setNoOfDispatchingTask(int noOfDispatchingTask) {
        this.noOfDispatchingTask = noOfDispatchingTask;
    }

    public void setPollingTaskScheduler(ScheduledExecutorService pollingTaskScheduler) {
        this.pollingTaskScheduler = pollingTaskScheduler;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public boolean isExchangeDurable() {
        return this.isExchangeDurable;
    }

    public boolean isExchangeAutoDelete() {
        return this.isExchangeAutoDelete;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public boolean isInternalExchange() {
        return this.isInternalExchange;
    }

    public String getConsumerExchangeName() {
        return this.consumerExchangeName;
    }

    public String[] getBindingsKeys() {
        return this.bindingsKeys;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public boolean isQueueDurable() {
        return this.isQueueDurable;
    }

    public boolean isQueueRestricted() {
        return this.isQueueRestricted;
    }

    public boolean isQueueAutoDelete() {
        return this.isQueueAutoDelete;
    }

    public boolean isBlockingMode() {
        return this.isBlockingMode;
    }

    public int getNoOfConcurrentConsumers() {
        return this.noOfConcurrentConsumers;
    }

    public TimeUnit getScheduledTaskTimeUnit() {
        return this.scheduledTaskTimeUnit;
    }

    public int getNoOfDispatchingTask() {
        return this.noOfDispatchingTask;
    }

    public ExecutorService getPollingTaskScheduler() {
        return this.pollingTaskScheduler;
    }

    public AMQPTransportEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setResponseConnectionFactory(String responseConnectionFactory) {
        this.responseConnectionFactory = responseConnectionFactory;
    }

    public void setHaHandler(AMQPTransportReconnectHandler haHandler) {
        this.haHandler = haHandler;
    }

    public synchronized void start() throws AMQPTransportException {
        int i;
        try {
            if (this.exchangeName != null) {
                this.channel.exchangeDeclare(this.exchangeName, this.exchangeType, this.isExchangeDurable, this.isExchangeAutoDelete, this.isInternalExchange, null);
                String newQueueName = this.channel.queueDeclare().getQueue();
                log.info((Object)("QueueName is set to '" + newQueueName + "' for service '" + this.serviceName + "'"));
                this.queueName = newQueueName;
                if (this.bindingsKeys != null) {
                    for (String bindingKey : this.bindingsKeys) {
                        this.channel.queueBind(this.queueName, this.exchangeName, bindingKey);
                    }
                } else {
                    this.channel.queueBind(this.queueName, this.exchangeName, "");
                }
            } else {
                this.channel.queueDeclare(this.queueName, this.isQueueDurable, this.isQueueRestricted, this.isQueueAutoDelete, null);
            }
        }
        catch (IOException e) {
            this.handleException(e.getMessage(), e);
        }
        for (i = 0; i < this.noOfDispatchingTask; ++i) {
            this.pollingTaskScheduler.execute(new MessageDispatchTask(this.buffers));
        }
        for (i = 0; i < this.noOfConcurrentConsumers; ++i) {
            try {
                QueueingConsumer consumer = new QueueingConsumer(this.channel);
                boolean isAutoAck = !this.isUseTx;
                this.channel.basicConsume(this.queueName, isAutoAck, (Consumer)consumer);
                ScheduledFuture<?> pollingTaskFuture = this.pollingTaskScheduler.scheduleWithFixedDelay(new MessageIOTask(consumer, this.buffers, this.isUseTx), this.scheduledTaskInitialDelay, this.scheduledTaskDelay, this.scheduledTaskTimeUnit);
                this.taskFutureList.add(pollingTaskFuture);
                continue;
            }
            catch (IOException e) {
                this.handleException(e.getMessage(), e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("A polling task started listening on the queue '" + this.queueName + "' on behalf of the service '" + this.serviceName + "'"));
        }
    }

    public synchronized void stop() {
        for (ScheduledFuture<?> pollingTaskFuture : this.taskFutureList) {
            pollingTaskFuture.cancel(false);
        }
    }

    private void handleException(String msg, Throwable t) throws AMQPTransportException {
        log.error((Object)msg, t);
        throw new AMQPTransportException(msg, t);
    }

    private final class MessageProcessingTask
    implements Runnable {
        private AMQPTransportMessage message;
        private AMQPTransportBuffers buffers;
        private boolean isSOAP11;

        private MessageProcessingTask(AMQPTransportMessage message, AMQPTransportBuffers buffers) {
            this.message = message;
            this.buffers = buffers;
        }

        @Override
        public void run() {
            try {
                this.handleIncomingMessage(this.message, this.buffers);
            }
            catch (AxisFault axisFault) {
                try {
                    this.handleFaultMessage(this.message, this.buffers, axisFault);
                }
                catch (Exception e) {
                    log.error((Object)"Error while sending the fault message to the client. Client will not receive any errors!", (Throwable)e);
                }
            }
        }

        private boolean handleIncomingMessage(AMQPTransportMessage message, AMQPTransportBuffers buffers) throws AxisFault {
            if (message == null) {
                throw new AxisFault("A null message received!");
            }
            try {
                MessageContext msgContext = AMQPTransportPollingTask.this.endpoint.createMessageContext();
                String msgId = message.getMessageId();
                msgContext.setMessageID(msgId);
                msgContext.setProperty("AMQP_CORRELATION_ID", (Object)message.getCorrelationId());
                msgContext.setProperty("AMQP_TRANSPORT_BUFFER_KEY", (Object)buffers);
                String contentType = message.getContentType();
                if (contentType == null) {
                    contentType = AMQPTransportPollingTask.this.configuredContentType;
                }
                Map<String, Object> trpHeaders = message.getHeaders();
                if (message.getReplyTo() != null) {
                    msgContext.setProperty("OutTransportInfo", (Object)new AMQPOutTransportInfo(contentType, AMQPTransportPollingTask.this.responseConnectionFactory, message.getReplyTo()));
                    msgContext.setProperty("AMQP_REPLY_TO", (Object)message.getReplyTo());
                    msgContext.setProperty("RESPONSE_CONNECTION_FACTORY_NAME", (Object)AMQPTransportPollingTask.this.responseConnectionFactory);
                }
                HTTPTransportUtils.initializeMessageContext((MessageContext)msgContext, (String)message.getSoapAction(), null, (String)contentType);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(message.getBody());
                msgContext.setProperty("ContentType", (Object)contentType);
                msgContext.setProperty("TRANSPORT_HEADERS", trpHeaders);
                Builder builder = BuilderUtil.getBuilderFromSelector((String)contentType, (MessageContext)msgContext);
                InputStream gzipInputStream = HTTPTransportUtils.handleGZip((MessageContext)msgContext, (InputStream)inputStream);
                OMElement documentElement = builder.processDocument(gzipInputStream, contentType, msgContext);
                msgContext.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
                this.isSOAP11 = msgContext.isSOAP11();
                AxisEngine.receive((MessageContext)msgContext);
                return true;
            }
            catch (IOException e) {
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
        }

        private void handleFaultMessage(AMQPTransportMessage originalMsg, AMQPTransportBuffers buffers, AxisFault axisFault) throws Exception {
            SOAPFactory factory = this.isSOAP11 ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
            OMDocument soapFaultDocument = factory.createOMDocument();
            SOAPEnvelope faultEnvelope = factory.getDefaultFaultEnvelope();
            soapFaultDocument.addChild((OMNode)faultEnvelope);
            SOAPFault fault = faultEnvelope.getBody().getFault();
            if (fault == null) {
                fault = factory.createSOAPFault();
            }
            SOAPFaultCode code = factory.createSOAPFaultCode();
            code.setText(axisFault.getMessage());
            fault.setCode(code);
            SOAPFaultReason reason = factory.createSOAPFaultReason();
            reason.setText(axisFault.getMessage());
            fault.setReason(reason);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            faultEnvelope.serialize((OutputStream)out);
            AMQPTransportMessage msg = new AMQPTransportMessage((BasicProperties)new AMQP.BasicProperties(), out.toByteArray());
            try {
                buffers.addResponseMessage(msg);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private final class MessageDispatchTask
    implements Runnable {
        private AMQPTransportBuffers buffers;

        private MessageDispatchTask(AMQPTransportBuffers buffers) {
            this.buffers = buffers;
        }

        @Override
        public void run() {
            while (true) {
                AMQPTransportMessage msg;
                if ((msg = this.buffers.getRequestMessage()) == null) {
                    continue;
                }
                AMQPTransportPollingTask.this.pollingTaskScheduler.execute(new MessageProcessingTask(msg, this.buffers));
            }
        }
    }

    private final class MessageIOTask
    implements Runnable {
        private AMQPTransportBuffers buffers;
        private QueueingConsumer queueingConsumer;
        private boolean isUseTx;

        private MessageIOTask(QueueingConsumer queueingConsumer, AMQPTransportBuffers buffers, boolean isAutoAck) {
            this.queueingConsumer = queueingConsumer;
            this.buffers = buffers;
            this.isUseTx = isAutoAck;
        }

        @Override
        public void run() {
            block16: {
                try {
                    QueueingConsumer.Delivery delivery;
                    if (this.isUseTx) {
                        AMQPTransportPollingTask.this.channel.txSelect();
                    }
                    if ((delivery = this.queueingConsumer.nextDelivery()) != null) {
                        this.buffers.addRequestMessage(new AMQPTransportMessage(delivery));
                        if (this.isUseTx) {
                            AMQPTransportPollingTask.this.channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
                            AMQPTransportPollingTask.this.channel.txCommit();
                        }
                    } else if (this.isUseTx) {
                        AMQPTransportPollingTask.this.channel.txRollback();
                    }
                }
                catch (InterruptedException e) {
                    log.error((Object)("Polling task was interrupted for service '" + AMQPTransportPollingTask.this.serviceName + "'"), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    log.error((Object)("I/O error occurs for the polling tasks for service '" + AMQPTransportPollingTask.this.serviceName + "'"), (Throwable)e);
                }
                catch (ShutdownSignalException e) {
                    if (!e.isHardError()) break block16;
                    log.error((Object)("Polling task for service '" + AMQPTransportPollingTask.this.serviceName + "' received a shutdown signal"), (Throwable)e);
                    Semaphore available = new Semaphore(0, true);
                    String key = UUID.randomUUID().toString();
                    AMQPTransportPollingTask.this.haHandler.getBlockedTasks().add(new AMQPTransportHAEntry(available, key, AMQPTransportPollingTask.this.connectionFactoryName));
                    try {
                        available.acquire();
                    }
                    catch (InterruptedException ie) {
                        log.error((Object)"The blocking semaphore was interrupted", (Throwable)e);
                        Thread.currentThread().interrupt();
                        return;
                    }
                    AMQPTransportHABrokerEntry brokerEntry = (AMQPTransportHABrokerEntry)AMQPTransportPollingTask.this.haHandler.getConnectionMap().get(key);
                    if (brokerEntry == null) {
                        log.error((Object)("No new connection factory was found for key '" + key + "'"));
                    } else {
                        AMQPTransportPollingTask.this.setChannel(brokerEntry.getChannel());
                        AMQPTransportPollingTask.this.stop();
                        try {
                            AMQPTransportPollingTask.this.start();
                            log.info((Object)("Worker task for service '" + AMQPTransportPollingTask.this.serviceName + "' is re-deployed"));
                        }
                        catch (AMQPTransportException ex) {
                            log.error((Object)"Start of polling tasks failed. System must be restarted!");
                        }
                    }
                }
                catch (ConsumerCancelledException e) {
                    log.error((Object)("Polling task for service '" + AMQPTransportPollingTask.this.serviceName + "' received a cancellation signal"), (Throwable)e);
                }
            }
        }
    }

    private static enum TASK_STATE {
        STOPPED,
        STARTED,
        FAILURE;

    }
}

