/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.HashMap;
import org.apache.sysml.parser.BooleanIdentifier;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.DoubleIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.ParseInfo;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class RelationalExpression
extends Expression {
    private Expression _left;
    private Expression _right;
    private Expression.RelationalOp _opcode;

    public RelationalExpression(Expression.RelationalOp bop) {
        this._opcode = bop;
        this.setFilename("MAIN SCRIPT");
        this.setBeginLine(0);
        this.setBeginColumn(0);
        this.setEndLine(0);
        this.setEndColumn(0);
        this.setText(null);
    }

    public RelationalExpression(Expression.RelationalOp bop, ParseInfo parseInfo) {
        this._opcode = bop;
        this.setParseInfo(parseInfo);
    }

    @Override
    public Expression rewriteExpression(String prefix) {
        RelationalExpression newExpr = new RelationalExpression(this._opcode, this);
        newExpr.setLeft(this._left.rewriteExpression(prefix));
        newExpr.setRight(this._right.rewriteExpression(prefix));
        return newExpr;
    }

    public Expression.RelationalOp getOpCode() {
        return this._opcode;
    }

    public void setLeft(Expression l) {
        this._left = l;
        if (this._left != null) {
            this.setParseInfo(this._left);
        }
    }

    public void setRight(Expression r) {
        this._right = r;
        if (this._right != null) {
            this.setParseInfo(this._right);
        }
    }

    public Expression getLeft() {
        return this._left;
    }

    public Expression getRight() {
        return this._right;
    }

    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) {
        boolean isRightMatrix;
        if (this._left instanceof FunctionCallIdentifier) {
            this.raiseValidateError("user-defined function calls not supported in relational expressions", false, "Unsupported Expression");
        }
        if (this._right instanceof FunctionCallIdentifier) {
            this.raiseValidateError("user-defined function calls not supported in relational expressions", false, "Unsupported Expression");
        }
        if ((this._left != null && this._left instanceof BooleanIdentifier || this._right != null && this._right instanceof BooleanIdentifier) && (this._left instanceof IntIdentifier || this._left instanceof DoubleIdentifier || this._right instanceof IntIdentifier || this._right instanceof DoubleIdentifier)) {
            if (this._left instanceof BooleanIdentifier) {
                if (((BooleanIdentifier)this._left).getValue()) {
                    this.setLeft(new IntIdentifier(1L, (ParseInfo)this._left));
                } else {
                    this.setLeft(new IntIdentifier(0L, (ParseInfo)this._left));
                }
            } else if (this._right instanceof BooleanIdentifier) {
                if (((BooleanIdentifier)this._right).getValue()) {
                    this.setRight(new IntIdentifier(1L, (ParseInfo)this._right));
                } else {
                    this.setRight(new IntIdentifier(0L, (ParseInfo)this._right));
                }
            }
        }
        this._left.validateExpression(ids, constVars, conditional);
        if (this._right != null) {
            this._right.validateExpression(ids, constVars, conditional);
        }
        if (!conditional) {
            if (this._left instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this._left).getName())) {
                this._left = constVars.get(((DataIdentifier)this._left).getName());
            }
            if (this._right instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this._right).getName())) {
                this._right = constVars.get(((DataIdentifier)this._right).getName());
            }
        }
        String outputName = RelationalExpression.getTempName();
        DataIdentifier output = new DataIdentifier(outputName);
        output.setParseInfo(this);
        boolean isLeftMatrix = this._left.getOutput() != null && this._left.getOutput().getDataType() == Expression.DataType.MATRIX;
        boolean bl = isRightMatrix = this._right.getOutput() != null && this._right.getOutput().getDataType() == Expression.DataType.MATRIX;
        if (isLeftMatrix || isRightMatrix) {
            if (isLeftMatrix && isRightMatrix) {
                this.checkMatchingDimensions(this._left, this._right, true);
            }
            MatrixCharacteristics dims = RelationalExpression.getBinaryMatrixCharacteristics(this._left, this._right);
            output.setDataType(Expression.DataType.MATRIX);
            output.setDimensions(dims.getRows(), dims.getCols());
            output.setBlockDimensions(dims.getRowsPerBlock(), dims.getColsPerBlock());
            output.setValueType(Expression.ValueType.DOUBLE);
        } else {
            output.setBooleanProperties();
        }
        this.setOutput(output);
    }

    private void checkMatchingDimensions(Expression expr1, Expression expr2, boolean allowsMV) {
        if (expr1 != null && expr2 != null) {
            if (expr1.getOutput().getDim1() == -1L || expr2.getOutput().getDim1() == -1L || expr1.getOutput().getDim2() == -1L || expr2.getOutput().getDim2() == -1L) {
                return;
            }
            if (!allowsMV && expr1.getOutput().getDim1() != expr2.getOutput().getDim1() || allowsMV && expr1.getOutput().getDim1() != expr2.getOutput().getDim1() && expr2.getOutput().getDim1() != 1L || !allowsMV && expr1.getOutput().getDim2() != expr2.getOutput().getDim2() || allowsMV && expr1.getOutput().getDim2() != expr2.getOutput().getDim2() && expr2.getOutput().getDim2() != 1L) {
                this.raiseValidateError("Mismatch in matrix dimensions of parameters for function " + (Object)((Object)this.getOpCode()), false, "Invalid Parameters");
            }
        }
    }

    public String toString() {
        String leftString = this._left instanceof StringIdentifier ? "\"" + this._left.toString() + "\"" : this._left.toString();
        String rightString = this._right instanceof StringIdentifier ? "\"" + this._right.toString() + "\"" : this._right.toString();
        return "(" + leftString + " " + this._opcode.toString() + " " + rightString + ")";
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariables(this._left.variablesRead());
        result.addVariables(this._right.variablesRead());
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        result.addVariables(this._left.variablesUpdated());
        result.addVariables(this._right.variablesUpdated());
        return result;
    }
}

