/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.LongStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.random.Well1024a;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.matrix.data.DenseBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.util.CommonThreadPool;
import org.apache.sysml.runtime.util.NormalPRNGenerator;
import org.apache.sysml.runtime.util.PRNGenerator;
import org.apache.sysml.runtime.util.PoissonPRNGenerator;
import org.apache.sysml.runtime.util.UniformPRNGenerator;
import org.apache.sysml.runtime.util.UtilFunctions;

public class LibMatrixDatagen {
    private static final Log LOG = LogFactory.getLog((String)LibMatrixDatagen.class.getName());
    private static final long PAR_NUMCELL_THRESHOLD = 524288L;
    private static IDSequence _seqRandInput = new IDSequence();

    private LibMatrixDatagen() {
    }

    public static boolean isShortcutRandOperation(double min, double max, double sparsity, RandomMatrixGenerator.PDF pdf) {
        return pdf == RandomMatrixGenerator.PDF.UNIFORM && (min == 0.0 && max == 0.0 || sparsity == 1.0 && min == max);
    }

    public static double updateSeqIncr(double seq_from, double seq_to, double seq_incr) {
        return seq_from > seq_to && seq_incr == 1.0 ? -1.0 : seq_incr;
    }

    public static String generateUniqueSeedPath(String basedir) {
        return basedir + "tmp" + _seqRandInput.getNextID() + ".randinput";
    }

    public static Well1024a setupSeedsForRand(long seed) {
        long lSeed = seed == -1L ? DataGenOp.generateRandomSeed() : seed;
        LOG.trace((Object)("Setting up RandSeeds with initial seed = " + lSeed + "."));
        Random random = new Random(lSeed);
        Well1024a bigrand = new Well1024a();
        int[] seeds = new int[32];
        for (int s = 0; s < seeds.length; ++s) {
            seeds[s] = random.nextInt();
        }
        bigrand.setSeed(seeds);
        return bigrand;
    }

    @Deprecated
    public static LongStream computeNNZperBlock(long nrow, long ncol, int brlen, int bclen, double sparsity) {
        long lnumBlocks = (long)(Math.ceil((double)nrow / (double)brlen) * Math.ceil((double)ncol / (double)bclen));
        if (lnumBlocks > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("A random matrix of size [" + nrow + "," + ncol + "] can not be created. Number of blocks (" + lnumBlocks + ") exceeds the maximum integer size. Try to increase the block size.");
        }
        int numBlocks = (int)lnumBlocks;
        int numColBlocks = (int)Math.ceil((double)ncol / (double)bclen);
        long nnz = (long)Math.ceil((double)nrow * ((double)ncol * sparsity));
        if (nnz < (long)numBlocks) {
            double P = (double)nnz / (double)numBlocks;
            Random runif = new Random(System.nanoTime());
            return LongStream.range(0L, numBlocks).map(i -> {
                double lP = P / (double)(brlen * bclen) * (double)UtilFunctions.computeBlockSize(nrow, 1L + i / (long)numColBlocks, brlen) * (double)UtilFunctions.computeBlockSize(ncol, 1L + i % (long)numColBlocks, bclen);
                return runif.nextDouble() <= lP ? 1L : 0L;
            });
        }
        return LongStream.range(0L, numBlocks).map(i -> (long)(sparsity * (double)UtilFunctions.computeBlockSize(nrow, 1L + i / (long)numColBlocks, brlen) * (double)UtilFunctions.computeBlockSize(ncol, 1L + i % (long)numColBlocks, bclen)));
    }

    public static RandomMatrixGenerator createRandomMatrixGenerator(String pdfStr, int r, int c, int rpb, int cpb, double sp, double min, double max, String distParams) {
        RandomMatrixGenerator.PDF pdf = RandomMatrixGenerator.PDF.valueOf(pdfStr.toUpperCase());
        RandomMatrixGenerator rgen = null;
        switch (pdf) {
            case UNIFORM: {
                rgen = new RandomMatrixGenerator(pdf, r, c, rpb, cpb, sp, min, max);
                break;
            }
            case NORMAL: {
                rgen = new RandomMatrixGenerator(pdf, r, c, rpb, cpb, sp);
                break;
            }
            case POISSON: {
                double mean = Double.NaN;
                try {
                    mean = Double.parseDouble(distParams);
                }
                catch (NumberFormatException e) {
                    throw new DMLRuntimeException("Failed to parse Poisson distribution parameter: " + distParams);
                }
                rgen = new RandomMatrixGenerator(pdf, r, c, rpb, cpb, sp, min, max, mean);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported probability distribution \"" + (Object)((Object)pdf) + "\" in rand() -- it must be one of \"uniform\", \"normal\", or \"poisson\"");
            }
        }
        return rgen;
    }

    public static void generateRandomMatrix(MatrixBlock out, RandomMatrixGenerator rgen, Well1024a bigrand, long bSeed) {
        double max;
        boolean invokedFromCP = bigrand != null;
        int rows = rgen._rows;
        int cols = rgen._cols;
        int rpb = rgen._rowsPerBlock;
        int cpb = rgen._colsPerBlock;
        double sparsity = rgen._sparsity;
        LibMatrixDatagen.checkMatrixDimensionsAndSparsity(rows, cols, sparsity);
        double min = rgen._pdf == RandomMatrixGenerator.PDF.UNIFORM ? rgen._min : 0.0;
        double d = max = rgen._pdf == RandomMatrixGenerator.PDF.UNIFORM ? rgen._max : 1.0;
        if (rgen._pdf == RandomMatrixGenerator.PDF.UNIFORM) {
            if (min == 0.0 && max == 0.0) {
                out.reset(rows, cols, true);
                return;
            }
            if (sparsity == 1.0 && (min == max || Double.isNaN(min) && Double.isNaN(max))) {
                out.reset(rows, cols, min);
                return;
            }
        }
        long estnnz = (long)Math.ceil(min == 0.0 && max == 0.0 ? 0.0 : sparsity * (double)rows * (double)cols);
        boolean lsparse = MatrixBlock.evalSparseFormatInMemory(rows, cols, estnnz);
        out.reset(rows, cols, lsparse, estnnz);
        out.allocateBlock();
        int nrb = (int)Math.ceil((double)rows / (double)rpb);
        int ncb = (int)Math.ceil((double)cols / (double)cpb);
        long[] seeds = invokedFromCP ? LibMatrixDatagen.generateSeedsForCP(bigrand, nrb, ncb) : null;
        LibMatrixDatagen.genRandomNumbers(invokedFromCP, 0, nrb, 0, ncb, out, rgen, bSeed, seeds);
        out.recomputeNonZeros();
    }

    public static void generateRandomMatrix(MatrixBlock out, RandomMatrixGenerator rgen, Well1024a bigrand, long bSeed, int k) {
        int rows = rgen._rows;
        int cols = rgen._cols;
        int rpb = rgen._rowsPerBlock;
        int cpb = rgen._colsPerBlock;
        double sparsity = rgen._sparsity;
        LibMatrixDatagen.checkMatrixDimensionsAndSparsity(rows, cols, sparsity);
        double min = rgen._pdf == RandomMatrixGenerator.PDF.UNIFORM ? rgen._min : 0.0;
        double max = rgen._pdf == RandomMatrixGenerator.PDF.UNIFORM ? rgen._max : 1.0;
        long estnnz = min == 0.0 && max == 0.0 ? 0L : (long)(sparsity * (double)rows * (double)cols);
        boolean lsparse = MatrixBlock.evalSparseFormatInMemory(rows, cols, estnnz);
        if (k <= 1 || rows <= rpb && lsparse || (long)rows * (long)cols < 524288L || !MatrixBlock.isThreadSafe(lsparse)) {
            LibMatrixDatagen.generateRandomMatrix(out, rgen, bigrand, bSeed);
            return;
        }
        if (rgen._pdf == RandomMatrixGenerator.PDF.UNIFORM) {
            if (min == 0.0 && max == 0.0) {
                out.reset(rows, cols, false);
                return;
            }
            if (sparsity == 1.0 && min == max) {
                out.reset(rows, cols, min);
                return;
            }
        }
        out.reset(rows, cols, lsparse, estnnz);
        out.allocateBlock();
        int nrb = (int)Math.ceil((double)rows / (double)rpb);
        int ncb = (int)Math.ceil((double)cols / (double)cpb);
        boolean parcol = !out.sparse && nrb < k && ncb > nrb;
        int parnb = parcol ? ncb : nrb;
        long[] seeds = LibMatrixDatagen.generateSeedsForCP(bigrand, nrb, ncb);
        long nnz = 0L;
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<RandTask> tasks = new ArrayList<RandTask>();
            int blklen = (int)Math.ceil((double)parnb / (double)k);
            int i = 0;
            while (i < k & i * blklen < parnb) {
                int rl = parcol ? 0 : i * blklen;
                int ru = parcol ? nrb : Math.min((i + 1) * blklen, parnb);
                int cl = parcol ? i * blklen : 0;
                int cu = parcol ? Math.min((i + 1) * blklen, parnb) : ncb;
                long[] lseeds = LibMatrixDatagen.sliceSeedsForCP(seeds, rl, ru, cl, cu, nrb, ncb);
                tasks.add(new RandTask(rl, ru, cl, cu, out, rgen, bSeed, lseeds));
                ++i;
            }
            List ret = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future rc : ret) {
                nnz += ((Long)rc.get()).longValue();
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
        out.setNonZeros(nnz);
    }

    public static void generateSequence(MatrixBlock out, double from, double to, double incr) {
        if (from > to && incr > 0.0 || incr == 0.0) {
            throw new DMLRuntimeException("Wrong sequence increment: from=" + from + ", to=" + to + ", incr=" + incr);
        }
        int rows = (int)UtilFunctions.getSeqLength(from, to, incr);
        int cols = 1;
        out.reset(rows, cols, false);
        out.allocateDenseBlock();
        double[] c = out.getDenseBlockValues();
        double cur = from;
        for (int i = 0; i < rows; ++i) {
            c[i] = cur;
            cur += incr;
        }
        out.recomputeNonZeros();
    }

    public static void generateSample(MatrixBlock out, long range, int size, boolean replace, long seed) {
        out.reset(size, 1, false);
        double[] a = out.allocateBlock().getDenseBlockValues();
        long l = seed = seed == -1L ? System.nanoTime() : seed;
        if (!replace) {
            for (int i = 0; i < size; ++i) {
                a[i] = i + 1;
            }
            Random rand = new Random(seed);
            int i = size + 1;
            while ((long)i <= range) {
                if (rand.nextInt(i) < size) {
                    a[rand.nextInt((int)size)] = i;
                }
                ++i;
            }
            for (i = 0; i < size - 1; ++i) {
                int j = rand.nextInt(size - i) + i;
                double tmp = a[i];
                a[i] = a[j];
                a[j] = tmp;
            }
        } else {
            Random r = new Random(seed);
            for (int i = 0; i < size; ++i) {
                a[i] = 1L + LibMatrixDatagen.nextLong(r, range);
            }
        }
        out.setNonZeros(size);
        out.examSparsity();
    }

    private static long[] generateSeedsForCP(Well1024a bigrand, int nrb, int ncb) {
        int numBlocks = nrb * ncb;
        long[] seeds = new long[numBlocks];
        for (int l = 0; l < numBlocks; ++l) {
            seeds[l] = bigrand.nextLong();
        }
        return seeds;
    }

    private static long[] sliceSeedsForCP(long[] seeds, int rl, int ru, int cl, int cu, int nrb, int ncb) {
        int numBlocks = (ru - rl) * (cu - cl);
        long[] lseeds = new long[numBlocks];
        for (int i = rl; i < ru; ++i) {
            System.arraycopy(seeds, i * ncb + cl, lseeds, (i - rl) * (cu - cl), cu - cl);
        }
        return lseeds;
    }

    private static void genRandomNumbers(boolean invokedFromCP, int rl, int ru, int cl, int cu, MatrixBlock out, RandomMatrixGenerator rgen, long bSeed, long[] seeds) {
        int rows = rgen._rows;
        int cols = rgen._cols;
        int rpb = rgen._rowsPerBlock;
        int cpb = rgen._colsPerBlock;
        double sparsity = rgen._sparsity;
        double min = rgen._pdf == RandomMatrixGenerator.PDF.UNIFORM ? rgen._min : 0.0;
        double max = rgen._pdf == RandomMatrixGenerator.PDF.UNIFORM ? rgen._max : 1.0;
        double range = max - min;
        int clen = out.clen;
        int estnnzRow = (int)(sparsity * (double)cols);
        int nrb = (int)Math.ceil((double)rows / (double)rpb);
        int ncb = (int)Math.ceil((double)cols / (double)cpb);
        int counter = 0;
        PRNGenerator valuePRNG = rgen._valuePRNG;
        if (valuePRNG == null) {
            switch (rgen._pdf) {
                case UNIFORM: {
                    valuePRNG = new UniformPRNGenerator();
                    break;
                }
                case NORMAL: {
                    valuePRNG = new NormalPRNGenerator();
                    break;
                }
                case POISSON: {
                    valuePRNG = new PoissonPRNGenerator();
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Unsupported distribution function for Rand: " + (Object)((Object)rgen._pdf));
                }
            }
        }
        UniformPRNGenerator nnzPRNG = new UniformPRNGenerator(0L);
        if (out.sparse && estnnzRow > 0 && cl == 0 && cu == ncb) {
            for (int i = rl * rpb; i < Math.min(ru * rpb, rows); ++i) {
                out.sparseBlock.allocate(i, estnnzRow);
            }
        }
        for (int rbi = rl; rbi < ru; ++rbi) {
            int blockrows = rbi == nrb - 1 ? rows - rbi * rpb : rpb;
            int rowoffset = rbi * rpb;
            for (int cbj = cl; cbj < cu; ++cbj) {
                int cix;
                double[] cvals;
                Serializable c;
                int blockcols = cbj == ncb - 1 ? cols - cbj * cpb : cpb;
                int coloffset = cbj * cpb;
                long seed = !invokedFromCP ? bSeed : seeds[counter++];
                valuePRNG.setSeed(seed);
                nnzPRNG.setSeed(seed);
                boolean localSparse = MatrixBlock.evalSparseFormatInMemory(blockrows, blockcols, (long)(sparsity * (double)blockrows * (double)blockcols));
                if (localSparse) {
                    c = out.sparseBlock;
                    double log1mp = Math.log(1.0 - sparsity);
                    int idx = 0;
                    long blocksize = blockrows * blockcols;
                    while ((long)idx < blocksize && (long)(idx += (int)Math.ceil(Math.log(nnzPRNG.nextDouble()) / log1mp)) <= blocksize) {
                        int rix = (idx - 1) / blockcols;
                        int cix2 = (idx - 1) % blockcols;
                        double val = min + range * valuePRNG.nextDouble();
                        ((SparseBlock)c).allocate(rowoffset + rix, estnnzRow, clen);
                        ((SparseBlock)c).append(rowoffset + rix, coloffset + cix2, val);
                    }
                    continue;
                }
                if (sparsity == 1.0) {
                    c = out.getDenseBlock();
                    for (int ii = 0; ii < blockrows; ++ii) {
                        cvals = ((DenseBlock)c).values(rowoffset + ii);
                        cix = ((DenseBlock)c).pos(rowoffset + ii, coloffset);
                        for (int jj = 0; jj < blockcols; ++jj) {
                            cvals[cix + jj] = min + range * valuePRNG.nextDouble();
                        }
                    }
                    continue;
                }
                if (out.sparse) {
                    c = out.sparseBlock;
                    for (int ii = 0; ii < blockrows; ++ii) {
                        for (int jj = 0; jj < blockcols; ++jj) {
                            if (!(nnzPRNG.nextDouble() <= sparsity)) continue;
                            double val = min + range * valuePRNG.nextDouble();
                            ((SparseBlock)c).allocate(ii + rowoffset, estnnzRow, clen);
                            ((SparseBlock)c).append(ii + rowoffset, jj + coloffset, val);
                        }
                    }
                    continue;
                }
                c = out.getDenseBlock();
                for (int ii = 0; ii < blockrows; ++ii) {
                    cvals = ((DenseBlock)c).values(rowoffset + ii);
                    cix = ((DenseBlock)c).pos(rowoffset + ii, coloffset);
                    for (int jj = 0; jj < blockcols; ++jj) {
                        if (!(nnzPRNG.nextDouble() <= sparsity)) continue;
                        cvals[cix + jj] = min + range * valuePRNG.nextDouble();
                    }
                }
            }
        }
    }

    private static void checkMatrixDimensionsAndSparsity(int rows, int cols, double sp) {
        if (rows < 0 || cols < 0 || sp < 0.0 || sp > 1.0) {
            throw new DMLRuntimeException("Invalid matrix characteristics: " + rows + "x" + cols + ", " + sp);
        }
    }

    private static long nextLong(Random r, long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        while ((bits = r.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    private static class RandTask
    implements Callable<Long> {
        private int _rl = -1;
        private int _ru = -1;
        private int _cl = -1;
        private int _cu = -1;
        private MatrixBlock _out = null;
        private RandomMatrixGenerator _rgen = new RandomMatrixGenerator();
        private long _bSeed = 0L;
        private long[] _seeds = null;

        public RandTask(int rl, int ru, int cl, int cu, MatrixBlock out, RandomMatrixGenerator rgen, long bSeed, long[] seeds) {
            this._rl = rl;
            this._ru = ru;
            this._cl = cl;
            this._cu = cu;
            this._out = out;
            this._rgen.init(rgen._pdf, rgen._rows, rgen._cols, rgen._rowsPerBlock, rgen._colsPerBlock, rgen._sparsity, rgen._min, rgen._max, rgen._mean);
            this._bSeed = bSeed;
            this._seeds = seeds;
        }

        @Override
        public Long call() {
            LibMatrixDatagen.genRandomNumbers(true, this._rl, this._ru, this._cl, this._cu, this._out, this._rgen, this._bSeed, this._seeds);
            int rpb = this._rgen._rowsPerBlock;
            int cpb = this._rgen._colsPerBlock;
            return this._out.recomputeNonZeros(this._rl * rpb, Math.min(this._ru * rpb, this._rgen._rows) - 1, this._cl * cpb, Math.min(this._cu * cpb, this._rgen._cols) - 1);
        }
    }
}

