/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.PlusMultiply;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.AggregateUnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;
import scala.Tuple2;

public class CumulativeAggregateSPInstruction
extends AggregateUnarySPInstruction {
    private CumulativeAggregateSPInstruction(AggregateUnaryOperator op, CPOperand in1, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.CumsumAggregate, op, null, in1, out, null, opcode, istr);
    }

    public static CumulativeAggregateSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 2);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        AggregateUnaryOperator aggun = InstructionUtils.parseCumulativeAggregateUnaryOperator(opcode);
        return new CumulativeAggregateSPInstruction(aggun, in1, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        MatrixCharacteristics mc = sec.getMatrixCharacteristics(this.input1.getName());
        long rlen = mc.getRows();
        int brlen = mc.getRowsPerBlock();
        int bclen = mc.getColsPerBlock();
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        AggregateUnaryOperator auop = (AggregateUnaryOperator)this._optr;
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = in.mapToPair((PairFunction)new RDDCumAggFunction(auop, rlen, brlen, bclen));
        out = RDDAggregateUtils.mergeByKey(out, false);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
    }

    private static class RDDCumAggFunction
    implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 11324676268945117L;
        private final AggregateUnaryOperator _op;
        private UnaryOperator _uop = null;
        private final long _rlen;
        private final int _brlen;
        private final int _bclen;

        public RDDCumAggFunction(AggregateUnaryOperator op, long rlen, int brlen, int bclen) {
            this._op = op;
            this._rlen = rlen;
            this._brlen = brlen;
            this._bclen = bclen;
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
            MatrixBlock blkIn = (MatrixBlock)arg0._2();
            MatrixIndexes ixOut = new MatrixIndexes();
            MatrixBlock blkOut = new MatrixBlock();
            AggregateUnaryOperator aop = this._op;
            if (aop.aggOp.increOp.fn instanceof PlusMultiply) {
                aop.indexFn.execute(ixIn, ixOut);
                if (this._uop == null) {
                    this._uop = new UnaryOperator(Builtin.getBuiltinFnObject("ucumk+*"));
                }
                MatrixBlock t1 = (MatrixBlock)blkIn.unaryOperations(this._uop, new MatrixBlock());
                MatrixBlock t2 = blkIn.slice(0, blkIn.getNumRows() - 1, 1, 1, new MatrixBlock());
                blkOut.reset(1, 2);
                blkOut.quickSetValue(0, 0, t1.quickGetValue(t1.getNumRows() - 1, 0));
                blkOut.quickSetValue(0, 1, t2.prod());
            } else {
                OperationsOnMatrixValues.performAggregateUnary(ixIn, blkIn, ixOut, blkOut, aop, this._brlen, this._bclen);
                if (aop.aggOp.correctionExists) {
                    blkOut.dropLastRowsOrColumns(aop.aggOp.correctionLocation);
                }
            }
            long rlenOut = (long)Math.ceil((double)this._rlen / (double)this._brlen);
            long rixOut = (long)Math.ceil((double)ixIn.getRowIndex() / (double)this._brlen);
            int rlenBlk = (int)Math.min(rlenOut - (rixOut - 1L) * (long)this._brlen, (long)this._brlen);
            int clenBlk = blkOut.getNumColumns();
            int posBlk = (int)((ixIn.getRowIndex() - 1L) % (long)this._brlen);
            MatrixBlock blkOut2 = new MatrixBlock(rlenBlk, clenBlk, false);
            blkOut2.copy(posBlk, posBlk, 0, clenBlk - 1, blkOut, true);
            ixOut.setIndexes(rixOut, ixOut.getColumnIndex());
            return new Tuple2((Object)ixOut, (Object)blkOut2);
        }
    }
}

