/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.specific;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.avro.AvroTestUtil;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.TestAnnotation;
import org.apache.avro.TestProtocolParsing;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.avro.test.Kind;
import org.apache.avro.test.MD5;
import org.apache.avro.test.Simple;
import org.apache.avro.test.TestRecord;
import org.junit.Assert;
import org.junit.Test;

public class TestSpecificCompiler {
    static final String PROTOCOL = "{ \"protocol\": \"default\",\n  \"types\":\n    [\n      {\n       \"name\": \"finally\",\n       \"type\": \"error\",\n       \"fields\": [{\"name\": \"catch\", \"type\": \"boolean\"}]\n      }\n    ],\n  \"messages\": { \"goto\":\n    { \"request\": [{\"name\": \"break\", \"type\": \"string\"}],\n      \"response\": \"string\",\n      \"errors\": [\"finally\"]\n    }   }\n}\n";
    private static String SCHEMA = "{ \"name\": \"volatile\", \"type\": \"record\",   \"fields\": [ {\"name\": \"package\", \"type\": \"string\" },                {\"name\": \"data\", \"type\": \"int\" },                {\"name\": \"value\", \"type\": \"int\" },                {\"name\": \"defaultValue\", \"type\": \"int\" },                {\"name\": \"other\", \"type\": \"int\" },                {\"name\": \"short\", \"type\": \"volatile\" } ] }";

    @Test
    public void testEsc() {
        Assert.assertEquals((Object)"\\\"", (Object)SpecificCompiler.javaEscape((Object)"\""));
    }

    @Test
    public void testMakePath() {
        Assert.assertEquals((Object)"foo/bar/Baz.java".replace("/", File.separator), (Object)SpecificCompiler.makePath((String)"Baz", (String)"foo.bar"));
        Assert.assertEquals((Object)"baz.java", (Object)SpecificCompiler.makePath((String)"baz", (String)""));
    }

    @Test
    public void testPrimitiveSchemaGeneratesNothing() {
        Assert.assertEquals((long)0L, (long)new SpecificCompiler(Schema.parse((String)"\"double\"")).compile().size());
    }

    @Test
    public void testSimpleEnumSchema() throws IOException {
        Collection outputs = new SpecificCompiler(Schema.parse((String)"{\"type\":\"enum\", \"name\":\"Test\",\"symbols\": [\"A\", \"B\"]}")).compile();
        Assert.assertEquals((long)1L, (long)outputs.size());
        SpecificCompiler.OutputFile o = (SpecificCompiler.OutputFile)outputs.iterator().next();
        Assert.assertEquals((Object)o.path, (Object)"Test.java");
        Assert.assertTrue((boolean)o.contents.contains("public enum Test"));
        TestSpecificCompiler.assertCompilesWithJavaCompiler(outputs);
    }

    @Test
    public void testMangleIfReserved() {
        Assert.assertEquals((Object)"foo", (Object)SpecificCompiler.mangle((String)"foo"));
        Assert.assertEquals((Object)"goto$", (Object)SpecificCompiler.mangle((String)"goto"));
    }

    @Test
    public void testManglingForProtocols() throws IOException {
        String protocolDef = PROTOCOL;
        Collection c = new SpecificCompiler(Protocol.parse((String)protocolDef)).compile();
        Iterator i = c.iterator();
        String errType = ((SpecificCompiler.OutputFile)i.next()).contents;
        String protocol = ((SpecificCompiler.OutputFile)i.next()).contents;
        Assert.assertTrue((boolean)errType.contains("public class finally$ extends org.apache.avro.specific.SpecificExceptionBase"));
        Assert.assertTrue((boolean)errType.contains("public boolean catch$;"));
        Assert.assertTrue((boolean)protocol.contains("java.lang.CharSequence goto$(java.lang.CharSequence break$)"));
        Assert.assertTrue((boolean)protocol.contains("public interface default$"));
        Assert.assertTrue((boolean)protocol.contains("throws org.apache.avro.AvroRemoteException, finally$"));
        TestSpecificCompiler.assertCompilesWithJavaCompiler(c);
    }

    @Test
    public void testManglingForRecords() throws IOException {
        Collection c = new SpecificCompiler(Schema.parse((String)SCHEMA)).compile();
        Assert.assertEquals((long)1L, (long)c.size());
        String contents = ((SpecificCompiler.OutputFile)c.iterator().next()).contents;
        Assert.assertTrue((boolean)contents.contains("public java.lang.CharSequence package$;"));
        Assert.assertTrue((boolean)contents.contains("class volatile$ extends"));
        Assert.assertTrue((boolean)contents.contains("volatile$ short$;"));
        TestSpecificCompiler.assertCompilesWithJavaCompiler(c);
    }

    @Test
    public void testManglingForEnums() throws IOException {
        String enumSchema = "{ \"name\": \"instanceof\", \"type\": \"enum\",  \"symbols\": [\"new\", \"super\", \"switch\"] }";
        Collection c = new SpecificCompiler(Schema.parse((String)enumSchema)).compile();
        Assert.assertEquals((long)1L, (long)c.size());
        String contents = ((SpecificCompiler.OutputFile)c.iterator().next()).contents;
        Assert.assertTrue((boolean)contents.contains("new$"));
        TestSpecificCompiler.assertCompilesWithJavaCompiler(c);
    }

    @Test
    public void testSchemaSplit() throws IOException {
        SpecificCompiler compiler = new SpecificCompiler(Schema.parse((String)SCHEMA));
        compiler.maxStringChars = 10;
        Collection files = compiler.compile();
        TestSpecificCompiler.assertCompilesWithJavaCompiler(files);
    }

    @Test
    public void testProtocolSplit() throws IOException {
        SpecificCompiler compiler = new SpecificCompiler(Protocol.parse((String)PROTOCOL));
        compiler.maxStringChars = 10;
        Collection files = compiler.compile();
        TestSpecificCompiler.assertCompilesWithJavaCompiler(files);
    }

    @Test
    public void testSchemaWithDocs() {
        Collection outputs = new SpecificCompiler(Schema.parse((String)"{\n  \"type\": \"record\",\n  \"name\": \"outer_record\",\n  \"doc\": \"This is not a world record.\",\n  \"fields\": [\n    { \"type\": { \"type\": \"fixed\", \"doc\": \"Very Inner Fixed\",                   \"name\": \"very_inner_fixed\", \"size\": 1 },\n      \"doc\": \"Inner Fixed\", \"name\": \"inner_fixed\" },\n    { \"type\": \"string\",\n      \"name\": \"inner_string\",\n      \"doc\": \"Inner String\" },\n    { \"type\": { \"type\": \"enum\", \"doc\": \"Very Inner Enum\", \n                  \"name\": \"very_inner_enum\", \n                  \"symbols\": [ \"A\", \"B\", \"C\" ] },\n      \"doc\": \"Inner Enum\", \"name\": \"inner_enum\" },\n    { \"type\": [\"string\", \"int\"], \"doc\": \"Inner Union\", \n      \"name\": \"inner_union\" }\n  ]\n}\n")).compile();
        Assert.assertEquals((long)3L, (long)outputs.size());
        int count = 0;
        for (SpecificCompiler.OutputFile o : outputs) {
            if (o.path.endsWith("outer_record.java")) {
                ++count;
                Assert.assertTrue((boolean)o.contents.contains("/** This is not a world record. */"));
                Assert.assertTrue((boolean)o.contents.contains("/** Inner Fixed */"));
                Assert.assertTrue((boolean)o.contents.contains("/** Inner Enum */"));
                Assert.assertTrue((boolean)o.contents.contains("/** Inner String */"));
            }
            if (o.path.endsWith("very_inner_fixed.java")) {
                ++count;
                Assert.assertTrue((boolean)o.contents.contains("/** Very Inner Fixed */"));
                Assert.assertTrue((boolean)o.contents.contains("@org.apache.avro.specific.FixedSize(1)"));
            }
            if (!o.path.endsWith("very_inner_enum.java")) continue;
            ++count;
            Assert.assertTrue((boolean)o.contents.contains("/** Very Inner Enum */"));
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testProtocolWithDocs() throws IOException {
        Protocol protocol = TestProtocolParsing.getSimpleProtocol();
        Collection out = new SpecificCompiler(protocol).compile();
        Assert.assertEquals((long)6L, (long)out.size());
        int count = 0;
        for (SpecificCompiler.OutputFile o : out) {
            if (!o.path.endsWith("Simple.java")) continue;
            ++count;
            Assert.assertTrue((boolean)o.contents.contains("/** Protocol used for testing. */"));
            Assert.assertTrue((boolean)o.contents.contains("/** Send a greeting */"));
        }
        Assert.assertEquals((String)"Missed generated protocol!", (long)1L, (long)count);
    }

    @Test
    public void testNeedCompile() throws IOException, InterruptedException {
        String schema = "{ \"name\": \"Foo\", \"type\": \"record\",   \"fields\": [ {\"name\": \"package\", \"type\": \"string\" },                {\"name\": \"short\", \"type\": \"Foo\" } ] }";
        File inputFile = AvroTestUtil.tempFile(this.getClass(), (String)"input.avsc");
        FileWriter fw = new FileWriter(inputFile);
        fw.write(schema);
        fw.close();
        File outputDir = new File(System.getProperty("test.dir", "target/test") + System.getProperty("file.separator") + "test_need_compile");
        File outputFile = new File(outputDir, "Foo.java");
        outputFile.delete();
        Assert.assertTrue((!outputFile.exists() ? 1 : 0) != 0);
        outputDir.delete();
        Assert.assertTrue((!outputDir.exists() ? 1 : 0) != 0);
        SpecificCompiler.compileSchema((File)inputFile, (File)outputDir);
        Assert.assertTrue((boolean)outputDir.exists());
        Assert.assertTrue((boolean)outputFile.exists());
        long lastModified = outputFile.lastModified();
        Thread.sleep(1000L);
        SpecificCompiler.compileSchema((File)inputFile, (File)outputDir);
        Assert.assertEquals((long)lastModified, (long)outputFile.lastModified());
        fw = new FileWriter(inputFile);
        fw.write(schema);
        fw.close();
        SpecificCompiler.compileSchema((File)inputFile, (File)outputDir);
        Assert.assertTrue((lastModified != outputFile.lastModified() ? 1 : 0) != 0);
    }

    private Schema createRecord(String name, boolean isError, Schema.Field ... fields) {
        Schema record = Schema.createRecord((String)name, null, null, (boolean)isError);
        record.setFields(Arrays.asList(fields));
        return record;
    }

    @Test
    public void generateGetMethod() {
        Schema.Field height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field height_and_width = new Schema.Field("height_and_width", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"getHeight", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, height), (Schema.Field)height));
        Assert.assertEquals((Object)"getHeightAndWidth", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, height_and_width), (Schema.Field)height_and_width));
        Assert.assertEquals((Object)"getMessage", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, message), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"getMessage$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, message), (Schema.Field)message));
        Assert.assertEquals((Object)"getCause", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, cause), (Schema.Field)cause));
        cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"getCause$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, cause), (Schema.Field)cause));
        Assert.assertEquals((Object)"getClass$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, clasz), (Schema.Field)clasz));
        clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"getClass$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, clasz), (Schema.Field)clasz));
        Assert.assertEquals((Object)"getSchema$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, schema), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"getSchema$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, schema), (Schema.Field)schema));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assert.assertEquals((Object)"getHeight", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, Height), (Schema.Field)Height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assert.assertEquals((Object)"getHeight$0", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assert.assertEquals((Object)"getHeight$1", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)Height));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"getMessage$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, Message2), (Schema.Field)Message2));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"getMessage$0", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"getMessage$1", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)Message2));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"getSchema$", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, Schema$), (Schema.Field)Schema$));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"getSchema$0", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"getSchema$1", (Object)SpecificCompiler.generateGetMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)Schema$));
    }

    @Test
    public void generateSetMethod() {
        Schema.Field height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field height_and_width = new Schema.Field("height_and_width", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"setHeight", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, height), (Schema.Field)height));
        Assert.assertEquals((Object)"setHeightAndWidth", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, height_and_width), (Schema.Field)height_and_width));
        Assert.assertEquals((Object)"setMessage", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, message), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"setMessage$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, message), (Schema.Field)message));
        Assert.assertEquals((Object)"setCause", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, cause), (Schema.Field)cause));
        cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"setCause$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, cause), (Schema.Field)cause));
        Assert.assertEquals((Object)"setClass$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, clasz), (Schema.Field)clasz));
        clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"setClass$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, clasz), (Schema.Field)clasz));
        Assert.assertEquals((Object)"setSchema$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, schema), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"setSchema$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, schema), (Schema.Field)schema));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assert.assertEquals((Object)"setHeight", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, Height), (Schema.Field)Height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assert.assertEquals((Object)"setHeight$0", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assert.assertEquals((Object)"setHeight$1", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)Height));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"setMessage$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, Message2), (Schema.Field)Message2));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"setMessage$0", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"setMessage$1", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)Message2));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"setSchema$", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, Schema$), (Schema.Field)Schema$));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"setSchema$0", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"setSchema$1", (Object)SpecificCompiler.generateSetMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)Schema$));
    }

    @Test
    public void generateHasMethod() {
        Schema.Field height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field height_and_width = new Schema.Field("height_and_width", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"hasHeight", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, height), (Schema.Field)height));
        Assert.assertEquals((Object)"hasHeightAndWidth", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, height_and_width), (Schema.Field)height_and_width));
        Assert.assertEquals((Object)"hasMessage", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, message), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"hasMessage$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, message), (Schema.Field)message));
        Assert.assertEquals((Object)"hasCause", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, cause), (Schema.Field)cause));
        cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"hasCause$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, cause), (Schema.Field)cause));
        Assert.assertEquals((Object)"hasClass$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, clasz), (Schema.Field)clasz));
        clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"hasClass$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, clasz), (Schema.Field)clasz));
        Assert.assertEquals((Object)"hasSchema$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, schema), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"hasSchema$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, schema), (Schema.Field)schema));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assert.assertEquals((Object)"hasHeight", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, Height), (Schema.Field)Height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assert.assertEquals((Object)"hasHeight$0", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assert.assertEquals((Object)"hasHeight$1", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)Height));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"hasMessage$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, Message2), (Schema.Field)Message2));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"hasMessage$0", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"hasMessage$1", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)Message2));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"hasSchema$", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, Schema$), (Schema.Field)Schema$));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"hasSchema$0", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"hasSchema$1", (Object)SpecificCompiler.generateHasMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)Schema$));
    }

    @Test
    public void generateClearMethod() {
        Schema.Field height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Schema.Field height_and_width = new Schema.Field("height_and_width", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"clearHeight", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, height), (Schema.Field)height));
        Assert.assertEquals((Object)"clearHeightAndWidth", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, height_and_width), (Schema.Field)height_and_width));
        Assert.assertEquals((Object)"clearMessage", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, message), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"clearMessage$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, message), (Schema.Field)message));
        Assert.assertEquals((Object)"clearCause", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, cause), (Schema.Field)cause));
        cause = new Schema.Field("cause", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"clearCause$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, cause), (Schema.Field)cause));
        Assert.assertEquals((Object)"clearClass$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, clasz), (Schema.Field)clasz));
        clasz = new Schema.Field("class", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"clearClass$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, clasz), (Schema.Field)clasz));
        Assert.assertEquals((Object)"clearSchema$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, schema), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"clearSchema$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, schema), (Schema.Field)schema));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assert.assertEquals((Object)"clearHeight", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, Height), (Schema.Field)Height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assert.assertEquals((Object)"clearHeight$0", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)height));
        height = new Schema.Field("height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Height = new Schema.Field("Height", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        Assert.assertEquals((Object)"clearHeight$1", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, height, Height), (Schema.Field)Height));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"clearMessage$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, Message2), (Schema.Field)Message2));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"clearMessage$0", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)message));
        message = new Schema.Field("message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Message2 = new Schema.Field("Message", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"clearMessage$1", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", true, message, Message2), (Schema.Field)Message2));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"clearSchema$", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, Schema$), (Schema.Field)Schema$));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"clearSchema$0", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)schema));
        schema = new Schema.Field("schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema$ = new Schema.Field("Schema", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Assert.assertEquals((Object)"clearSchema$1", (Object)SpecificCompiler.generateClearMethod((Schema)this.createRecord("test", false, schema, Schema$), (Schema.Field)Schema$));
    }

    @Test
    public void testAnnotations() throws Exception {
        Assert.assertNotNull((Object)Simple.class.getAnnotation(TestAnnotation.class));
        Assert.assertNotNull((Object)TestRecord.class.getAnnotation(TestAnnotation.class));
        Assert.assertNotNull((Object)MD5.class.getAnnotation(TestAnnotation.class));
        Assert.assertNotNull((Object)Kind.class.getAnnotation(TestAnnotation.class));
        Assert.assertNotNull((Object)TestRecord.class.getField("name").getAnnotation(TestAnnotation.class));
        Assert.assertNotNull((Object)Simple.class.getMethod("ack", new Class[0]).getAnnotation(TestAnnotation.class));
    }

    @Test
    public void testAliases() throws IOException {
        Schema s = Schema.parse((String)"{\"name\":\"X\",\"type\":\"record\",\"aliases\":[\"Y\"],\"fields\":[{\"name\":\"f\",\"type\":\"int\",\"aliases\":[\"g\"]}]}");
        SpecificCompiler compiler = new SpecificCompiler(s);
        compiler.setStringType(GenericData.StringType.valueOf((String)"String"));
        Collection outputs = compiler.compile();
        Assert.assertEquals((long)1L, (long)outputs.size());
        SpecificCompiler.OutputFile o = (SpecificCompiler.OutputFile)outputs.iterator().next();
        Assert.assertEquals((Object)o.path, (Object)"X.java");
        Assert.assertTrue((boolean)o.contents.contains("[\\\"Y\\\"]"));
        Assert.assertTrue((boolean)o.contents.contains("[\\\"g\\\"]"));
    }

    public static void assertCompiles(Schema schema, boolean useJavaCompiler) throws IOException {
        Collection outputs = new SpecificCompiler(schema).compile();
        Assert.assertTrue((null != outputs ? 1 : 0) != 0);
        if (useJavaCompiler) {
            TestSpecificCompiler.assertCompilesWithJavaCompiler(outputs);
        }
    }

    public static void assertCompiles(Protocol protocol, boolean useJavaCompiler) throws IOException {
        Collection outputs = new SpecificCompiler(protocol).compile();
        Assert.assertTrue((null != outputs ? 1 : 0) != 0);
        if (useJavaCompiler) {
            TestSpecificCompiler.assertCompilesWithJavaCompiler(outputs);
        }
    }

    static void assertCompilesWithJavaCompiler(Collection<SpecificCompiler.OutputFile> outputs) throws IOException {
        if (outputs.isEmpty()) {
            return;
        }
        File dstDir = AvroTestUtil.tempFile(TestSpecificCompiler.class, (String)"realCompiler");
        ArrayList<File> javaFiles = new ArrayList<File>();
        for (SpecificCompiler.OutputFile o : outputs) {
            javaFiles.add(o.writeToDestination(null, dstDir));
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        JavaCompiler.CompilationTask cTask = compiler.getTask(null, fileManager, null, null, null, fileManager.getJavaFileObjects(javaFiles.toArray(new File[javaFiles.size()])));
        Assert.assertTrue((boolean)cTask.call());
    }
}

