/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.codegen;

import java.util.ArrayList;
import jcuda.Pointer;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.runtime.codegen.SpoofOperator;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;

public interface SpoofCUDAOperator {
    public static final int JNI_MAT_ENTRY_SIZE = 6;

    public String getName();

    public void setScalarPtr(Pointer var1);

    public Pointer getScalarPtr();

    public void releaseScalarGPUMemory(ExecutionContext var1);

    default public long[] prepareInputPointers(ExecutionContext ec, ArrayList<MatrixObject> inputs, int offset) {
        long[] in = new long[offset * 6];
        for (int i = 0; i < offset; ++i) {
            int j = i * 6;
            if (inputs.get(i).getGPUObject(ec.getGPUContext(0)).isSparse()) {
                in[j] = ec.getGPUSparsePointerAddress((MatrixObject)inputs.get((int)i)).nnz;
                in[j + 1] = inputs.get(i).getNumRows();
                in[j + 2] = inputs.get(i).getNumColumns();
                in[j + 3] = GPUObject.getPointerAddress(ec.getGPUSparsePointerAddress((MatrixObject)inputs.get((int)i)).rowPtr);
                in[j + 4] = GPUObject.getPointerAddress(ec.getGPUSparsePointerAddress((MatrixObject)inputs.get((int)i)).colInd);
                in[j + 5] = GPUObject.getPointerAddress(ec.getGPUSparsePointerAddress((MatrixObject)inputs.get((int)i)).val);
                continue;
            }
            in[j] = inputs.get(i).getNnz();
            in[j + 1] = inputs.get(i).getNumRows();
            in[j + 2] = inputs.get(i).getNumColumns();
            in[j + 5] = ec.getGPUDensePointerAddress(inputs.get(i));
        }
        return in;
    }

    default public long[] prepareSideInputPointers(ExecutionContext ec, ArrayList<MatrixObject> inputs, int offset, boolean tB1) {
        long[] sides = new long[(inputs.size() - offset) * 6];
        for (int i = offset; i < inputs.size(); ++i) {
            int j = (i - offset) * 6;
            if (inputs.get(i).getGPUObject(ec.getGPUContext(0)).isSparse()) {
                sides[j] = ec.getGPUSparsePointerAddress((MatrixObject)inputs.get((int)i)).nnz;
                sides[j + 1] = inputs.get(i).getNumRows();
                sides[j + 2] = inputs.get(i).getNumColumns();
                sides[j + 3] = GPUObject.getPointerAddress(ec.getGPUSparsePointerAddress((MatrixObject)inputs.get((int)i)).rowPtr);
                sides[j + 4] = GPUObject.getPointerAddress(ec.getGPUSparsePointerAddress((MatrixObject)inputs.get((int)i)).colInd);
                sides[j + 5] = GPUObject.getPointerAddress(ec.getGPUSparsePointerAddress((MatrixObject)inputs.get((int)i)).val);
                continue;
            }
            if (tB1 && j == 0) {
                long rows = inputs.get(i).getNumRows();
                long cols = inputs.get(i).getNumColumns();
                Pointer b1 = inputs.get(i).getGPUObject(ec.getGPUContext(0)).getDensePointer();
                Pointer ptr = ec.getGPUContext(0).allocate(this.getName(), rows * cols * (long)LibMatrixCUDA.sizeOfDataType);
                LibMatrixCUDA.denseTranspose(ec, ec.getGPUContext(0), this.getName(), b1, ptr, rows, cols);
                sides[j] = inputs.get(i).getNnz();
                sides[j + 1] = cols;
                sides[j + 2] = rows;
                sides[j + 5] = GPUObject.getPointerAddress(ptr);
                continue;
            }
            sides[j] = inputs.get(i).getNnz();
            sides[j + 1] = inputs.get(i).getNumRows();
            sides[j + 2] = inputs.get(i).getNumColumns();
            sides[j + 5] = ec.getGPUDensePointerAddress(inputs.get(i));
        }
        return sides;
    }

    default public long[] prepareOutputPointers(ExecutionContext ec, MatrixObject output, boolean sparseOut) {
        long[] out = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
        if (sparseOut) {
            out[0] = ec.getGPUSparsePointerAddress((MatrixObject)output).nnz;
            out[1] = output.getNumRows();
            out[2] = output.getNumColumns();
            out[3] = GPUObject.getPointerAddress(ec.getGPUSparsePointerAddress((MatrixObject)output).rowPtr);
            out[4] = GPUObject.getPointerAddress(ec.getGPUSparsePointerAddress((MatrixObject)output).colInd);
            out[5] = GPUObject.getPointerAddress(ec.getGPUSparsePointerAddress((MatrixObject)output).val);
        } else {
            out[0] = output.getNnz();
            out[1] = output.getNumRows();
            out[2] = output.getNumColumns();
            out[5] = ec.getGPUDensePointerAddress(output);
        }
        return out;
    }

    public MatrixObject execute(ExecutionContext var1, ArrayList<MatrixObject> var2, ArrayList<ScalarObject> var3, String var4);

    public ScalarObject execute(ExecutionContext var1, ArrayList<MatrixObject> var2, ArrayList<ScalarObject> var3);

    public int execute_sp(long var1, long[] var3, long[] var4, long[] var5, long[] var6, long var7);

    public int execute_dp(long var1, long[] var3, long[] var4, long[] var5, long[] var6, long var7);

    public static abstract class PrecisionProxy {
        protected final long ctx = SpoofCompiler.native_contexts.get((Object)SpoofCompiler.GeneratorAPI.CUDA);

        public abstract int exec(ExecutionContext var1, SpoofCUDAOperator var2, int var3, long[] var4, long[] var5, long[] var6, ArrayList<ScalarObject> var7, long var8);

        protected Pointer transferScalars(ExecutionContext ec, SpoofCUDAOperator op, int sizeOfDataType, ArrayList<ScalarObject> scalarObjects) {
            double[] s = SpoofOperator.prepInputScalars(scalarObjects);
            Pointer ptr = ec.getGPUContext(0).allocate(op.getName(), (long)scalarObjects.size() * (long)sizeOfDataType);
            LibMatrixCUDA.cudaSupportFunctions.hostToDevice(ec.getGPUContext(0), s, ptr, op.getName());
            return ptr;
        }
    }
}

