/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.encoding;

import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.ConstEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.DenseEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.EmptyEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.SparseEncoding;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayCountHashMap;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public interface IEncode {
    public static final Log LOG = LogFactory.getLog((String)IEncode.class.getName());

    public static IEncode createFromMatrixBlock(MatrixBlock m, boolean transposed, int[] rowCols) {
        if (m.isEmpty()) {
            return new EmptyEncoding();
        }
        if (rowCols.length == 1) {
            return IEncode.createFromMatrixBlock(m, transposed, rowCols[0]);
        }
        return IEncode.createWithReader(m, rowCols, transposed);
    }

    public static IEncode createFromMatrixBlockDelta(MatrixBlock m, boolean transposed, int[] rowCols) {
        return IEncode.createFromMatrixBlockDelta(m, transposed, rowCols, transposed ? m.getNumColumns() : m.getNumRows());
    }

    public static IEncode createFromMatrixBlockDelta(MatrixBlock m, boolean transposed, int[] rowCols, int nVals) {
        throw new NotImplementedException();
    }

    public static IEncode createFromMatrixBlock(MatrixBlock m, boolean transposed, int rowCol) {
        if (m.isEmpty()) {
            return new EmptyEncoding();
        }
        if (transposed) {
            if (m.isInSparseFormat()) {
                return IEncode.createFromSparseTransposed(m, rowCol);
            }
            return IEncode.createFromDenseTransposed(m, rowCol);
        }
        if (m.isInSparseFormat()) {
            return IEncode.createFromSparse(m, rowCol);
        }
        return IEncode.createFromDense(m, rowCol);
    }

    private static IEncode createFromDenseTransposed(MatrixBlock m, int row) {
        DoubleCountHashMap map = new DoubleCountHashMap(16);
        DenseBlock db = m.getDenseBlock();
        int off = db.pos(row);
        int nCol = m.getNumColumns();
        int end = off + nCol;
        double[] vals = db.values(row);
        for (int i = off; i < end; ++i) {
            map.increment(vals[i]);
        }
        int nUnique = map.size();
        if (nUnique == 1) {
            return new ConstEncoding(m.getNumColumns());
        }
        if (map.getOrDefault(0.0, -1) > nCol / 4) {
            map.replaceWithUIDsNoZero();
            int zeroCount = map.get(0.0);
            int nV = nCol - zeroCount;
            IntArrayList offsets = new IntArrayList(nV);
            AMapToData d = MapToFactory.create(nV, nUnique - 1);
            int i = off;
            int r = 0;
            int di = 0;
            while (i < end) {
                if (vals[i] != 0.0) {
                    offsets.appendValue(r);
                    d.set(di++, map.get(vals[i]));
                }
                ++i;
                ++r;
            }
            AOffset o = OffsetFactory.createOffset(offsets);
            return new SparseEncoding(d, o, zeroCount, nCol);
        }
        map.replaceWithUIDs();
        AMapToData d = MapToFactory.create(nCol, nUnique);
        int i = off;
        int r = 0;
        while (i < end) {
            d.set(r, map.get(vals[i]));
            ++i;
            ++r;
        }
        return new DenseEncoding(d);
    }

    private static IEncode createFromSparseTransposed(MatrixBlock m, int row) {
        DoubleCountHashMap map = new DoubleCountHashMap(16);
        SparseBlock sb = m.getSparseBlock();
        if (sb.isEmpty(row)) {
            return new EmptyEncoding();
        }
        int apos = sb.pos(row);
        int alen = sb.size(row) + apos;
        double[] avals = sb.values(row);
        int[] aix = sb.indexes(row);
        for (int i = apos; i < alen; ++i) {
            map.increment(avals[i]);
        }
        int nUnique = map.size();
        map.replaceWithUIDs();
        int nCol = m.getNumColumns();
        if (alen - apos > nCol / 4) {
            AMapToData d = MapToFactory.create(nCol, nUnique + 1);
            for (int i = apos; i < alen; ++i) {
                d.set(aix[i], map.get(avals[i]) + 1);
            }
            return new DenseEncoding(d);
        }
        AMapToData d = MapToFactory.create(alen - apos, nUnique);
        int i = apos;
        int j = 0;
        while (i < alen) {
            d.set(j, map.get(avals[i]));
            ++i;
            ++j;
        }
        AOffset o = OffsetFactory.createOffset(aix, apos, alen);
        int zero = m.getNumColumns() - o.getSize();
        try {
            return new SparseEncoding(d, o, zero, m.getNumColumns());
        }
        catch (Exception e) {
            throw new DMLCompressionException(Arrays.toString(aix), e);
        }
    }

    private static IEncode createFromDense(MatrixBlock m, int col) {
        DenseBlock db = m.getDenseBlock();
        if (!db.isContiguous()) {
            throw new NotImplementedException("Not Implemented non contiguous dense matrix encoding for sample");
        }
        DoubleCountHashMap map = new DoubleCountHashMap(16);
        int off = col;
        int nCol = m.getNumColumns();
        int nRow = m.getNumRows();
        int end = off + nRow * nCol;
        double[] vals = m.getDenseBlockValues();
        for (int i = off; i < end; i += nCol) {
            map.increment(vals[i]);
        }
        int nUnique = map.size();
        if (nUnique == 1) {
            return new ConstEncoding(m.getNumColumns());
        }
        if (map.getOrDefault(0.0, -1) > nRow / 4) {
            map.replaceWithUIDsNoZero();
            int zeroCount = map.get(0.0);
            int nV = m.getNumRows() - zeroCount;
            IntArrayList offsets = new IntArrayList(nV);
            AMapToData d = MapToFactory.create(nV, nUnique - 1);
            int i = off;
            int r = 0;
            int di = 0;
            while (i < end) {
                if (vals[i] != 0.0) {
                    offsets.appendValue(r);
                    d.set(di++, map.get(vals[i]));
                }
                i += nCol;
                ++r;
            }
            AOffset o = OffsetFactory.createOffset(offsets);
            return new SparseEncoding(d, o, zeroCount, nRow);
        }
        map.replaceWithUIDs();
        AMapToData d = MapToFactory.create(nRow, nUnique);
        int i = off;
        int r = 0;
        while (i < end) {
            d.set(r, map.get(vals[i]));
            i += nCol;
            ++r;
        }
        return new DenseEncoding(d);
    }

    private static IEncode createFromSparse(MatrixBlock m, int col) {
        DoubleCountHashMap map = new DoubleCountHashMap(16);
        SparseBlock sb = m.getSparseBlock();
        double guessedNumberOfNonZero = Math.min(4.0, Math.ceil((double)m.getNumRows() * m.getSparsity()));
        IntArrayList offsets = new IntArrayList((int)guessedNumberOfNonZero);
        for (int r = 0; r < m.getNumRows(); ++r) {
            if (sb.isEmpty(r)) continue;
            int apos = sb.pos(r);
            int alen = sb.size(r) + apos;
            int[] aix = sb.indexes(r);
            int index = Arrays.binarySearch(aix, apos, alen, col);
            if (index < 0) continue;
            offsets.appendValue(r);
            map.increment(sb.values(r)[index]);
        }
        if (offsets.size() == 0) {
            return new EmptyEncoding();
        }
        int nUnique = map.size();
        map.replaceWithUIDs();
        AMapToData d = MapToFactory.create(offsets.size(), nUnique);
        int off = 0;
        int r = 0;
        while (off < offsets.size()) {
            if (!sb.isEmpty(r)) {
                int apos = sb.pos(r);
                int alen = sb.size(r) + apos;
                int[] aix = sb.indexes(r);
                int index = Arrays.binarySearch(aix, apos, alen, col);
                if (index >= 0) {
                    d.set(off++, map.get(sb.values(r)[index]));
                }
            }
            ++r;
        }
        AOffset o = OffsetFactory.createOffset(offsets);
        int zero = m.getNumRows() - offsets.size();
        return new SparseEncoding(d, o, zero, m.getNumRows());
    }

    private static IEncode createWithReader(MatrixBlock m, int[] rowCols, boolean transposed) {
        ReaderColumnSelection reader1 = ReaderColumnSelection.createReader(m, rowCols, transposed);
        int nRows = transposed ? m.getNumColumns() : m.getNumRows();
        DblArrayCountHashMap map = new DblArrayCountHashMap(16, rowCols.length);
        IntArrayList offsets = new IntArrayList();
        DblArray cellVals = reader1.nextRow();
        while (cellVals != null) {
            map.increment(cellVals);
            offsets.appendValue(reader1.getCurrentRowIndex());
            cellVals = reader1.nextRow();
        }
        if (offsets.size() == 0) {
            return new EmptyEncoding();
        }
        if (map.size() == 1 && offsets.size() == nRows) {
            return new ConstEncoding(nRows);
        }
        map.replaceWithUIDs();
        if (offsets.size() < nRows / 4) {
            int zeros = nRows - offsets.size();
            return IEncode.createWithReaderSparse(m, map, zeros, rowCols, offsets, nRows, transposed);
        }
        return IEncode.createWithReaderDense(m, map, rowCols, nRows, transposed, offsets.size() < nRows);
    }

    private static IEncode createWithReaderDense(MatrixBlock m, DblArrayCountHashMap map, int[] rowCols, int nRows, boolean transposed, boolean zero) {
        int unique = map.size() + (zero ? 1 : 0);
        ReaderColumnSelection reader2 = ReaderColumnSelection.createReader(m, rowCols, transposed);
        AMapToData d = MapToFactory.create(nRows, unique);
        if (zero) {
            DblArray cellVals;
            while ((cellVals = reader2.nextRow()) != null) {
                d.set(reader2.getCurrentRowIndex(), map.get(cellVals) + 1);
            }
        } else {
            DblArray cellVals;
            while ((cellVals = reader2.nextRow()) != null) {
                d.set(reader2.getCurrentRowIndex(), map.get(cellVals));
            }
        }
        return new DenseEncoding(d);
    }

    private static IEncode createWithReaderSparse(MatrixBlock m, DblArrayCountHashMap map, int zeros, int[] rowCols, IntArrayList offsets, int nRows, boolean transposed) {
        ReaderColumnSelection reader2 = ReaderColumnSelection.createReader(m, rowCols, transposed);
        DblArray cellVals = reader2.nextRow();
        AMapToData d = MapToFactory.create(offsets.size(), map.size());
        int i = 0;
        while (cellVals != null) {
            d.set(i++, map.get(cellVals));
            cellVals = reader2.nextRow();
        }
        AOffset o = OffsetFactory.createOffset(offsets);
        return new SparseEncoding(d, o, zeros, nRows);
    }

    public IEncode combine(IEncode var1);

    public int getUnique();

    public EstimationFactors extractFacts(int[] var1, int var2, double var3, double var5);

    public boolean isDense();
}

