/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.encoding;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToChar;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToCharPByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.AEncode;
import org.apache.sysds.runtime.compress.estim.encoding.ConstEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.EmptyEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.compress.estim.encoding.SparseEncoding;
import org.apache.sysds.runtime.compress.utils.HashMapLongInt;

public class DenseEncoding
extends AEncode {
    private static boolean zeroWarn = false;
    private final AMapToData map;

    public DenseEncoding(AMapToData map) {
        this.map = map;
        if (CompressedMatrixBlock.debug) {
            int[] freq = map.getCounts();
            for (int i = 0; i < freq.length && !zeroWarn; ++i) {
                if (freq[i] != 0) continue;
                LOG.warn((Object)"Dense encoding contains zero encoding, indicating not all dictionary entries are in use");
                zeroWarn = true;
            }
        }
    }

    @Override
    public IEncode combine(IEncode e) {
        if (e instanceof EmptyEncoding || e instanceof ConstEncoding) {
            return this;
        }
        if (e instanceof SparseEncoding) {
            return this.combineSparse((SparseEncoding)e);
        }
        return this.combineDense((DenseEncoding)e);
    }

    @Override
    public Pair<IEncode, HashMapLongInt> combineWithMap(IEncode e) {
        if (e instanceof EmptyEncoding || e instanceof ConstEncoding) {
            return new ImmutablePair((Object)this, null);
        }
        if (e instanceof SparseEncoding) {
            return this.combineSparseNoResize((SparseEncoding)e);
        }
        return this.combineDenseNoResize((DenseEncoding)e);
    }

    protected IEncode combineSparse(SparseEncoding e) {
        int maxUnique = e.getUnique() * this.getUnique();
        int size = this.map.size();
        int nVl = this.getUnique();
        AMapToData ret = this.assignSparse(e);
        if (maxUnique + nVl > size) {
            return (IEncode)this.combineSparseHashMap(ret).getLeft();
        }
        return this.combineSparseMapToData(ret, maxUnique, nVl);
    }

    private AMapToData assignSparse(SparseEncoding e) {
        int maxUnique = e.getUnique() * this.getUnique();
        int size = this.map.size();
        int nVl = this.getUnique();
        AMapToData ret = MapToFactory.create(size, maxUnique);
        ret.copy(this.map);
        AIterator itr = e.off.getIterator();
        int fr = e.off.getOffsetToLast();
        int ir = itr.value();
        while (ir < fr) {
            ret.set(ir, ret.getIndex(ir) + (e.map.getIndex(itr.getDataIndex()) + 1) * nVl);
            ir = itr.next();
        }
        ret.set(fr, ret.getIndex(fr) + (e.map.getIndex(itr.getDataIndex()) + 1) * nVl);
        return ret;
    }

    private final Pair<IEncode, HashMapLongInt> combineSparseHashMap(AMapToData ret) {
        int size = ret.size();
        HashMapLongInt m = new HashMapLongInt(100);
        for (int r = 0; r < size; ++r) {
            int v;
            int prev = ret.getIndex(r);
            int mv = m.putIfAbsent(prev, v = m.size());
            if (mv == -1) {
                ret.set(r, v);
                continue;
            }
            ret.set(r, mv);
        }
        return new ImmutablePair((Object)new DenseEncoding(ret.resize(m.size())), (Object)m);
    }

    private final DenseEncoding combineSparseMapToData(AMapToData ret, int maxUnique, int nVl) {
        int size = ret.size();
        AMapToData m = MapToFactory.create(maxUnique, maxUnique + nVl);
        int newUID = 1;
        for (int r = 0; r < size; ++r) {
            int prev = ret.getIndex(r);
            int mv = m.getIndex(prev);
            if (mv == 0) {
                mv = m.setAndGet(prev, newUID++);
            }
            ret.set(r, mv - 1);
        }
        return new DenseEncoding(ret.resize(newUID - 1));
    }

    protected DenseEncoding combineDense(DenseEncoding other) {
        DenseEncoding retE;
        Object m;
        if (this.map == other.map) {
            return this;
        }
        AMapToData lm = this.map;
        AMapToData rm = other.map;
        int nVL = lm.getUnique();
        int nVR = rm.getUnique();
        int size = this.map.size();
        int maxUnique = nVL * nVR;
        AMapToData ret = MapToFactory.create(size, maxUnique);
        if (maxUnique < Math.max(nVL, nVR)) {
            m = new HashMapLongInt(Math.max(100, size / 100));
            retE = this.combineDenseWithHashMapLong(lm, rm, size, nVL, ret, (HashMapLongInt)m);
        } else if (maxUnique > size && maxUnique > 2048) {
            m = new HashMapLongInt(Math.max(100, maxUnique / 100));
            retE = this.combineDenseWithHashMap(lm, rm, size, nVL, ret, (HashMapLongInt)m);
        } else {
            m = MapToFactory.create(maxUnique, maxUnique + 1);
            retE = this.combineDenseWithMapToData(lm, rm, size, nVL, ret, maxUnique, (AMapToData)m);
        }
        if (retE.getUnique() < 0) {
            String th = this.toString();
            String ot = other.toString();
            String cm = retE.toString();
            if (th.length() > 1000) {
                th = th.substring(0, 1000);
            }
            if (ot.length() > 1000) {
                ot = ot.substring(0, 1000);
            }
            if (cm.length() > 1000) {
                cm = cm.substring(0, 1000);
            }
            throw new DMLCompressionException("Failed to combine dense encodings correctly: Number unique values is lower than max input: \n\n" + th + "\n\n" + ot + "\n\n" + cm);
        }
        return retE;
    }

    private Pair<IEncode, HashMapLongInt> combineDenseNoResize(DenseEncoding other) {
        if (this.map.equals(other.map)) {
            return this.combineSameMapping();
        }
        AMapToData lm = this.map;
        AMapToData rm = other.map;
        int nVL = lm.getUnique();
        int nVR = rm.getUnique();
        int size = this.map.size();
        int maxUnique = (int)Math.min((long)nVL * (long)nVR, (long)size);
        AMapToData ret = MapToFactory.create(size, maxUnique);
        HashMapLongInt m = new HashMapLongInt(Math.max(100, maxUnique / 1000));
        return new ImmutablePair((Object)this.combineDenseWithHashMap(lm, rm, size, nVL, ret, m), (Object)m);
    }

    private Pair<IEncode, HashMapLongInt> combineSameMapping() {
        LOG.warn((Object)"Constructing perfect mapping, this could be optimized to skip hashmap");
        HashMapLongInt m = new HashMapLongInt(Math.max(100, this.map.size() / 100));
        for (int i = 0; i < this.map.getUnique(); ++i) {
            m.putIfAbsent(i * (this.map.getUnique() + 1), i);
        }
        return new ImmutablePair((Object)this, (Object)m);
    }

    private Pair<IEncode, HashMapLongInt> combineSparseNoResize(SparseEncoding other) {
        AMapToData a = this.assignSparse(other);
        return this.combineSparseHashMap(a);
    }

    protected final DenseEncoding combineDenseWithHashMapLong(AMapToData lm, AMapToData rm, int size, long nVL, AMapToData ret, HashMapLongInt m) {
        if (ret instanceof MapToChar) {
            for (int r = 0; r < size; ++r) {
                DenseEncoding.addValHashMapChar((long)lm.getIndex(r) + (long)rm.getIndex(r) * nVL, r, m, (MapToChar)ret);
            }
        } else {
            for (int r = 0; r < size; ++r) {
                DenseEncoding.addValHashMap((long)lm.getIndex(r) + (long)rm.getIndex(r) * nVL, r, m, ret);
            }
        }
        return new DenseEncoding(ret.resize(m.size()));
    }

    protected final DenseEncoding combineDenseWithHashMap(AMapToData lm, AMapToData rm, int size, int nVL, AMapToData ret, HashMapLongInt m) {
        if (ret instanceof MapToChar) {
            this.combineDenseWIthHashMapCharOut(lm, rm, size, nVL, (MapToChar)ret, m);
        } else if (ret instanceof MapToCharPByte) {
            this.combineDenseWIthHashMapPByteOut(lm, rm, size, nVL, (MapToCharPByte)ret, m);
        } else {
            this.combineDenseWithHashMapGeneric(lm, rm, size, nVL, ret, m);
        }
        ret.setUnique(m.size());
        return new DenseEncoding(ret);
    }

    private final void combineDenseWIthHashMapPByteOut(AMapToData lm, AMapToData rm, int size, int nVL, MapToCharPByte ret, HashMapLongInt m) {
        for (int r = 0; r < size; ++r) {
            DenseEncoding.addValHashMapCharByte(this.calculateID(lm, rm, nVL, r), r, m, ret);
        }
    }

    private final void combineDenseWIthHashMapCharOut(AMapToData lm, AMapToData rm, int size, int nVL, MapToChar ret, HashMapLongInt m) {
        if (lm instanceof MapToChar && rm instanceof MapToChar) {
            this.combineDenseWIthHashMapAllChar(lm, rm, size, nVL, ret, m);
        } else {
            this.combineDenseWIthHashMapCharOutGeneric(lm, rm, size, nVL, ret, m);
        }
    }

    private final void combineDenseWIthHashMapCharOutGeneric(AMapToData lm, AMapToData rm, int size, int nVL, MapToChar ret, HashMapLongInt m) {
        for (int r = 0; r < size; ++r) {
            DenseEncoding.addValHashMapChar(this.calculateID(lm, rm, nVL, r), r, m, ret);
        }
    }

    private final void combineDenseWIthHashMapAllChar(AMapToData lm, AMapToData rm, int size, int nVL, MapToChar ret, HashMapLongInt m) {
        MapToChar lmC = (MapToChar)lm;
        MapToChar rmC = (MapToChar)rm;
        for (int r = 0; r < size; ++r) {
            DenseEncoding.addValHashMapChar(lmC.getIndex(r) + rmC.getIndex(r) * nVL, r, m, ret);
        }
    }

    protected final void combineDenseWithHashMapGeneric(AMapToData lm, AMapToData rm, int size, int nVL, AMapToData ret, HashMapLongInt m) {
        for (int r = 0; r < size; ++r) {
            DenseEncoding.addValHashMap(this.calculateID(lm, rm, nVL, r), r, m, ret);
        }
    }

    protected final DenseEncoding combineDenseWithMapToData(AMapToData lm, AMapToData rm, int size, int nVL, AMapToData ret, int maxUnique, AMapToData m) {
        int newUID = 1;
        newUID = this.addValRange(lm, rm, size, nVL, ret, m, newUID, 0, size);
        ret.setUnique(newUID - 1);
        return new DenseEncoding(ret);
    }

    private int addValRange(AMapToData lm, AMapToData rm, int size, int nVL, AMapToData ret, AMapToData m, int newUID, int start, int end) {
        for (int r = start; r < end; ++r) {
            newUID = DenseEncoding.addValMapToData(this.calculateID(lm, rm, nVL, r), r, m, newUID, ret);
        }
        return newUID;
    }

    private int calculateID(AMapToData lm, AMapToData rm, int nVL, int r) {
        return lm.getIndex(r) + rm.getIndex(r) * nVL;
    }

    protected static int addValMapToData(int nv, int r, AMapToData map, int newId, AMapToData d) {
        int mv = map.getIndex(nv);
        if (mv == 0) {
            mv = map.setAndGet(nv, newId++);
        }
        d.set(r, mv - 1);
        return newId;
    }

    protected static void addValHashMap(int nv, int r, HashMapLongInt map, AMapToData d) {
        int v = map.size();
        int mv = map.putIfAbsent(nv, v);
        if (mv == -1) {
            d.set(r, v);
        } else {
            d.set(r, mv);
        }
    }

    protected static void addValHashMapChar(int nv, int r, HashMapLongInt map, MapToChar d) {
        int v = map.size();
        int mv = map.putIfAbsent(nv, v);
        if (mv == -1) {
            d.set(r, v);
        } else {
            d.set(r, mv);
        }
    }

    protected static void addValHashMapCharByte(int nv, int r, HashMapLongInt map, MapToCharPByte d) {
        int v = map.size();
        int mv = map.putIfAbsent(nv, v);
        if (mv == -1) {
            d.set(r, v);
        } else {
            d.set(r, mv);
        }
    }

    protected static void addValHashMapChar(long nv, int r, HashMapLongInt map, MapToChar d) {
        int v = map.size();
        int mv = map.putIfAbsent(nv, v);
        if (mv == -1) {
            d.set(r, v);
        } else {
            d.set(r, mv);
        }
    }

    protected static void addValHashMap(long nv, int r, HashMapLongInt map, AMapToData d) {
        int v = map.size();
        int mv = map.putIfAbsent(nv, v);
        if (mv == -1) {
            d.set(r, v);
        } else {
            d.set(r, mv);
        }
    }

    @Override
    public int getUnique() {
        return this.map.getUnique();
    }

    @Override
    public EstimationFactors extractFacts(int nRows, double tupleSparsity, double matrixSparsity, CompressionSettings cs) {
        int largestOffs = 0;
        int[] counts = this.map.getCounts();
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] > largestOffs) {
                largestOffs = counts[i];
                continue;
            }
            if (counts[i] != 0) continue;
            if (!zeroWarn) {
                LOG.warn((Object)("Invalid count of 0 all values should have at least one instance index: " + i + " of " + counts.length));
                zeroWarn = true;
            }
            counts[i] = 1;
        }
        if (cs.isRLEAllowed()) {
            return new EstimationFactors(this.map.getUnique(), nRows, largestOffs, counts, 0, nRows, this.map.countRuns(), false, false, matrixSparsity, tupleSparsity);
        }
        return new EstimationFactors(this.map.getUnique(), nRows, largestOffs, counts, 0, nRows, false, false, matrixSparsity, tupleSparsity);
    }

    public AMapToData getMap() {
        return this.map;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean equals(IEncode e) {
        return e instanceof DenseEncoding && ((DenseEncoding)e).map.equals(this.map);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("\n");
        sb.append("mapping: ");
        sb.append(this.map);
        return sb.toString();
    }
}

