/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.system;

import java.util.ArrayList;
import java.util.List;
import org.apache.sis.system.Threads;

abstract class DaemonThread
extends Thread {
    private final DaemonThread previous;
    private volatile boolean killRequested;

    protected DaemonThread(String name, DaemonThread lastCreatedDaemon) {
        super(Threads.DAEMONS, null, name, 16384L);
        this.previous = lastCreatedDaemon;
        this.setDaemon(true);
    }

    @Override
    public abstract void run();

    protected boolean isStalled() {
        return false;
    }

    protected final boolean isKillRequested() {
        return this.killRequested;
    }

    static void killAll(DaemonThread thread, long stopWaitingAt) throws InterruptedException {
        long delay;
        DaemonThread t = thread;
        while (t != null) {
            t.killRequested = true;
            t.interrupt();
            t = t.previous;
        }
        while (thread != null && (delay = stopWaitingAt - System.nanoTime()) > 0L) {
            thread.join(delay / 1000000L);
            thread = thread.previous;
        }
    }

    static List<Thread> listStalledThreads(DaemonThread thread) {
        ArrayList<DaemonThread> list = null;
        while (thread != null) {
            if (!thread.isAlive() || thread.isStalled()) {
                if (list == null) {
                    list = new ArrayList<DaemonThread>();
                }
                list.add(thread);
            }
            thread = thread.previous;
        }
        return list;
    }
}

