/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBMetaData;
import jakarta.ejb.EJBObject;
import jakarta.ejb.Handle;
import jakarta.ejb.HomeHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ejbd.EjbDaemon;
import org.apache.openejb.server.ejbd.KeepAliveServer;
import org.apache.openejb.spi.ApplicationServer;

public class EjbServer
implements ServerService,
ApplicationServer {
    protected KeepAliveServer keepAlive;
    protected EjbDaemon server;

    public void init(Properties props) throws Exception {
        this.server = new EjbDaemon();
        if (props.getProperty("name") == null) {
            props.setProperty("name", this.getName());
        }
        this.server.init(props);
        this.keepAlive = new KeepAliveServer(this, this.server.isGzip());
    }

    public void start() throws ServiceException {
        if (null != this.keepAlive) {
            this.keepAlive.start();
        } else {
            this.logNotInitialized();
        }
    }

    private void logNotInitialized() {
        Logger.getLogger(EjbServer.class.getName()).log(Level.WARNING, "EjbServer was not initialized");
    }

    public void stop() throws ServiceException {
        if (null != this.keepAlive) {
            this.keepAlive.stop();
        } else {
            this.logNotInitialized();
        }
    }

    public String getName() {
        return "ejbd";
    }

    public int getPort() {
        return 0;
    }

    public void service(Socket socket) throws ServiceException, IOException {
        if (null != this.keepAlive) {
            this.keepAlive.service(socket);
        } else {
            this.logNotInitialized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(InputStream inputStream, OutputStream outputStream) throws ServiceException, IOException {
        ServerFederation.setApplicationServer((ApplicationServer)this.server);
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.server.service(inputStream, outputStream);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public String getIP() {
        return "";
    }

    public EJBMetaData getEJBMetaData(ProxyInfo info) {
        return this.server.getEJBMetaData(info);
    }

    public Handle getHandle(ProxyInfo info) {
        return this.server.getHandle(info);
    }

    public HomeHandle getHomeHandle(ProxyInfo info) {
        return this.server.getHomeHandle(info);
    }

    public EJBObject getEJBObject(ProxyInfo info) {
        return this.server.getEJBObject(info);
    }

    public Object getBusinessObject(ProxyInfo info) {
        return this.server.getBusinessObject(info);
    }

    public EJBHome getEJBHome(ProxyInfo info) {
        return this.server.getEJBHome(info);
    }
}

