/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.testing.evaluator.AbstractCasEvaluator;

public class StringFeatureCasEvaluator
extends AbstractCasEvaluator {
    @Override
    public CAS evaluate(CAS test, CAS run, Collection<String> excludedTypes, boolean includeSubtypes, boolean useAllTypes) throws CASRuntimeException, CASException {
        Type falsePositiveType = run.getTypeSystem().getType("org.apache.uima.ruta.type.FalsePositive");
        Type falseNegativeType = run.getTypeSystem().getType("org.apache.uima.ruta.type.FalseNegative");
        Type truePositveType = run.getTypeSystem().getType("org.apache.uima.ruta.type.TruePositive");
        Feature feature = falsePositiveType.getFeatureByBaseName("original");
        List allTypes = test.getTypeSystem().getProperlySubsumedTypes(test.getTypeSystem().getTopType());
        ArrayList<Type> types = new ArrayList<Type>();
        Type stringType = run.getTypeSystem().getType("uima.cas.String");
        Type basicType = run.getTypeSystem().getType("org.apache.uima.ruta.type.RutaBasic");
        TypeSystem typeSystem = test.getTypeSystem();
        Type annotationType = test.getAnnotationType();
        block0: for (Type eachType : allTypes) {
            if (excludedTypes.contains(eachType.getName()) || eachType.getName().equals(test.getDocumentAnnotation().getType().getName())) continue;
            List features = eachType.getFeatures();
            for (Feature f : features) {
                Type range = f.getRange();
                if (!typeSystem.subsumes(annotationType, range) && !typeSystem.subsumes(stringType, range) || eachType.getName().startsWith("org.apache.uima.ruta.type") || typeSystem.subsumes(basicType, eachType)) continue;
                types.add(eachType);
                continue block0;
            }
        }
        Collection<FeatureStructure> testFSs = this.getFeatureStructures(types, test);
        Collection<FeatureStructure> runFSs = this.getFeatureStructures(types, run);
        HashSet<FeatureStructure> matched = new HashSet<FeatureStructure>();
        ArrayList<FeatureStructure> fp = new ArrayList<FeatureStructure>();
        ArrayList<FeatureStructure> fn = new ArrayList<FeatureStructure>();
        ArrayList<FeatureStructure> tp = new ArrayList<FeatureStructure>();
        for (FeatureStructure eachTest : testFSs) {
            FeatureStructure original;
            Type type;
            FeatureStructure createFS;
            boolean found = false;
            for (FeatureStructure eachRun : runFSs) {
                if (!this.match(eachTest, eachRun)) continue;
                matched.add(eachRun);
                found = true;
                break;
            }
            if (!found) {
                createFS = run.createFS(falseNegativeType);
                this.fillFS(eachTest, createFS, false);
                type = run.getTypeSystem().getType(eachTest.getType().getName());
                original = run.createFS(type);
                this.fillFS(eachTest, original, true);
                createFS.setFeatureValue(feature, original);
                fn.add(createFS);
                continue;
            }
            createFS = run.createFS(truePositveType);
            this.fillFS(eachTest, createFS, false);
            type = run.getTypeSystem().getType(eachTest.getType().getName());
            original = run.createFS(type);
            this.fillFS(eachTest, original, true);
            createFS.setFeatureValue(feature, original);
            tp.add(createFS);
        }
        for (FeatureStructure each : runFSs) {
            if (matched.contains(each)) continue;
            FeatureStructure createFS = run.createFS(falsePositiveType);
            this.fillFS(each, createFS, false);
            Type type = run.getTypeSystem().getType(each.getType().getName());
            FeatureStructure original = run.createFS(type);
            this.fillFS(each, original, true);
            createFS.setFeatureValue(feature, original);
            fp.add(createFS);
        }
        for (FeatureStructure fs : fn) {
            run.addFsToIndexes(fs);
        }
        for (FeatureStructure fs : fp) {
            run.addFsToIndexes(fs);
        }
        for (FeatureStructure fs : tp) {
            run.addFsToIndexes(fs);
        }
        return run;
    }

    private void fillFS(FeatureStructure fs, FeatureStructure newFS, boolean withFeatures) {
        if (fs instanceof AnnotationFS) {
            Annotation a = (Annotation)newFS;
            a.setBegin(((AnnotationFS)fs).getBegin());
            a.setEnd(((AnnotationFS)fs).getEnd());
        }
        if (withFeatures) {
            CAS testCas = fs.getCAS();
            TypeSystem testTS = testCas.getTypeSystem();
            Type stringType = testTS.getType("uima.cas.String");
            List features = fs.getType().getFeatures();
            for (Feature feature : features) {
                Type range = feature.getRange();
                if (!testTS.subsumes(stringType, range)) continue;
                String valueTest = fs.getStringValue(feature);
                Feature feature2 = newFS.getType().getFeatureByBaseName(feature.getShortName());
                newFS.setStringValue(feature2, valueTest);
            }
        }
    }

    private Collection<FeatureStructure> getFeatureStructures(List<Type> types, CAS cas) {
        TypeSystem typeSystem = cas.getTypeSystem();
        Type stringType = typeSystem.getType("uima.cas.String");
        HashSet<FeatureStructure> result = new HashSet<FeatureStructure>();
        AnnotationIndex annotationIndex = cas.getAnnotationIndex();
        for (AnnotationFS each : annotationIndex) {
            Type type = each.getType();
            block1: for (Type eachType : types) {
                if (!typeSystem.subsumes(eachType, type)) continue;
                List features = each.getType().getFeatures();
                for (Feature feature : features) {
                    Type range = feature.getRange();
                    if (!typeSystem.subsumes(stringType, range)) continue;
                    result.add((FeatureStructure)each);
                    continue block1;
                }
            }
        }
        return result;
    }

    private boolean match(FeatureStructure a1, FeatureStructure a2) {
        Type type1 = a1.getType();
        Type type2 = a2.getType();
        if (!type1.getName().equals(type2.getName())) {
            return false;
        }
        if (a1 instanceof AnnotationFS && a2 instanceof AnnotationFS) {
            AnnotationFS a11 = (AnnotationFS)a1;
            AnnotationFS a22 = (AnnotationFS)a2;
            if (a11.getBegin() != a22.getBegin() || a11.getEnd() != a22.getEnd()) {
                return false;
            }
        }
        CAS cas = a1.getCAS();
        TypeSystem typeSystem = cas.getTypeSystem();
        Type stringType = typeSystem.getType("uima.cas.String");
        List features1 = type1.getFeatures();
        boolean result = true;
        boolean allEmpty1 = true;
        boolean allEmpty2 = true;
        for (Feature eachFeature1 : features1) {
            Type range = eachFeature1.getRange();
            if (!typeSystem.subsumes(stringType, range)) continue;
            String name = eachFeature1.getShortName();
            Feature eachFeature2 = type2.getFeatureByBaseName(name);
            String featureValue1 = a1.getStringValue(eachFeature1);
            String featureValue2 = a2.getStringValue(eachFeature2);
            allEmpty1 &= featureValue1 == null;
            allEmpty2 &= featureValue2 == null;
            if (featureValue1 != null) {
                featureValue1 = featureValue1.replaceAll("\\d", "").replaceAll("\\W", "");
            }
            if (featureValue2 != null) {
                featureValue2 = featureValue2.replaceAll("\\d", "").replaceAll("\\W", "");
            }
            result &= featureValue1 == null && featureValue2 == null || featureValue1.equals(featureValue2);
        }
        return result && allEmpty1 == allEmpty2;
    }
}

