/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.TypeSensitiveAction;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class UnmarkAllAction
extends TypeSensitiveAction {
    private final AbstractTypeListExpression list;

    public UnmarkAllAction(ITypeExpression type, AbstractTypeListExpression list) {
        super(type);
        this.list = list;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        Type t;
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        ArrayList<Type> retainList = new ArrayList();
        if (this.list != null) {
            retainList = this.list.getList(context, stream);
        }
        if ((t = this.type.getType(context, stream)) == null) {
            return;
        }
        TypeSystem typeSystem = stream.getCas().getTypeSystem();
        LinkedList<AnnotationFS> toRemove = new LinkedList<AnnotationFS>();
        List<List<RuleElementMatch>> matchInfo = match.getMatchInfo(element);
        for (List<RuleElementMatch> l : matchInfo) {
            RuleElementMatch ruleElementMatch = l.get(0);
            List<AnnotationFS> textsMatched = ruleElementMatch.getTextsMatched();
            for (AnnotationFS each : textsMatched) {
                RutaBasic beginAnchor = stream.getBeginAnchor(each.getBegin());
                Collection beginAnchors = beginAnchor.getBeginAnchors(t);
                for (AnnotationFS annotationFS : beginAnchors) {
                    if (annotationFS.getEnd() != each.getEnd() && annotationFS.getBegin() != each.getBegin() || this.retainType(annotationFS.getType(), retainList, typeSystem)) continue;
                    toRemove.add(annotationFS);
                }
            }
        }
        for (AnnotationFS annotationFS : toRemove) {
            stream.removeAnnotation(annotationFS);
        }
    }

    private boolean retainType(Type type, List<Type> retainList, TypeSystem typeSystem) {
        for (Type each : retainList) {
            if (!typeSystem.subsumes(each, type)) continue;
            return true;
        }
        return false;
    }

    public AbstractTypeListExpression getList() {
        return this.list;
    }
}

