/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/

package org.apache.uima.ruta.testing.ui.views.evalDataTable;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class TypeTableSorter extends ViewerSorter {

  private static final int ASCENDING = 0;

  private static final int DESCENDING = 1;

  private int column;

  private int direction;

  public void doSort(int column) {
    if (column == this.column) {
      // Same column as last sort; toggle the direction
      direction = 1 - direction;
    } else {
      // New column; do an ascending sort
      this.column = column;
      direction = ASCENDING;
    }
  }

  @Override
  public int compare(Viewer viewer, Object e1, Object e2) {
    int rc = 0;
    TypeEvalData td1 = (TypeEvalData) e1;
    TypeEvalData td2 = (TypeEvalData) e2;

    switch (column) {
      case TypeEvalTableConst.COLUMN_TYPE_NAME:
        rc = td1.getTypeName().compareTo(td2.getTypeName());
        break;
      case TypeEvalTableConst.COLUMN_TRUE_POSITIVES:
        rc = td1.getTruePositives() - td2.getTruePositives();
        break;
      case TypeEvalTableConst.COLUMN_FALSE_POSITIVES:
        rc = td1.getFalsePositives() - td2.getFalsePositives();
        break;
      case TypeEvalTableConst.COLUMN_FALSE_NEGATIVES:
        rc = td1.getFalseNegatives() - td2.getFalseNegatives();
        break;
      case TypeEvalTableConst.COLUMN_PRECISION:
        rc = Double.compare(td1.getPrecision(), td2.getPrecision());
        break;
      case TypeEvalTableConst.COLUMN_RECALL:
        rc = Double.compare(td1.getRecall(), td2.getRecall());
        break;
      case TypeEvalTableConst.COLUMN_F1:
        rc = Double.compare(td1.getFOne(), td2.getFOne());
        ;
        break;
    }

    if (direction == DESCENDING)
      rc = -rc;

    return rc;
  }

}
