/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;

public class PlainTextAnnotator
extends JCasAnnotator_ImplBase {
    public static final String TYPE_LINE = "org.apache.uima.ruta.type.Line";
    public static final String TYPE_WSLINE = "org.apache.uima.ruta.type.WSLine";
    public static final String TYPE_EMPTYLINE = "org.apache.uima.ruta.type.EmptyLine";
    public static final String TYPE_PARAGRAPH = "org.apache.uima.ruta.type.Paragraph";

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        CAS cas = jcas.getCas();
        String documentText = cas.getDocumentText();
        BufferedReader br = new BufferedReader(new StringReader(documentText));
        Type lineType = cas.getTypeSystem().getType(TYPE_LINE);
        Type wsLineType = cas.getTypeSystem().getType(TYPE_WSLINE);
        Type emptyLineType = cas.getTypeSystem().getType(TYPE_EMPTYLINE);
        Type paragraphType = cas.getTypeSystem().getType(TYPE_PARAGRAPH);
        int offsetTillNow = 0;
        int paragraphBegin = -1;
        int lastLineEnd = 0;
        boolean lastWasEmpty = true;
        String eachLine = null;
        try {
            while ((eachLine = br.readLine()) != null) {
                String substring;
                boolean wsLine = StringUtils.isBlank((CharSequence)eachLine);
                if (!wsLine && StringUtils.isBlank((CharSequence)eachLine.trim().replaceAll("\u00a0|\u202f|\ufeff|\u2007|\u180e", ""))) {
                    wsLine = true;
                }
                boolean emptyLine = StringUtils.isEmpty((CharSequence)eachLine);
                int offsetAfterLine = offsetTillNow + eachLine.length();
                int nlLength = 1;
                if (documentText.length() >= offsetAfterLine + 2 && (substring = documentText.substring(offsetAfterLine, offsetAfterLine + 2)).equals("\r\n")) {
                    nlLength = 2;
                }
                if (lastWasEmpty && !wsLine) {
                    paragraphBegin = offsetTillNow;
                }
                if (wsLine && emptyLine) {
                    AnnotationFS newEmptyLineFS = cas.createAnnotation(emptyLineType, offsetTillNow, offsetTillNow + nlLength);
                    cas.addFsToIndexes((FeatureStructure)newEmptyLineFS);
                } else if (wsLine && !emptyLine) {
                    AnnotationFS newWSLineFS = cas.createAnnotation(wsLineType, offsetTillNow, offsetTillNow + eachLine.length());
                    cas.addFsToIndexes((FeatureStructure)newWSLineFS);
                } else if (!emptyLine) {
                    AnnotationFS newLineFS = cas.createAnnotation(lineType, offsetTillNow, offsetTillNow + eachLine.length());
                    cas.addFsToIndexes((FeatureStructure)newLineFS);
                    lastWasEmpty = false;
                    lastLineEnd = offsetTillNow + eachLine.length();
                }
                if (wsLine && !lastWasEmpty && lastLineEnd != 0) {
                    newParaFS = cas.createAnnotation(paragraphType, paragraphBegin, lastLineEnd);
                    cas.addFsToIndexes((FeatureStructure)newParaFS);
                } else if (offsetAfterLine + nlLength == documentText.length()) {
                    newParaFS = cas.createAnnotation(paragraphType, paragraphBegin, offsetAfterLine);
                    cas.addFsToIndexes((FeatureStructure)newParaFS);
                } else if (offsetAfterLine == documentText.length()) {
                    newParaFS = cas.createAnnotation(paragraphType, paragraphBegin, offsetAfterLine);
                    cas.addFsToIndexes((FeatureStructure)newParaFS);
                }
                if (wsLine) {
                    lastWasEmpty = true;
                }
                offsetTillNow = offsetTillNow + eachLine.length() + nlLength;
            }
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

