/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ide;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.DefaultColors;
import org.apache.uima.caseditor.core.model.dotcorpus.DotCorpus;
import org.apache.uima.caseditor.core.model.dotcorpus.DotCorpusSerializer;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.apache.uima.caseditor.editor.CasDocumentProvider;
import org.apache.uima.caseditor.editor.DocumentUimaImpl;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasEditor;
import org.apache.uima.caseditor.ide.CasEditorIdePlugin;
import org.apache.uima.caseditor.ide.TypeSystemLocationPropertyPage;
import org.apache.uima.caseditor.ide.WorkspaceResourceDialog;
import org.apache.uima.caseditor.ide.searchstrategy.ITypeSystemSearchStrategy;
import org.apache.uima.caseditor.ide.searchstrategy.TypeSystemSearchStrategyFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.FileEditorInput;

public class DefaultCasDocumentProvider
extends CasDocumentProvider {
    private static final String CAS_EDITOR_SESSION_PROPERTIES = "CAS_EDITOR_SESSION_PROPERTIES";
    private Map<String, String> documentToTypeSystemMap = new HashMap<String, String>();
    private Map<String, String> typeSystemForNextDocumentOnly = new HashMap<String, String>();
    private Map<String, IPreferenceStore> sessionPreferenceStores = new HashMap<String, IPreferenceStore>();
    private Map<String, PreferenceStore> typeSystemPreferences = new HashMap<String, PreferenceStore>();
    private boolean isFileChangeTrackingEnabled = true;

    private String getStyleFileForTypeSystem(String typeSystemFile) {
        int lastSlashIndex = typeSystemFile.lastIndexOf("/");
        String styleId = typeSystemFile.substring(0, lastSlashIndex + 1);
        styleId = styleId + ".style-" + typeSystemFile.substring(lastSlashIndex + 1);
        return styleId;
    }

    private String getPreferenceFileForTypeSystem(String typeSystemFile) {
        int lastSlashIndex = typeSystemFile.lastIndexOf("/");
        String styleId = typeSystemFile.substring(0, lastSlashIndex + 1);
        styleId = styleId + ".pref-" + typeSystemFile.substring(lastSlashIndex + 1);
        return styleId;
    }

    private Collection<AnnotationStyle> getConfiguredAnnotationStyles(IPreferenceStore store, TypeSystem types) {
        return new HashSet<AnnotationStyle>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICasDocument createDocument(Object element) throws CoreException {
        if (element instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)element;
            IFile casFile = fileInput.getFile();
            IFile typeSystemFile = null;
            String typeSystemFileString = null;
            String document = casFile.getFullPath().toPortableString();
            if (this.typeSystemForNextDocumentOnly.get(document) != null) {
                typeSystemFileString = this.typeSystemForNextDocumentOnly.get(document);
                this.typeSystemForNextDocumentOnly.put(document, null);
            }
            IPreferenceStore prefStore = CasEditorIdePlugin.getDefault().getPreferenceStore();
            boolean useLastTypesystem = prefStore.getBoolean("CAS_EDITOR_REMEMBER_TYPESYSTEM");
            if (typeSystemFileString == null && useLastTypesystem) {
                typeSystemFileString = this.documentToTypeSystemMap.get(document);
            }
            if (typeSystemFileString != null) {
                typeSystemFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(typeSystemFileString));
            }
            if (typeSystemFile == null || !typeSystemFile.exists()) {
                Map<Integer, ITypeSystemSearchStrategy> searchStrategies = TypeSystemSearchStrategyFactory.instance().getSearchStrategies();
                Collection<ITypeSystemSearchStrategy> values = searchStrategies.values();
                for (ITypeSystemSearchStrategy eachStrategy : values) {
                    IFile findTypeSystem = eachStrategy.findTypeSystem(casFile);
                    if (findTypeSystem == null || !findTypeSystem.exists()) continue;
                    typeSystemFile = findTypeSystem;
                    break;
                }
            }
            if (typeSystemFile == null) {
                typeSystemFile = TypeSystemLocationPropertyPage.getTypeSystemLocation(casFile.getProject());
            }
            if (typeSystemFile != null && typeSystemFile.exists()) {
                IFile prefFile;
                PreferenceStore tsPrefStore;
                if (!typeSystemFile.isSynchronized(0)) {
                    typeSystemFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                if ((tsPrefStore = this.typeSystemPreferences.get((prefFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getPreferenceFileForTypeSystem(typeSystemFile.getFullPath().toPortableString())))).getFullPath().toPortableString())) == null) {
                    if (prefFile.exists()) {
                        tsPrefStore = new PreferenceStore(prefFile.getName());
                        try {
                            tsPrefStore.load(prefFile.getContents());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        IFile styleFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getStyleFileForTypeSystem(typeSystemFile.getFullPath().toPortableString())));
                        if (styleFile.exists()) {
                            DotCorpus dotCorpus;
                            InputStream styleFileIn = null;
                            try {
                                styleFileIn = styleFile.getContents();
                                dotCorpus = DotCorpusSerializer.parseDotCorpus((InputStream)styleFileIn);
                            }
                            finally {
                                if (styleFileIn != null) {
                                    try {
                                        styleFileIn.close();
                                    }
                                    catch (IOException e) {
                                        CasEditorPlugin.log((Throwable)e);
                                    }
                                }
                            }
                            if (dotCorpus != null) {
                                tsPrefStore = new PreferenceStore(prefFile.getName());
                                for (AnnotationStyle style : dotCorpus.getAnnotationStyles()) {
                                    AnnotationStyle.putAnnotatationStyleToStore((IPreferenceStore)tsPrefStore, (AnnotationStyle)style);
                                }
                                for (String shownType : dotCorpus.getShownTypes()) {
                                    tsPrefStore.putValue(shownType + ".isShown", "true");
                                }
                                ByteArrayOutputStream prefOut = new ByteArrayOutputStream();
                                try {
                                    tsPrefStore.save((OutputStream)prefOut, "");
                                }
                                catch (IOException e) {
                                    CasEditorPlugin.log((Throwable)e);
                                }
                                prefFile.create((InputStream)new ByteArrayInputStream(prefOut.toByteArray()), 1, null);
                            }
                        }
                    }
                    if (tsPrefStore == null) {
                        tsPrefStore = new PreferenceStore(prefFile.getName());
                        CAS cas = DocumentUimaImpl.getVirginCAS((IFile)typeSystemFile);
                        TypeSystem ts = cas.getTypeSystem();
                        Collection<AnnotationStyle> defaultStyles = this.getConfiguredAnnotationStyles((IPreferenceStore)tsPrefStore, ts);
                        Collection newStyles = DefaultColors.assignColors((TypeSystem)ts, defaultStyles);
                        for (AnnotationStyle style : newStyles) {
                            AnnotationStyle.putAnnotatationStyleToStore((IPreferenceStore)tsPrefStore, (AnnotationStyle)style);
                        }
                    }
                    this.typeSystemPreferences.put(prefFile.getFullPath().toPortableString(), tsPrefStore);
                }
                this.documentToTypeSystemMap.put(document, typeSystemFile.getFullPath().toPortableString());
                IPreferenceStore store = this.sessionPreferenceStores.get(this.getTypesystemId(element));
                if (store == null) {
                    PreferenceStore newStore = new PreferenceStore();
                    this.sessionPreferenceStores.put(this.getTypesystemId(element), (IPreferenceStore)newStore);
                    newStore.addPropertyChangeListener((IPropertyChangeListener)new SaveSessionPreferencesTrigger(element));
                    String sessionPreferenceString = typeSystemFile.getPersistentProperty(new QualifiedName("", CAS_EDITOR_SESSION_PROPERTIES));
                    if (sessionPreferenceString != null) {
                        try {
                            newStore.load((InputStream)new ByteArrayInputStream(sessionPreferenceString.getBytes(StandardCharsets.UTF_8)));
                        }
                        catch (IOException e) {
                            CasEditorPlugin.log((Throwable)e);
                        }
                    }
                }
                CAS cas = DocumentUimaImpl.getVirginCAS((IFile)typeSystemFile);
                DocumentUimaImpl doc = new DocumentUimaImpl(cas, casFile, typeSystemFile.getFullPath().makeRelative().toString());
                this.elementErrorStatus.remove(element);
                return doc;
            }
            String message = typeSystemFile != null ? "Cannot find type system!\nPlease place a valid type system in this path:\n" + typeSystemFile.getFullPath().toString() : "Type system is not set, please choose a type system to open the CAS.";
            Status status = new Status(4, "org.apache.uima.dev", 12, message, null);
            this.elementErrorStatus.put(element, status);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSaveDocument(IProgressMonitor monitor, Object element, ICasDocument document, boolean overwrite) throws CoreException {
        if (element instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)element;
            IFile file = fileInput.getFile();
            if (document instanceof DocumentUimaImpl) {
                DocumentUimaImpl documentImpl = (DocumentUimaImpl)document;
                ByteArrayOutputStream outStream = new ByteArrayOutputStream(40000);
                documentImpl.serialize((OutputStream)outStream);
                ByteArrayInputStream stream = new ByteArrayInputStream(outStream.toByteArray());
                this.isFileChangeTrackingEnabled = false;
                try {
                    file.setContents((InputStream)stream, true, false, null);
                }
                finally {
                    this.isFileChangeTrackingEnabled = true;
                }
            }
        }
        this.fireElementDirtyStateChanged(element, false);
    }

    private String getTypesystemId(Object element) {
        if (element instanceof FileEditorInput) {
            FileEditorInput editorInput = (FileEditorInput)element;
            return this.documentToTypeSystemMap.get(editorInput.getFile().getFullPath().toPortableString());
        }
        return null;
    }

    public void saveTypeSystemPreferenceStore(Object element) {
        String prefereceFileId = this.getPreferenceFileForTypeSystem(this.getTypesystemId(element));
        PreferenceStore preferences = this.typeSystemPreferences.get(prefereceFileId);
        IFile preferenceFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString((String)prefereceFileId));
        ByteArrayOutputStream preferenceBytes = new ByteArrayOutputStream();
        try {
            preferences.save((OutputStream)preferenceBytes, "");
        }
        catch (IOException e) {
            CasEditorPlugin.log((Throwable)e);
        }
        try {
            if (preferenceFile.exists()) {
                preferenceFile.setContents((InputStream)new ByteArrayInputStream(preferenceBytes.toByteArray()), true, false, null);
            } else {
                preferenceFile.create((InputStream)new ByteArrayInputStream(preferenceBytes.toByteArray()), true, null);
            }
        }
        catch (CoreException e) {
            CasEditorPlugin.log((Throwable)e);
        }
    }

    public IPreferenceStore getTypeSystemPreferenceStore(Object element) {
        String tsId = this.getTypesystemId(element);
        if (tsId != null) {
            return (IPreferenceStore)this.typeSystemPreferences.get(this.getPreferenceFileForTypeSystem(tsId));
        }
        return null;
    }

    public IPreferenceStore getSessionPreferenceStore(Object element) {
        return this.sessionPreferenceStores.get(this.getTypesystemId(element));
    }

    void setTypeSystem(String document, String typeSystem) {
        this.documentToTypeSystemMap.put(document, typeSystem);
    }

    void setTypeSystemForNextDocumentOnly(String document, String typeSystem) {
        this.typeSystemForNextDocumentOnly.put(document, typeSystem);
    }

    public Composite createTypeSystemSelectorForm(final ICasEditor editor, Composite parent, IStatus status) {
        Composite provideTypeSystemForm = new Composite(parent, 0);
        provideTypeSystemForm.setLayout((Layout)new GridLayout(1, false));
        Label infoLabel = new Label(provideTypeSystemForm, 0);
        infoLabel.setText(status.getMessage());
        Button retryButton = new Button(provideTypeSystemForm, 0);
        retryButton.setText("Choose Type System ...");
        retryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource = WorkspaceResourceDialog.getWorkspaceResourceElement(Display.getCurrent().getActiveShell(), (IResource)ResourcesPlugin.getWorkspace().getRoot(), "Select a Type System", "Please select a Type System:");
                if (resource != null) {
                    FileEditorInput editorInput = (FileEditorInput)editor.getEditorInput();
                    DefaultCasDocumentProvider.this.setTypeSystemForNextDocumentOnly(editorInput.getFile().getFullPath().toPortableString(), resource.getFullPath().toString());
                    editor.reopenEditorWithNewTypeSystem();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                throw new IllegalStateException("Never be called!");
            }
        });
        return provideTypeSystemForm;
    }

    protected CasDocumentProvider.ElementInfo createElementInfo(Object element) {
        FileElementInfo info = new FileElementInfo(super.createElementInfo(element));
        info.deleteListener = new ModifyElementListener((FileEditorInput)element);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)info.deleteListener, 1);
        return info;
    }

    protected void disposeElementInfo(Object element, CasDocumentProvider.ElementInfo info) {
        FileElementInfo fileInfo = (FileElementInfo)info;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)fileInfo.deleteListener);
        super.disposeElementInfo(element, info);
    }

    private void handleElementDeleted(Object element) {
        this.fireElementDeleted(element);
    }

    private void handleElementChanged(Object element) {
        this.fireElementChanged(element);
    }

    private class SaveSessionPreferencesTrigger
    implements IPropertyChangeListener {
        private Object element;

        SaveSessionPreferencesTrigger(Object element) {
            this.element = element;
        }

        public void propertyChange(PropertyChangeEvent event) {
            IResource tsFile = ResourcesPlugin.getWorkspace().getRoot().findMember(DefaultCasDocumentProvider.this.getTypesystemId(this.element));
            PreferenceStore prefStore = (PreferenceStore)DefaultCasDocumentProvider.this.getSessionPreferenceStore(this.element);
            ByteArrayOutputStream prefBytes = new ByteArrayOutputStream();
            try {
                prefStore.save((OutputStream)prefBytes, "");
            }
            catch (IOException e) {
                CasEditorIdePlugin.log(e);
            }
            try {
                tsFile.setPersistentProperty(new QualifiedName("", DefaultCasDocumentProvider.CAS_EDITOR_SESSION_PROPERTIES), new String(prefBytes.toByteArray(), StandardCharsets.UTF_8));
            }
            catch (CoreException e) {
                CasEditorIdePlugin.log(e);
            }
        }
    }

    private static class FileElementInfo
    extends CasDocumentProvider.ElementInfo {
        private ModifyElementListener deleteListener;

        FileElementInfo(CasDocumentProvider.ElementInfo info) {
            super(info.element);
        }
    }

    private class ModifyElementListener
    implements IResourceChangeListener {
        private FileEditorInput fileInput;

        public ModifyElementListener(FileEditorInput fileInput) {
            this.fileInput = fileInput;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource;
                        if (delta.getFlags() != 131072 && delta.getResource().getType() == 1 && (resource = delta.getResource()).equals((Object)ModifyElementListener.this.fileInput.getFile())) {
                            if (delta.getKind() == 2) {
                                DefaultCasDocumentProvider.this.handleElementDeleted(ModifyElementListener.this.fileInput);
                            } else if (delta.getKind() == 4 && DefaultCasDocumentProvider.this.isFileChangeTrackingEnabled) {
                                DefaultCasDocumentProvider.this.handleElementChanged(ModifyElementListener.this.fileInput);
                            }
                        }
                        return true;
                    }
                };
                delta.accept(visitor);
            }
            catch (CoreException e) {
                CasEditorPlugin.log((Throwable)e);
            }
        }
    }
}

