/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class CastExpression
extends Expression {
    public CastExpression(AstType castToType, Expression expression) {
        super(expression.getOffset());
        this.setType(castToType);
        this.setExpression(expression);
    }

    public final AstType getType() {
        return this.getChildByRole(Roles.TYPE);
    }

    public final void setType(AstType type) {
        this.setChildByRole(Roles.TYPE, type);
    }

    public final JavaTokenNode getLeftParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    public final JavaTokenNode getRightParenthesisToken() {
        return this.getChildByRole(Roles.RIGHT_PARENTHESIS);
    }

    public final Expression getExpression() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setExpression(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitCastExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof CastExpression) {
            CastExpression otherCast = (CastExpression)other;
            return !otherCast.isNull() && this.getType().matches(otherCast.getType(), match) && this.getExpression().matches(otherCast.getExpression(), match);
        }
        return false;
    }
}

