/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.resource.PearSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.URISpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.taeconfigurator.TAEConfiguratorPlugin;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.FileAndShortName;
import org.apache.uima.taeconfigurator.editors.ui.FlowSection;
import org.apache.uima.taeconfigurator.editors.ui.SofaMapSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddRemoteServiceDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.FindComponentDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.PickTaeForTypesDialog;
import org.apache.uima.taeconfigurator.files.MultiResourceSelectionDialogWithFlowOption;
import org.apache.uima.taeconfigurator.model.FlowNodes;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.IManagedForm;

public class AggregateSection
extends AbstractSection {
    private Table filesTable;
    private Button addButton;
    private Button addRemoteButton;
    private Button findAnalysisEngineButton;
    private Button removeButton;
    private Button addToFlowButton;
    private Button removeFromFlowButton;
    private boolean bDisableToolTipHelp = false;
    private static final String REMOTE_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<uriSpecifier xmlns=\"http://uima.apache.org/resourceSpecifier\">\n  <resourceType>{0}</resourceType>\n  <uri>{1}</uri> \n  <protocol>{2}</protocol>\n  <timeout>{3}</timeout>  {4}\n</uriSpecifier>";
    private static final String REMOTE_JMS_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<customResourceSpecifier xmlns=\"http://uima.apache.org/resourceSpecifier\">\n  <resourceClassName>org.apache.uima.aae.jms_adapter.JmsAnalysisEngineServiceAdapter</resourceClassName>\n  <parameters>\n    <parameter name=\"brokerURL\" value=\"{0}\"/>\n    <parameter name=\"endpoint\"  value=\"{1}\"/>\n{2}  </parameters>\n</customResourceSpecifier>";
    private static final String[] delegateComponentStringHeadersLC = new String[]{"<analysisenginedescription", "<casconsumerdescription", "<taedescription"};

    public Button getRemoveFromFlowButton() {
        return this.removeFromFlowButton;
    }

    public AggregateSection(MultiPageEditor aEditor, Composite parent) {
        super(aEditor, parent, "Component Engines", "The following engines are included in this aggregate.");
    }

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        Composite sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        Composite tableContainer = this.newComposite(sectionClient);
        this.enableBorders(tableContainer);
        this.toolkit.paintBordersFor(tableContainer);
        this.filesTable = this.newTable(tableContainer, 65536, 150);
        this.filesTable.setHeaderVisible(true);
        this.newTableColumn(this.filesTable, 50, 16384, "Delegate");
        this.newTableColumn(this.filesTable, 75, 16384, "Key Name");
        Button tempForSize = this.toolkit.createButton(tableContainer, "Remove", 8);
        Point p = tempForSize.computeSize(-1, -1);
        tempForSize.dispose();
        Composite bottomButtonContainer = this.newButtonContainer(tableContainer, 2, 3 * p.x);
        this.addButton = this.newPushButton(bottomButtonContainer, "Add...", "Click here to add a locally defined AE or CAS Consumer delegate", true);
        this.removeButton = this.newPushButton(bottomButtonContainer, "Remove", "Click here to remove the selected item", true);
        Composite sideButtonContainer = this.newButtonContainer(sectionClient, 1, 80);
        AggregateSection.spacer(sideButtonContainer);
        AggregateSection.spacer(sideButtonContainer);
        this.addToFlowButton = this.newPushButton(sideButtonContainer, ">>", "Click here to add the selected item to the flow", false);
        this.removeFromFlowButton = this.newPushButton(sideButtonContainer, "<<", "Click here to remove the selected item from the flow", false);
        AggregateSection.spacer(sideButtonContainer);
        this.addRemoteButton = this.newPushButton(sideButtonContainer, "AddRemote", "Click here to add a Remote Analysis Engine", true);
        this.findAnalysisEngineButton = this.newPushButton(sideButtonContainer, "Find AE", "Click here to search for an Analysis Engine", true);
        this.addButton.setSize(this.removeButton.getSize());
        this.filesTable.addListener(3, (Listener)this);
        this.filesTable.addListener(32, (Listener)this);
    }

    public void refresh() {
        super.refresh();
        if (!this.isAggregate()) {
            this.filesTable.removeAll();
            this.getSection().setText("Not Used");
            this.getSection().setDescription("This section is only applicable for Aggregate descriptors.");
        } else {
            this.getSection().setText("Component Engines");
            this.getSection().setDescription("The following engines are included in this aggregate.");
            Map delegates = this.getDelegateAnalysisEngineSpecifiersWithImports();
            String[] priorOrderedKeys = new String[this.filesTable.getItemCount()];
            for (int i = 0; i < priorOrderedKeys.length; ++i) {
                priorOrderedKeys[i] = this.filesTable.getItem(i).getText(1);
            }
            this.filesTable.removeAll();
            HashSet keys = new HashSet();
            if (delegates != null) {
                keys.addAll(delegates.keySet());
            }
            for (int i = 0; i < priorOrderedKeys.length; ++i) {
                if (!keys.contains(priorOrderedKeys[i])) continue;
                Object o = delegates.get(priorOrderedKeys[i]);
                if (o instanceof Import) {
                    this.addFile(o, priorOrderedKeys[i]);
                }
                keys.remove(priorOrderedKeys[i]);
            }
            for (String key : keys) {
                Object o = delegates.get(key);
                if (!(o instanceof Import)) continue;
                this.addFile(o, key);
            }
            this.packTable(this.filesTable);
        }
        this.enable();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addButton) {
            this.handleAdd();
        } else if (event.widget == this.removeButton || event.type == 2 && event.character == '\u007f') {
            this.handleRemove();
        } else if (event.widget == this.addToFlowButton) {
            this.handleAddToFlow();
        } else if (event.widget == this.removeFromFlowButton) {
            this.handleRemoveFromFlow();
        } else if (event.widget == this.addRemoteButton) {
            this.handleAddRemote();
        } else if (event.widget == this.findAnalysisEngineButton) {
            this.handleFindAnalysisEngine();
        } else if (event.widget == this.filesTable) {
            if (event.type == 13) {
                boolean bEnableButtons = this.filesTable.getSelectionCount() > 0;
                this.removeButton.setEnabled(bEnableButtons);
                this.addToFlowButton.setEnabled(bEnableButtons);
            } else if (event.type == 3 && (event.button == 3 || event.button == 1 && 0 != (event.stateMask & 0x40000))) {
                this.handleTableContextMenuRequest(event);
            } else if (event.type == 32 && !this.bDisableToolTipHelp) {
                this.handleTableHoverHelp(event);
            }
        }
    }

    private void handleAdd() {
        MultiResourceSelectionDialogWithFlowOption dialog = new MultiResourceSelectionDialogWithFlowOption(this.getSection().getShell(), (IAdaptable)this.editor.getFile().getProject().getParent(), "Component Engine Selection", this.editor.getFile().getLocation(), this.editor);
        dialog.setTitle("Component Engine Selection");
        dialog.setMessage("Select one or more component engines from the workspace:");
        if (1 == dialog.open()) {
            return;
        }
        Object[] files = dialog.getResult();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                FileAndShortName fsn = new FileAndShortName(files[i]);
                this.produceKeyAddDelegate(fsn.shortName, fsn.fileName, dialog.getAutoAddToFlow(), dialog.isImportByName);
            }
        }
    }

    private void produceKeyAddDelegate(String shortName, String fullPathFileName, boolean addToFlow, boolean isImportByName) {
        boolean bSuccess = false;
        String keyName = this.produceUniqueComponentKey(shortName);
        if (null != keyName && (bSuccess = this.addDelegate(fullPathFileName, shortName, keyName, isImportByName))) {
            this.editor.addDirtyTypeName("<Aggregate>");
            this.refresh();
            if (addToFlow) {
                this.addNodeToFlow(keyName);
            }
        }
    }

    private void handleRemove() {
        boolean bOutputsChanged;
        int nSelectionIndex = this.filesTable.getSelectionIndex();
        String key = this.filesTable.getItem(nSelectionIndex).getText(1);
        if (this.editor.getAggregatePage().getFlowSection().containsNode(key)) {
            String sCascadeDeleteTitle = "Cascade delete warning";
            String sCascadeDeleteMessage = "This will cause a cascading deletion of an associated input, output, index, or type priority.  Ok to continue?";
            boolean bContinue = MessageDialog.openConfirm((Shell)this.getSection().getShell(), (String)sCascadeDeleteTitle, (String)sCascadeDeleteMessage);
            if (!bContinue) {
                return;
            }
        }
        ResourceSpecifier delegate = (ResourceSpecifier)this.editor.getResolvedDelegates().get(key);
        Map delegatesWithImport = this.editor.getAeDescription().getDelegateAnalysisEngineSpecifiersWithImports();
        Object savedDelegate1 = delegatesWithImport.get(key);
        delegatesWithImport.remove(key);
        Object savedDelegate2 = this.getDelegateAnalysisEngineSpecifiersWithImports().get(key);
        this.getDelegateAnalysisEngineSpecifiersWithImports().remove(key);
        FlowNodes flow = new FlowNodes(this.getAnalysisEngineMetaData().getFlowConstraints());
        String[] savedFlowNodes = flow.getFlow();
        if (null == savedFlowNodes) {
            savedFlowNodes = stringArray0;
        }
        ArrayList<String> nodes = new ArrayList<String>(savedFlowNodes.length);
        for (int i = 0; i < savedFlowNodes.length; ++i) {
            String flowNode = savedFlowNodes[i];
            if (flowNode.equals(key)) continue;
            nodes.add(flowNode);
        }
        flow.setFlow(nodes.toArray(stringArray0));
        if (!this.isValidAggregateChange()) {
            this.getDelegateAnalysisEngineSpecifiersWithImports().put(key, savedDelegate2);
            delegatesWithImport.put(key, savedDelegate1);
            flow.setFlow(savedFlowNodes);
            return;
        }
        Map typeNameHash = this.editor.allTypes.get();
        boolean bInputsChanged = !this.editor.validateInputs(typeNameHash);
        boolean bl = bOutputsChanged = !this.editor.validateOutputs(typeNameHash);
        if (bInputsChanged || bOutputsChanged) {
            Object msg = "Some of the following are no longer valid and have been deleted (or appropriately altered): \n\n";
            if (bInputsChanged) {
                msg = (String)msg + "Inputs \n";
            }
            if (bOutputsChanged) {
                msg = (String)msg + "Outputs \n";
            }
            Utility.popMessage("Capabilities Changed", (String)msg, 2);
        }
        SofaMapSection.removeSofaMappings(key, delegate, this.editor);
        this.editor.getAggregatePage().getFlowSection().refresh();
        if (this.filesTable.getItemCount() > nSelectionIndex) {
            this.filesTable.setSelection(nSelectionIndex);
            this.filesTable.setFocus();
            this.enable();
        }
        this.refresh();
        this.finishAggregateChangeAction();
    }

    private void handleAddToFlow() {
        String node = this.filesTable.getSelection()[0].getText(1);
        this.addNodeToFlow(node);
        this.getTable().setSelection(-1);
        this.enable();
        Table flowList = this.editor.getAggregatePage().getFlowSection().getFlowList();
        flowList.setSelection(flowList.getItemCount() - 1);
        this.editor.getAggregatePage().getFlowSection().enable();
        flowList.setFocus();
    }

    private void addNodeToFlow(String node) {
        FlowSection fs = this.editor.getAggregatePage().getFlowSection();
        fs.addNode(node);
    }

    private void handleRemoveFromFlow() {
        FlowSection fs = this.editor.getAggregatePage().getFlowSection();
        String selectedKey = fs.getFlowList().getSelection()[0].getText();
        fs.handleRemove();
        for (int i = 0; i < this.getTable().getItemCount(); ++i) {
            String thisKey = this.getTable().getItem(i).getText(1);
            if (!selectedKey.equals(thisKey)) continue;
            this.getTable().setSelection(i);
            this.enable();
            this.getTable().setFocus();
            break;
        }
    }

    private void handleAddRemote() {
        String sDescriptorPath = this.editor.getFile().getParent().getLocation().toString() + "/";
        AddRemoteServiceDialog dialog = new AddRemoteServiceDialog(this, sDescriptorPath);
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return;
        }
        String sServiceType = dialog.getSelectedServiceTypeName();
        if (!(sServiceType == null || sServiceType.equals("UIMA-AS JMS") || sServiceType.equals("SOAP") || sServiceType.equals("Vinci"))) {
            return;
        }
        String sURI = dialog.getSelectedUri();
        String sKey = dialog.getSelectedKey();
        if (!this.isNewKey(sKey)) {
            Utility.popMessage("Duplicate Key", "You have specified a duplicate key.  Please try again.", 1);
            return;
        }
        PrintWriter printWriter = this.setupToPrintFile(dialog.genFilePath);
        if (null != printWriter) {
            if (!sServiceType.equals("UIMA-AS JMS")) {
                Object vnsHostPort = "";
                if (dialog.vnsHost.length() > 0) {
                    vnsHostPort = MessageFormat.format("    <parameter name=\"VNS_HOST\" value=\"{0}\"/>\n", dialog.vnsHost);
                }
                if (dialog.vnsPort.length() > 0) {
                    vnsHostPort = (String)vnsHostPort + MessageFormat.format("    <parameter name=\"VNS_PORT\" value=\"{0}\"/>\n", dialog.vnsPort);
                }
                if (((String)vnsHostPort).length() > 0) {
                    vnsHostPort = "\n  <parameters>" + (String)vnsHostPort + "  </parameters>";
                }
                printWriter.println(MessageFormat.format(REMOTE_TEMPLATE, dialog.aeOrCc, sURI, sServiceType, dialog.timeout, vnsHostPort));
            } else {
                StringBuilder sb = new StringBuilder();
                this.addParam(sb, "timeout", dialog.timeout);
                this.addParam(sb, "getmetatimeout", dialog.getmetaTimeout);
                this.addParam(sb, "cpctimeout", dialog.cpcTimeout);
                this.addParam(sb, "binary_serialization", dialog.binary_serialization);
                this.addParam(sb, "ignore_process_errors", dialog.ignore_process_errors);
                printWriter.println(MessageFormat.format(REMOTE_JMS_TEMPLATE, sURI, dialog.endpoint, sb.toString()));
            }
            printWriter.close();
            boolean bSuccess = this.addDelegate(dialog.genFilePath, sKey, sKey, dialog.isImportByName);
            if (bSuccess) {
                boolean bAutoAddToFlow = dialog.getAutoAddToFlow();
                if (bAutoAddToFlow) {
                    this.addNodeToFlow(sKey);
                }
                this.refresh();
            }
        }
    }

    private StringBuilder addParam(StringBuilder sb, String name, String value) {
        if (value != null && value.length() > 0) {
            sb = sb.append("      <parameter name=\"").append(name).append("\" value=\"").append(value).append("\"/>\n");
        }
        return sb;
    }

    private void handleFindAnalysisEngine() {
        FindComponentDialog dialog1 = new FindComponentDialog(this, "Find an Analysis Engine (AE), CAS Consumer, or Remote Service Descriptor", "Specify a name pattern and/or additional constraints, and then push the Search button", delegateComponentStringHeadersLC);
        if (1 == dialog1.open()) {
            return;
        }
        List matchingDelegateComponentDescriptors = dialog1.getMatchingDelegateComponentDescriptors();
        List matchingDelegateComponentDescriptions = dialog1.getMatchingDelegateComponentDescriptions();
        if (matchingDelegateComponentDescriptors.size() == 0) {
            Utility.popMessage("No matching Delegate Components", "There are no Delegate Components matching your search criteria.", 1);
            return;
        }
        PickTaeForTypesDialog dialog2 = new PickTaeForTypesDialog(this, this.editor.getFile().getName(), matchingDelegateComponentDescriptors, matchingDelegateComponentDescriptions);
        if (1 == dialog2.open()) {
            return;
        }
        String[] selectedDelegateComponentDescriptors = dialog2.getSelectedDelegateComponentDescriptors();
        if (selectedDelegateComponentDescriptors == null || selectedDelegateComponentDescriptors.length == 0) {
            return;
        }
        for (int i = 0; i < selectedDelegateComponentDescriptors.length; ++i) {
            String fileName = selectedDelegateComponentDescriptors[i].replace('\\', '/');
            int nLastSlashLoc = fileName.lastIndexOf(47);
            String shortName = nLastSlashLoc == -1 ? fileName : fileName.substring(nLastSlashLoc + 1);
            this.produceKeyAddDelegate(shortName, this.editor.getFullPathFromDescriptorRelativePath(fileName), true, dialog2.isImportByName);
        }
        this.finishAggregateChangeAction();
    }

    private void handleTableContextMenuRequest(Event event) {
        TableItem item = this.filesTable.getItem(new Point(event.x, event.y));
        if (null == item) {
            return;
        }
        String thisKey = item.getText(1);
        Import imp = (Import)this.getDelegateAnalysisEngineSpecifiersWithImports().get(thisKey);
        this.bDisableToolTipHelp = true;
        this.requestPopUpOverImport(imp, (Control)this.filesTable, event);
        this.bDisableToolTipHelp = false;
    }

    private void handleTableHoverHelp(Event event) {
        Map dels;
        TableItem item = this.filesTable.getItem(new Point(event.x, event.y));
        String sDesc = "";
        if (null != item && null != (dels = this.editor.getResolvedDelegates())) {
            sDesc = this.getDescriptionForDescriptor(item.getText(0), (ResourceSpecifier)dels.get(item.getText(1)));
        }
        this.filesTable.setToolTipText(sDesc);
    }

    private boolean addDelegate(String fileName, String shortName, String keyName, boolean isImportByName) {
        Map delegatesWithImport = this.getDelegateAnalysisEngineSpecifiersWithImports();
        Import imp = this.createImport(fileName, isImportByName);
        XMLizable inputDescription = this.readImport(imp, fileName, isImportByName);
        if (null == inputDescription) {
            return false;
        }
        if (!(inputDescription instanceof AnalysisEngineDescription || inputDescription instanceof CasConsumerDescription || inputDescription instanceof URISpecifier || inputDescription instanceof PearSpecifier || this.isJmsDescriptor(inputDescription))) {
            Utility.popMessage("Invalid kind of descriptor", MessageFormat.format("Operation cancelled: The descriptor ''{0}'' being added is not an Analysis Engine or a CAS Consumer or a Remote Service.", AggregateSection.maybeShortenFileName(fileName)), 1);
            return false;
        }
        this.editor.getResolvedDelegates().put(keyName, inputDescription);
        delegatesWithImport.put(keyName, imp);
        if (!this.isValidAggregateChange()) {
            this.editor.getResolvedDelegates().remove(keyName);
            delegatesWithImport.remove(keyName);
            return false;
        }
        this.finishAggregateChangeAction();
        return true;
    }

    private boolean isNewKey(String keyName) {
        for (int i = 0; i < this.filesTable.getItemCount(); ++i) {
            if (!this.filesTable.getItem(i).getText(1).equals(keyName)) continue;
            return false;
        }
        return true;
    }

    public void addParametersForDelegate(AnalysisEngineDescription tae) {
        ConfigurationParameter[] candidateNewParams = tae.getAnalysisEngineMetaData().getConfigurationParameterDeclarations().getConfigurationParameters();
        NameValuePair[] candidateSettings = tae.getAnalysisEngineMetaData().getConfigurationParameterSettings().getParameterSettings();
        ConfigurationParameter[] oldParams = this.getAnalysisEngineMetaData().getConfigurationParameterDeclarations().getConfigurationParameters();
        NameValuePair[] oldSettings = this.getAnalysisEngineMetaData().getConfigurationParameterSettings().getParameterSettings();
        if (candidateNewParams == null || candidateNewParams.length == 0) {
            return;
        }
        if (oldParams == null || oldParams.length == 0) {
            this.getAnalysisEngineMetaData().getConfigurationParameterDeclarations().setConfigurationParameters(candidateNewParams);
            this.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterSettings(candidateSettings);
        } else {
            int i;
            int i2;
            Vector<ConfigurationParameter> newParams = new Vector<ConfigurationParameter>();
            for (int i3 = 0; i3 < candidateNewParams.length; ++i3) {
                boolean bNew = true;
                for (int j = 0; j < oldParams.length; ++j) {
                    if (!candidateNewParams[i3].getName().equals(oldParams[j].getName()) || !candidateNewParams[i3].getType().equals(oldParams[j].getType())) continue;
                    bNew = false;
                }
                if (!bNew) continue;
                newParams.add(candidateNewParams[i3]);
            }
            ConfigurationParameter[] newPlusOldParams = new ConfigurationParameter[oldParams.length + newParams.size()];
            for (i2 = 0; i2 < oldParams.length; ++i2) {
                newPlusOldParams[i2] = oldParams[i2];
            }
            for (i2 = 0; i2 < newParams.size(); ++i2) {
                newPlusOldParams[oldParams.length + i2] = (ConfigurationParameter)newParams.elementAt(i2);
            }
            this.getAnalysisEngineMetaData().getConfigurationParameterDeclarations().setConfigurationParameters(newPlusOldParams);
            Vector<NameValuePair> newSettings = new Vector<NameValuePair>();
            if (candidateSettings != null) {
                for (int i4 = 0; i4 < candidateSettings.length; ++i4) {
                    boolean bNew = true;
                    for (int j = 0; j < oldSettings.length; ++j) {
                        if (!candidateSettings[i4].getName().equals(oldSettings[j].getName())) continue;
                        bNew = false;
                    }
                    if (!bNew) continue;
                    newSettings.add(candidateSettings[i4]);
                }
            }
            NameValuePair[] newPlusOldSettings = new NameValuePair[oldSettings.length + newSettings.size()];
            for (i = 0; i < oldSettings.length; ++i) {
                newPlusOldSettings[i] = oldSettings[i];
            }
            for (i = 0; i < newSettings.size(); ++i) {
                newPlusOldSettings[oldSettings.length + i] = (NameValuePair)newSettings.elementAt(i);
            }
            this.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterSettings(newPlusOldSettings);
        }
    }

    @Override
    public void enable() {
        boolean isPrimitive = this.isPrimitive();
        boolean bEnable = this.filesTable.getSelectionIndex() > -1;
        this.addButton.setEnabled(!isPrimitive);
        this.addRemoteButton.setEnabled(!isPrimitive);
        this.findAnalysisEngineButton.setEnabled(!isPrimitive);
        this.removeButton.setEnabled(bEnable);
        this.addToFlowButton.setEnabled(bEnable);
    }

    private void addFile(Object o, String keyName) {
        Import impItem = (Import)o;
        String fileName = impItem.getLocation();
        if (null == fileName || 0 == fileName.length()) {
            fileName = impItem.getName();
        }
        TableItem item = new TableItem(this.filesTable, 0);
        item.setImage(TAEConfiguratorPlugin.getImage("annotator.gif"));
        item.setText(0, fileName);
        item.setText(1, keyName);
    }

    public Table getTable() {
        return this.filesTable;
    }
}

