/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.resource.metadata.AllowedValue;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class TypeSystemUtil {
    private static final String NAMESPACE_SEPARATOR_AS_STRING = ".";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TypeSystemDescription> loadTypeSystemDescriptionsFromClasspath(Class<?> aContext, String ... aLocations) {
        ResourceManager_impl resMgr = new ResourceManager_impl(aContext.getClassLoader());
        try {
            ArrayList<TypeSystemDescription> typeSystemDescriptions = new ArrayList<TypeSystemDescription>();
            for (String location : aLocations) {
                URL resource = aContext.getResource(location);
                if (resource == null) {
                    UIMAFramework.getLogger().error("Unable to locate type system description as a resource [{}]", location);
                    continue;
                }
                try {
                    TypeSystemDescription tsd = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(resource));
                    tsd.resolveImports(resMgr);
                    typeSystemDescriptions.add(tsd);
                }
                catch (IOException | InvalidXMLException e) {
                    UIMAFramework.getLogger().error("Error loading type system description [{}] from [{}]", new Object[]{location, resource, e});
                }
            }
            ArrayList<TypeSystemDescription> arrayList = typeSystemDescriptions;
            return arrayList;
        }
        finally {
            resMgr.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TypePriorities> loadTypePrioritiesFromClasspath(Class<?> aContext, String ... aLocations) {
        ResourceManager_impl resMgr = new ResourceManager_impl(aContext.getClassLoader());
        try {
            ArrayList<TypePriorities> typePriorities = new ArrayList<TypePriorities>();
            for (String location : aLocations) {
                URL resource = aContext.getResource(location);
                if (resource == null) {
                    UIMAFramework.getLogger().error("Unable to locate type priorities as a resource [{}]", location);
                    continue;
                }
                try {
                    TypePriorities tps = UIMAFramework.getXMLParser().parseTypePriorities(new XMLInputSource(resource));
                    tps.resolveImports(resMgr);
                    typePriorities.add(tps);
                }
                catch (IOException | InvalidXMLException e) {
                    UIMAFramework.getLogger().error("Error loading type priorities [{}] from [{}]", new Object[]{location, resource, e});
                }
            }
            ArrayList<TypePriorities> arrayList = typePriorities;
            return arrayList;
        }
        finally {
            resMgr.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FsIndexCollection> loadFsIndexCollectionsFromClasspath(Class<?> aContext, String ... aLocations) {
        ResourceManager_impl resMgr = new ResourceManager_impl(aContext.getClassLoader());
        try {
            ArrayList<FsIndexCollection> fsIndexCollections = new ArrayList<FsIndexCollection>();
            for (String location : aLocations) {
                URL resource = aContext.getResource(location);
                if (resource == null) {
                    UIMAFramework.getLogger().error("Unable to locate FS index collections as a resource [{}]", location);
                    continue;
                }
                try {
                    FsIndexCollection fsic = UIMAFramework.getXMLParser().parseFsIndexCollection(new XMLInputSource(resource));
                    fsic.resolveImports(resMgr);
                    fsIndexCollections.add(fsic);
                }
                catch (IOException | InvalidXMLException e) {
                    UIMAFramework.getLogger().error("Error loading FS index collections [{}] from [{}]", new Object[]{location, resource, e});
                }
            }
            ArrayList<FsIndexCollection> arrayList = fsIndexCollections;
            return arrayList;
        }
        finally {
            resMgr.destroy();
        }
    }

    public static TypeSystemDescription typeSystem2TypeSystemDescription(TypeSystem aTypeSystem) {
        ResourceSpecifierFactory fact = UIMAFramework.getResourceSpecifierFactory();
        TypeSystemDescription tsDesc = fact.createTypeSystemDescription();
        Iterator<Type> typeIter = aTypeSystem.getTypeIterator();
        ArrayList<TypeDescription> typeDescs = new ArrayList<TypeDescription>();
        while (typeIter.hasNext()) {
            Type type = typeIter.next();
            if (type.getName().startsWith("uima.cas") || type.getName().equals("uima.tcas.Annotation") || type.isArray()) continue;
            typeDescs.add(TypeSystemUtil.type2TypeDescription(type, aTypeSystem));
        }
        TypeDescription[] typeDescArr = new TypeDescription[typeDescs.size()];
        typeDescs.toArray(typeDescArr);
        tsDesc.setTypes(typeDescArr);
        return tsDesc;
    }

    public static TypeDescription type2TypeDescription(Type aType, TypeSystem aTypeSystem) {
        TypeDescription typeDesc = UIMAFramework.getResourceSpecifierFactory().createTypeDescription();
        typeDesc.setName(aType.getName());
        Type superType = aTypeSystem.getParent(aType);
        typeDesc.setSupertypeName(superType.getName());
        Type stringType = aTypeSystem.getType("uima.cas.String");
        if (aTypeSystem.subsumes(stringType, aType)) {
            String[] allowedValues = TypeSystemUtil.getAllowedValuesForType(aType, aTypeSystem);
            AllowedValue[] avObjs = new AllowedValue[allowedValues.length];
            for (int i = 0; i < allowedValues.length; ++i) {
                AllowedValue av = UIMAFramework.getResourceSpecifierFactory().createAllowedValue();
                av.setString(allowedValues[i]);
                avObjs[i] = av;
            }
            typeDesc.setAllowedValues(avObjs);
        } else {
            ArrayList<FeatureDescription> featDescs = new ArrayList<FeatureDescription>();
            for (Feature feat : aType.getFeatures()) {
                if (superType.getFeatures().contains(feat)) continue;
                featDescs.add(TypeSystemUtil.feature2FeatureDescription(feat));
            }
            FeatureDescription[] featDescArr = new FeatureDescription[featDescs.size()];
            featDescs.toArray(featDescArr);
            typeDesc.setFeatures(featDescArr);
        }
        return typeDesc;
    }

    public static FeatureDescription feature2FeatureDescription(Feature aFeature) {
        Type rangeType;
        FeatureDescription featDesc = UIMAFramework.getResourceSpecifierFactory().createFeatureDescription();
        featDesc.setName(aFeature.getShortName());
        if (aFeature.isMultipleReferencesAllowed()) {
            featDesc.setMultipleReferencesAllowed(true);
        }
        if ((rangeType = aFeature.getRange()).isArray() && !rangeType.getComponentType().isPrimitive()) {
            featDesc.setRangeTypeName("uima.cas.FSArray");
            String elementTypeName = rangeType.getComponentType().getName();
            if (!"uima.cas.TOP".equals(elementTypeName)) {
                featDesc.setElementType(elementTypeName);
            }
        } else {
            featDesc.setRangeTypeName(rangeType.getName());
        }
        return featDesc;
    }

    public static String[] getAllowedValuesForType(Type aType, TypeSystem aTypeSystem) {
        LowLevelTypeSystem lts = aTypeSystem.getLowLevelTypeSystem();
        return lts.ll_getStringSet(lts.ll_getCodeForType(aType));
    }

    public static boolean isFeatureName(String name) {
        return TypeSystemUtil.isIdentifier(name);
    }

    public static boolean isTypeName(String name) {
        StringTokenizer tok = new StringTokenizer(name, NAMESPACE_SEPARATOR_AS_STRING, true);
        while (tok.hasMoreTokens()) {
            if (!TypeSystemUtil.isIdentifier(tok.nextToken())) {
                return false;
            }
            if (!tok.hasMoreTokens() || tok.nextToken().equals(NAMESPACE_SEPARATOR_AS_STRING) && tok.hasMoreTokens()) continue;
            return false;
        }
        return true;
    }

    private static boolean isIdentifier(String s) {
        if (s == null) {
            return false;
        }
        int len = s.length();
        if (len == 0) {
            return false;
        }
        int pos = 0;
        if (!TypeSystemUtil.isIdentifierStart(s.charAt(pos))) {
            return false;
        }
        ++pos;
        while (pos < len) {
            if (!TypeSystemUtil.isIdentifierChar(s.charAt(pos))) {
                return false;
            }
            ++pos;
        }
        return true;
    }

    private static boolean isIdentifierStart(char c) {
        return Character.isLetter(c);
    }

    private static boolean isIdentifierChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }
}

