/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.privacy.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.EventInfo;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.ServerInfo;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.PrivacyService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.persistence.spi.aggregate.BaseAggregate;
import org.apache.unomi.persistence.spi.aggregate.TermsAggregate;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivacyServiceImpl
implements PrivacyService {
    private static final Logger logger = LoggerFactory.getLogger(PrivacyServiceImpl.class);
    private PersistenceService persistenceService;
    private ProfileService profileService;
    private EventService eventService;
    private BundleContext bundleContext;

    public PrivacyServiceImpl() {
        logger.info("Initializing privacy service...");
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ServerInfo getServerInfo() {
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setServerIdentifier("Apache Unomi");
        serverInfo.setServerVersion(this.bundleContext.getBundle().getVersion().toString());
        Map eventTypeCounts = this.persistenceService.aggregateWithOptimizedQuery(null, (BaseAggregate)new TermsAggregate("eventType"), "event");
        ArrayList<EventInfo> eventTypes = new ArrayList<EventInfo>();
        for (Map.Entry eventTypeEntry : eventTypeCounts.entrySet()) {
            EventInfo eventInfo = new EventInfo();
            eventInfo.setName((String)eventTypeEntry.getKey());
            eventInfo.setOccurences((Long)eventTypeEntry.getValue());
            eventTypes.add(eventInfo);
        }
        serverInfo.setEventTypes(eventTypes);
        serverInfo.setCapabilities(new HashMap());
        return serverInfo;
    }

    public Boolean deleteProfile(String profileId) {
        Profile profile = this.profileService.load(profileId);
        if (profile == null) {
            return false;
        }
        Event profileDeletedEvent = new Event("profileDeleted", null, profile, null, null, (Item)profile, new Date());
        profileDeletedEvent.setPersistent(true);
        this.eventService.send(profileDeletedEvent);
        Profile emptyProfile = new Profile(profileId);
        this.profileService.save(emptyProfile);
        return true;
    }

    public Boolean anonymizeProfile(String profileId, String scope) {
        Profile profile = this.profileService.load(profileId);
        if (profile == null) {
            return false;
        }
        Event anonymizeProfileEvent = new Event("anonymizeProfile", null, profile, scope, null, (Item)profile, new Date());
        anonymizeProfileEvent.setPersistent(true);
        this.eventService.send(anonymizeProfileEvent);
        boolean res = profile.getProperties().keySet().removeAll(this.getDeniedProperties(profile.getItemId()));
        Event profileUpdatedEvent = new Event("profileUpdated", null, profile, scope, null, (Item)profile, new Date());
        profileUpdatedEvent.setPersistent(false);
        this.eventService.send(profileUpdatedEvent);
        this.profileService.save(profile);
        return res;
    }

    public Boolean anonymizeBrowsingData(String profileId) {
        Profile profile = this.profileService.load(profileId);
        if (profile == null) {
            return false;
        }
        List sessions = this.profileService.getProfileSessions(profileId, null, 0, -1, null).getList();
        if (sessions.isEmpty()) {
            return false;
        }
        for (Session session : sessions) {
            Profile newProfile = this.getAnonymousProfile(session.getProfile());
            session.setProfile(newProfile);
            this.persistenceService.save((Item)session);
            List events = this.eventService.searchEvents(session.getItemId(), new String[0], null, 0, -1, null).getList();
            for (Event event : events) {
                this.persistenceService.update(event.getItemId(), event.getTimeStamp(), Event.class, "profileId", (Object)newProfile.getItemId());
            }
        }
        return true;
    }

    public Boolean deleteProfileData(String profileId, boolean purgeData) {
        if (purgeData) {
            this.eventService.removeProfileEvents(profileId);
            this.profileService.removeProfileSessions(profileId);
        } else {
            this.anonymizeBrowsingData(profileId);
        }
        this.profileService.delete(profileId, false);
        return true;
    }

    public Boolean setRequireAnonymousBrowsing(String profileId, boolean anonymous, String scope) {
        Profile profile = this.profileService.load(profileId);
        if (profile == null) {
            return false;
        }
        profile.getSystemProperties().put("requireAnonymousProfile", anonymous);
        if (anonymous) {
            profile.getSystemProperties().remove("goals");
            profile.getSystemProperties().remove("pastEvents");
        }
        Event profileUpdated = new Event("profileUpdated", null, profile, scope, null, (Item)profile, new Date());
        profileUpdated.setPersistent(false);
        this.eventService.send(profileUpdated);
        this.profileService.save(profile);
        return true;
    }

    public Boolean isRequireAnonymousBrowsing(String profileId) {
        Profile profile = this.profileService.load(profileId);
        return this.isRequireAnonymousBrowsing(profile);
    }

    public Boolean isRequireAnonymousBrowsing(Profile profile) {
        if (profile == null) {
            return false;
        }
        Boolean anonymous = (Boolean)profile.getSystemProperties().get("requireAnonymousProfile");
        return anonymous != null && anonymous != false;
    }

    public Profile getAnonymousProfile(Profile profile) {
        Profile anonymousProfile = new Profile();
        anonymousProfile.getSystemProperties().put("isAnonymousProfile", true);
        anonymousProfile.getProperties().putAll(profile.getProperties());
        anonymousProfile.getProperties().keySet().removeAll(this.getDeniedProperties(profile.getItemId()));
        return anonymousProfile;
    }

    public List<String> getFilteredEventTypes(String profileId) {
        Profile profile = this.profileService.load(profileId);
        return this.getFilteredEventTypes(profile);
    }

    public List<String> getFilteredEventTypes(Profile profile) {
        if (profile == null) {
            return new ArrayList<String>();
        }
        return (List)profile.getProperty("filteredEventTypes");
    }

    public Boolean setFilteredEventTypes(String profileId, List<String> eventTypes) {
        Profile profile = this.profileService.load(profileId);
        if (profile == null) {
            return null;
        }
        profile.setProperty("filteredEventTypes", eventTypes);
        this.profileService.save(profile);
        return true;
    }

    public List<String> getDeniedProperties(String profileId) {
        ArrayList<String> deniedProperties = new ArrayList<String>();
        Set personalIdsProps = this.profileService.getPropertyTypeBySystemTag("personalIdentifierProperties");
        personalIdsProps.forEach(propType -> deniedProperties.add(propType.getMetadata().getId()));
        return deniedProperties;
    }

    public Boolean setDeniedProperties(String profileId, List<String> propertyNames) {
        return null;
    }

    public List<String> getDeniedPropertyDistribution(String profileId) {
        return null;
    }

    public Boolean setDeniedPropertyDistribution(String profileId, List<String> propertyNames) {
        return null;
    }

    public Boolean removeProperty(String profileId, String propertyName) {
        Profile profile = this.profileService.load(profileId);
        if (profile == null) {
            return null;
        }
        if (!profile.getProperties().containsKey(propertyName)) {
            return false;
        }
        Object propertyValue = profile.getProperties().remove(propertyName);
        this.profileService.save(profile);
        return true;
    }
}

