/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.request.actions;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.Subdivision;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.plugins.request.useragent.UserAgent;
import org.apache.unomi.plugins.request.useragent.UserAgentDetectorServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetRemoteHostInfoAction
implements ActionExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)SetRemoteHostInfoAction.class.getName());
    private UserAgentDetectorServiceImpl userAgentDetectorService;
    private DatabaseReader databaseReader;
    private String pathToGeoLocationDatabase;
    private String defaultSessionCountryCode = "CH";
    private String defaultSessionCountryName = "Switzerland";
    private String defaultSessionCity = "Geneva";
    private int defaultSessionAdminSubDiv1 = 2660645;
    private int defaultSessionAdminSubDiv2 = 6458783;
    private String defaultSessionIsp = "Cablecom";
    private double defaultLatitude = 46.1884341;
    private double defaultLongitude = 6.1282508;

    public UserAgentDetectorServiceImpl getUserAgentDetectorService() {
        return this.userAgentDetectorService;
    }

    public void setUserAgentDetectorService(UserAgentDetectorServiceImpl userAgentDetectorService) {
        this.userAgentDetectorService = userAgentDetectorService;
    }

    public void setPathToGeoLocationDatabase(String pathToGeoLocationDatabase) {
        this.pathToGeoLocationDatabase = pathToGeoLocationDatabase;
    }

    public void setDefaultSessionCountryCode(String defaultSessionCountryCode) {
        this.defaultSessionCountryCode = defaultSessionCountryCode;
    }

    public void setDefaultSessionCountryName(String defaultSessionCountryName) {
        this.defaultSessionCountryName = defaultSessionCountryName;
    }

    public void setDefaultSessionCity(String defaultSessionCity) {
        this.defaultSessionCity = defaultSessionCity;
    }

    public void setDefaultSessionAdminSubDiv1(Integer defaultSessionAdminSubDiv1) {
        this.defaultSessionAdminSubDiv1 = defaultSessionAdminSubDiv1;
    }

    public void setDefaultSessionAdminSubDiv2(Integer defaultSessionAdminSubDiv2) {
        this.defaultSessionAdminSubDiv2 = defaultSessionAdminSubDiv2;
    }

    public void setDefaultSessionIsp(String defaultSessionIsp) {
        this.defaultSessionIsp = defaultSessionIsp;
    }

    public void setDefaultLatitude(double defaultLatitude) {
        this.defaultLatitude = defaultLatitude;
    }

    public void setDefaultLongitude(double defaultLongitude) {
        this.defaultLongitude = defaultLongitude;
    }

    public int execute(Action action, Event event) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)event.getAttributes().get("http_request");
        if (httpServletRequest == null) {
            return 0;
        }
        Session session = event.getSession();
        if (session == null) {
            return 0;
        }
        String remoteAddr = httpServletRequest.getRemoteAddr();
        if (logger.isDebugEnabled()) {
            logger.debug("Remote address is " + remoteAddr);
        }
        String remoteAddrParameter = httpServletRequest.getParameter("remoteAddr");
        if (logger.isDebugEnabled()) {
            logger.debug("Remote address param is " + remoteAddr);
        }
        String xff = httpServletRequest.getHeader("X-Forwarded-For");
        if (logger.isDebugEnabled()) {
            logger.debug("X-Forwarded-For is " + xff);
        }
        if (remoteAddrParameter != null && remoteAddrParameter.length() > 0) {
            remoteAddr = remoteAddrParameter;
        } else if (xff != null && !xff.equals("")) {
            if (xff.indexOf(44) > -1) {
                xff = xff.substring(0, xff.indexOf(44));
            }
            remoteAddr = xff;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Remote address used to localized is " + remoteAddr);
        }
        try {
            if (SetRemoteHostInfoAction.isAValidIPAddress(remoteAddr)) {
                this.ipLookupInDatabase(remoteAddr, session);
            } else {
                session.setProperty("sessionCountryCode", (Object)this.defaultSessionCountryCode);
                session.setProperty("sessionCountryName", (Object)this.defaultSessionCountryName);
                session.setProperty("sessionCity", (Object)this.defaultSessionCity);
                session.setProperty("sessionAdminSubDiv1", (Object)this.defaultSessionAdminSubDiv1);
                session.setProperty("sessionAdminSubDiv2", (Object)this.defaultSessionAdminSubDiv2);
                session.setProperty("sessionIsp", (Object)this.defaultSessionIsp);
                HashMap<String, Double> location = new HashMap<String, Double>();
                location.put("lat", this.defaultLatitude);
                location.put("lon", this.defaultLongitude);
                session.setProperty("location", location);
            }
            session.setProperty("countryAndCity", (Object)(session.getProperty("sessionCountryName") + "@@" + session.getProperty("sessionCity") + "@@" + session.getProperty("sessionAdminSubDiv1") + "@@" + session.getProperty("sessionAdminSubDiv2")));
        }
        catch (Exception e) {
            logger.error("Cannot lookup IP", (Throwable)e);
        }
        UserAgent agent = this.userAgentDetectorService.parseUserAgent(httpServletRequest.getHeader("User-Agent"));
        session.setProperty("operatingSystemFamily", (Object)agent.getOperatingSystemFamily());
        session.setProperty("operatingSystemName", (Object)agent.getOperatingSystemName());
        session.setProperty("userAgentName", (Object)agent.getUserAgentName());
        session.setProperty("userAgentVersion", (Object)agent.getUserAgentVersion());
        session.setProperty("userAgentNameAndVersion", (Object)agent.getUserAgentNameAndVersion());
        session.setProperty("deviceCategory", (Object)agent.getDeviceCategory());
        session.setProperty("deviceName", (Object)agent.getDeviceName());
        session.setProperty("deviceBrand", (Object)agent.getDeviceBrand());
        return 2;
    }

    @PostConstruct
    public void postConstruct() {
        if (this.pathToGeoLocationDatabase == null) {
            return;
        }
        File database = new File(this.pathToGeoLocationDatabase);
        if (!database.exists()) {
            return;
        }
        try {
            this.databaseReader = new DatabaseReader.Builder(database).build();
        }
        catch (IOException e) {
            logger.error("Cannot read IP database", (Throwable)e);
        }
    }

    private boolean ipLookupInDatabase(String remoteAddr, Session session) {
        if (this.databaseReader == null) {
            return false;
        }
        try {
            String isp;
            CityResponse cityResponse = this.databaseReader.city(InetAddress.getByName(remoteAddr));
            if (cityResponse.getCountry().getName() != null) {
                session.setProperty("sessionCountryCode", (Object)cityResponse.getCountry().getIsoCode());
                session.setProperty("sessionCountryName", (Object)cityResponse.getCountry().getName());
            }
            if (cityResponse.getCity().getName() != null) {
                session.setProperty("sessionCity", (Object)cityResponse.getCity().getName());
                session.setProperty("sessionCityId", (Object)cityResponse.getCity().getGeoNameId());
            }
            if (cityResponse.getSubdivisions().size() > 0) {
                session.setProperty("sessionAdminSubDiv1", (Object)((Subdivision)cityResponse.getSubdivisions().get(0)).getGeoNameId());
            }
            if (cityResponse.getSubdivisions().size() > 1) {
                session.setProperty("sessionAdminSubDiv2", (Object)((Subdivision)cityResponse.getSubdivisions().get(1)).getGeoNameId());
            }
            if ((isp = this.databaseReader.isp(InetAddress.getByName(remoteAddr)).getIsp()) != null) {
                session.setProperty("sessionIsp", (Object)isp);
            }
            HashMap<String, Double> locationMap = new HashMap<String, Double>();
            if (cityResponse.getLocation().getLatitude() != null && cityResponse.getLocation().getLongitude() != null) {
                locationMap.put("lat", cityResponse.getLocation().getLatitude());
                locationMap.put("lon", cityResponse.getLocation().getLongitude());
                session.setProperty("location", locationMap);
            }
            return true;
        }
        catch (GeoIp2Exception | IOException e) {
            logger.debug("Cannot resolve IP", e);
            return false;
        }
    }

    private static boolean isAValidIPAddress(String remoteAddr) {
        if (InetAddressUtils.isIPv4Address((String)remoteAddr) || InetAddressUtils.isIPv6Address((String)remoteAddr)) {
            InetAddress addr;
            try {
                addr = InetAddress.getByName(remoteAddr);
            }
            catch (UnknownHostException e) {
                logger.debug("Cannot resolve IP", (Throwable)e);
                return false;
            }
            if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
                return false;
            }
            try {
                return NetworkInterface.getByInetAddress(addr) == null;
            }
            catch (SocketException e) {
                return false;
            }
        }
        return false;
    }
}

