/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.log4j.Level;
import org.apache.lucene.search.TotalHits;
import org.apache.unomi.api.CustomItem;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.MetadataItem;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.DateRange;
import org.apache.unomi.api.query.NumericRange;
import org.apache.unomi.metrics.MetricAdapter;
import org.apache.unomi.metrics.MetricsService;
import org.apache.unomi.persistence.elasticsearch.ESCustomObjectMapper;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionContextHelper;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilderDispatcher;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionEvaluator;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionEvaluatorDispatcher;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.persistence.spi.aggregate.BaseAggregate;
import org.apache.unomi.persistence.spi.aggregate.DateAggregate;
import org.apache.unomi.persistence.spi.aggregate.DateRangeAggregate;
import org.apache.unomi.persistence.spi.aggregate.IpRangeAggregate;
import org.apache.unomi.persistence.spi.aggregate.NumericRangeAggregate;
import org.apache.unomi.persistence.spi.aggregate.TermsAggregate;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.CustomRestHighLevelClient;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.core.AcknowledgedResponse;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.client.core.MainResponse;
import org.elasticsearch.client.indexlifecycle.LifecycleAction;
import org.elasticsearch.client.indexlifecycle.LifecyclePolicy;
import org.elasticsearch.client.indexlifecycle.Phase;
import org.elasticsearch.client.indexlifecycle.PutLifecyclePolicyRequest;
import org.elasticsearch.client.indexlifecycle.RolloverAction;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.client.tasks.GetTaskRequest;
import org.elasticsearch.client.tasks.GetTaskResponse;
import org.elasticsearch.client.tasks.TaskSubmissionResponse;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.HasAggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.global.Global;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.missing.MissingAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.IpRangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.TaskId;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchPersistenceServiceImpl
implements PersistenceService,
SynchronousBundleListener {
    public static final String BULK_PROCESSOR_BULK_SIZE = "bulkProcessor.bulkSize";
    public static final String BULK_PROCESSOR_FLUSH_INTERVAL = "bulkProcessor.flushInterval";
    public static final String BULK_PROCESSOR_BACKOFF_POLICY = "bulkProcessor.backoffPolicy";
    public static final String SEQ_NO = "seq_no";
    public static final String PRIMARY_TERM = "primary_term";
    private static final Logger logger = LoggerFactory.getLogger((String)ElasticSearchPersistenceServiceImpl.class.getName());
    private static final String ROLLOVER_LIFECYCLE_NAME = "unomi-rollover-policy";
    private boolean throwExceptions = false;
    private CustomRestHighLevelClient client;
    private BulkProcessor bulkProcessor;
    private String elasticSearchAddresses;
    private List<String> elasticSearchAddressList = new ArrayList<String>();
    private String clusterName;
    private String indexPrefix;
    private String monthlyIndexNumberOfShards;
    private String monthlyIndexNumberOfReplicas;
    private String monthlyIndexMappingTotalFieldsLimit;
    private String monthlyIndexMaxDocValueFieldsSearch;
    private String numberOfShards;
    private String numberOfReplicas;
    private String indexMappingTotalFieldsLimit;
    private String indexMaxDocValueFieldsSearch;
    private String[] fatalIllegalStateErrors;
    private BundleContext bundleContext;
    private Map<String, String> mappings = new HashMap<String, String>();
    private ConditionEvaluatorDispatcher conditionEvaluatorDispatcher;
    private ConditionESQueryBuilderDispatcher conditionESQueryBuilderDispatcher;
    private List<String> itemsMonthlyIndexed;
    private Map<String, String> routingByType;
    private Integer defaultQueryLimit = 10;
    private Integer removeByQueryTimeoutInMinutes = 10;
    private Integer taskWaitingTimeout = 3600000;
    private Integer taskWaitingPollingInterval = 1000;
    private String bulkProcessorConcurrentRequests = "1";
    private String bulkProcessorBulkActions = "1000";
    private String bulkProcessorBulkSize = "5MB";
    private String bulkProcessorFlushInterval = "5s";
    private String bulkProcessorBackoffPolicy = "exponential";
    private String sessionLatestIndex;
    private List<String> rolloverIndices;
    private String rolloverMaxSize;
    private String rolloverMaxAge;
    private String rolloverMaxDocs;
    private String rolloverIndexNumberOfShards;
    private String rolloverIndexNumberOfReplicas;
    private String rolloverIndexMappingTotalFieldsLimit;
    private String rolloverIndexMaxDocValueFieldsSearch;
    private String minimalElasticSearchVersion = "7.0.0";
    private String maximalElasticSearchVersion = "8.0.0";
    private String username;
    private String password;
    private boolean sslEnable = false;
    private boolean sslTrustAllCertificates = false;
    private int aggregateQueryBucketSize = 5000;
    private MetricsService metricsService;
    private boolean useBatchingForSave = false;
    private boolean useBatchingForUpdate = true;
    private String logLevelRestClient = "ERROR";
    private boolean alwaysOverwrite = true;
    private boolean aggQueryThrowOnMissingDocs = false;
    private Integer aggQueryMaxResponseSizeHttp = null;
    private Integer clientSocketTimeout = null;
    private Map<String, WriteRequest.RefreshPolicy> itemTypeToRefreshPolicy = new HashMap<String, WriteRequest.RefreshPolicy>();
    private Map<String, Map<String, Map<String, Object>>> knownMappings = new HashMap<String, Map<String, Map<String, Object>>>();
    private static final Map<String, String> itemTypeIndexNameMap = new HashMap<String, String>();
    private static final Collection<String> systemItems = Arrays.asList("actionType", "campaign", "campaignevent", "goal", "userList", "propertyType", "scope", "conditionType", "rule", "scoring", "segment", "groovyAction", "topic", "patch", "jsonSchema", "importConfig", "exportConfig", "rulestats");

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setElasticSearchAddresses(String elasticSearchAddresses) {
        this.elasticSearchAddresses = elasticSearchAddresses;
        String[] elasticSearchAddressesArray = elasticSearchAddresses.split(",");
        this.elasticSearchAddressList.clear();
        for (String elasticSearchAddress : elasticSearchAddressesArray) {
            this.elasticSearchAddressList.add(elasticSearchAddress.trim());
        }
    }

    public void setItemTypeToRefreshPolicy(String itemTypeToRefreshPolicy) throws IOException {
        if (!itemTypeToRefreshPolicy.isEmpty()) {
            this.itemTypeToRefreshPolicy = (Map)new ObjectMapper().readValue(itemTypeToRefreshPolicy, (TypeReference)new TypeReference<HashMap<String, WriteRequest.RefreshPolicy>>(){});
        }
    }

    public void setFatalIllegalStateErrors(String fatalIllegalStateErrors) {
        this.fatalIllegalStateErrors = (String[])Arrays.stream(fatalIllegalStateErrors.split(",")).map(i -> i.trim()).filter(i -> !i.isEmpty()).toArray(String[]::new);
    }

    public void setAggQueryMaxResponseSizeHttp(String aggQueryMaxResponseSizeHttp) {
        if (StringUtils.isNumeric((CharSequence)aggQueryMaxResponseSizeHttp)) {
            this.aggQueryMaxResponseSizeHttp = Integer.parseInt(aggQueryMaxResponseSizeHttp);
        }
    }

    public void setIndexPrefix(String indexPrefix) {
        this.indexPrefix = indexPrefix;
    }

    @Deprecated
    public void setMonthlyIndexNumberOfShards(String monthlyIndexNumberOfShards) {
        this.monthlyIndexNumberOfShards = monthlyIndexNumberOfShards;
    }

    @Deprecated
    public void setMonthlyIndexNumberOfReplicas(String monthlyIndexNumberOfReplicas) {
        this.monthlyIndexNumberOfReplicas = monthlyIndexNumberOfReplicas;
    }

    @Deprecated
    public void setMonthlyIndexMappingTotalFieldsLimit(String monthlyIndexMappingTotalFieldsLimit) {
        this.monthlyIndexMappingTotalFieldsLimit = monthlyIndexMappingTotalFieldsLimit;
    }

    @Deprecated
    public void setMonthlyIndexMaxDocValueFieldsSearch(String monthlyIndexMaxDocValueFieldsSearch) {
        this.monthlyIndexMaxDocValueFieldsSearch = monthlyIndexMaxDocValueFieldsSearch;
    }

    @Deprecated
    public void setItemsMonthlyIndexedOverride(String itemsMonthlyIndexedOverride) {
        this.itemsMonthlyIndexed = StringUtils.isNotEmpty((CharSequence)itemsMonthlyIndexedOverride) ? Arrays.asList((String[])itemsMonthlyIndexedOverride.split(",").clone()) : Collections.emptyList();
    }

    public void setNumberOfShards(String numberOfShards) {
        this.numberOfShards = numberOfShards;
    }

    public void setNumberOfReplicas(String numberOfReplicas) {
        this.numberOfReplicas = numberOfReplicas;
    }

    public void setIndexMappingTotalFieldsLimit(String indexMappingTotalFieldsLimit) {
        this.indexMappingTotalFieldsLimit = indexMappingTotalFieldsLimit;
    }

    public void setIndexMaxDocValueFieldsSearch(String indexMaxDocValueFieldsSearch) {
        this.indexMaxDocValueFieldsSearch = indexMaxDocValueFieldsSearch;
    }

    public void setDefaultQueryLimit(Integer defaultQueryLimit) {
        this.defaultQueryLimit = defaultQueryLimit;
    }

    public void setRoutingByType(Map<String, String> routingByType) {
        this.routingByType = routingByType;
    }

    public void setConditionEvaluatorDispatcher(ConditionEvaluatorDispatcher conditionEvaluatorDispatcher) {
        this.conditionEvaluatorDispatcher = conditionEvaluatorDispatcher;
    }

    public void setConditionESQueryBuilderDispatcher(ConditionESQueryBuilderDispatcher conditionESQueryBuilderDispatcher) {
        this.conditionESQueryBuilderDispatcher = conditionESQueryBuilderDispatcher;
    }

    public void setBulkProcessorConcurrentRequests(String bulkProcessorConcurrentRequests) {
        this.bulkProcessorConcurrentRequests = bulkProcessorConcurrentRequests;
    }

    public void setBulkProcessorBulkActions(String bulkProcessorBulkActions) {
        this.bulkProcessorBulkActions = bulkProcessorBulkActions;
    }

    public void setBulkProcessorBulkSize(String bulkProcessorBulkSize) {
        this.bulkProcessorBulkSize = bulkProcessorBulkSize;
    }

    public void setBulkProcessorFlushInterval(String bulkProcessorFlushInterval) {
        this.bulkProcessorFlushInterval = bulkProcessorFlushInterval;
    }

    public void setBulkProcessorBackoffPolicy(String bulkProcessorBackoffPolicy) {
        this.bulkProcessorBackoffPolicy = bulkProcessorBackoffPolicy;
    }

    public void setRolloverIndices(String rolloverIndices) {
        this.rolloverIndices = StringUtils.isNotEmpty((CharSequence)rolloverIndices) ? Arrays.asList((String[])rolloverIndices.split(",").clone()) : null;
    }

    public void setRolloverMaxSize(String rolloverMaxSize) {
        this.rolloverMaxSize = rolloverMaxSize;
    }

    public void setRolloverMaxAge(String rolloverMaxAge) {
        this.rolloverMaxAge = rolloverMaxAge;
    }

    public void setRolloverMaxDocs(String rolloverMaxDocs) {
        this.rolloverMaxDocs = rolloverMaxDocs;
    }

    public void setRolloverIndexNumberOfShards(String rolloverIndexNumberOfShards) {
        this.rolloverIndexNumberOfShards = rolloverIndexNumberOfShards;
    }

    public void setRolloverIndexNumberOfReplicas(String rolloverIndexNumberOfReplicas) {
        this.rolloverIndexNumberOfReplicas = rolloverIndexNumberOfReplicas;
    }

    public void setRolloverIndexMappingTotalFieldsLimit(String rolloverIndexMappingTotalFieldsLimit) {
        this.rolloverIndexMappingTotalFieldsLimit = rolloverIndexMappingTotalFieldsLimit;
    }

    public void setRolloverIndexMaxDocValueFieldsSearch(String rolloverIndexMaxDocValueFieldsSearch) {
        this.rolloverIndexMaxDocValueFieldsSearch = rolloverIndexMaxDocValueFieldsSearch;
    }

    public void setMinimalElasticSearchVersion(String minimalElasticSearchVersion) {
        this.minimalElasticSearchVersion = minimalElasticSearchVersion;
    }

    public void setMaximalElasticSearchVersion(String maximalElasticSearchVersion) {
        this.maximalElasticSearchVersion = maximalElasticSearchVersion;
    }

    public void setAggregateQueryBucketSize(int aggregateQueryBucketSize) {
        this.aggregateQueryBucketSize = aggregateQueryBucketSize;
    }

    public void setClientSocketTimeout(String clientSocketTimeout) {
        if (StringUtils.isNumeric((CharSequence)clientSocketTimeout)) {
            this.clientSocketTimeout = Integer.parseInt(clientSocketTimeout);
        }
    }

    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public void setUseBatchingForSave(boolean useBatchingForSave) {
        this.useBatchingForSave = useBatchingForSave;
    }

    public void setUseBatchingForUpdate(boolean useBatchingForUpdate) {
        this.useBatchingForUpdate = useBatchingForUpdate;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSslEnable(boolean sslEnable) {
        this.sslEnable = sslEnable;
    }

    public void setSslTrustAllCertificates(boolean sslTrustAllCertificates) {
        this.sslTrustAllCertificates = sslTrustAllCertificates;
    }

    public void setAggQueryThrowOnMissingDocs(boolean aggQueryThrowOnMissingDocs) {
        this.aggQueryThrowOnMissingDocs = aggQueryThrowOnMissingDocs;
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }

    public void setAlwaysOverwrite(boolean alwaysOverwrite) {
        this.alwaysOverwrite = alwaysOverwrite;
    }

    public void setLogLevelRestClient(String logLevelRestClient) {
        this.logLevelRestClient = logLevelRestClient;
    }

    public void setTaskWaitingTimeout(String taskWaitingTimeout) {
        if (StringUtils.isNumeric((CharSequence)taskWaitingTimeout)) {
            this.taskWaitingTimeout = Integer.parseInt(taskWaitingTimeout);
        }
    }

    public void setTaskWaitingPollingInterval(String taskWaitingPollingInterval) {
        if (StringUtils.isNumeric((CharSequence)taskWaitingPollingInterval)) {
            this.taskWaitingPollingInterval = Integer.parseInt(taskWaitingPollingInterval);
        }
    }

    public void start() throws Exception {
        try {
            Level lvl = Level.toLevel((String)this.logLevelRestClient, (Level)Level.ERROR);
            org.apache.log4j.Logger.getLogger((String)"org.elasticsearch.client.RestClient").setLevel(lvl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        new InClassLoaderExecute<Object>(null, null, this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            public Object execute(Object ... args) throws Exception {
                ElasticSearchPersistenceServiceImpl.this.buildClient();
                MainResponse response = ElasticSearchPersistenceServiceImpl.this.client.info(RequestOptions.DEFAULT);
                MainResponse.Version version = response.getVersion();
                Version clusterVersion = Version.fromString(version.getNumber());
                Version minimalVersion = Version.fromString(ElasticSearchPersistenceServiceImpl.this.minimalElasticSearchVersion);
                Version maximalVersion = Version.fromString(ElasticSearchPersistenceServiceImpl.this.maximalElasticSearchVersion);
                if (clusterVersion.before(minimalVersion) || clusterVersion.equals(maximalVersion) || clusterVersion.after(maximalVersion)) {
                    throw new Exception("ElasticSearch version is not within [" + minimalVersion + "," + maximalVersion + "), aborting startup !");
                }
                ElasticSearchPersistenceServiceImpl.this.registerRolloverLifecyclePolicy();
                ElasticSearchPersistenceServiceImpl.this.loadPredefinedMappings(ElasticSearchPersistenceServiceImpl.this.bundleContext, false);
                ElasticSearchPersistenceServiceImpl.this.loadPainlessScripts(ElasticSearchPersistenceServiceImpl.this.bundleContext);
                for (Bundle existingBundle : ElasticSearchPersistenceServiceImpl.this.bundleContext.getBundles()) {
                    if (existingBundle.getBundleContext() == null) continue;
                    ElasticSearchPersistenceServiceImpl.this.loadPredefinedMappings(existingBundle.getBundleContext(), false);
                    ElasticSearchPersistenceServiceImpl.this.loadPainlessScripts(existingBundle.getBundleContext());
                }
                if (ElasticSearchPersistenceServiceImpl.this.client != null && ElasticSearchPersistenceServiceImpl.this.bulkProcessor == null) {
                    ElasticSearchPersistenceServiceImpl.this.bulkProcessor = ElasticSearchPersistenceServiceImpl.this.getBulkProcessor();
                }
                logger.info("Waiting for GREEN cluster status...");
                ElasticSearchPersistenceServiceImpl.this.client.cluster().health(new ClusterHealthRequest().waitForGreenStatus(), RequestOptions.DEFAULT);
                logger.info("Cluster status is GREEN");
                if (ElasticSearchPersistenceServiceImpl.this.isItemTypeRollingOver("session")) {
                    logger.info("Sessions are using rollover indices, loading latest session index available ...");
                    GetAliasesResponse sessionAliasResponse = ElasticSearchPersistenceServiceImpl.this.client.indices().getAlias(new GetAliasesRequest(ElasticSearchPersistenceServiceImpl.this.getIndex("session")), RequestOptions.DEFAULT);
                    Map<String, Set<AliasMetaData>> aliases = sessionAliasResponse.getAliases();
                    if (!aliases.isEmpty()) {
                        ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex = new TreeSet<String>(aliases.keySet()).last();
                        logger.info("Latest available session index found is: {}", (Object)ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex);
                    } else {
                        throw new IllegalStateException("No index found for sessions");
                    }
                }
                return true;
            }
        }.executeInClassLoader(new Object[0]);
        this.bundleContext.addBundleListener((BundleListener)this);
        logger.info(this.getClass().getName() + " service started successfully.");
    }

    private void buildClient() throws NoSuchFieldException, IllegalAccessException {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (String elasticSearchAddress : this.elasticSearchAddressList) {
            String[] elasticSearchAddressParts = elasticSearchAddress.split(":");
            String elasticSearchHostName = elasticSearchAddressParts[0];
            int elasticSearchPort = Integer.parseInt(elasticSearchAddressParts[1]);
            nodeList.add(new Node(new HttpHost(elasticSearchHostName, elasticSearchPort, this.sslEnable ? "https" : "http")));
        }
        RestClientBuilder clientBuilder = RestClient.builder(nodeList.toArray(new Node[nodeList.size()]));
        if (this.clientSocketTimeout != null) {
            clientBuilder.setRequestConfigCallback(requestConfigBuilder -> {
                requestConfigBuilder.setSocketTimeout(this.clientSocketTimeout.intValue());
                return requestConfigBuilder;
            });
        }
        clientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
            if (this.sslTrustAllCertificates) {
                try {
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    }}, new SecureRandom());
                    httpClientBuilder.setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    logger.error("Error creating SSL Context for trust all certificates", (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.username)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            return httpClientBuilder;
        });
        logger.info("Connecting to ElasticSearch persistence backend using cluster name " + this.clusterName + " and index prefix " + this.indexPrefix + "...");
        this.client = new CustomRestHighLevelClient(clientBuilder);
    }

    public BulkProcessor getBulkProcessor() {
        String backoffPolicyStr;
        int concurrentRequests;
        if (this.bulkProcessor != null) {
            return this.bulkProcessor;
        }
        BulkProcessor.Listener bulkProcessorListener = new BulkProcessor.Listener(){

            @Override
            public void beforeBulk(long executionId, BulkRequest request) {
                logger.debug("Before Bulk");
            }

            @Override
            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                logger.debug("After Bulk");
            }

            @Override
            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                logger.error("After Bulk (failure)", failure);
            }
        };
        BulkProcessor.Builder bulkProcessorBuilder = BulkProcessor.builder((request, bulkListener) -> this.client.bulkAsync((BulkRequest)request, RequestOptions.DEFAULT, (ActionListener<BulkResponse>)bulkListener), bulkProcessorListener);
        if (this.bulkProcessorConcurrentRequests != null && (concurrentRequests = Integer.parseInt(this.bulkProcessorConcurrentRequests)) > 1) {
            bulkProcessorBuilder.setConcurrentRequests(concurrentRequests);
        }
        if (this.bulkProcessorBulkActions != null) {
            int bulkActions = Integer.parseInt(this.bulkProcessorBulkActions);
            bulkProcessorBuilder.setBulkActions(bulkActions);
        }
        if (this.bulkProcessorBulkSize != null) {
            bulkProcessorBuilder.setBulkSize(ByteSizeValue.parseBytesSizeValue(this.bulkProcessorBulkSize, new ByteSizeValue(5L, ByteSizeUnit.MB), BULK_PROCESSOR_BULK_SIZE));
        }
        if (this.bulkProcessorFlushInterval != null) {
            bulkProcessorBuilder.setFlushInterval(TimeValue.parseTimeValue(this.bulkProcessorFlushInterval, null, BULK_PROCESSOR_FLUSH_INTERVAL));
        } else {
            bulkProcessorBuilder.setFlushInterval(new TimeValue(5L, TimeUnit.SECONDS));
        }
        if (this.bulkProcessorBackoffPolicy != null && (backoffPolicyStr = this.bulkProcessorBackoffPolicy) != null && backoffPolicyStr.length() > 0) {
            if ("nobackoff".equals(backoffPolicyStr = backoffPolicyStr.toLowerCase())) {
                bulkProcessorBuilder.setBackoffPolicy(BackoffPolicy.noBackoff());
            } else if (backoffPolicyStr.startsWith("constant(")) {
                int paramStartPos = backoffPolicyStr.indexOf("constant(" + "constant(".length());
                int paramEndPos = backoffPolicyStr.indexOf(")", paramStartPos);
                int paramSeparatorPos = backoffPolicyStr.indexOf(",", paramStartPos);
                TimeValue delay = TimeValue.parseTimeValue(backoffPolicyStr.substring(paramStartPos, paramSeparatorPos), new TimeValue(5L, TimeUnit.SECONDS), BULK_PROCESSOR_BACKOFF_POLICY);
                int maxNumberOfRetries = Integer.parseInt(backoffPolicyStr.substring(paramSeparatorPos + 1, paramEndPos));
                bulkProcessorBuilder.setBackoffPolicy(BackoffPolicy.constantBackoff(delay, maxNumberOfRetries));
            } else if (backoffPolicyStr.startsWith("exponential")) {
                if (!backoffPolicyStr.contains("(")) {
                    bulkProcessorBuilder.setBackoffPolicy(BackoffPolicy.exponentialBackoff());
                } else {
                    int paramStartPos = backoffPolicyStr.indexOf("exponential(" + "exponential(".length());
                    int paramEndPos = backoffPolicyStr.indexOf(")", paramStartPos);
                    int paramSeparatorPos = backoffPolicyStr.indexOf(",", paramStartPos);
                    TimeValue delay = TimeValue.parseTimeValue(backoffPolicyStr.substring(paramStartPos, paramSeparatorPos), new TimeValue(5L, TimeUnit.SECONDS), BULK_PROCESSOR_BACKOFF_POLICY);
                    int maxNumberOfRetries = Integer.parseInt(backoffPolicyStr.substring(paramSeparatorPos + 1, paramEndPos));
                    bulkProcessorBuilder.setBackoffPolicy(BackoffPolicy.exponentialBackoff(delay, maxNumberOfRetries));
                }
            }
        }
        this.bulkProcessor = bulkProcessorBuilder.build();
        return this.bulkProcessor;
    }

    public void stop() {
        new InClassLoaderExecute<Object>(null, null, this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Object execute(Object ... args) throws IOException {
                logger.info("Closing ElasticSearch persistence backend...");
                if (ElasticSearchPersistenceServiceImpl.this.bulkProcessor != null) {
                    try {
                        ElasticSearchPersistenceServiceImpl.this.bulkProcessor.awaitClose(2L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException e) {
                        logger.error("Error waiting for bulk operations to flush !", (Throwable)e);
                    }
                }
                if (ElasticSearchPersistenceServiceImpl.this.client != null) {
                    ElasticSearchPersistenceServiceImpl.this.client.close();
                }
                return null;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public void bindConditionEvaluator(ServiceReference<ConditionEvaluator> conditionEvaluatorServiceReference) {
        ConditionEvaluator conditionEvaluator = (ConditionEvaluator)this.bundleContext.getService(conditionEvaluatorServiceReference);
        this.conditionEvaluatorDispatcher.addEvaluator(conditionEvaluatorServiceReference.getProperty("conditionEvaluatorId").toString(), conditionEvaluator);
    }

    public void unbindConditionEvaluator(ServiceReference<ConditionEvaluator> conditionEvaluatorServiceReference) {
        if (conditionEvaluatorServiceReference == null) {
            return;
        }
        this.conditionEvaluatorDispatcher.removeEvaluator(conditionEvaluatorServiceReference.getProperty("conditionEvaluatorId").toString());
    }

    public void bindConditionESQueryBuilder(ServiceReference<ConditionESQueryBuilder> conditionESQueryBuilderServiceReference) {
        ConditionESQueryBuilder conditionESQueryBuilder = (ConditionESQueryBuilder)this.bundleContext.getService(conditionESQueryBuilderServiceReference);
        this.conditionESQueryBuilderDispatcher.addQueryBuilder(conditionESQueryBuilderServiceReference.getProperty("queryBuilderId").toString(), conditionESQueryBuilder);
    }

    public void unbindConditionESQueryBuilder(ServiceReference<ConditionESQueryBuilder> conditionESQueryBuilderServiceReference) {
        if (conditionESQueryBuilderServiceReference == null) {
            return;
        }
        this.conditionESQueryBuilderDispatcher.removeQueryBuilder(conditionESQueryBuilderServiceReference.getProperty("queryBuilderId").toString());
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 128: {
                this.loadPredefinedMappings(event.getBundle().getBundleContext(), true);
                this.loadPainlessScripts(event.getBundle().getBundleContext());
            }
        }
    }

    private void loadPredefinedMappings(BundleContext bundleContext, boolean forceUpdateMapping) {
        Enumeration predefinedMappings = bundleContext.getBundle().findEntries("META-INF/cxs/mappings", "*.json", true);
        if (predefinedMappings == null) {
            return;
        }
        while (predefinedMappings.hasMoreElements()) {
            URL predefinedMappingURL = (URL)predefinedMappings.nextElement();
            logger.info("Found mapping at " + predefinedMappingURL + ", loading... ");
            try {
                String path = predefinedMappingURL.getPath();
                String name = path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
                String mappingSource = this.loadMappingFile(predefinedMappingURL);
                this.mappings.put(name, mappingSource);
                if (this.createIndex(name)) continue;
                logger.info("Found index for type {}", (Object)name);
                if (!forceUpdateMapping) continue;
                logger.info("Updating mapping for {}", (Object)name);
                this.createMapping(name, mappingSource);
            }
            catch (Exception e) {
                logger.error("Error while loading mapping definition " + predefinedMappingURL, (Throwable)e);
            }
        }
    }

    private void loadPainlessScripts(BundleContext bundleContext) {
        Enumeration scriptsURL = bundleContext.getBundle().findEntries("META-INF/cxs/painless", "*.painless", true);
        if (scriptsURL == null) {
            return;
        }
        HashMap<String, String> scriptsById = new HashMap<String, String>();
        while (scriptsURL.hasMoreElements()) {
            URL scriptURL = (URL)scriptsURL.nextElement();
            logger.info("Found painless script at " + scriptURL + ", loading... ");
            try {
                InputStream in = scriptURL.openStream();
                try {
                    String script = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                    String scriptId = FilenameUtils.getBaseName((String)scriptURL.getPath());
                    scriptsById.put(scriptId, script);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (Exception e) {
                logger.error("Error while loading painless script " + scriptURL, (Throwable)e);
            }
        }
        this.storeScripts(scriptsById);
    }

    private String loadMappingFile(URL predefinedMappingURL) throws IOException {
        String l;
        BufferedReader reader = new BufferedReader(new InputStreamReader(predefinedMappingURL.openStream()));
        StringBuilder content = new StringBuilder();
        while ((l = reader.readLine()) != null) {
            content.append(l);
        }
        return content.toString();
    }

    public <T extends Item> List<T> getAllItems(Class<T> clazz) {
        return this.getAllItems(clazz, 0, -1, null).getList();
    }

    public long getAllItemsCount(String itemType) {
        return this.queryCount(QueryBuilders.matchAllQuery(), itemType);
    }

    public <T extends Item> PartialList<T> getAllItems(Class<T> clazz, int offset, int size, String sortBy) {
        return this.getAllItems(clazz, offset, size, sortBy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Item> PartialList<T> getAllItems(Class<T> clazz, int offset, int size, String sortBy, String scrollTimeValidity) {
        long startTime = System.currentTimeMillis();
        try {
            PartialList<T> partialList = this.query((QueryBuilder)QueryBuilders.matchAllQuery(), sortBy, clazz, offset, size, null, scrollTimeValidity);
            return partialList;
        }
        finally {
            if (this.metricsService != null && this.metricsService.isActivated()) {
                this.metricsService.updateTimer(this.getClass().getName() + ".getAllItems", startTime);
            }
        }
    }

    public <T extends Item> T load(String itemId, Class<T> clazz) {
        return this.load(itemId, clazz, null);
    }

    @Deprecated
    public <T extends Item> T load(String itemId, Date dateHint, Class<T> clazz) {
        return this.load(itemId, clazz, null);
    }

    @Deprecated
    public CustomItem loadCustomItem(String itemId, Date dateHint, String customItemType) {
        return this.load(itemId, CustomItem.class, customItemType);
    }

    public CustomItem loadCustomItem(String itemId, String customItemType) {
        return this.load(itemId, CustomItem.class, customItemType);
    }

    private <T extends Item> T load(final String itemId, final Class<T> clazz, final String customItemType) {
        if (StringUtils.isEmpty((CharSequence)itemId)) {
            return null;
        }
        return (T)((Item)new InClassLoaderExecute<T>(this.metricsService, this.getClass().getName() + ".loadItem", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected T execute(Object ... args) throws Exception {
                try {
                    boolean sessionSpecialDirectAccess;
                    String itemType = Item.getItemType((Class)clazz);
                    if (customItemType != null) {
                        itemType = customItemType;
                    }
                    final String documentId = ElasticSearchPersistenceServiceImpl.this.getDocumentIDForItemType(itemId, itemType);
                    boolean bl = sessionSpecialDirectAccess = ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex != null && "session".equals(itemType);
                    if (!sessionSpecialDirectAccess && ElasticSearchPersistenceServiceImpl.this.isItemTypeRollingOver(itemType)) {
                        return new MetricAdapter<T>(ElasticSearchPersistenceServiceImpl.this.metricsService, ".loadItemWithQuery"){

                            public T execute(Object ... args) throws Exception {
                                if (customItemType == null) {
                                    PartialList r = ElasticSearchPersistenceServiceImpl.this.query((QueryBuilder)QueryBuilders.idsQuery().addIds(documentId), null, clazz, 0, 1, null, null);
                                    if (r.size() > 0) {
                                        return (Item)r.get(0);
                                    }
                                } else {
                                    PartialList<CustomItem> r = ElasticSearchPersistenceServiceImpl.this.query((QueryBuilder)QueryBuilders.idsQuery().addIds(documentId), null, customItemType, 0, 1, null, null);
                                    if (r.size() > 0) {
                                        return (Item)r.get(0);
                                    }
                                }
                                return null;
                            }
                        }.execute(new Object[0]);
                    }
                    GetRequest getRequest = new GetRequest(sessionSpecialDirectAccess ? ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex : ElasticSearchPersistenceServiceImpl.this.getIndex(itemType), documentId);
                    GetResponse response = ElasticSearchPersistenceServiceImpl.this.client.get(getRequest, RequestOptions.DEFAULT);
                    if (response.isExists()) {
                        String sourceAsString = response.getSourceAsString();
                        Item value = (Item)ESCustomObjectMapper.getObjectMapper().readValue(sourceAsString, clazz);
                        ElasticSearchPersistenceServiceImpl.this.setMetadata(value, response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), response.getIndex());
                        return value;
                    }
                    return null;
                }
                catch (ElasticsearchStatusException ese) {
                    if (ese.status().equals((Object)RestStatus.NOT_FOUND)) {
                        return null;
                    }
                    throw new Exception("Error loading itemType=" + clazz.getName() + " customItemType=" + customItemType + " itemId=" + itemId, ese);
                }
                catch (IndexNotFoundException e) {
                    return null;
                }
                catch (Exception ex) {
                    throw new Exception("Error loading itemType=" + clazz.getName() + " customItemType=" + customItemType + " itemId=" + itemId, ex);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]));
    }

    private void setMetadata(Item item, String itemId, long version, long seqNo, long primaryTerm, String index) {
        if (!systemItems.contains(item.getItemType()) && item.getItemId() == null) {
            item.setItemId(itemId);
        }
        item.setVersion(Long.valueOf(version));
        item.setSystemMetadata(SEQ_NO, (Object)seqNo);
        item.setSystemMetadata(PRIMARY_TERM, (Object)primaryTerm);
        item.setSystemMetadata("index", (Object)index);
    }

    public boolean isConsistent(Item item) {
        return this.getRefreshPolicy(item.getItemType()) != WriteRequest.RefreshPolicy.NONE;
    }

    public boolean save(Item item) {
        return this.save(item, this.useBatchingForSave, this.alwaysOverwrite);
    }

    public boolean save(Item item, boolean useBatching) {
        return this.save(item, useBatching, this.alwaysOverwrite);
    }

    public boolean save(final Item item, Boolean useBatchingOption, Boolean alwaysOverwriteOption) {
        final boolean useBatching = useBatchingOption == null ? this.useBatchingForSave : useBatchingOption;
        final boolean alwaysOverwrite = alwaysOverwriteOption == null ? this.alwaysOverwrite : alwaysOverwriteOption;
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".saveItem", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                try {
                    String source = ESCustomObjectMapper.getObjectMapper().writeValueAsString((Object)item);
                    String itemType = item.getItemType();
                    if (item instanceof CustomItem) {
                        itemType = ((CustomItem)item).getCustomItemType();
                    }
                    String documentId = ElasticSearchPersistenceServiceImpl.this.getDocumentIDForItemType(item.getItemId(), itemType);
                    String index = item.getSystemMetadata("index") != null ? (String)item.getSystemMetadata("index") : ElasticSearchPersistenceServiceImpl.this.getIndex(itemType);
                    IndexRequest indexRequest = new IndexRequest(index);
                    indexRequest.id(documentId);
                    indexRequest.source(source, XContentType.JSON);
                    if (!alwaysOverwrite) {
                        Long seqNo = (Long)item.getSystemMetadata(ElasticSearchPersistenceServiceImpl.SEQ_NO);
                        Long primaryTerm = (Long)item.getSystemMetadata(ElasticSearchPersistenceServiceImpl.PRIMARY_TERM);
                        if (seqNo != null && primaryTerm != null) {
                            indexRequest.setIfSeqNo(seqNo);
                            indexRequest.setIfPrimaryTerm(primaryTerm);
                        } else {
                            indexRequest.opType(DocWriteRequest.OpType.CREATE);
                        }
                    }
                    if (ElasticSearchPersistenceServiceImpl.this.routingByType.containsKey(itemType)) {
                        indexRequest.routing(ElasticSearchPersistenceServiceImpl.this.routingByType.get(itemType));
                    }
                    try {
                        if (ElasticSearchPersistenceServiceImpl.this.bulkProcessor == null || !useBatching) {
                            indexRequest.setRefreshPolicy(ElasticSearchPersistenceServiceImpl.this.getRefreshPolicy(itemType));
                            IndexResponse response = ElasticSearchPersistenceServiceImpl.this.client.index(indexRequest, RequestOptions.DEFAULT);
                            String responseIndex = response.getIndex();
                            String itemId = response.getId();
                            ElasticSearchPersistenceServiceImpl.this.setMetadata(item, itemId, response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), responseIndex);
                            if ("session".equals(itemType) && ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex != null && response.getResult().equals(DocWriteResponse.Result.CREATED) && !responseIndex.equals(ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex)) {
                                ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex = responseIndex;
                            }
                        } else {
                            ElasticSearchPersistenceServiceImpl.this.bulkProcessor.add(indexRequest);
                        }
                        ElasticSearchPersistenceServiceImpl.this.logMetadataItemOperation("saved", item);
                    }
                    catch (IndexNotFoundException e) {
                        logger.error("Could not find index {}, could not register item type {} with id {} ", new Object[]{index, itemType, item.getItemId(), e});
                        return false;
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new Exception("Error saving item " + item, e);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean update(Item item, Date dateHint, Class clazz, String propertyName, Object propertyValue) {
        return this.update(item, clazz, propertyName, propertyValue);
    }

    public boolean update(Item item, Date dateHint, Class clazz, Map source) {
        return this.update(item, clazz, source);
    }

    public boolean update(Item item, Date dateHint, Class clazz, Map source, boolean alwaysOverwrite) {
        return this.update(item, clazz, source, alwaysOverwrite);
    }

    public boolean update(Item item, Class clazz, String propertyName, Object propertyValue) {
        return this.update(item, clazz, Collections.singletonMap(propertyName, propertyValue), this.alwaysOverwrite);
    }

    public boolean update(Item item, Class clazz, Map source) {
        return this.update(item, clazz, source, this.alwaysOverwrite);
    }

    public boolean update(final Item item, final Class clazz, final Map source, final boolean alwaysOverwrite) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".updateItem", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                try {
                    UpdateRequest updateRequest = ElasticSearchPersistenceServiceImpl.this.createUpdateRequest(clazz, item, source, alwaysOverwrite);
                    if (ElasticSearchPersistenceServiceImpl.this.bulkProcessor == null || !ElasticSearchPersistenceServiceImpl.this.useBatchingForUpdate) {
                        UpdateResponse response = ElasticSearchPersistenceServiceImpl.this.client.update(updateRequest, RequestOptions.DEFAULT);
                        ElasticSearchPersistenceServiceImpl.this.setMetadata(item, response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), response.getIndex());
                    } else {
                        ElasticSearchPersistenceServiceImpl.this.bulkProcessor.add(updateRequest);
                    }
                    ElasticSearchPersistenceServiceImpl.this.logMetadataItemOperation("updated", item);
                    return true;
                }
                catch (IndexNotFoundException e) {
                    throw new Exception("No index found for itemType=" + clazz.getName() + "itemId=" + item.getItemId(), e);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    private UpdateRequest createUpdateRequest(Class clazz, Item item, Map source, boolean alwaysOverwrite) {
        String itemType = Item.getItemType((Class)clazz);
        String documentId = this.getDocumentIDForItemType(item.getItemId(), itemType);
        String index = item.getSystemMetadata("index") != null ? (String)item.getSystemMetadata("index") : this.getIndex(itemType);
        UpdateRequest updateRequest = new UpdateRequest(index, documentId);
        updateRequest.doc(source);
        if (!alwaysOverwrite) {
            Long seqNo = (Long)item.getSystemMetadata(SEQ_NO);
            Long primaryTerm = (Long)item.getSystemMetadata(PRIMARY_TERM);
            if (seqNo != null && primaryTerm != null) {
                updateRequest.setIfSeqNo(seqNo);
                updateRequest.setIfPrimaryTerm(primaryTerm);
            }
        }
        return updateRequest;
    }

    public List<String> update(final Map<Item, Map> items, Date dateHint, final Class clazz) {
        if (items.isEmpty()) {
            return new ArrayList<String>();
        }
        List result = (List)new InClassLoaderExecute<List<String>>(this.metricsService, this.getClass().getName() + ".updateItems", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected List<String> execute(Object ... args) throws Exception {
                long batchRequestStartTime = System.currentTimeMillis();
                BulkRequest bulkRequest = new BulkRequest();
                items.forEach((item, source) -> {
                    UpdateRequest updateRequest = ElasticSearchPersistenceServiceImpl.this.createUpdateRequest(clazz, (Item)item, (Map)source, ElasticSearchPersistenceServiceImpl.this.alwaysOverwrite);
                    bulkRequest.add(updateRequest);
                });
                BulkResponse bulkResponse = ElasticSearchPersistenceServiceImpl.this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
                logger.debug("{} profiles updated with bulk segment in {}ms", (Object)bulkRequest.numberOfActions(), (Object)(System.currentTimeMillis() - batchRequestStartTime));
                ArrayList<String> failedItemsIds = new ArrayList<String>();
                if (bulkResponse.hasFailures()) {
                    Iterator<BulkItemResponse> iterator = bulkResponse.iterator();
                    iterator.forEachRemaining(bulkItemResponse -> failedItemsIds.add(bulkItemResponse.getId()));
                }
                return failedItemsIds;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        return result;
    }

    public boolean updateWithQueryAndScript(Date dateHint, Class<?> clazz, String[] scripts, Map<String, Object>[] scriptParams, Condition[] conditions) {
        return this.updateWithQueryAndScript(clazz, scripts, scriptParams, conditions);
    }

    public boolean updateWithQueryAndScript(Class<?> clazz, String[] scripts, Map<String, Object>[] scriptParams, Condition[] conditions) {
        Script[] builtScripts = new Script[scripts.length];
        for (int i = 0; i < scripts.length; ++i) {
            builtScripts[i] = new Script(ScriptType.INLINE, "painless", scripts[i], scriptParams[i]);
        }
        return this.updateWithQueryAndScript(new Class[]{clazz}, builtScripts, conditions, true);
    }

    public boolean updateWithQueryAndStoredScript(Date dateHint, Class<?> clazz, String[] scripts, Map<String, Object>[] scriptParams, Condition[] conditions) {
        return this.updateWithQueryAndStoredScript(new Class[]{clazz}, scripts, scriptParams, conditions, true);
    }

    public boolean updateWithQueryAndStoredScript(Class<?> clazz, String[] scripts, Map<String, Object>[] scriptParams, Condition[] conditions) {
        return this.updateWithQueryAndStoredScript(new Class[]{clazz}, scripts, scriptParams, conditions, true);
    }

    public boolean updateWithQueryAndStoredScript(Class<?>[] classes, String[] scripts, Map<String, Object>[] scriptParams, Condition[] conditions, boolean waitForComplete) {
        Script[] builtScripts = new Script[scripts.length];
        for (int i = 0; i < scripts.length; ++i) {
            builtScripts[i] = new Script(ScriptType.STORED, null, scripts[i], scriptParams[i]);
        }
        return this.updateWithQueryAndScript(classes, builtScripts, conditions, waitForComplete);
    }

    private boolean updateWithQueryAndScript(final Class<?>[] classes, final Script[] scripts, final Condition[] conditions, final boolean waitForComplete) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".updateWithQueryAndScript", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                CharSequence[] itemTypes = (String[])Arrays.stream(classes).map(Item::getItemType).toArray(String[]::new);
                String[] indices = (String[])Arrays.stream(itemTypes).map(itemType -> ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery((String)itemType)).toArray(String[]::new);
                try {
                    for (int i = 0; i < scripts.length; ++i) {
                        RefreshRequest refreshRequest = new RefreshRequest(indices);
                        ElasticSearchPersistenceServiceImpl.this.client.indices().refresh(refreshRequest, RequestOptions.DEFAULT);
                        QueryBuilder queryBuilder = ElasticSearchPersistenceServiceImpl.this.conditionESQueryBuilderDispatcher.buildFilter(conditions[i]);
                        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(indices);
                        updateByQueryRequest.setConflicts("proceed");
                        updateByQueryRequest.setMaxRetries(1000);
                        updateByQueryRequest.setSlices(2);
                        updateByQueryRequest.setScript(scripts[i]);
                        updateByQueryRequest.setQuery(ElasticSearchPersistenceServiceImpl.this.wrapWithItemsTypeQuery((String[])itemTypes, queryBuilder));
                        TaskSubmissionResponse taskResponse = ElasticSearchPersistenceServiceImpl.this.client.submitUpdateByQuery(updateByQueryRequest, RequestOptions.DEFAULT);
                        if (taskResponse == null) {
                            logger.error("update with query and script: no response returned for query: {}", (Object)queryBuilder);
                            continue;
                        }
                        if (waitForComplete) {
                            ElasticSearchPersistenceServiceImpl.this.waitForTaskComplete(updateByQueryRequest, taskResponse);
                            continue;
                        }
                        logger.debug("ES task started {}", (Object)taskResponse.getTask());
                    }
                    return true;
                }
                catch (IndexNotFoundException e) {
                    throw new Exception("No index found for itemTypes=" + String.join((CharSequence)",", itemTypes), e);
                }
                catch (ScriptException e) {
                    logger.error("Error in the update script : {}\n{}\n{}", new Object[]{e.getScript(), e.getDetailedMessage(), e.getScriptStack()});
                    throw new Exception("Error in the update script");
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    private void waitForTaskComplete(AbstractBulkByScrollRequest request, final TaskSubmissionResponse response) {
        if (logger.isDebugEnabled()) {
            logger.debug("Waiting task [{}]: [{}] using query: [{}], polling every {}ms with a timeout configured to {}ms", new Object[]{response.getTask(), request.toString(), request.getSearchRequest().source().query(), this.taskWaitingPollingInterval, this.taskWaitingTimeout});
        }
        final long start = System.currentTimeMillis();
        new InClassLoaderExecute<Void>(this.metricsService, this.getClass().getName() + ".waitForTask", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Void execute(Object ... args) throws Exception {
                block5: {
                    Optional<GetTaskResponse> getTaskResponseOptional;
                    TaskId taskId = new TaskId(response.getTask());
                    while ((getTaskResponseOptional = ElasticSearchPersistenceServiceImpl.this.client.tasks().get(new GetTaskRequest(taskId.getNodeId(), taskId.getId()), RequestOptions.DEFAULT)).isPresent()) {
                        GetTaskResponse getTaskResponse = getTaskResponseOptional.get();
                        if (getTaskResponse.isCompleted()) {
                            if (!logger.isDebugEnabled()) break block5;
                            long millis = getTaskResponse.getTaskInfo().getRunningTimeNanos() / 1000000L;
                            long seconds = millis / 1000L;
                            logger.debug("Waiting task [{}]: Finished in {} {}", new Object[]{taskId, seconds >= 1L ? seconds : millis, seconds >= 1L ? "seconds" : "milliseconds"});
                            break block5;
                        }
                        if (start + (long)ElasticSearchPersistenceServiceImpl.this.taskWaitingTimeout.intValue() < System.currentTimeMillis()) {
                            logger.error("Waiting task [{}]: Exceeded configured timeout ({}ms), aborting wait process", (Object)taskId, (Object)ElasticSearchPersistenceServiceImpl.this.taskWaitingTimeout);
                            break block5;
                        }
                        try {
                            Thread.sleep(ElasticSearchPersistenceServiceImpl.this.taskWaitingPollingInterval.intValue());
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IllegalStateException("Waiting task [{}]: interrupted");
                        }
                    }
                    logger.error("Waiting task [{}]: No task found", (Object)taskId);
                }
                return null;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public boolean storeScripts(final Map<String, String> scripts) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".storeScripts", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                boolean executedSuccessfully = true;
                for (Map.Entry script : scripts.entrySet()) {
                    PutStoredScriptRequest putStoredScriptRequest = new PutStoredScriptRequest();
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    builder.startObject();
                    builder.startObject("script");
                    builder.field("lang", "painless");
                    builder.field("source", (String)script.getValue());
                    builder.endObject();
                    builder.endObject();
                    putStoredScriptRequest.content(BytesReference.bytes(builder), XContentType.JSON);
                    putStoredScriptRequest.id((String)script.getKey());
                    org.elasticsearch.action.support.master.AcknowledgedResponse response = ElasticSearchPersistenceServiceImpl.this.client.putScript(putStoredScriptRequest, RequestOptions.DEFAULT);
                    executedSuccessfully &= response.isAcknowledged();
                    if (response.isAcknowledged()) {
                        logger.info("Successfully stored painless script: {}", script.getKey());
                        continue;
                    }
                    logger.error("Failed to store painless script: {}", script.getKey());
                }
                return executedSuccessfully;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean updateWithScript(Item item, Date dateHint, Class<?> clazz, String script, Map<String, Object> scriptParams) {
        return this.updateWithScript(item, clazz, script, scriptParams);
    }

    public boolean updateWithScript(final Item item, final Class<?> clazz, final String script, final Map<String, Object> scriptParams) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".updateWithScript", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                try {
                    String itemType = Item.getItemType((Class)clazz);
                    String index = ElasticSearchPersistenceServiceImpl.this.getIndex(itemType);
                    String documentId = ElasticSearchPersistenceServiceImpl.this.getDocumentIDForItemType(item.getItemId(), itemType);
                    Script actualScript = new Script(ScriptType.INLINE, "painless", script, scriptParams);
                    UpdateRequest updateRequest = new UpdateRequest(index, documentId);
                    Long seqNo = (Long)item.getSystemMetadata(ElasticSearchPersistenceServiceImpl.SEQ_NO);
                    Long primaryTerm = (Long)item.getSystemMetadata(ElasticSearchPersistenceServiceImpl.PRIMARY_TERM);
                    if (seqNo != null && primaryTerm != null) {
                        updateRequest.setIfSeqNo(seqNo);
                        updateRequest.setIfPrimaryTerm(primaryTerm);
                    }
                    updateRequest.script(actualScript);
                    if (ElasticSearchPersistenceServiceImpl.this.bulkProcessor == null) {
                        UpdateResponse response = ElasticSearchPersistenceServiceImpl.this.client.update(updateRequest, RequestOptions.DEFAULT);
                        ElasticSearchPersistenceServiceImpl.this.setMetadata(item, response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), response.getIndex());
                    } else {
                        ElasticSearchPersistenceServiceImpl.this.bulkProcessor.add(updateRequest);
                    }
                    return true;
                }
                catch (IndexNotFoundException e) {
                    throw new Exception("No index found for itemType=" + clazz.getName() + "itemId=" + item.getItemId(), e);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    public <T extends Item> boolean remove(String itemId, Class<T> clazz) {
        return this.remove(itemId, clazz, null);
    }

    public boolean removeCustomItem(String itemId, String customItemType) {
        return this.remove(itemId, CustomItem.class, customItemType);
    }

    private <T extends Item> boolean remove(final String itemId, final Class<T> clazz, final String customItemType) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".removeItem", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                try {
                    String itemType = Item.getItemType((Class)clazz);
                    if (customItemType != null) {
                        itemType = customItemType;
                    }
                    String documentId = ElasticSearchPersistenceServiceImpl.this.getDocumentIDForItemType(itemId, itemType);
                    String index = ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType);
                    DeleteRequest deleteRequest = new DeleteRequest(index, documentId);
                    ElasticSearchPersistenceServiceImpl.this.client.delete(deleteRequest, RequestOptions.DEFAULT);
                    if (MetadataItem.class.isAssignableFrom(clazz)) {
                        logger.info("Item of type {} with ID {} has been removed", (Object)(customItemType != null ? customItemType : clazz.getSimpleName()), (Object)itemId);
                    }
                    return true;
                }
                catch (Exception e) {
                    throw new Exception("Cannot remove", e);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    public <T extends Item> boolean removeByQuery(final Condition query, final Class<T> clazz) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".removeByQuery", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                QueryBuilder queryBuilder = ElasticSearchPersistenceServiceImpl.this.conditionESQueryBuilderDispatcher.getQueryBuilder(query);
                return ElasticSearchPersistenceServiceImpl.this.removeByQuery(queryBuilder, clazz);
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    public <T extends Item> boolean removeByQuery(QueryBuilder queryBuilder, Class<T> clazz) throws Exception {
        try {
            String itemType = Item.getItemType(clazz);
            logger.debug("Remove item of type {} using a query", (Object)itemType);
            DeleteByQueryRequest deleteByQueryRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(this.getIndexNameForQuery(itemType)).setQuery(this.wrapWithItemTypeQuery(itemType, queryBuilder)).setSlices(0)).setAbortOnVersionConflict(false)).setTimeout(TimeValue.timeValueMinutes(this.removeByQueryTimeoutInMinutes.intValue()));
            TaskSubmissionResponse taskResponse = this.client.submitDeleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            if (taskResponse == null) {
                logger.error("Remove by query: no response returned for query: {}", (Object)queryBuilder);
                return false;
            }
            this.waitForTaskComplete(deleteByQueryRequest, taskResponse);
            return true;
        }
        catch (Exception e) {
            throw new Exception("Cannot remove by query", e);
        }
    }

    public boolean indexTemplateExists(final String templateName) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".indexTemplateExists", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws IOException {
                IndexTemplatesExistRequest indexTemplatesExistRequest = new IndexTemplatesExistRequest(templateName);
                return ElasticSearchPersistenceServiceImpl.this.client.indices().existsTemplate(indexTemplatesExistRequest, RequestOptions.DEFAULT);
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean removeIndexTemplate(final String templateName) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".removeIndexTemplate", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws IOException {
                DeleteIndexTemplateRequest deleteIndexTemplateRequest = new DeleteIndexTemplateRequest(templateName);
                org.elasticsearch.action.support.master.AcknowledgedResponse deleteIndexTemplateResponse = ElasticSearchPersistenceServiceImpl.this.client.indices().deleteTemplate(deleteIndexTemplateRequest, RequestOptions.DEFAULT);
                return deleteIndexTemplateResponse.isAcknowledged();
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean registerRolloverLifecyclePolicy() {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".createMonthlyIndexLifecyclePolicy", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws IOException {
                HashMap<String, Phase> phases = new HashMap<String, Phase>();
                HashMap<String, LifecycleAction> hotActions = new HashMap<String, LifecycleAction>();
                Long maxDocs = StringUtils.isEmpty((CharSequence)ElasticSearchPersistenceServiceImpl.this.rolloverMaxDocs) ? null : Long.valueOf(Long.parseLong(ElasticSearchPersistenceServiceImpl.this.rolloverMaxDocs));
                hotActions.put("rollover", new RolloverAction(StringUtils.isEmpty((CharSequence)ElasticSearchPersistenceServiceImpl.this.rolloverMaxSize) ? null : ByteSizeValue.parseBytesSizeValue(ElasticSearchPersistenceServiceImpl.this.rolloverMaxSize, "rollover.maxSize"), StringUtils.isEmpty((CharSequence)ElasticSearchPersistenceServiceImpl.this.rolloverMaxAge) ? null : TimeValue.parseTimeValue(ElasticSearchPersistenceServiceImpl.this.rolloverMaxAge, null, "rollover.maxAge"), maxDocs));
                phases.put("hot", new Phase("hot", TimeValue.ZERO, hotActions));
                LifecyclePolicy policy = new LifecyclePolicy(ElasticSearchPersistenceServiceImpl.this.indexPrefix + "-unomi-rollover-policy", phases);
                PutLifecyclePolicyRequest request = new PutLifecyclePolicyRequest(policy);
                AcknowledgedResponse putLifecyclePolicy = ElasticSearchPersistenceServiceImpl.this.client.indexLifecycle().putLifecyclePolicy(request, RequestOptions.DEFAULT);
                return putLifecyclePolicy.isAcknowledged();
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean createIndex(final String itemType) {
        logger.debug("Create index {}", (Object)itemType);
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".createIndex", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws IOException {
                String index = ElasticSearchPersistenceServiceImpl.this.getIndex(itemType);
                GetIndexRequest getIndexRequest = new GetIndexRequest(index);
                boolean indexExists = ElasticSearchPersistenceServiceImpl.this.client.indices().exists(getIndexRequest, RequestOptions.DEFAULT);
                if (!indexExists) {
                    if (ElasticSearchPersistenceServiceImpl.this.isItemTypeRollingOver(itemType)) {
                        ElasticSearchPersistenceServiceImpl.this.internalCreateRolloverTemplate(itemType);
                        ElasticSearchPersistenceServiceImpl.this.internalCreateRolloverIndex(index);
                    } else {
                        ElasticSearchPersistenceServiceImpl.this.internalCreateIndex(index, ElasticSearchPersistenceServiceImpl.this.mappings.get(itemType));
                    }
                }
                return !indexExists;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean removeIndex(String itemType) {
        final String index = this.getIndex(itemType);
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".removeIndex", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws IOException {
                GetIndexRequest getIndexRequest = new GetIndexRequest(index);
                boolean indexExists = ElasticSearchPersistenceServiceImpl.this.client.indices().exists(getIndexRequest, RequestOptions.DEFAULT);
                if (indexExists) {
                    DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(index);
                    ElasticSearchPersistenceServiceImpl.this.client.indices().delete(deleteIndexRequest, RequestOptions.DEFAULT);
                }
                return indexExists;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    private void internalCreateRolloverTemplate(String itemName) throws IOException {
        String rolloverAlias = this.indexPrefix + "-" + itemName;
        PutIndexTemplateRequest putIndexTemplateRequest = new PutIndexTemplateRequest(rolloverAlias + "-rollover-template").patterns(Collections.singletonList(this.getRolloverIndexForQuery(itemName))).order(1).settings("{\n    \"index\" : {\n        \"number_of_shards\" : " + (String)StringUtils.defaultIfEmpty((CharSequence)this.rolloverIndexNumberOfShards, (CharSequence)this.monthlyIndexNumberOfShards) + ",\n        \"number_of_replicas\" : " + (String)StringUtils.defaultIfEmpty((CharSequence)this.rolloverIndexNumberOfReplicas, (CharSequence)this.monthlyIndexNumberOfReplicas) + ",\n        \"mapping.total_fields.limit\" : " + (String)StringUtils.defaultIfEmpty((CharSequence)this.rolloverIndexMappingTotalFieldsLimit, (CharSequence)this.monthlyIndexMappingTotalFieldsLimit) + ",\n        \"max_docvalue_fields_search\" : " + (String)StringUtils.defaultIfEmpty((CharSequence)this.rolloverIndexMaxDocValueFieldsSearch, (CharSequence)this.monthlyIndexMaxDocValueFieldsSearch) + ",\n        \"lifecycle.name\": \"" + this.indexPrefix + "-unomi-rollover-policy\",\n        \"lifecycle.rollover_alias\": \"" + rolloverAlias + "\"    },\n    \"analysis\": {\n      \"analyzer\": {\n        \"folding\": {\n          \"type\":\"custom\",\n          \"tokenizer\": \"keyword\",\n          \"filter\":  [ \"lowercase\", \"asciifolding\" ]\n        }\n      }\n    }\n}\n", XContentType.JSON);
        if (this.mappings.get(itemName) == null) {
            logger.warn("Couldn't find mapping for item {}, won't create monthly index template", (Object)itemName);
            return;
        }
        putIndexTemplateRequest.mapping(this.mappings.get(itemName), XContentType.JSON);
        this.client.indices().putTemplate(putIndexTemplateRequest, RequestOptions.DEFAULT);
    }

    private void internalCreateRolloverIndex(String indexName) throws IOException {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName + "-000001").alias(new Alias(indexName).writeIndex(true));
        CreateIndexResponse createIndexResponse = this.client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        logger.info("Index created: [{}], acknowledge: [{}], shards acknowledge: [{}]", new Object[]{createIndexResponse.index(), createIndexResponse.isAcknowledged(), createIndexResponse.isShardsAcknowledged()});
    }

    private void internalCreateIndex(String indexName, String mappingSource) throws IOException {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        createIndexRequest.settings("{\n    \"index\" : {\n        \"number_of_shards\" : " + this.numberOfShards + ",\n        \"number_of_replicas\" : " + this.numberOfReplicas + ",\n        \"mapping.total_fields.limit\" : " + this.indexMappingTotalFieldsLimit + ",\n        \"max_docvalue_fields_search\" : " + this.indexMaxDocValueFieldsSearch + "\n    },\n    \"analysis\": {\n      \"analyzer\": {\n        \"folding\": {\n          \"type\":\"custom\",\n          \"tokenizer\": \"keyword\",\n          \"filter\":  [ \"lowercase\", \"asciifolding\" ]\n        }\n      }\n    }\n}\n", XContentType.JSON);
        if (mappingSource != null) {
            createIndexRequest.mapping(mappingSource, XContentType.JSON);
        }
        CreateIndexResponse createIndexResponse = this.client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        logger.info("Index created: [{}], acknowledge: [{}], shards acknowledge: [{}]", new Object[]{createIndexResponse.index(), createIndexResponse.isAcknowledged(), createIndexResponse.isShardsAcknowledged()});
    }

    public void createMapping(String type, String source) {
        try {
            this.putMapping(source, this.getIndex(type));
        }
        catch (IOException ioe) {
            logger.error("Error while creating mapping for type " + type + " and source " + source, (Throwable)ioe);
        }
    }

    public void setPropertyMapping(PropertyType property, String itemType) {
        try {
            Map subMappings;
            Map subSubMappings;
            Map<String, Map<String, Object>> mappings = this.getPropertiesMapping(itemType);
            if (mappings == null) {
                mappings = new HashMap<String, Map<String, Object>>();
            }
            if ((subSubMappings = (Map)(subMappings = mappings.computeIfAbsent("properties", k -> new HashMap())).computeIfAbsent("properties", k -> new HashMap())).containsKey(property.getItemId())) {
                logger.warn("Mapping already exists for type " + itemType + " and property " + property.getItemId());
                return;
            }
            Map<String, Object> propertyMapping = this.createPropertyMapping(property);
            if (propertyMapping.isEmpty()) {
                return;
            }
            this.mergePropertiesMapping(subSubMappings, propertyMapping);
            HashMap<String, Map<String, Map<String, Object>>> mappingsWrapper = new HashMap<String, Map<String, Map<String, Object>>>();
            mappingsWrapper.put("properties", mappings);
            String mappingsSource = ESCustomObjectMapper.getObjectMapper().writeValueAsString(mappingsWrapper);
            this.putMapping(mappingsSource, this.getIndex(itemType));
        }
        catch (IOException ioe) {
            logger.error("Error while creating mapping for type " + itemType + " and property " + property.getValueTypeId(), (Throwable)ioe);
        }
    }

    private Map<String, Object> createPropertyMapping(PropertyType property) {
        String esType = this.convertValueTypeToESType(property.getValueTypeId());
        HashMap<String, Object> definition = new HashMap<String, Object>();
        if (esType == null) {
            logger.warn("No predefined type found for property[{}], no mapping will be created", (Object)property.getValueTypeId());
            return Collections.emptyMap();
        }
        definition.put("type", esType);
        if ("text".equals(esType)) {
            definition.put("analyzer", "folding");
            HashMap fields = new HashMap();
            HashMap<String, Object> keywordField = new HashMap<String, Object>();
            keywordField.put("type", "keyword");
            keywordField.put("ignore_above", 256);
            fields.put("keyword", keywordField);
            definition.put("fields", fields);
        }
        if ("set".equals(property.getValueTypeId())) {
            HashMap childProperties = new HashMap();
            property.getChildPropertyTypes().forEach(childType -> {
                Map<String, Object> propertyMapping = this.createPropertyMapping((PropertyType)childType);
                if (!propertyMapping.isEmpty()) {
                    this.mergePropertiesMapping(childProperties, propertyMapping);
                }
            });
            definition.put("properties", childProperties);
        }
        return Collections.singletonMap(property.getItemId(), definition);
    }

    private String convertValueTypeToESType(String valueTypeId) {
        switch (valueTypeId) {
            case "set": 
            case "json": {
                return "object";
            }
            case "boolean": {
                return "boolean";
            }
            case "geopoint": {
                return "geo_point";
            }
            case "integer": {
                return "integer";
            }
            case "long": {
                return "long";
            }
            case "float": {
                return "float";
            }
            case "date": {
                return "date";
            }
            case "string": 
            case "id": 
            case "email": {
                return "text";
            }
        }
        return null;
    }

    private boolean putMapping(final String source, final String indexName) throws IOException {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".putMapping", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                try {
                    PutMappingRequest putMappingRequest = new PutMappingRequest(indexName);
                    putMappingRequest.source(source, XContentType.JSON);
                    org.elasticsearch.action.support.master.AcknowledgedResponse response = ElasticSearchPersistenceServiceImpl.this.client.indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
                    return response.isAcknowledged();
                }
                catch (Exception e) {
                    throw new Exception("Cannot create/update mapping", e);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    public Map<String, Map<String, Object>> getPropertiesMapping(final String itemType) {
        return (Map)new InClassLoaderExecute<Map<String, Map<String, Object>>>(this.metricsService, this.getClass().getName() + ".getPropertiesMapping", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Map<String, Map<String, Object>> execute(Object ... args) throws Exception {
                GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
                getMappingsRequest.indices(ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType));
                GetMappingsResponse getMappingsResponse = ElasticSearchPersistenceServiceImpl.this.client.indices().getMapping(getMappingsRequest, RequestOptions.DEFAULT);
                Map<String, MappingMetaData> mappings = getMappingsResponse.mappings();
                TreeSet<String> orderedKeys = new TreeSet<String>(mappings.keySet());
                HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
                try {
                    for (String key : orderedKeys) {
                        if (!mappings.containsKey(key)) continue;
                        Map properties = (Map)mappings.get(key).getSourceAsMap().get("properties");
                        for (Map.Entry entry : properties.entrySet()) {
                            if (result.containsKey(entry.getKey())) {
                                Map subResult = (Map)result.get(entry.getKey());
                                for (Map.Entry subentry : ((Map)entry.getValue()).entrySet()) {
                                    if (subResult.containsKey(subentry.getKey()) && subResult.get(subentry.getKey()) instanceof Map && subentry.getValue() instanceof Map) {
                                        ElasticSearchPersistenceServiceImpl.this.mergePropertiesMapping((Map)subResult.get(subentry.getKey()), (Map)subentry.getValue());
                                        continue;
                                    }
                                    subResult.put((String)subentry.getKey(), subentry.getValue());
                                }
                                continue;
                            }
                            result.put((String)entry.getKey(), (Map)entry.getValue());
                        }
                    }
                }
                catch (Throwable t) {
                    throw new Exception("Cannot get mapping for itemType=" + itemType, t);
                }
                return result;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    private void mergePropertiesMapping(Map<String, Object> result, Map<String, Object> entry) {
        if (entry == null || entry.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> subentry : entry.entrySet()) {
            if (result.containsKey(subentry.getKey()) && result.get(subentry.getKey()) instanceof Map && subentry.getValue() instanceof Map) {
                this.mergePropertiesMapping((Map)result.get(subentry.getKey()), (Map)subentry.getValue());
                continue;
            }
            result.put(subentry.getKey(), subentry.getValue());
        }
    }

    public Map<String, Object> getPropertyMapping(String property, String itemType) {
        Map<String, Map<String, Object>> mappings = this.knownMappings.get(itemType);
        Map<String, Object> result = this.getPropertyMapping(property, mappings);
        if (result == null) {
            mappings = this.getPropertiesMapping(itemType);
            this.knownMappings.put(itemType, mappings);
            result = this.getPropertyMapping(property, mappings);
        }
        return result;
    }

    private Map<String, Object> getPropertyMapping(String property, Map<String, Map<String, Object>> mappings) {
        Map<String, Object> propMapping = null;
        String[] properties = StringUtils.split((String)property, (char)'.');
        for (int i = 0; i < properties.length && mappings != null; ++i) {
            String s = properties[i];
            propMapping = mappings.get(s);
            if (i == properties.length - 1) {
                return propMapping;
            }
            mappings = propMapping != null ? (Map)propMapping.get("properties") : null;
        }
        return null;
    }

    private String getPropertyNameWithData(String name, String itemType) {
        Map<String, Object> propertyMapping = this.getPropertyMapping((String)name, itemType);
        if (propertyMapping == null) {
            return null;
        }
        if (propertyMapping != null && "text".equals(propertyMapping.get("type")) && propertyMapping.containsKey("fields") && ((Map)propertyMapping.get("fields")).containsKey("keyword")) {
            name = (String)name + ".keyword";
        }
        return name;
    }

    public boolean saveQuery(final String queryName, final String query) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".saveQuery", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                try {
                    logger.info("Saving query : " + queryName);
                    String index = ElasticSearchPersistenceServiceImpl.this.getIndex(".percolator");
                    IndexRequest indexRequest = new IndexRequest(index);
                    indexRequest.id(queryName);
                    indexRequest.source(query, XContentType.JSON);
                    indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    ElasticSearchPersistenceServiceImpl.this.client.index(indexRequest, RequestOptions.DEFAULT);
                    return true;
                }
                catch (Exception e) {
                    throw new Exception("Cannot save query", e);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean saveQuery(String queryName, Condition query) {
        if (query == null) {
            return false;
        }
        this.saveQuery(queryName, this.conditionESQueryBuilderDispatcher.getQuery(query));
        return true;
    }

    public boolean removeQuery(String queryName) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".removeQuery", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                try {
                    String index = ElasticSearchPersistenceServiceImpl.this.getIndex(".percolator");
                    DeleteRequest deleteRequest = new DeleteRequest(index);
                    deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    ElasticSearchPersistenceServiceImpl.this.client.delete(deleteRequest, RequestOptions.DEFAULT);
                    return true;
                }
                catch (Exception e) {
                    throw new Exception("Cannot delete query", e);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean isValidCondition(Condition condition, Item item) {
        try {
            this.conditionEvaluatorDispatcher.eval(condition, item);
            QueryBuilders.boolQuery().must(QueryBuilders.idsQuery().addIds(item.getItemId())).must(this.conditionESQueryBuilderDispatcher.buildFilter(condition));
        }
        catch (Exception e) {
            logger.error("Failed to validate condition. See debug log level for more information");
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to validate condition, condition={}", (Object)condition, (Object)e);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testMatch(Condition query, Item item) {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = this.conditionEvaluatorDispatcher.eval(query, item);
            return bl;
        }
        catch (UnsupportedOperationException e) {
            logger.error("Eval not supported, continue with query", (Throwable)e);
        }
        finally {
            if (this.metricsService != null && this.metricsService.isActivated()) {
                this.metricsService.updateTimer(this.getClass().getName() + ".testMatchLocally", startTime);
            }
        }
        startTime = System.currentTimeMillis();
        try {
            Class<?> clazz = item.getClass();
            String itemType = Item.getItemType(clazz);
            String documentId = this.getDocumentIDForItemType(item.getItemId(), itemType);
            BoolQueryBuilder builder = QueryBuilders.boolQuery().must(QueryBuilders.idsQuery().addIds(documentId)).must(this.conditionESQueryBuilderDispatcher.buildFilter(query));
            boolean bl = this.queryCount(builder, itemType) > 0L;
            return bl;
        }
        finally {
            if (this.metricsService != null && this.metricsService.isActivated()) {
                this.metricsService.updateTimer(this.getClass().getName() + ".testMatchInElasticSearch", startTime);
            }
        }
    }

    public <T extends Item> List<T> query(Condition query, String sortBy, Class<T> clazz) {
        return this.query(query, sortBy, clazz, 0, -1).getList();
    }

    public <T extends Item> PartialList<T> query(Condition query, String sortBy, Class<T> clazz, int offset, int size) {
        return this.query(this.conditionESQueryBuilderDispatcher.getQueryBuilder(query), sortBy, clazz, offset, size, null, null);
    }

    public <T extends Item> PartialList<T> query(Condition query, String sortBy, Class<T> clazz, int offset, int size, String scrollTimeValidity) {
        return this.query(this.conditionESQueryBuilderDispatcher.getQueryBuilder(query), sortBy, clazz, offset, size, null, scrollTimeValidity);
    }

    public PartialList<CustomItem> queryCustomItem(Condition query, String sortBy, String customItemType, int offset, int size, String scrollTimeValidity) {
        return this.query(this.conditionESQueryBuilderDispatcher.getQueryBuilder(query), sortBy, customItemType, offset, size, null, scrollTimeValidity);
    }

    public <T extends Item> PartialList<T> queryFullText(String fulltext, Condition query, String sortBy, Class<T> clazz, int offset, int size) {
        return this.query((QueryBuilder)QueryBuilders.boolQuery().must(QueryBuilders.queryStringQuery(fulltext)).must(this.conditionESQueryBuilderDispatcher.getQueryBuilder(query)), sortBy, clazz, offset, size, null, null);
    }

    public <T extends Item> List<T> query(String fieldName, String fieldValue, String sortBy, Class<T> clazz) {
        return this.query(fieldName, fieldValue, sortBy, clazz, 0, -1).getList();
    }

    public <T extends Item> List<T> query(String fieldName, String[] fieldValues, String sortBy, Class<T> clazz) {
        return this.query((QueryBuilder)QueryBuilders.termsQuery(fieldName, ConditionContextHelper.foldToASCII(fieldValues)), sortBy, clazz, 0, -1, this.getRouting(fieldName, fieldValues, clazz), null).getList();
    }

    public <T extends Item> PartialList<T> query(String fieldName, String fieldValue, String sortBy, Class<T> clazz, int offset, int size) {
        return this.query((QueryBuilder)QueryBuilders.termQuery(fieldName, ConditionContextHelper.foldToASCII(fieldValue)), sortBy, clazz, offset, size, this.getRouting(fieldName, new String[]{fieldValue}, clazz), null);
    }

    public <T extends Item> PartialList<T> queryFullText(String fieldName, String fieldValue, String fulltext, String sortBy, Class<T> clazz, int offset, int size) {
        return this.query((QueryBuilder)QueryBuilders.boolQuery().must(QueryBuilders.queryStringQuery(fulltext)).must(QueryBuilders.termQuery(fieldName, fieldValue)), sortBy, clazz, offset, size, this.getRouting(fieldName, new String[]{fieldValue}, clazz), null);
    }

    public <T extends Item> PartialList<T> queryFullText(String fulltext, String sortBy, Class<T> clazz, int offset, int size) {
        return this.query((QueryBuilder)QueryBuilders.queryStringQuery(fulltext), sortBy, clazz, offset, size, null, null);
    }

    public <T extends Item> PartialList<T> rangeQuery(String fieldName, String from, String to, String sortBy, Class<T> clazz, int offset, int size) {
        RangeQueryBuilder builder = QueryBuilders.rangeQuery(fieldName);
        builder.from(from);
        builder.to(to);
        return this.query((QueryBuilder)builder, sortBy, clazz, offset, size, null, null);
    }

    public long queryCount(Condition query, String itemType) {
        try {
            return this.conditionESQueryBuilderDispatcher.count(query);
        }
        catch (UnsupportedOperationException e) {
            try {
                QueryBuilder filter = this.conditionESQueryBuilderDispatcher.buildFilter(query);
                if (filter instanceof IdsQueryBuilder) {
                    return ((IdsQueryBuilder)filter).ids().size();
                }
                return this.queryCount(filter, itemType);
            }
            catch (UnsupportedOperationException e1) {
                return -1L;
            }
        }
    }

    private long queryCount(final QueryBuilder filter, final String itemType) {
        return (Long)new InClassLoaderExecute<Long>(this.metricsService, this.getClass().getName() + ".queryCount", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Long execute(Object ... args) throws IOException {
                CountRequest countRequest = new CountRequest(ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType));
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                searchSourceBuilder.query(ElasticSearchPersistenceServiceImpl.this.wrapWithItemTypeQuery(itemType, filter));
                countRequest.source(searchSourceBuilder);
                CountResponse response = ElasticSearchPersistenceServiceImpl.this.client.count(countRequest, RequestOptions.DEFAULT);
                return response.getCount();
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    private <T extends Item> PartialList<T> query(QueryBuilder query, String sortBy, Class<T> clazz, int offset, int size, String[] routing, String scrollTimeValidity) {
        return this.query(query, sortBy, clazz, null, offset, size, routing, scrollTimeValidity);
    }

    private PartialList<CustomItem> query(QueryBuilder query, String sortBy, String customItemType, int offset, int size, String[] routing, String scrollTimeValidity) {
        return this.query(query, sortBy, CustomItem.class, customItemType, offset, size, routing, scrollTimeValidity);
    }

    private <T extends Item> PartialList<T> query(final QueryBuilder query, final String sortBy, final Class<T> clazz, final String customItemType, final int offset, final int size, final String[] routing, final String scrollTimeValidity) {
        return (PartialList)new InClassLoaderExecute<PartialList<T>>(this.metricsService, this.getClass().getName() + ".query", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected PartialList<T> execute(Object ... args) throws Exception {
                ArrayList<Item> results = new ArrayList<Item>();
                String scrollIdentifier = null;
                long totalHits = 0L;
                PartialList.Relation totalHitsRelation = PartialList.Relation.EQUAL;
                try {
                    String itemType = Item.getItemType((Class)clazz);
                    if (customItemType != null) {
                        itemType = customItemType;
                    }
                    TimeValue keepAlive = TimeValue.timeValueHours(1L);
                    SearchRequest searchRequest = new SearchRequest(ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType));
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().fetchSource(true).seqNoAndPrimaryTerm(true).query(ElasticSearchPersistenceServiceImpl.this.wrapWithItemTypeQuery(itemType, query)).size(size < 0 ? ElasticSearchPersistenceServiceImpl.this.defaultQueryLimit : size).from(offset);
                    if (scrollTimeValidity != null) {
                        keepAlive = TimeValue.parseTimeValue(scrollTimeValidity, TimeValue.timeValueHours(1L), "scrollTimeValidity");
                        searchRequest.scroll(keepAlive);
                    }
                    if (size == Integer.MIN_VALUE) {
                        searchSourceBuilder.size(ElasticSearchPersistenceServiceImpl.this.defaultQueryLimit);
                    } else if (size != -1) {
                        searchSourceBuilder.size(size);
                    } else {
                        searchRequest.scroll(keepAlive);
                    }
                    if (routing != null) {
                        searchRequest.routing(routing);
                    }
                    if (sortBy != null) {
                        String[] sortByArray = sortBy.split(",");
                        for (String sortByElement : sortByArray) {
                            if (sortByElement.startsWith("geo:")) {
                                String[] elements = sortByElement.split(":");
                                GeoDistanceSortBuilder distanceSortBuilder = SortBuilders.geoDistanceSort(elements[1], Double.parseDouble(elements[2]), Double.parseDouble(elements[3])).unit(DistanceUnit.KILOMETERS);
                                if (elements.length > 4 && elements[4].equals("desc")) {
                                    searchSourceBuilder.sort((SortBuilder<?>)distanceSortBuilder.order(SortOrder.DESC));
                                    continue;
                                }
                                searchSourceBuilder.sort((SortBuilder<?>)distanceSortBuilder.order(SortOrder.ASC));
                                continue;
                            }
                            String name = ElasticSearchPersistenceServiceImpl.this.getPropertyNameWithData(StringUtils.substringBeforeLast((String)sortByElement, (String)":"), itemType);
                            if (name == null) continue;
                            if (sortByElement.endsWith(":desc")) {
                                searchSourceBuilder.sort(name, SortOrder.DESC);
                                continue;
                            }
                            searchSourceBuilder.sort(name, SortOrder.ASC);
                        }
                    }
                    searchSourceBuilder.version(true);
                    searchRequest.source(searchSourceBuilder);
                    SearchResponse response = ElasticSearchPersistenceServiceImpl.this.client.search(searchRequest, RequestOptions.DEFAULT);
                    if (size == -1) {
                        SearchScrollRequest searchScrollRequest;
                        do {
                            for (SearchHit searchHit : response.getHits().getHits()) {
                                String sourceAsString = searchHit.getSourceAsString();
                                Item value = (Item)ESCustomObjectMapper.getObjectMapper().readValue(sourceAsString, clazz);
                                ElasticSearchPersistenceServiceImpl.this.setMetadata(value, searchHit.getId(), searchHit.getVersion(), searchHit.getSeqNo(), searchHit.getPrimaryTerm(), searchHit.getIndex());
                                results.add(value);
                            }
                            searchScrollRequest = new SearchScrollRequest(response.getScrollId());
                            searchScrollRequest.scroll(keepAlive);
                        } while ((response = ElasticSearchPersistenceServiceImpl.this.client.scroll(searchScrollRequest, RequestOptions.DEFAULT)).getHits().getHits().length != 0);
                        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                        clearScrollRequest.addScrollId(response.getScrollId());
                        ElasticSearchPersistenceServiceImpl.this.client.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
                    } else {
                        SearchHits searchHits = response.getHits();
                        scrollIdentifier = response.getScrollId();
                        totalHits = searchHits.getTotalHits().value;
                        totalHitsRelation = ElasticSearchPersistenceServiceImpl.this.getTotalHitsRelation(searchHits.getTotalHits());
                        if (scrollIdentifier != null && totalHits == 0L) {
                            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                            clearScrollRequest.addScrollId(response.getScrollId());
                            ElasticSearchPersistenceServiceImpl.this.client.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
                        }
                        for (SearchHit searchHit : searchHits) {
                            String sourceAsString = searchHit.getSourceAsString();
                            Item value = (Item)ESCustomObjectMapper.getObjectMapper().readValue(sourceAsString, clazz);
                            ElasticSearchPersistenceServiceImpl.this.setMetadata(value, searchHit.getId(), searchHit.getVersion(), searchHit.getSeqNo(), searchHit.getPrimaryTerm(), searchHit.getIndex());
                            results.add(value);
                        }
                    }
                }
                catch (Exception t) {
                    throw new Exception("Error loading itemType=" + clazz.getName() + " query=" + query + " sortBy=" + sortBy, t);
                }
                PartialList result = new PartialList(results, (long)offset, (long)size, totalHits, totalHitsRelation);
                if (scrollIdentifier != null && totalHits != 0L) {
                    result.setScrollIdentifier(scrollIdentifier);
                    result.setScrollTimeValidity(scrollTimeValidity);
                }
                return result;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    private PartialList.Relation getTotalHitsRelation(TotalHits totalHits) {
        return TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO.equals((Object)totalHits.relation) ? PartialList.Relation.GREATER_THAN_OR_EQUAL_TO : PartialList.Relation.EQUAL;
    }

    public <T extends Item> PartialList<T> continueScrollQuery(final Class<T> clazz, final String scrollIdentifier, final String scrollTimeValidity) {
        return (PartialList)new InClassLoaderExecute<PartialList<T>>(this.metricsService, this.getClass().getName() + ".continueScrollQuery", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected PartialList<T> execute(Object ... args) throws Exception {
                ArrayList<Item> results = new ArrayList<Item>();
                long totalHits = 0L;
                try {
                    TimeValue keepAlive = TimeValue.parseTimeValue(scrollTimeValidity, TimeValue.timeValueMinutes(10L), "scrollTimeValidity");
                    SearchScrollRequest searchScrollRequest = new SearchScrollRequest(scrollIdentifier);
                    searchScrollRequest.scroll(keepAlive);
                    SearchResponse response = ElasticSearchPersistenceServiceImpl.this.client.scroll(searchScrollRequest, RequestOptions.DEFAULT);
                    if (response.getHits().getHits().length == 0) {
                        SearchHit[] clearScrollRequest = new ClearScrollRequest();
                        clearScrollRequest.addScrollId(response.getScrollId());
                        ElasticSearchPersistenceServiceImpl.this.client.clearScroll((ClearScrollRequest)clearScrollRequest, RequestOptions.DEFAULT);
                    } else {
                        for (SearchHit searchHit : response.getHits().getHits()) {
                            String sourceAsString = searchHit.getSourceAsString();
                            Item value = (Item)ESCustomObjectMapper.getObjectMapper().readValue(sourceAsString, clazz);
                            ElasticSearchPersistenceServiceImpl.this.setMetadata(value, searchHit.getId(), searchHit.getVersion(), searchHit.getSeqNo(), searchHit.getPrimaryTerm(), searchHit.getIndex());
                            results.add(value);
                        }
                    }
                    PartialList result = new PartialList(results, 0L, (long)response.getHits().getHits().length, response.getHits().getTotalHits().value, ElasticSearchPersistenceServiceImpl.this.getTotalHitsRelation(response.getHits().getTotalHits()));
                    if (scrollIdentifier != null) {
                        result.setScrollIdentifier(scrollIdentifier);
                        result.setScrollTimeValidity(scrollTimeValidity);
                    }
                    return result;
                }
                catch (Exception t) {
                    throw new Exception("Error continuing scrolling query for itemType=" + clazz.getName() + " scrollIdentifier=" + scrollIdentifier + " scrollTimeValidity=" + scrollTimeValidity, t);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public PartialList<CustomItem> continueCustomItemScrollQuery(final String customItemType, final String scrollIdentifier, final String scrollTimeValidity) {
        return (PartialList)new InClassLoaderExecute<PartialList<CustomItem>>(this.metricsService, this.getClass().getName() + ".continueScrollQuery", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected PartialList<CustomItem> execute(Object ... args) throws Exception {
                ArrayList<CustomItem> results = new ArrayList<CustomItem>();
                long totalHits = 0L;
                try {
                    TimeValue keepAlive = TimeValue.parseTimeValue(scrollTimeValidity, TimeValue.timeValueMinutes(10L), "scrollTimeValidity");
                    SearchScrollRequest searchScrollRequest = new SearchScrollRequest(scrollIdentifier);
                    searchScrollRequest.scroll(keepAlive);
                    SearchResponse response = ElasticSearchPersistenceServiceImpl.this.client.scroll(searchScrollRequest, RequestOptions.DEFAULT);
                    if (response.getHits().getHits().length == 0) {
                        SearchHit[] clearScrollRequest = new ClearScrollRequest();
                        clearScrollRequest.addScrollId(response.getScrollId());
                        ElasticSearchPersistenceServiceImpl.this.client.clearScroll((ClearScrollRequest)clearScrollRequest, RequestOptions.DEFAULT);
                    } else {
                        for (SearchHit searchHit : response.getHits().getHits()) {
                            String sourceAsString = searchHit.getSourceAsString();
                            CustomItem value = (CustomItem)ESCustomObjectMapper.getObjectMapper().readValue(sourceAsString, CustomItem.class);
                            ElasticSearchPersistenceServiceImpl.this.setMetadata((Item)value, searchHit.getId(), searchHit.getVersion(), searchHit.getSeqNo(), searchHit.getPrimaryTerm(), searchHit.getIndex());
                            results.add(value);
                        }
                    }
                    PartialList result = new PartialList(results, 0L, (long)response.getHits().getHits().length, response.getHits().getTotalHits().value, ElasticSearchPersistenceServiceImpl.this.getTotalHitsRelation(response.getHits().getTotalHits()));
                    if (scrollIdentifier != null) {
                        result.setScrollIdentifier(scrollIdentifier);
                        result.setScrollTimeValidity(scrollTimeValidity);
                    }
                    return result;
                }
                catch (Exception t) {
                    throw new Exception("Error continuing scrolling query for itemType=" + customItemType + " scrollIdentifier=" + scrollIdentifier + " scrollTimeValidity=" + scrollTimeValidity, t);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    @Deprecated
    public Map<String, Long> aggregateQuery(Condition filter, BaseAggregate aggregate, String itemType) {
        return this.aggregateQuery(filter, aggregate, itemType, false, this.aggregateQueryBucketSize);
    }

    public Map<String, Long> aggregateWithOptimizedQuery(Condition filter, BaseAggregate aggregate, String itemType) {
        return this.aggregateQuery(filter, aggregate, itemType, true, this.aggregateQueryBucketSize);
    }

    public Map<String, Long> aggregateWithOptimizedQuery(Condition filter, BaseAggregate aggregate, String itemType, int size) {
        return this.aggregateQuery(filter, aggregate, itemType, true, size);
    }

    private Map<String, Long> aggregateQuery(final Condition filter, final BaseAggregate aggregate, final String itemType, final boolean optimizedQuery, final int queryBucketSize) {
        return (Map)new InClassLoaderExecute<Map<String, Long>>(this.metricsService, this.getClass().getName() + ".aggregateQuery", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            /*
             * WARNING - void declaration
             */
            @Override
            protected Map<String, Long> execute(Object ... args) throws IOException {
                SearchResponse searchResponse;
                Aggregations aggregations;
                LinkedHashMap<String, Long> results = new LinkedHashMap<String, Long>();
                SearchRequest searchRequest = new SearchRequest(ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType));
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                searchSourceBuilder.size(0);
                MatchAllQueryBuilder matchAll = QueryBuilders.matchAllQuery();
                boolean isItemTypeSharingIndex = ElasticSearchPersistenceServiceImpl.this.isItemTypeSharingIndex(itemType);
                searchSourceBuilder.query(isItemTypeSharingIndex ? ElasticSearchPersistenceServiceImpl.this.getItemTypeQueryBuilder(itemType) : matchAll);
                List<Object> lastAggregation = new ArrayList();
                if (aggregate != null) {
                    Object rangebuilder;
                    Object bucketsAggregation = null;
                    String string = aggregate.getField();
                    if (aggregate instanceof DateAggregate) {
                        DateAggregate dateAggregate = (DateAggregate)aggregate;
                        DateHistogramAggregationBuilder dateHistogramBuilder = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram("buckets").field(string)).calendarInterval(new DateHistogramInterval(dateAggregate.getInterval()));
                        if (dateAggregate.getFormat() != null) {
                            dateHistogramBuilder.format(dateAggregate.getFormat());
                        }
                        bucketsAggregation = dateHistogramBuilder;
                    } else if (aggregate instanceof NumericRangeAggregate) {
                        RangeAggregationBuilder rangeAggregationBuilder = (RangeAggregationBuilder)AggregationBuilders.range("buckets").field(string);
                        for (NumericRange numericRange : ((NumericRangeAggregate)aggregate).getRanges()) {
                            if (numericRange == null) continue;
                            if (numericRange.getFrom() != null && numericRange.getTo() != null) {
                                rangeAggregationBuilder.addRange(numericRange.getKey(), numericRange.getFrom(), numericRange.getTo());
                                continue;
                            }
                            if (numericRange.getFrom() != null) {
                                rangeAggregationBuilder.addUnboundedFrom(numericRange.getKey(), numericRange.getFrom());
                                continue;
                            }
                            if (numericRange.getTo() == null) continue;
                            rangeAggregationBuilder.addUnboundedTo(numericRange.getKey(), numericRange.getTo());
                        }
                        bucketsAggregation = rangeAggregationBuilder;
                    } else if (aggregate instanceof DateRangeAggregate) {
                        DateRangeAggregate dateRangeAggregate = (DateRangeAggregate)aggregate;
                        rangebuilder = (DateRangeAggregationBuilder)AggregationBuilders.dateRange("buckets").field(string);
                        if (dateRangeAggregate.getFormat() != null) {
                            ((ValuesSourceAggregationBuilder)rangebuilder).format(dateRangeAggregate.getFormat());
                        }
                        for (DateRange range : dateRangeAggregate.getDateRanges()) {
                            if (range == null) continue;
                            ((DateRangeAggregationBuilder)rangebuilder).addRange(range.getKey(), range.getFrom() != null ? range.getFrom().toString() : null, range.getTo() != null ? range.getTo().toString() : null);
                        }
                        bucketsAggregation = rangebuilder;
                    } else if (aggregate instanceof IpRangeAggregate) {
                        IpRangeAggregate ipRangeAggregate = (IpRangeAggregate)aggregate;
                        rangebuilder = (IpRangeAggregationBuilder)AggregationBuilders.ipRange("buckets").field(string);
                        for (DateRange range : ipRangeAggregate.getRanges()) {
                            if (range == null) continue;
                            ((IpRangeAggregationBuilder)rangebuilder).addRange(range.getKey(), range.getFrom(), range.getTo());
                        }
                        bucketsAggregation = rangebuilder;
                    } else {
                        String string2 = ElasticSearchPersistenceServiceImpl.this.getPropertyNameWithData(string, itemType);
                        if (string2 != null) {
                            TermsAggregate termsAggregate;
                            bucketsAggregation = ((TermsAggregationBuilder)AggregationBuilders.terms("buckets").field(string2)).size(queryBucketSize);
                            if (aggregate instanceof TermsAggregate && (termsAggregate = (TermsAggregate)aggregate).getPartition() > -1 && termsAggregate.getNumPartitions() > -1) {
                                ((TermsAggregationBuilder)bucketsAggregation).includeExclude(new IncludeExclude(termsAggregate.getPartition(), termsAggregate.getNumPartitions()));
                            }
                        }
                    }
                    if (bucketsAggregation != null) {
                        void var9_11;
                        MissingAggregationBuilder missingAggregationBuilder = (MissingAggregationBuilder)AggregationBuilders.missing("missing").field((String)var9_11);
                        for (AggregationBuilder aggregationBuilder : lastAggregation) {
                            ((AggregationBuilder)bucketsAggregation).subAggregation(aggregationBuilder);
                            missingAggregationBuilder.subAggregation(aggregationBuilder);
                        }
                        lastAggregation = Arrays.asList(bucketsAggregation, missingAggregationBuilder);
                    }
                }
                if (optimizedQuery) {
                    for (AggregationBuilder aggregationBuilder : lastAggregation) {
                        searchSourceBuilder.aggregation(aggregationBuilder);
                    }
                    if (filter != null) {
                        searchSourceBuilder.query(ElasticSearchPersistenceServiceImpl.this.wrapWithItemTypeQuery(itemType, ElasticSearchPersistenceServiceImpl.this.conditionESQueryBuilderDispatcher.buildFilter(filter)));
                    }
                } else {
                    if (filter != null) {
                        FilterAggregationBuilder filterAggregation = AggregationBuilders.filter("filter", ElasticSearchPersistenceServiceImpl.this.wrapWithItemTypeQuery(itemType, ElasticSearchPersistenceServiceImpl.this.conditionESQueryBuilderDispatcher.buildFilter(filter)));
                        for (AggregationBuilder aggregationBuilder : lastAggregation) {
                            ((AggregationBuilder)filterAggregation).subAggregation(aggregationBuilder);
                        }
                        lastAggregation = Collections.singletonList(filterAggregation);
                    }
                    GlobalAggregationBuilder globalAggregation = AggregationBuilders.global("global");
                    for (AggregationBuilder aggregationBuilder : lastAggregation) {
                        ((AggregationBuilder)globalAggregation).subAggregation(aggregationBuilder);
                    }
                    searchSourceBuilder.aggregation(globalAggregation);
                }
                searchRequest.source(searchSourceBuilder);
                RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
                if (ElasticSearchPersistenceServiceImpl.this.aggQueryMaxResponseSizeHttp != null) {
                    builder.setHttpAsyncResponseConsumerFactory(new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(ElasticSearchPersistenceServiceImpl.this.aggQueryMaxResponseSizeHttp));
                }
                if ((aggregations = (searchResponse = ElasticSearchPersistenceServiceImpl.this.client.search(searchRequest, builder.build())).getAggregations()) != null) {
                    void var10_34;
                    if (optimizedQuery) {
                        if (searchResponse.getHits() != null) {
                            results.put("_filtered", searchResponse.getHits().getTotalHits().value);
                        }
                    } else {
                        Global globalAgg = (Global)aggregations.get("global");
                        results.put("_all", globalAgg.getDocCount());
                        Aggregations aggregations2 = globalAgg.getAggregations();
                        if (aggregations2.get("filter") != null) {
                            Filter filter2 = (Filter)aggregations2.get("filter");
                            results.put("_filtered", filter2.getDocCount());
                            Aggregations aggregations3 = filter2.getAggregations();
                        }
                    }
                    if (var10_34.get("buckets") != null) {
                        Terms terms;
                        if (ElasticSearchPersistenceServiceImpl.this.aggQueryThrowOnMissingDocs && var10_34.get("buckets") instanceof Terms && ((terms = (Terms)var10_34.get("buckets")).getDocCountError() > 0L || terms.getSumOfOtherDocCounts() > 0L)) {
                            throw new UnsupportedOperationException("Some docs are missing in aggregation query. docCountError is:" + terms.getDocCountError() + " sumOfOtherDocCounts:" + terms.getSumOfOtherDocCounts());
                        }
                        long totalDocCount = 0L;
                        MultiBucketsAggregation terms2 = (MultiBucketsAggregation)var10_34.get("buckets");
                        for (MultiBucketsAggregation.Bucket bucket : terms2.getBuckets()) {
                            results.put(bucket.getKeyAsString(), bucket.getDocCount());
                            totalDocCount += bucket.getDocCount();
                        }
                        SingleBucketAggregation missing = (SingleBucketAggregation)var10_34.get("missing");
                        if (missing.getDocCount() > 0L) {
                            results.put("_missing", missing.getDocCount());
                            totalDocCount += missing.getDocCount();
                        }
                        if (searchResponse.getHits() != null && TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO.equals((Object)searchResponse.getHits().getTotalHits().relation)) {
                            results.put("_filtered", totalDocCount);
                        }
                    }
                }
                return results;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    private <T extends Item> String[] getRouting(String fieldName, String[] fieldValues, Class<T> clazz) {
        String itemType = Item.getItemType(clazz);
        String[] routing = null;
        if (this.routingByType.containsKey(itemType) && this.routingByType.get(itemType).equals(fieldName)) {
            routing = fieldValues;
        }
        return routing;
    }

    public void refresh() {
        new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".refresh", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) {
                if (ElasticSearchPersistenceServiceImpl.this.bulkProcessor != null) {
                    ElasticSearchPersistenceServiceImpl.this.bulkProcessor.flush();
                }
                try {
                    ElasticSearchPersistenceServiceImpl.this.client.indices().refresh(Requests.refreshRequest(new String[0]), RequestOptions.DEFAULT);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public <T extends Item> void refreshIndex(final Class<T> clazz, Date dateHint) {
        new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".refreshIndex", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) {
                try {
                    String itemType = Item.getItemType((Class)clazz);
                    String index = ElasticSearchPersistenceServiceImpl.this.getIndex(itemType);
                    ElasticSearchPersistenceServiceImpl.this.client.indices().refresh(Requests.refreshRequest(index), RequestOptions.DEFAULT);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public void purge(Date date) {
    }

    public <T extends Item> void purgeTimeBasedItems(final int existsNumberOfDays, final Class<T> clazz) {
        new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".purgeTimeBasedItems", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                String itemType = Item.getItemType((Class)clazz);
                if (existsNumberOfDays > 0 && ElasticSearchPersistenceServiceImpl.this.isItemTypeRollingOver(itemType)) {
                    ElasticSearchPersistenceServiceImpl.this.removeByQuery(QueryBuilders.rangeQuery("timeStamp").lte("now-" + existsNumberOfDays + "d"), clazz);
                    TreeMap<String, Long> countsPerIndex = new TreeMap<String, Long>();
                    GetIndexResponse getIndexResponse = ElasticSearchPersistenceServiceImpl.this.client.indices().get(new GetIndexRequest(ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType)), RequestOptions.DEFAULT);
                    for (String index : getIndexResponse.getIndices()) {
                        countsPerIndex.put(index, ElasticSearchPersistenceServiceImpl.this.client.count(new CountRequest(index), RequestOptions.DEFAULT).getCount());
                    }
                    if (countsPerIndex.size() >= 1) {
                        countsPerIndex.pollLastEntry();
                        for (Map.Entry entry : countsPerIndex.entrySet()) {
                            if ((Long)entry.getValue() != 0L) continue;
                            ElasticSearchPersistenceServiceImpl.this.client.indices().delete(new DeleteIndexRequest((String)entry.getKey()), RequestOptions.DEFAULT);
                        }
                    }
                }
                return true;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public void purge(final String scope) {
        logger.debug("Purge scope {}", (Object)scope);
        new InClassLoaderExecute<Void>(this.metricsService, this.getClass().getName() + ".purgeWithScope", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Void execute(Object ... args) throws IOException {
                BulkResponse deleteResponse;
                SearchScrollRequest searchScrollRequest;
                TermQueryBuilder query = QueryBuilders.termQuery("scope", scope);
                BulkRequest deleteByScopeBulkRequest = new BulkRequest();
                TimeValue keepAlive = TimeValue.timeValueHours(1L);
                SearchRequest searchRequest = new SearchRequest(ElasticSearchPersistenceServiceImpl.this.getAllIndexForQuery()).scroll(keepAlive);
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(query).size(100);
                searchRequest.source(searchSourceBuilder);
                SearchResponse response = ElasticSearchPersistenceServiceImpl.this.client.search(searchRequest, RequestOptions.DEFAULT);
                do {
                    for (SearchHit hit : response.getHits().getHits()) {
                        DeleteRequest deleteRequest = new DeleteRequest(hit.getIndex(), hit.getId());
                        deleteByScopeBulkRequest.add(deleteRequest);
                    }
                    searchScrollRequest = new SearchScrollRequest(response.getScrollId());
                    searchScrollRequest.scroll(keepAlive);
                } while ((response = ElasticSearchPersistenceServiceImpl.this.client.scroll(searchScrollRequest, RequestOptions.DEFAULT)).getHits().getHits().length != 0);
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(response.getScrollId());
                ElasticSearchPersistenceServiceImpl.this.client.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
                if (deleteByScopeBulkRequest.numberOfActions() > 0 && (deleteResponse = ElasticSearchPersistenceServiceImpl.this.client.bulk(deleteByScopeBulkRequest, RequestOptions.DEFAULT)).hasFailures()) {
                    logger.warn("Couldn't delete from scope " + scope + ":\n{}", (Object)deleteResponse.buildFailureMessage());
                }
                return null;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public Map<String, Double> getSingleValuesMetrics(final Condition condition, final String[] metrics, final String field, final String itemType) {
        return (Map)new InClassLoaderExecute<Map<String, Double>>(this.metricsService, this.getClass().getName() + ".getSingleValuesMetrics", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Map<String, Double> execute(Object ... args) throws IOException {
                Object metricsResults;
                LinkedHashMap<String, Double> results = new LinkedHashMap<String, Double>();
                SearchRequest searchRequest = new SearchRequest(ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType));
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).query(ElasticSearchPersistenceServiceImpl.this.isItemTypeSharingIndex(itemType) ? ElasticSearchPersistenceServiceImpl.this.getItemTypeQueryBuilder(itemType) : QueryBuilders.matchAllQuery());
                FilterAggregationBuilder filterAggregation = AggregationBuilders.filter("metrics", ElasticSearchPersistenceServiceImpl.this.conditionESQueryBuilderDispatcher.buildFilter(condition));
                if (metrics != null) {
                    String[] stringArray = metrics;
                    int n = stringArray.length;
                    block16: for (int i = 0; i < n; ++i) {
                        String metric;
                        switch (metric = stringArray[i]) {
                            case "sum": {
                                ((AggregationBuilder)filterAggregation).subAggregation((AggregationBuilder)AggregationBuilders.sum("sum").field(field));
                                continue block16;
                            }
                            case "avg": {
                                ((AggregationBuilder)filterAggregation).subAggregation((AggregationBuilder)AggregationBuilders.avg("avg").field(field));
                                continue block16;
                            }
                            case "min": {
                                ((AggregationBuilder)filterAggregation).subAggregation((AggregationBuilder)AggregationBuilders.min("min").field(field));
                                continue block16;
                            }
                            case "max": {
                                ((AggregationBuilder)filterAggregation).subAggregation((AggregationBuilder)AggregationBuilders.max("max").field(field));
                                continue block16;
                            }
                            case "card": {
                                ((AggregationBuilder)filterAggregation).subAggregation((AggregationBuilder)AggregationBuilders.cardinality("card").field(field));
                                continue block16;
                            }
                            case "count": {
                                ((AggregationBuilder)filterAggregation).subAggregation((AggregationBuilder)AggregationBuilders.count("count").field(field));
                            }
                        }
                    }
                }
                searchSourceBuilder.aggregation(filterAggregation);
                searchRequest.source(searchSourceBuilder);
                SearchResponse response = ElasticSearchPersistenceServiceImpl.this.client.search(searchRequest, RequestOptions.DEFAULT);
                Aggregations aggregations = response.getAggregations();
                if (aggregations != null && (metricsResults = aggregations.get("metrics")) instanceof HasAggregations) {
                    aggregations = ((HasAggregations)metricsResults).getAggregations();
                    for (Aggregation aggregation : aggregations) {
                        NumericMetricsAggregation.SingleValue singleValue = (NumericMetricsAggregation.SingleValue)aggregation;
                        results.put("_" + singleValue.getName(), singleValue.value());
                    }
                }
                return results;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    private String getConfig(Map<String, String> settings, String key, String defaultValue) {
        if (settings != null && settings.get(key) != null) {
            return settings.get(key);
        }
        return defaultValue;
    }

    private String getAllIndexForQuery() {
        return this.indexPrefix + "*";
    }

    private String getIndexNameForQuery(String itemType) {
        return this.isItemTypeRollingOver(itemType) ? this.getRolloverIndexForQuery(itemType) : this.getIndex(itemType);
    }

    private String getRolloverIndexForQuery(String itemType) {
        return this.indexPrefix + "-" + itemType.toLowerCase() + "-*";
    }

    private String getIndex(String itemType) {
        return (this.indexPrefix + "-" + this.getIndexNameForItemType(itemType)).toLowerCase();
    }

    private String getIndexNameForItemType(String itemType) {
        return itemTypeIndexNameMap.getOrDefault(itemType, itemType);
    }

    private String getDocumentIDForItemType(String itemId, String itemType) {
        return systemItems.contains(itemType) ? itemId + "_" + itemType.toLowerCase() : itemId;
    }

    private QueryBuilder wrapWithItemTypeQuery(String itemType, QueryBuilder originalQuery) {
        if (this.isItemTypeSharingIndex(itemType)) {
            BoolQueryBuilder wrappedQuery = QueryBuilders.boolQuery();
            wrappedQuery.must(this.getItemTypeQueryBuilder(itemType));
            wrappedQuery.must(originalQuery);
            return wrappedQuery;
        }
        return originalQuery;
    }

    private QueryBuilder wrapWithItemsTypeQuery(String[] itemTypes, QueryBuilder originalQuery) {
        if (itemTypes.length == 1) {
            return this.wrapWithItemTypeQuery(itemTypes[0], originalQuery);
        }
        if (Arrays.stream(itemTypes).anyMatch(this::isItemTypeSharingIndex)) {
            BoolQueryBuilder itemTypeQuery = QueryBuilders.boolQuery();
            itemTypeQuery.minimumShouldMatch(1);
            for (String itemType : itemTypes) {
                itemTypeQuery.should(this.getItemTypeQueryBuilder(itemType));
            }
            BoolQueryBuilder wrappedQuery = QueryBuilders.boolQuery();
            wrappedQuery.filter(itemTypeQuery);
            wrappedQuery.must(originalQuery);
            return wrappedQuery;
        }
        return originalQuery;
    }

    private QueryBuilder getItemTypeQueryBuilder(String itemType) {
        return QueryBuilders.termQuery("itemType", ConditionContextHelper.foldToASCII(itemType));
    }

    private boolean isItemTypeSharingIndex(String itemType) {
        return itemTypeIndexNameMap.containsKey(itemType);
    }

    private boolean isItemTypeRollingOver(String itemType) {
        return (this.rolloverIndices != null ? this.rolloverIndices : this.itemsMonthlyIndexed).contains(itemType);
    }

    private WriteRequest.RefreshPolicy getRefreshPolicy(String itemType) {
        if (this.itemTypeToRefreshPolicy.containsKey(itemType)) {
            return this.itemTypeToRefreshPolicy.get(itemType);
        }
        return WriteRequest.RefreshPolicy.NONE;
    }

    private void logMetadataItemOperation(String operation, Item item) {
        if (item instanceof MetadataItem) {
            logger.info("Item of type {} with ID {} has been {}", new Object[]{item.getItemType(), item.getItemId(), operation});
        }
    }

    static {
        for (String systemItem : systemItems) {
            itemTypeIndexNameMap.put(systemItem, "systemItems");
        }
        itemTypeIndexNameMap.put("profile", "profile");
        itemTypeIndexNameMap.put("persona", "profile");
    }

    public static abstract class InClassLoaderExecute<T> {
        private String timerName;
        private MetricsService metricsService;
        private BundleContext bundleContext;
        private String[] fatalIllegalStateErrors;
        private boolean throwExceptions;

        public InClassLoaderExecute(MetricsService metricsService, String timerName, BundleContext bundleContext, String[] fatalIllegalStateErrors, boolean throwExceptions) {
            this.timerName = timerName;
            this.metricsService = metricsService;
            this.bundleContext = bundleContext;
            this.fatalIllegalStateErrors = fatalIllegalStateErrors;
            this.throwExceptions = throwExceptions;
        }

        protected abstract T execute(Object ... var1) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T executeInClassLoader(Object ... args) throws Exception {
            long startTime = System.currentTimeMillis();
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                T t = this.execute(args);
                return t;
            }
            finally {
                if (this.metricsService != null && this.metricsService.isActivated()) {
                    this.metricsService.updateTimer(this.timerName, startTime);
                }
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }

        public T catchingExecuteInClassLoader(boolean logError, Object ... args) {
            try {
                return this.executeInClassLoader(this.timerName, args);
            }
            catch (Throwable t) {
                for (Throwable tTemp = t; tTemp != null; tTemp = tTemp.getCause()) {
                    if (!(tTemp instanceof IllegalStateException)) continue;
                    if (!Arrays.stream(this.fatalIllegalStateErrors).anyMatch(tTemp.getMessage()::contains)) continue;
                    this.handleFatalStateError();
                    return null;
                }
                this.handleError(t, logError);
                return null;
            }
        }

        private void handleError(Throwable t, boolean logError) {
            if (logError) {
                logger.error("Error while executing in class loader", t);
            }
            if (this.throwExceptions) {
                throw new RuntimeException(t);
            }
        }

        private void handleFatalStateError() {
            logger.error("Fatal state error occurred - stopping application");
            try {
                this.bundleContext.getBundle(0L).stop();
            }
            catch (Throwable tInner) {
                System.exit(-1);
            }
        }
    }
}

