/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.CondLength;

public class BorderAndPadding
implements Cloneable {
    public static final int TOP = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    static final long bDiscard_MASK = 0x100000000L;
    static final long iLength_MASK = 0xFFFFFFFFL;
    private BorderInfo[] borderInfo = new BorderInfo[4];
    private long[] padding = new long[4];

    public Object clone() throws CloneNotSupportedException {
        BorderAndPadding bp = (BorderAndPadding)super.clone();
        bp.padding = new long[this.padding.length];
        System.arraycopy(this.padding, 0, bp.padding, 0, this.padding.length);
        bp.borderInfo = (BorderInfo[])this.borderInfo.clone();
        int i = 0;
        while (i < this.borderInfo.length) {
            if (this.borderInfo[i] != null) {
                bp.borderInfo[i] = (BorderInfo)this.borderInfo[i].clone();
            }
            ++i;
        }
        return bp;
    }

    public int getBorderBottomWidth(boolean bDiscard) {
        return this.getBorderWidth(2, bDiscard);
    }

    public ColorType getBorderColor(int side) {
        if (this.borderInfo[side] != null) {
            return this.borderInfo[side].mColor;
        }
        return null;
    }

    public int getBorderLeftWidth(boolean bDiscard) {
        return this.getBorderWidth(3, bDiscard);
    }

    public int getBorderRightWidth(boolean bDiscard) {
        return this.getBorderWidth(1, bDiscard);
    }

    public int getBorderStyle(int side) {
        if (this.borderInfo[side] != null) {
            return this.borderInfo[side].mStyle;
        }
        return 0;
    }

    public int getBorderTopWidth(boolean bDiscard) {
        return this.getBorderWidth(0, bDiscard);
    }

    private int getBorderWidth(int side, boolean bDiscard) {
        if (this.borderInfo[side] == null || bDiscard && (this.borderInfo[side].mWidth & 0x100000000L) != 0L) {
            return 0;
        }
        return (int)(this.borderInfo[side].mWidth & 0xFFFFFFFFL);
    }

    private int getPadding(int side, boolean bDiscard) {
        return (int)(this.padding[side] & 0xFFFFFFFFL);
    }

    public int getPaddingBottom(boolean bDiscard) {
        return this.getPadding(2, bDiscard);
    }

    public int getPaddingLeft(boolean bDiscard) {
        return this.getPadding(3, bDiscard);
    }

    public int getPaddingRight(boolean bDiscard) {
        return this.getPadding(1, bDiscard);
    }

    public int getPaddingTop(boolean bDiscard) {
        return this.getPadding(0, bDiscard);
    }

    private static final long new_ResolvedCondLength(CondLength length) {
        return (length.isDiscard() ? 0x100000000L : 0L) + (long)length.mvalue();
    }

    public void setBorder(int side, int style, CondLength width, ColorType color) {
        this.borderInfo[side] = new BorderInfo(style, width, color);
    }

    public void setBorderLength(int side, int iLength) {
        this.borderInfo[side].mWidth = (long)iLength + (this.borderInfo[side].mWidth & 0x100000000L);
    }

    public void setPadding(int side, CondLength width) {
        this.padding[side] = BorderAndPadding.new_ResolvedCondLength(width);
    }

    public void setPaddingLength(int side, int iLength) {
        this.padding[side] = (long)iLength + (this.padding[side] & 0x100000000L);
    }

    public static class BorderInfo
    implements Cloneable {
        private int mStyle;
        private ColorType mColor;
        private long mWidth;

        BorderInfo(int style, CondLength width, ColorType color) {
            this.mStyle = style;
            this.mWidth = BorderAndPadding.new_ResolvedCondLength(width);
            this.mColor = color;
        }

        public Object clone() throws CloneNotSupportedException {
            BorderInfo bi = (BorderInfo)super.clone();
            bi.mWidth = this.mWidth;
            return bi;
        }
    }
}

