/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.HashMap;
import org.apache.fop.apps.FOPException;
import org.apache.fop.layout.FontMetric;
import org.apache.fop.messaging.MessageHandler;

public class FontInfo {
    HashMap usedFonts;
    HashMap triplets = new HashMap();
    HashMap fonts = new HashMap();

    public FontInfo() {
        this.usedFonts = new HashMap();
    }

    public void addFontProperties(String name, String family, String style, String weight) {
        String key = FontInfo.createFontKey(family, style, weight);
        this.triplets.put(key, name);
    }

    public void addMetrics(String name, FontMetric metrics) {
        this.fonts.put(name, metrics);
    }

    public static String createFontKey(String family, String style, String weight) {
        int i;
        try {
            i = Integer.parseInt(weight);
        }
        catch (NumberFormatException numberFormatException) {
            i = 0;
        }
        if (i > 600) {
            weight = "bold";
        } else if (i > 0) {
            weight = "normal";
        }
        return String.valueOf(family) + "," + style + "," + weight;
    }

    public String fontLookup(String key) throws FOPException {
        String f = (String)this.triplets.get(key);
        if (f == null) {
            int i = key.indexOf(44);
            String s = "any" + key.substring(i);
            f = (String)this.triplets.get(s);
            if (f == null) {
                f = (String)this.triplets.get("any,normal,normal");
                if (f == null) {
                    throw new FOPException("no default font defined by OutputConverter");
                }
                MessageHandler.errorln("defaulted font to any,normal,normal");
            }
            MessageHandler.errorln("unknown font " + key + " so defaulted font to any");
        }
        this.usedFonts.put(f, this.fonts.get(f));
        return f;
    }

    public String fontLookup(String family, String style, String weight) throws FOPException {
        return this.fontLookup(FontInfo.createFontKey(family, style, weight));
    }

    public HashMap getFonts() {
        return this.fonts;
    }

    public FontMetric getMetricsFor(String fontName) throws FOPException {
        this.usedFonts.put(fontName, this.fonts.get(fontName));
        return (FontMetric)this.fonts.get(fontName);
    }

    public HashMap getUsedFonts() {
        return this.usedFonts;
    }

    public boolean hasFont(String key) {
        return this.triplets.get(key) != null;
    }

    public boolean hasFont(String family, String style, String weight) {
        String key = FontInfo.createFontKey(family, style, weight);
        return this.triplets.get(key) != null;
    }
}

