/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.http2.markup.head.undertow;

import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.PushBuilderImpl;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.http2.markup.head.PushBuilder;
import org.apache.wicket.http2.markup.head.PushItem;
import org.apache.wicket.http2.markup.head.PushItemHeaderValue;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndertowPushBuilder
implements PushBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowPushBuilder.class);

    public void push(HttpServletRequest httpServletRequest, PushItem ... pushItems) {
        Request request = RequestCycle.get().getRequest();
        HttpServletRequest httpRequest = (HttpServletRequest)request.getContainerRequest();
        HttpServletRequestImpl undertowRequest = (HttpServletRequestImpl)httpRequest;
        PushBuilderImpl pushBuilder = (PushBuilderImpl)undertowRequest.newPushBuilder();
        if (pushBuilder != null) {
            for (PushItem pushItem : pushItems) {
                pushBuilder.path(pushItem.getUrl());
                pushItem.getHeaders().entrySet().stream().forEach(pushHeader -> {
                    String key = (String)pushHeader.getKey();
                    PushItemHeaderValue value = (PushItemHeaderValue)pushHeader.getValue();
                    if (value.getOperation() == PushItemHeaderValue.HeaderOperation.ADD) {
                        pushBuilder.addHeader(key, value.getValue());
                    } else {
                        pushBuilder.setHeader(key, value.getValue());
                    }
                });
                pushBuilder.push();
            }
        } else {
            LOG.warn("Attempted to use HTTP2 Push but it is not supported for the current request: {}!", (Object)httpRequest);
        }
    }
}

