#!BPY

#""" 
#Name: 'Clean Material Indices'
#Blender: 248
#Group: 'Materials'
#Tooltip: 'remove any materials that are not used by the mesh faces'
#"""

# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2009 Michael Williamson
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

__author__ = 'Michael Williamson'
__url__ = ('http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Materials/Clean_Material_Indices')
__version__ = '1'
__bpydoc__ = """

run to remove all material slots that are not tagged to any mesh faces (ie un-used!)

"""



import bpy
import Blender
from Blender import *
from bpy import*		

		
#-------------------------------------------------
def main():
	
	scn = data.scenes.active
	for ob in scn.objects.context:
		if not ob.lib and ob.type == 'Mesh':	# object isn't from a library and is a mesh
	
		
			#get number of materials on mesh
			
			me = ob.getData(mesh=1) 
			mats = me.materials 
			
			#check the faces on the mesh to build a list of used materials
			usedMatIndex =[]		#we'll store used materials indices here
			faceMats =[]			#a list of material names corrosponding to face names
				
			for f in me.faces:
				#get the material index for this face...
				faceindex = f.mat
				
				#indices will be lost: Store face mat use by name
				currentfacemat = mats[faceindex].name
				faceMats.append(currentfacemat)
				
				
				#check if index is already listed as used or not
				found = 0
				for m in usedMatIndex:
					if m == faceindex:
						found = 1
						#break
					
				if found == 0:
					#add this index to the list
					
					usedMatIndex.append(faceindex)
						 
			#re-assign the used mats to the mesh and leave out the unused
			ml = []
			mnames = []
			for u in usedMatIndex:
				ml.append( mats[u] )
				#we'll need a list of names to get the face indices...
				mnames.append(mats[u].name)
				
			me.materials = ml
			me.update() 
			
			#restore face indices:
			i = 0
			for f in me.faces:
				matindex = mnames.index(faceMats[i])
				f.mat = matindex
				i += 1
			

	return 1

done = main()
if done == 1:
	print "done"
	Draw.PupMenu("Done%t|OK") 
else:
	print "Nothing Done"
