#!BPY

"""
Name: 'Galaxy Generator Script'
Blender: 248
Group: 'Misc'
Tooltip: 'Create Galaxys.'
"""

# --------------------------------------------------------------------------
#Galaxy Generator Script v0.1 by timmeh (Timothy Wakeham)
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

from Blender import *
import random
import math

mesh = NMesh.New()

radius = 101
stars = 1000
depth = 3
randomness = 100

for index in range(stars):
	i = Mathutils.Rand()
	j = Mathutils.Rand()
	k = i * j
	xoff = Mathutils.Rand() * randomness
	yoff = Mathutils.Rand() * randomness
	length = k * radius
	angle = Mathutils.Rand() * 2 * math.pi
	x = length * math.cos(angle)
	y = length * math.sin(angle)
	z = Mathutils.Rand() * depth - (depth / 2)
	newVert = NMesh.Vert(x,y,z)
	mesh.verts.append(newVert)
	
NMesh.PutRaw(mesh)

Redraw()