#!BPY
# -*- coding: latin-1 -*-
""" Registration info for Blender menus:
Name: '3D View Background Color'
Blender: 240
Group: 'Themes'
Tip: 'Let you change the background color of your 3D View.'
"""

__author__ = ("Eckhard M. Jger (El Barto), area42 - Agentur & Systempartner")
__url__ = ["area42 - Agentur & Systempartner Website, http://www.area42.de"]
__email__ = ["area42 - Agentur & Systempartner, office:area42*de"]
__name__= "3D View Background Color"
__version__ = "1.0.0"
__bpydoc__ = """\
This script let you change the background color of the 3D View.

Usage:
"""

import Blender
from Blender.BGL import *
from Blender.Draw import *
from Blender.Window import Theme

sldCol = [Create(150), Create(150), Create(150)]
world = Blender.World.Get()
TgReal = Create(0)
 
def draw():
	global btnQuit, btnACol, btnZCol, btnCCol, btnHCol, sldCol, TgReal

	theme = Theme.Get()[0]
	thmUi = theme.get('ui')
	thmBg = theme.get('BUTS')
	thmBGcol = thmBg.back
	thmHDcol = thmBg.header
	thmUIpop = thmUi.popup
	thmUIth = thmUi.text_hi
	thmUItx = thmUi.text
	
	# Window BG	
	glClearColor(float(thmBGcol[0])/255, float(thmBGcol[1])/255, float(thmBGcol[2])/255, 0.0)
	glClear(GL_COLOR_BUFFER_BIT)

	# Dialog BG
	glColor3f(float(thmUIpop[0])/255, float(thmUIpop[1])/255, float(thmUIpop[2])/255)
	glRecti(8, 284, 364, 24)
	
	#Header BG
	glColor3f((float(thmHDcol[0])/255)*.9, (float(thmHDcol[1])/255)*.9, (float(thmHDcol[2])/255)*.9)
	glRecti(8, 284, 364, 308)
	glColor3f(float(thmUIth[0])/255, float(thmUIth[1])/255, float(thmUIth[2])/255)
	glRasterPos2i(24, 290)
	Blender.Draw.Text(__name__+' '+__version__, "large")
	glRasterPos2i(25, 290)
	Blender.Draw.Text(__name__+' '+__version__, "large")
	
	#Content
	glColor3f(float(thmUItx[0])/255, float(thmUItx[1])/255, float(thmUItx[2])/255)

	#Content Custom Color
	Button('Custom Color', 4, 24, 240, 80, 24, 'Set background color of 3D View to custom color')
	TgReal = Toggle('<', 21, 104, 240, 16, 24, TgReal.val, 'Realtime Preview in 3D View')
	Button('Get', 9, 144, 216, 48, 16, 'Get background color from 3D View')
	glColor3f(float(sldCol[0].val)/255,float(sldCol[1].val)/255,float(sldCol[2].val)/255)	
	glRectf(144, 240, 192, 264)
	sldCol[0] = Slider('Red ', 7, 200, 248, 148, 16, sldCol[0].val, 1, 255, 1, 'Set red color channel')
	sldCol[1] = Slider('Grn ', 7, 200, 232, 148, 16, sldCol[1].val, 1, 255, 1, 'Set green color channel')
	sldCol[2] = Slider('Blu  ', 7, 200, 216, 148, 16, sldCol[2].val, 1, 255, 1, 'Set blue color channel')
	
	#Content Horizon Color
	Button('Horizon Color', 5, 24, 176, 96, 24, 'Set background color of 3D View to horizon color')
	if len(world) > 0:
		horcol = world[0].getHor()
		glColor3f(horcol[0],horcol[1],horcol[2])
	glRecti(144, 176, 192, 200)

	#Content Zenit Color
	Button('Zenit Color', 3, 24, 136, 96, 24, 'Set background color of 3D View to zenit color')
	if len(world) > 0:
		zencol = world[0].getZen()
		glColor3f(zencol[0],zencol[1],zencol[2])
	glRecti(144, 136, 192, 160)	

	#Content Ambient Color
	Button('Ambient Color', 2, 24, 96, 96, 24, 'Set background color of 3D View to zenit color')
	if len(world) > 0:
		ambcol = world[0].getAmb()
		glColor3f(ambcol[0],ambcol[1],ambcol[2])
	glRecti(144, 96, 192, 120)		
	
	glColor3f(float(thmUItx[0])/255, float(thmUItx[1])/255, float(thmUItx[2])/255)

	Button('Quit', 1, 256, 40, 96, 24, 'Quit this dialogue')
	
	#Author
	glRasterPos2i(10, 10)
	Blender.Draw.Text('El Barto, area42 - Agentur & Systempartner, www.area42.de, 2006', "tiny")
	
def event(evt, val):
	if (evt == ESCKEY and not val) or (evt == QKEY and not val): Exit()
	
def bgcolor(val):
	theme = Theme.Get()[0]
	t = theme.get('ui')
	vi = theme.get('view3d')
	vi.back = int(val[0]*255), int(val[1]*255), int(val[2]*255), 1

def bevent(evt):
	if evt == 1: #btnQuit
		Exit()

	elif evt == 2: #btnACol
		if len(world) > 0:
			newcol = world[0].getAmb()
			bgcolor(newcol)

	elif evt == 3: #btnZCol
		if len(world) > 0:
			newcol = world[0].getZen()
			bgcolor(newcol)

	elif evt == 7: #Slider
		glColor3f(sldCol[0].val/255, sldCol[1].val/255, sldCol[2].val/255)
		if TgReal.val == 1:
			newcol = [float(sldCol[0].val)/255, float(sldCol[1].val)/255, float(sldCol[2].val)/255]
			bgcolor(newcol)

	elif evt == 4: #btnCCol
		newcol = [float(sldCol[0].val)/255, float(sldCol[1].val)/255, float(sldCol[2].val)/255]
		bgcolor(newcol)

	elif evt == 5: #btnHCol
		if len(world) > 0:
			newcol = world[0].getHor()
			bgcolor(newcol)

	elif evt == 9: #Get
		theme = Theme.Get()[0]
		t = theme.get('ui')
		vi = theme.get('view3d')
		sldCol[0].val = vi.back[0]
		sldCol[1].val = vi.back[1]
		sldCol[2].val = vi.back[2]
					
	Blender.Redraw()

Register(draw, event, bevent)
