# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work envronment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gtk+
VER=2.16.6
REV=2
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev
usemingw64
usemsvs9x64

(

set -x

DEPS=`latest --arch=${ARCH} glib pkg-config atk cairo freetype expat fontconfig cairo pango libpng zlib`
PROXY_LIBINTL=`latest --arch=${ARCH} proxy-libintl`

PKG_CONFIG_PATH=
for D in $DEPS; do
    PATH=/devel/dist/${ARCH}/$D/bin:$PATH
    [ -d /devel/dist/${ARCH}/$D/lib/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
done

LIBPNG=`latest --arch=${ARCH} libpng`
ZLIB=`latest --arch=${ARCH} zlib`

# Don't do any relinking crap in libtool.
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# No wrappers either, thanks. We just set PATH to include the location of what we have built
sed -e 's/wrappers_required=yes/wrappers_required=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

patch -p1 <<'EOF'
commit e68a26ea72ce38315bba862e208e238b7febb405
Author: Steffen Macke <sdteffen@gmail.com>
Date:   Sat Feb 6 20:04:30 2010 +0200

    Fix menu bar problem in ms-windows theme engine on Windows 7
    
    Patch from bug #591186

diff --git a/modules/engines/ms-windows/msw_style.c b/modules/engines/ms-windows/msw_style.c
index bc253e1..d086378 100755
--- a/modules/engines/ms-windows/msw_style.c
+++ b/modules/engines/ms-windows/msw_style.c
@@ -698,8 +698,8 @@ setup_msw_rc_style (void)
   GdkColor text_prelight;
 
   /* Prelight */
-  sys_color_to_gtk_color (XP_THEME_CLASS_TEXT,
-			  get_windows_version () == VISTA_VERSION ? COLOR_MENUTEXT : COLOR_HIGHLIGHTTEXT,
+  sys_color_to_gtk_color (get_windows_version () >= VISTA_VERSION ? XP_THEME_CLASS_MENU : XP_THEME_CLASS_TEXT,
+			  get_windows_version () >= VISTA_VERSION ? COLOR_MENUTEXT : COLOR_HIGHLIGHTTEXT,
 			  &fg_prelight);
   sys_color_to_gtk_color (XP_THEME_CLASS_TEXT, COLOR_HIGHLIGHT, &bg_prelight);
   sys_color_to_gtk_color (XP_THEME_CLASS_TEXT, COLOR_HIGHLIGHT,
commit 6cf7c942f630a3d1bf4d288d6b5d13391d592adb
Author: Shixin Zeng <zeng.shixin@gmail.com>
Date:   Thu Aug 20 23:53:57 2009 +0300

    Don't use stream before it is created

diff --git a/gdk-pixbuf/io-gdip-utils.c b/gdk-pixbuf/io-gdip-utils.c
index eff2f76..b8fa72b 100644
--- a/gdk-pixbuf/io-gdip-utils.c
+++ b/gdk-pixbuf/io-gdip-utils.c
@@ -365,7 +365,6 @@ gdip_buffer_to_bitmap (GdipContext *context, GError **error)
   if (!hg)
     return NULL;
 
-  IStream_SetSize (stream, *(ULARGE_INTEGER *)&size64);
   hr = CreateStreamOnHGlobal (hg, FALSE, (LPSTREAM *)&stream);
 
   if (!SUCCEEDED (hr)) {
@@ -373,7 +372,9 @@ gdip_buffer_to_bitmap (GdipContext *context, GError **error)
     GlobalFree (hg);
     return NULL;
   }
-  
+
+  IStream_SetSize (stream, *(ULARGE_INTEGER *)&size64);
+
   status = GdipCreateBitmapFromStream (stream, &bitmap);
 
   if (Ok != status) {
commit 67834690d0086953ed892322d616c725414996cd
Author: Tor Lillqvist <tml@iki.fi>
Date:   Thu Oct 8 10:54:22 2009 +0300

    Fix the GDI+ gdk-pixbuf loader
    
    Should fix bug #552678. Patch by Dominic Lachowicz, based on a clueful
    response from Jason Copenhaver on Albeto Ruiz's blog
    http://aruiz.typepad.com/siliconisland/2009/08/dear-lazyweb-gtk-need-gdi-help.html

diff --git a/gdk-pixbuf/io-gdip-utils.c b/gdk-pixbuf/io-gdip-utils.c
index 9353725..eff2f76 100644
--- a/gdk-pixbuf/io-gdip-utils.c
+++ b/gdk-pixbuf/io-gdip-utils.c
@@ -31,6 +31,18 @@
 
 #define LOAD_BUFFER_SIZE 65536
 
+struct _GdipContext {
+  GdkPixbufModuleUpdatedFunc  updated_func;
+  GdkPixbufModulePreparedFunc prepared_func;
+  GdkPixbufModuleSizeFunc     size_func;
+
+  gpointer                    user_data;
+  GByteArray                 *buffer;
+  IStream                    *stream;
+  HGLOBAL                     hg;
+};
+typedef struct _GdipContext GdipContext;
+
 static GdiplusStartupFunc GdiplusStartup;
 static GdipCreateBitmapFromStreamFunc GdipCreateBitmapFromStream;
 static GdipBitmapGetPixelFunc GdipBitmapGetPixel;
@@ -339,16 +351,16 @@ gdip_pixbuf_to_bitmap (GdkPixbuf *pixbuf)
 }
 
 static GpBitmap *
-gdip_buffer_to_bitmap (const gchar *buffer, size_t size, GError **error)
+gdip_buffer_to_bitmap (GdipContext *context, GError **error)
 {
   HRESULT hr;
   HGLOBAL hg = NULL;
   GpBitmap *bitmap = NULL;
   IStream *stream = NULL;
   GpStatus status;
-  guint64 size64 = size;
+  guint64 size64 = context->buffer->len;
 
-  hg = gdip_buffer_to_hglobal (buffer, size, error);
+  hg = gdip_buffer_to_hglobal (context->buffer->data, context->buffer->len, error);
 
   if (!hg)
     return NULL;
@@ -364,26 +376,30 @@ gdip_buffer_to_bitmap (const gchar *buffer, size_t size, GError **error)
   
   status = GdipCreateBitmapFromStream (stream, &bitmap);
 
-  if (Ok != status)
+  if (Ok != status) {
     gdip_set_error_from_gpstatus (error, GDK_PIXBUF_ERROR_FAILED, status);
+    IStream_Release (stream);
+    GlobalFree (hg);
+    return NULL;
+  }
 
-  IStream_Release (stream);
-  GlobalFree (hg);
+  context->stream = stream;
+  context->hg = hg;
 
   return bitmap;
 }
 
 static GpImage *
-gdip_buffer_to_image (const gchar *buffer, size_t size, GError **error)
+gdip_buffer_to_image (GdipContext *context, GError **error)
 {
   HRESULT hr;
   HGLOBAL hg = NULL;
   GpImage *image = NULL;
   IStream *stream = NULL;
   GpStatus status;
-  guint64 size64 = size;
+  guint64 size64 = context->buffer->len;
 
-  hg = gdip_buffer_to_hglobal (buffer, size, error);
+  hg = gdip_buffer_to_hglobal (context->buffer->data, context->buffer->len, error);
 
   if (!hg)
     return NULL;
@@ -399,11 +415,15 @@ gdip_buffer_to_image (const gchar *buffer, size_t size, GError **error)
   IStream_SetSize (stream, *(ULARGE_INTEGER *)&size64);
   status = GdipLoadImageFromStream (stream, &image);
 
-  if (Ok != status)
+  if (Ok != status) {
     gdip_set_error_from_gpstatus (error, GDK_PIXBUF_ERROR_FAILED, status);
+    IStream_Release (stream);
+    GlobalFree (hg);
+    return NULL;
+  }
 
-  IStream_Release (stream);
-  GlobalFree (hg);
+  context->stream = stream;
+  context->hg = hg;
 
   return image;
 }
@@ -590,24 +610,14 @@ gdip_bitmap_get_n_loops (GpBitmap *bitmap, guint *loops)
   return success;
 }
 
-/*************************************************************************/
-/*************************************************************************/
-
-struct _GdipContext {
-  GdkPixbufModuleUpdatedFunc  updated_func;
-  GdkPixbufModulePreparedFunc prepared_func;
-  GdkPixbufModuleSizeFunc     size_func;
-
-  gpointer                    user_data;
-
-  GByteArray                 *buffer;
-};
-typedef struct _GdipContext GdipContext;
-
 static void
 destroy_gdipcontext (GdipContext *context)
 {
   if (context != NULL) {
+    if (context->stream != NULL) {
+      IStream_Release(context->stream);
+      GlobalFree (context->hg);
+    }
     g_byte_array_free (context->buffer, TRUE);
     g_free (context);
   }
@@ -806,9 +816,8 @@ gdk_pixbuf__gdip_image_stop_load (gpointer data, GError **error)
 {
   GdipContext *context = (GdipContext *)data;
   GpBitmap    *bitmap = NULL;
-  GByteArray *image_buffer = context->buffer;
 
-  bitmap = gdip_buffer_to_bitmap ((gchar *)image_buffer->data, image_buffer->len, error);
+  bitmap = gdip_buffer_to_bitmap (context, error);
 
   if (!bitmap) {
     destroy_gdipcontext (context);
@@ -823,7 +832,6 @@ static gboolean
 gdk_pixbuf__gdip_image_stop_vector_load (gpointer data, GError **error)
 {
   GdipContext *context = (GdipContext *)data;
-  GByteArray *image_buffer = context->buffer;
 
   GpImage *metafile;
   GpGraphics *graphics;
@@ -832,7 +840,7 @@ gdk_pixbuf__gdip_image_stop_vector_load (gpointer data, GError **error)
   float metafile_xres, metafile_yres;
   guint width, height;
 
-  metafile = gdip_buffer_to_image ((gchar *)image_buffer->data, image_buffer->len, error);
+  metafile = gdip_buffer_to_image (context, error);
   if (!metafile) {
     destroy_gdipcontext (context);
     g_set_error_literal (error, GDK_PIXBUF_ERROR, GDK_PIXBUF_ERROR_CORRUPT_IMAGE, _("Couldn't load metafile"));
EOF

patch -p0 <<'EOF'
--- Makefile.in
+++ Makefile.in
@@ -527,7 +527,7 @@
 	&& DISPLAY=:$$XID && export DISPLAY
 
 
-SRC_SUBDIRS = gdk-pixbuf gdk gtk modules demos tests perf contrib
+SRC_SUBDIRS = gdk-pixbuf gdk gtk modules demos
 SUBDIRS = po po-properties $(SRC_SUBDIRS) docs m4macros
 
 # require automake 1.4
EOF

mkdir gtk/.libs
echo '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<assembly xmlns="urn:schemas-microsoft-com:asm.v1" manifestVersion="1.0">
  <assemblyIdentity version="1.0.0.0"
     processorArchitecture="AMD64"
     name="gtk-update-icon-cache.exe"
     type="win32"/>
  <!-- Identify the application security requirements. -->
  <trustInfo xmlns="urn:schemas-microsoft-com:asm.v3">
    <security>
      <requestedPrivileges>
        <requestedExecutionLevel
          level="asInvoker"
          uiAccess="false"/>
        </requestedPrivileges>
       </security>
  </trustInfo>
</assembly>' >gtk/gtk-update-icon-cache.exe.manifest &&

cp -p gtk/gtk-update-icon-cache.exe.manifest gtk/.libs/gtk-update-icon-cache.exe.manifest &&

patch -p0 <<'EOF'
--- gtk/gtkprintoperation-win32.c
+++ gtk/gtkprintoperation-win32.c
@@ -72,7 +72,7 @@
 
 static const GUID myIID_IPrintDialogCallback  = {0x5852a2c3,0x6530,0x11d1,{0xb6,0xa3,0x0,0x0,0xf8,0x75,0x7b,0xf9}};
 
-#if !defined (_MSC_VER) && !defined (MINGW64) && !defined (__MINGW64)
+#if 0
 #undef INTERFACE
 #define INTERFACE IPrintDialogCallback
 DECLARE_INTERFACE_ (IPrintDialogCallback, IUnknown)
EOF

lt_cv_deplibs_check_method='pass_all' \
CC='x86_64-w64-mingw32-gcc' \
CPPFLAGS="-I/devel/dist/${ARCH}/${LIBPNG}/include \
-I/devel/dist/${ARCH}/${ZLIB}/include \
-I/devel/dist/${ARCH}/${PROXY_LIBINTL}/include" \
LDFLAGS="-L/devel/dist/${ARCH}/${LIBPNG}/lib \
-L/devel/dist/${ARCH}/${ZLIB}/lib \
-L/devel/dist/${ARCH}/${PROXY_LIBINTL}/lib -Wl,--exclude-libs=libintl.a \
-Wl,--enable-auto-image-base" \
LIBS=-lintl \
LIBPNG=`pkg-config --libs libpng` \
CFLAGS=-O2 \
./configure --host=x86_64-w64-mingw32 \
--with-gdktarget=win32 \
--enable-gdiplus \
--with-included-loaders \
--with-included-immodules \
--without-libjasper \
--enable-debug=yes \
--enable-explicit-deps=no \
--disable-gtk-doc \
--disable-static \
--prefix=$TARGET &&

rm gtk/gtk.def &&
PATH="$PWD/gdk-pixbuf/.libs:/devel/target/$HEX/bin:$PATH" make -j3 install &&

(echo '# Note: After adding a new separate gdk-pixbuf loader (for instance the svg one)' &&
    echo '# run gdk-pixbuf-query-loaders.exe redirecting its output into this file.' &&
    echo &&
    echo '# Note that the LoaderDir folder below does not name a folder that is' &&
    echo '# expected to exist. It was just a temporary directory used at build time.' &&
    echo &&
    cat $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders ) >$TARGET/etc/gtk-2.0/gdk-pixbuf.loaders.temp &&
    mv $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders.temp $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders &&

grep -v -E 'Automatically generated|Created by|ModulesPath =' <$TARGET/etc/gtk-2.0/gtk.immodules >$TARGET/etc/gtk-2.0/gtk.immodules.temp &&
    mv $TARGET/etc/gtk-2.0/gtk.immodules.temp $TARGET/etc/gtk-2.0/gtk.immodules &&

./gtk-zip.sh &&

# Package also the gtk-update-icon-cache.exe.manifest
cp -p gtk/gtk-update-icon-cache.exe.manifest $TARGET/bin
(cd $TARGET && zip /tmp/${MOD}-dev-${VER}.zip bin/gtk-update-icon-cache.exe.manifest) &&

mv /tmp/${MOD}-${VER}.zip /tmp/$RUNZIP &&
mv /tmp/${MOD}-dev-${VER}.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
