/*
 * Decompiled with CFR 0.152.
 */
package org.bluray.ti.selection;

import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.service.SIManager;
import javax.tv.service.Service;
import javax.tv.service.selection.InvalidServiceComponentException;
import javax.tv.service.selection.NormalContentEvent;
import javax.tv.service.selection.PresentationChangedEvent;
import javax.tv.service.selection.PresentationTerminatedEvent;
import javax.tv.service.selection.SelectPermission;
import javax.tv.service.selection.SelectionFailedEvent;
import javax.tv.service.selection.ServiceContentHandler;
import javax.tv.service.selection.ServiceContextDestroyedEvent;
import javax.tv.service.selection.ServiceContextEvent;
import javax.tv.service.selection.ServiceContextListener;
import javax.tv.service.selection.ServiceContextPermission;
import org.bluray.ti.Title;
import org.bluray.ti.TitleImpl;
import org.bluray.ti.selection.TitleContext;
import org.videolan.BDJListeners;
import org.videolan.BDJLoader;
import org.videolan.BDJLoaderCallback;
import org.videolan.Logger;
import org.videolan.media.content.BDHandler;
import org.videolan.media.content.PlayerManager;

public class TitleContextImpl
implements TitleContext {
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_DESTROYED = 2;
    private BDJListeners listeners = new BDJListeners();
    private TitleImpl title = null;
    private int state = 0;
    private static final Logger logger = Logger.getLogger(TitleContextImpl.class.getName());

    public Service getService() {
        return this.title;
    }

    public ServiceContentHandler[] getServiceContentHandlers() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ServiceContextPermission("getServiceContentHandlers", "own"));
        }
        if (this.state == 2) {
            throw new IllegalStateException();
        }
        if (this.state == 0) {
            return new ServiceContentHandler[0];
        }
        BDHandler player = PlayerManager.getInstance().getPlaylistPlayer();
        if (player != null) {
            ServiceContentHandler[] handler = new ServiceContentHandler[]{player};
            return handler;
        }
        System.err.println("getServiceContentHandlers(): none found");
        return new ServiceContentHandler[0];
    }

    public void start(Title title, boolean restart) throws SecurityException {
        TitleStartAction action;
        logger.info("start(" + title.getName() + ", restart=" + restart + ")");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SelectPermission(title.getLocator(), "own"));
        }
        if (this.state == 2) {
            logger.error("start() failed: Title Context already destroyed");
            throw new IllegalStateException();
        }
        if (!(restart || this.title != null && title.equals(this.title))) {
            logger.info("start(): title changed,  force restart");
            restart = true;
        }
        if (!BDJLoader.load((TitleImpl)title, restart, action = new TitleStartAction(this, (TitleImpl)title))) {
            action.loaderDone(false);
        }
    }

    public void select(Service service) throws SecurityException {
        logger.info("select(" + service.getName() + ")");
        this.start((Title)service, true);
    }

    public void select(Locator[] locators) throws InvalidLocatorException, InvalidServiceComponentException, SecurityException {
        Logger.unimplemented("TitleContextImpl", "select(Locator[])");
        for (int i = 0; i < locators.length; ++i) {
            logger.info("  [" + i + "]: " + locators[i]);
        }
        this.select(SIManager.createInstance().getService(locators[0]));
    }

    public void stop() throws SecurityException {
        logger.info("stop()");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ServiceContextPermission("stop", "own"));
        }
        if (this.state == 2) {
            throw new IllegalStateException();
        }
        TitleStopAction action = new TitleStopAction(this);
        if (!BDJLoader.unload(action)) {
            action.loaderDone(false);
        }
    }

    public void destroy() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ServiceContextPermission("stop", "own"));
        }
        if (this.state != 2) {
            this.state = 2;
            TitleStopAction action = new TitleStopAction(this);
            if (!BDJLoader.unload(action)) {
                action.loaderDone(false);
            }
        }
    }

    public void addListener(ServiceContextListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ServiceContextListener listener) {
        this.listeners.remove(listener);
    }

    public void presentationChanged() {
        if (this.state == 1) {
            this.postEvent(new PresentationChangedEvent(this));
        }
    }

    private void postEvent(ServiceContextEvent event) {
        this.listeners.putCallback(event);
    }

    private static class TitleStopAction
    implements BDJLoaderCallback {
        private TitleContextImpl context;

        private TitleStopAction(TitleContextImpl context) {
            this.context = context;
        }

        public void loaderDone(boolean succeed) {
            if (succeed) {
                this.context.postEvent(new PresentationTerminatedEvent(this.context, 5));
                if (this.context.state == 2) {
                    this.context.postEvent(new ServiceContextDestroyedEvent(this.context));
                } else {
                    this.context.state = 0;
                }
            } else {
                this.context.postEvent(new SelectionFailedEvent(this.context, 255));
            }
        }
    }

    private static class TitleStartAction
    implements BDJLoaderCallback {
        private TitleContextImpl context;
        private TitleImpl title;

        private TitleStartAction(TitleContextImpl context, TitleImpl title) {
            this.context = context;
            this.title = title;
        }

        public void loaderDone(boolean succeed) {
            if (succeed) {
                this.context.title = this.title;
                this.context.state = 1;
                this.context.postEvent(new NormalContentEvent(this.context));
            } else {
                this.context.postEvent(new SelectionFailedEvent(this.context, 255));
            }
        }
    }
}

