// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: server/application/application.proto

// Application Service
//
// Application Service API performs CRUD actions against application resources

package application

import (
	context "context"
	fmt "fmt"
	v1alpha1 "github.com/argoproj/argo-cd/v2/pkg/apis/application/v1alpha1"
	apiclient "github.com/argoproj/argo-cd/v2/reposerver/apiclient"
	github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
	proto "github.com/gogo/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	v11 "k8s.io/api/core/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// ApplicationQuery is a query for application resources. When getting multiple applications, the "projects" field acts
// as a filter. When getting a single application, you may specify either zero or one project. If you specify zero
// projects, the application will be returned regardless of which project it belongs to (assuming you have access). If
// you specify one project, the application will only be returned if it exists and belongs to the specified project.
// Otherwise you will receive a 404.
type ApplicationQuery struct {
	// the application's name
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// forces application reconciliation if set to 'hard'
	Refresh *string `protobuf:"bytes,2,opt,name=refresh" json:"refresh,omitempty"`
	// the project names to restrict returned list applications
	Projects []string `protobuf:"bytes,3,rep,name=projects" json:"projects,omitempty"`
	// when specified with a watch call, shows changes that occur after that particular version of a resource.
	ResourceVersion *string `protobuf:"bytes,4,opt,name=resourceVersion" json:"resourceVersion,omitempty"`
	// the selector to restrict returned list to applications only with matched labels
	Selector *string `protobuf:"bytes,5,opt,name=selector" json:"selector,omitempty"`
	// the repoURL to restrict returned list applications
	Repo *string `protobuf:"bytes,6,opt,name=repo" json:"repo,omitempty"`
	// the application's namespace
	AppNamespace *string `protobuf:"bytes,7,opt,name=appNamespace" json:"appNamespace,omitempty"`
	// the project names to restrict returned list applications (legacy name for backwards-compatibility)
	Project              []string `protobuf:"bytes,8,rep,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationQuery) Reset()         { *m = ApplicationQuery{} }
func (m *ApplicationQuery) String() string { return proto.CompactTextString(m) }
func (*ApplicationQuery) ProtoMessage()    {}
func (*ApplicationQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{0}
}
func (m *ApplicationQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationQuery.Merge(m, src)
}
func (m *ApplicationQuery) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationQuery.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationQuery proto.InternalMessageInfo

func (m *ApplicationQuery) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationQuery) GetRefresh() string {
	if m != nil && m.Refresh != nil {
		return *m.Refresh
	}
	return ""
}

func (m *ApplicationQuery) GetProjects() []string {
	if m != nil {
		return m.Projects
	}
	return nil
}

func (m *ApplicationQuery) GetResourceVersion() string {
	if m != nil && m.ResourceVersion != nil {
		return *m.ResourceVersion
	}
	return ""
}

func (m *ApplicationQuery) GetSelector() string {
	if m != nil && m.Selector != nil {
		return *m.Selector
	}
	return ""
}

func (m *ApplicationQuery) GetRepo() string {
	if m != nil && m.Repo != nil {
		return *m.Repo
	}
	return ""
}

func (m *ApplicationQuery) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationQuery) GetProject() []string {
	if m != nil {
		return m.Project
	}
	return nil
}

type NodeQuery struct {
	// the application's name
	Name                 *string  `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,2,opt,name=appNamespace" json:"appNamespace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeQuery) Reset()         { *m = NodeQuery{} }
func (m *NodeQuery) String() string { return proto.CompactTextString(m) }
func (*NodeQuery) ProtoMessage()    {}
func (*NodeQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{1}
}
func (m *NodeQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeQuery.Merge(m, src)
}
func (m *NodeQuery) XXX_Size() int {
	return m.Size()
}
func (m *NodeQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeQuery.DiscardUnknown(m)
}

var xxx_messageInfo_NodeQuery proto.InternalMessageInfo

func (m *NodeQuery) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *NodeQuery) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

type RevisionMetadataQuery struct {
	// the application's name
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// the revision of the app
	Revision *string `protobuf:"bytes,2,req,name=revision" json:"revision,omitempty"`
	// the application's namespace
	AppNamespace         *string  `protobuf:"bytes,3,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,4,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RevisionMetadataQuery) Reset()         { *m = RevisionMetadataQuery{} }
func (m *RevisionMetadataQuery) String() string { return proto.CompactTextString(m) }
func (*RevisionMetadataQuery) ProtoMessage()    {}
func (*RevisionMetadataQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{2}
}
func (m *RevisionMetadataQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RevisionMetadataQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RevisionMetadataQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RevisionMetadataQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RevisionMetadataQuery.Merge(m, src)
}
func (m *RevisionMetadataQuery) XXX_Size() int {
	return m.Size()
}
func (m *RevisionMetadataQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_RevisionMetadataQuery.DiscardUnknown(m)
}

var xxx_messageInfo_RevisionMetadataQuery proto.InternalMessageInfo

func (m *RevisionMetadataQuery) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *RevisionMetadataQuery) GetRevision() string {
	if m != nil && m.Revision != nil {
		return *m.Revision
	}
	return ""
}

func (m *RevisionMetadataQuery) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *RevisionMetadataQuery) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

// ApplicationEventsQuery is a query for application resource events
type ApplicationResourceEventsQuery struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	ResourceNamespace    *string  `protobuf:"bytes,2,opt,name=resourceNamespace" json:"resourceNamespace,omitempty"`
	ResourceName         *string  `protobuf:"bytes,3,opt,name=resourceName" json:"resourceName,omitempty"`
	ResourceUID          *string  `protobuf:"bytes,4,opt,name=resourceUID" json:"resourceUID,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,5,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,6,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationResourceEventsQuery) Reset()         { *m = ApplicationResourceEventsQuery{} }
func (m *ApplicationResourceEventsQuery) String() string { return proto.CompactTextString(m) }
func (*ApplicationResourceEventsQuery) ProtoMessage()    {}
func (*ApplicationResourceEventsQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{3}
}
func (m *ApplicationResourceEventsQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationResourceEventsQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationResourceEventsQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationResourceEventsQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationResourceEventsQuery.Merge(m, src)
}
func (m *ApplicationResourceEventsQuery) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationResourceEventsQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationResourceEventsQuery.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationResourceEventsQuery proto.InternalMessageInfo

func (m *ApplicationResourceEventsQuery) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationResourceEventsQuery) GetResourceNamespace() string {
	if m != nil && m.ResourceNamespace != nil {
		return *m.ResourceNamespace
	}
	return ""
}

func (m *ApplicationResourceEventsQuery) GetResourceName() string {
	if m != nil && m.ResourceName != nil {
		return *m.ResourceName
	}
	return ""
}

func (m *ApplicationResourceEventsQuery) GetResourceUID() string {
	if m != nil && m.ResourceUID != nil {
		return *m.ResourceUID
	}
	return ""
}

func (m *ApplicationResourceEventsQuery) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationResourceEventsQuery) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

// ManifestQuery is a query for manifest resources
type ApplicationManifestQuery struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Revision             *string  `protobuf:"bytes,2,opt,name=revision" json:"revision,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,3,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,4,opt,name=project" json:"project,omitempty"`
	SourcePositions      []int64  `protobuf:"varint,5,rep,name=sourcePositions" json:"sourcePositions,omitempty"`
	Revisions            []string `protobuf:"bytes,6,rep,name=revisions" json:"revisions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationManifestQuery) Reset()         { *m = ApplicationManifestQuery{} }
func (m *ApplicationManifestQuery) String() string { return proto.CompactTextString(m) }
func (*ApplicationManifestQuery) ProtoMessage()    {}
func (*ApplicationManifestQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{4}
}
func (m *ApplicationManifestQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationManifestQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationManifestQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationManifestQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationManifestQuery.Merge(m, src)
}
func (m *ApplicationManifestQuery) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationManifestQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationManifestQuery.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationManifestQuery proto.InternalMessageInfo

func (m *ApplicationManifestQuery) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationManifestQuery) GetRevision() string {
	if m != nil && m.Revision != nil {
		return *m.Revision
	}
	return ""
}

func (m *ApplicationManifestQuery) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationManifestQuery) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

func (m *ApplicationManifestQuery) GetSourcePositions() []int64 {
	if m != nil {
		return m.SourcePositions
	}
	return nil
}

func (m *ApplicationManifestQuery) GetRevisions() []string {
	if m != nil {
		return m.Revisions
	}
	return nil
}

type FileChunk struct {
	Chunk                []byte   `protobuf:"bytes,1,req,name=chunk" json:"chunk,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FileChunk) Reset()         { *m = FileChunk{} }
func (m *FileChunk) String() string { return proto.CompactTextString(m) }
func (*FileChunk) ProtoMessage()    {}
func (*FileChunk) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{5}
}
func (m *FileChunk) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FileChunk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FileChunk.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FileChunk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileChunk.Merge(m, src)
}
func (m *FileChunk) XXX_Size() int {
	return m.Size()
}
func (m *FileChunk) XXX_DiscardUnknown() {
	xxx_messageInfo_FileChunk.DiscardUnknown(m)
}

var xxx_messageInfo_FileChunk proto.InternalMessageInfo

func (m *FileChunk) GetChunk() []byte {
	if m != nil {
		return m.Chunk
	}
	return nil
}

type ApplicationManifestQueryWithFiles struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Checksum             *string  `protobuf:"bytes,2,req,name=checksum" json:"checksum,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,3,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,4,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationManifestQueryWithFiles) Reset()         { *m = ApplicationManifestQueryWithFiles{} }
func (m *ApplicationManifestQueryWithFiles) String() string { return proto.CompactTextString(m) }
func (*ApplicationManifestQueryWithFiles) ProtoMessage()    {}
func (*ApplicationManifestQueryWithFiles) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{6}
}
func (m *ApplicationManifestQueryWithFiles) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationManifestQueryWithFiles) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationManifestQueryWithFiles.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationManifestQueryWithFiles) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationManifestQueryWithFiles.Merge(m, src)
}
func (m *ApplicationManifestQueryWithFiles) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationManifestQueryWithFiles) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationManifestQueryWithFiles.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationManifestQueryWithFiles proto.InternalMessageInfo

func (m *ApplicationManifestQueryWithFiles) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationManifestQueryWithFiles) GetChecksum() string {
	if m != nil && m.Checksum != nil {
		return *m.Checksum
	}
	return ""
}

func (m *ApplicationManifestQueryWithFiles) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationManifestQueryWithFiles) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type ApplicationManifestQueryWithFilesWrapper struct {
	// Types that are valid to be assigned to Part:
	//	*ApplicationManifestQueryWithFilesWrapper_Query
	//	*ApplicationManifestQueryWithFilesWrapper_Chunk
	Part                 isApplicationManifestQueryWithFilesWrapper_Part `protobuf_oneof:"part"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *ApplicationManifestQueryWithFilesWrapper) Reset() {
	*m = ApplicationManifestQueryWithFilesWrapper{}
}
func (m *ApplicationManifestQueryWithFilesWrapper) String() string { return proto.CompactTextString(m) }
func (*ApplicationManifestQueryWithFilesWrapper) ProtoMessage()    {}
func (*ApplicationManifestQueryWithFilesWrapper) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{7}
}
func (m *ApplicationManifestQueryWithFilesWrapper) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationManifestQueryWithFilesWrapper) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationManifestQueryWithFilesWrapper.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationManifestQueryWithFilesWrapper) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationManifestQueryWithFilesWrapper.Merge(m, src)
}
func (m *ApplicationManifestQueryWithFilesWrapper) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationManifestQueryWithFilesWrapper) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationManifestQueryWithFilesWrapper.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationManifestQueryWithFilesWrapper proto.InternalMessageInfo

type isApplicationManifestQueryWithFilesWrapper_Part interface {
	isApplicationManifestQueryWithFilesWrapper_Part()
	MarshalTo([]byte) (int, error)
	Size() int
}

type ApplicationManifestQueryWithFilesWrapper_Query struct {
	Query *ApplicationManifestQueryWithFiles `protobuf:"bytes,1,opt,name=query,oneof" json:"query,omitempty"`
}
type ApplicationManifestQueryWithFilesWrapper_Chunk struct {
	Chunk *FileChunk `protobuf:"bytes,2,opt,name=chunk,oneof" json:"chunk,omitempty"`
}

func (*ApplicationManifestQueryWithFilesWrapper_Query) isApplicationManifestQueryWithFilesWrapper_Part() {
}
func (*ApplicationManifestQueryWithFilesWrapper_Chunk) isApplicationManifestQueryWithFilesWrapper_Part() {
}

func (m *ApplicationManifestQueryWithFilesWrapper) GetPart() isApplicationManifestQueryWithFilesWrapper_Part {
	if m != nil {
		return m.Part
	}
	return nil
}

func (m *ApplicationManifestQueryWithFilesWrapper) GetQuery() *ApplicationManifestQueryWithFiles {
	if x, ok := m.GetPart().(*ApplicationManifestQueryWithFilesWrapper_Query); ok {
		return x.Query
	}
	return nil
}

func (m *ApplicationManifestQueryWithFilesWrapper) GetChunk() *FileChunk {
	if x, ok := m.GetPart().(*ApplicationManifestQueryWithFilesWrapper_Chunk); ok {
		return x.Chunk
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ApplicationManifestQueryWithFilesWrapper) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ApplicationManifestQueryWithFilesWrapper_Query)(nil),
		(*ApplicationManifestQueryWithFilesWrapper_Chunk)(nil),
	}
}

type ApplicationResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationResponse) Reset()         { *m = ApplicationResponse{} }
func (m *ApplicationResponse) String() string { return proto.CompactTextString(m) }
func (*ApplicationResponse) ProtoMessage()    {}
func (*ApplicationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{8}
}
func (m *ApplicationResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationResponse.Merge(m, src)
}
func (m *ApplicationResponse) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationResponse proto.InternalMessageInfo

type ApplicationCreateRequest struct {
	Application          *v1alpha1.Application `protobuf:"bytes,1,req,name=application" json:"application,omitempty"`
	Upsert               *bool                 `protobuf:"varint,2,opt,name=upsert" json:"upsert,omitempty"`
	Validate             *bool                 `protobuf:"varint,3,opt,name=validate" json:"validate,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ApplicationCreateRequest) Reset()         { *m = ApplicationCreateRequest{} }
func (m *ApplicationCreateRequest) String() string { return proto.CompactTextString(m) }
func (*ApplicationCreateRequest) ProtoMessage()    {}
func (*ApplicationCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{9}
}
func (m *ApplicationCreateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationCreateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationCreateRequest.Merge(m, src)
}
func (m *ApplicationCreateRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationCreateRequest proto.InternalMessageInfo

func (m *ApplicationCreateRequest) GetApplication() *v1alpha1.Application {
	if m != nil {
		return m.Application
	}
	return nil
}

func (m *ApplicationCreateRequest) GetUpsert() bool {
	if m != nil && m.Upsert != nil {
		return *m.Upsert
	}
	return false
}

func (m *ApplicationCreateRequest) GetValidate() bool {
	if m != nil && m.Validate != nil {
		return *m.Validate
	}
	return false
}

type ApplicationUpdateRequest struct {
	Application          *v1alpha1.Application `protobuf:"bytes,1,req,name=application" json:"application,omitempty"`
	Validate             *bool                 `protobuf:"varint,2,opt,name=validate" json:"validate,omitempty"`
	Project              *string               `protobuf:"bytes,3,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ApplicationUpdateRequest) Reset()         { *m = ApplicationUpdateRequest{} }
func (m *ApplicationUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*ApplicationUpdateRequest) ProtoMessage()    {}
func (*ApplicationUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{10}
}
func (m *ApplicationUpdateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationUpdateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationUpdateRequest.Merge(m, src)
}
func (m *ApplicationUpdateRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationUpdateRequest proto.InternalMessageInfo

func (m *ApplicationUpdateRequest) GetApplication() *v1alpha1.Application {
	if m != nil {
		return m.Application
	}
	return nil
}

func (m *ApplicationUpdateRequest) GetValidate() bool {
	if m != nil && m.Validate != nil {
		return *m.Validate
	}
	return false
}

func (m *ApplicationUpdateRequest) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type ApplicationDeleteRequest struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Cascade              *bool    `protobuf:"varint,2,opt,name=cascade" json:"cascade,omitempty"`
	PropagationPolicy    *string  `protobuf:"bytes,3,opt,name=propagationPolicy" json:"propagationPolicy,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,4,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,5,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationDeleteRequest) Reset()         { *m = ApplicationDeleteRequest{} }
func (m *ApplicationDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*ApplicationDeleteRequest) ProtoMessage()    {}
func (*ApplicationDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{11}
}
func (m *ApplicationDeleteRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationDeleteRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationDeleteRequest.Merge(m, src)
}
func (m *ApplicationDeleteRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationDeleteRequest proto.InternalMessageInfo

func (m *ApplicationDeleteRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationDeleteRequest) GetCascade() bool {
	if m != nil && m.Cascade != nil {
		return *m.Cascade
	}
	return false
}

func (m *ApplicationDeleteRequest) GetPropagationPolicy() string {
	if m != nil && m.PropagationPolicy != nil {
		return *m.PropagationPolicy
	}
	return ""
}

func (m *ApplicationDeleteRequest) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationDeleteRequest) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type SyncOptions struct {
	Items                []string `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SyncOptions) Reset()         { *m = SyncOptions{} }
func (m *SyncOptions) String() string { return proto.CompactTextString(m) }
func (*SyncOptions) ProtoMessage()    {}
func (*SyncOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{12}
}
func (m *SyncOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SyncOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SyncOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SyncOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncOptions.Merge(m, src)
}
func (m *SyncOptions) XXX_Size() int {
	return m.Size()
}
func (m *SyncOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncOptions.DiscardUnknown(m)
}

var xxx_messageInfo_SyncOptions proto.InternalMessageInfo

func (m *SyncOptions) GetItems() []string {
	if m != nil {
		return m.Items
	}
	return nil
}

// ApplicationSyncRequest is a request to apply the config state to live state
type ApplicationSyncRequest struct {
	Name                 *string                           `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Revision             *string                           `protobuf:"bytes,2,opt,name=revision" json:"revision,omitempty"`
	DryRun               *bool                             `protobuf:"varint,3,opt,name=dryRun" json:"dryRun,omitempty"`
	Prune                *bool                             `protobuf:"varint,4,opt,name=prune" json:"prune,omitempty"`
	Strategy             *v1alpha1.SyncStrategy            `protobuf:"bytes,5,opt,name=strategy" json:"strategy,omitempty"`
	Resources            []*v1alpha1.SyncOperationResource `protobuf:"bytes,7,rep,name=resources" json:"resources,omitempty"`
	Manifests            []string                          `protobuf:"bytes,8,rep,name=manifests" json:"manifests,omitempty"`
	Infos                []*v1alpha1.Info                  `protobuf:"bytes,9,rep,name=infos" json:"infos,omitempty"`
	RetryStrategy        *v1alpha1.RetryStrategy           `protobuf:"bytes,10,opt,name=retryStrategy" json:"retryStrategy,omitempty"`
	SyncOptions          *SyncOptions                      `protobuf:"bytes,11,opt,name=syncOptions" json:"syncOptions,omitempty"`
	AppNamespace         *string                           `protobuf:"bytes,12,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string                           `protobuf:"bytes,13,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *ApplicationSyncRequest) Reset()         { *m = ApplicationSyncRequest{} }
func (m *ApplicationSyncRequest) String() string { return proto.CompactTextString(m) }
func (*ApplicationSyncRequest) ProtoMessage()    {}
func (*ApplicationSyncRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{13}
}
func (m *ApplicationSyncRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationSyncRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationSyncRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationSyncRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationSyncRequest.Merge(m, src)
}
func (m *ApplicationSyncRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationSyncRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationSyncRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationSyncRequest proto.InternalMessageInfo

func (m *ApplicationSyncRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationSyncRequest) GetRevision() string {
	if m != nil && m.Revision != nil {
		return *m.Revision
	}
	return ""
}

func (m *ApplicationSyncRequest) GetDryRun() bool {
	if m != nil && m.DryRun != nil {
		return *m.DryRun
	}
	return false
}

func (m *ApplicationSyncRequest) GetPrune() bool {
	if m != nil && m.Prune != nil {
		return *m.Prune
	}
	return false
}

func (m *ApplicationSyncRequest) GetStrategy() *v1alpha1.SyncStrategy {
	if m != nil {
		return m.Strategy
	}
	return nil
}

func (m *ApplicationSyncRequest) GetResources() []*v1alpha1.SyncOperationResource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ApplicationSyncRequest) GetManifests() []string {
	if m != nil {
		return m.Manifests
	}
	return nil
}

func (m *ApplicationSyncRequest) GetInfos() []*v1alpha1.Info {
	if m != nil {
		return m.Infos
	}
	return nil
}

func (m *ApplicationSyncRequest) GetRetryStrategy() *v1alpha1.RetryStrategy {
	if m != nil {
		return m.RetryStrategy
	}
	return nil
}

func (m *ApplicationSyncRequest) GetSyncOptions() *SyncOptions {
	if m != nil {
		return m.SyncOptions
	}
	return nil
}

func (m *ApplicationSyncRequest) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationSyncRequest) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

// ApplicationUpdateSpecRequest is a request to update application spec
type ApplicationUpdateSpecRequest struct {
	Name                 *string                   `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Spec                 *v1alpha1.ApplicationSpec `protobuf:"bytes,2,req,name=spec" json:"spec,omitempty"`
	Validate             *bool                     `protobuf:"varint,3,opt,name=validate" json:"validate,omitempty"`
	AppNamespace         *string                   `protobuf:"bytes,4,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string                   `protobuf:"bytes,5,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ApplicationUpdateSpecRequest) Reset()         { *m = ApplicationUpdateSpecRequest{} }
func (m *ApplicationUpdateSpecRequest) String() string { return proto.CompactTextString(m) }
func (*ApplicationUpdateSpecRequest) ProtoMessage()    {}
func (*ApplicationUpdateSpecRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{14}
}
func (m *ApplicationUpdateSpecRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationUpdateSpecRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationUpdateSpecRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationUpdateSpecRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationUpdateSpecRequest.Merge(m, src)
}
func (m *ApplicationUpdateSpecRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationUpdateSpecRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationUpdateSpecRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationUpdateSpecRequest proto.InternalMessageInfo

func (m *ApplicationUpdateSpecRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationUpdateSpecRequest) GetSpec() *v1alpha1.ApplicationSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *ApplicationUpdateSpecRequest) GetValidate() bool {
	if m != nil && m.Validate != nil {
		return *m.Validate
	}
	return false
}

func (m *ApplicationUpdateSpecRequest) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationUpdateSpecRequest) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

// ApplicationPatchRequest is a request to patch an application
type ApplicationPatchRequest struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Patch                *string  `protobuf:"bytes,2,req,name=patch" json:"patch,omitempty"`
	PatchType            *string  `protobuf:"bytes,3,req,name=patchType" json:"patchType,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,5,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,6,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationPatchRequest) Reset()         { *m = ApplicationPatchRequest{} }
func (m *ApplicationPatchRequest) String() string { return proto.CompactTextString(m) }
func (*ApplicationPatchRequest) ProtoMessage()    {}
func (*ApplicationPatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{15}
}
func (m *ApplicationPatchRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationPatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationPatchRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationPatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationPatchRequest.Merge(m, src)
}
func (m *ApplicationPatchRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationPatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationPatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationPatchRequest proto.InternalMessageInfo

func (m *ApplicationPatchRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationPatchRequest) GetPatch() string {
	if m != nil && m.Patch != nil {
		return *m.Patch
	}
	return ""
}

func (m *ApplicationPatchRequest) GetPatchType() string {
	if m != nil && m.PatchType != nil {
		return *m.PatchType
	}
	return ""
}

func (m *ApplicationPatchRequest) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationPatchRequest) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type ApplicationRollbackRequest struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Id                   *int64   `protobuf:"varint,2,req,name=id" json:"id,omitempty"`
	DryRun               *bool    `protobuf:"varint,3,opt,name=dryRun" json:"dryRun,omitempty"`
	Prune                *bool    `protobuf:"varint,4,opt,name=prune" json:"prune,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,6,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,7,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationRollbackRequest) Reset()         { *m = ApplicationRollbackRequest{} }
func (m *ApplicationRollbackRequest) String() string { return proto.CompactTextString(m) }
func (*ApplicationRollbackRequest) ProtoMessage()    {}
func (*ApplicationRollbackRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{16}
}
func (m *ApplicationRollbackRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationRollbackRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationRollbackRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationRollbackRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationRollbackRequest.Merge(m, src)
}
func (m *ApplicationRollbackRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationRollbackRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationRollbackRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationRollbackRequest proto.InternalMessageInfo

func (m *ApplicationRollbackRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationRollbackRequest) GetId() int64 {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return 0
}

func (m *ApplicationRollbackRequest) GetDryRun() bool {
	if m != nil && m.DryRun != nil {
		return *m.DryRun
	}
	return false
}

func (m *ApplicationRollbackRequest) GetPrune() bool {
	if m != nil && m.Prune != nil {
		return *m.Prune
	}
	return false
}

func (m *ApplicationRollbackRequest) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationRollbackRequest) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type ApplicationResourceRequest struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Namespace            *string  `protobuf:"bytes,2,opt,name=namespace" json:"namespace,omitempty"`
	ResourceName         *string  `protobuf:"bytes,3,req,name=resourceName" json:"resourceName,omitempty"`
	Version              *string  `protobuf:"bytes,4,req,name=version" json:"version,omitempty"`
	Group                *string  `protobuf:"bytes,5,opt,name=group" json:"group,omitempty"`
	Kind                 *string  `protobuf:"bytes,6,req,name=kind" json:"kind,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,7,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,8,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationResourceRequest) Reset()         { *m = ApplicationResourceRequest{} }
func (m *ApplicationResourceRequest) String() string { return proto.CompactTextString(m) }
func (*ApplicationResourceRequest) ProtoMessage()    {}
func (*ApplicationResourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{17}
}
func (m *ApplicationResourceRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationResourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationResourceRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationResourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationResourceRequest.Merge(m, src)
}
func (m *ApplicationResourceRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationResourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationResourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationResourceRequest proto.InternalMessageInfo

func (m *ApplicationResourceRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationResourceRequest) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *ApplicationResourceRequest) GetResourceName() string {
	if m != nil && m.ResourceName != nil {
		return *m.ResourceName
	}
	return ""
}

func (m *ApplicationResourceRequest) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

func (m *ApplicationResourceRequest) GetGroup() string {
	if m != nil && m.Group != nil {
		return *m.Group
	}
	return ""
}

func (m *ApplicationResourceRequest) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

func (m *ApplicationResourceRequest) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationResourceRequest) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type ApplicationResourcePatchRequest struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Namespace            *string  `protobuf:"bytes,2,opt,name=namespace" json:"namespace,omitempty"`
	ResourceName         *string  `protobuf:"bytes,3,req,name=resourceName" json:"resourceName,omitempty"`
	Version              *string  `protobuf:"bytes,4,req,name=version" json:"version,omitempty"`
	Group                *string  `protobuf:"bytes,5,opt,name=group" json:"group,omitempty"`
	Kind                 *string  `protobuf:"bytes,6,req,name=kind" json:"kind,omitempty"`
	Patch                *string  `protobuf:"bytes,7,req,name=patch" json:"patch,omitempty"`
	PatchType            *string  `protobuf:"bytes,8,req,name=patchType" json:"patchType,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,9,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,10,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationResourcePatchRequest) Reset()         { *m = ApplicationResourcePatchRequest{} }
func (m *ApplicationResourcePatchRequest) String() string { return proto.CompactTextString(m) }
func (*ApplicationResourcePatchRequest) ProtoMessage()    {}
func (*ApplicationResourcePatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{18}
}
func (m *ApplicationResourcePatchRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationResourcePatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationResourcePatchRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationResourcePatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationResourcePatchRequest.Merge(m, src)
}
func (m *ApplicationResourcePatchRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationResourcePatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationResourcePatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationResourcePatchRequest proto.InternalMessageInfo

func (m *ApplicationResourcePatchRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationResourcePatchRequest) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *ApplicationResourcePatchRequest) GetResourceName() string {
	if m != nil && m.ResourceName != nil {
		return *m.ResourceName
	}
	return ""
}

func (m *ApplicationResourcePatchRequest) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

func (m *ApplicationResourcePatchRequest) GetGroup() string {
	if m != nil && m.Group != nil {
		return *m.Group
	}
	return ""
}

func (m *ApplicationResourcePatchRequest) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

func (m *ApplicationResourcePatchRequest) GetPatch() string {
	if m != nil && m.Patch != nil {
		return *m.Patch
	}
	return ""
}

func (m *ApplicationResourcePatchRequest) GetPatchType() string {
	if m != nil && m.PatchType != nil {
		return *m.PatchType
	}
	return ""
}

func (m *ApplicationResourcePatchRequest) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationResourcePatchRequest) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type ApplicationResourceDeleteRequest struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Namespace            *string  `protobuf:"bytes,2,opt,name=namespace" json:"namespace,omitempty"`
	ResourceName         *string  `protobuf:"bytes,3,req,name=resourceName" json:"resourceName,omitempty"`
	Version              *string  `protobuf:"bytes,4,req,name=version" json:"version,omitempty"`
	Group                *string  `protobuf:"bytes,5,opt,name=group" json:"group,omitempty"`
	Kind                 *string  `protobuf:"bytes,6,req,name=kind" json:"kind,omitempty"`
	Force                *bool    `protobuf:"varint,7,opt,name=force" json:"force,omitempty"`
	Orphan               *bool    `protobuf:"varint,8,opt,name=orphan" json:"orphan,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,9,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,10,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationResourceDeleteRequest) Reset()         { *m = ApplicationResourceDeleteRequest{} }
func (m *ApplicationResourceDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*ApplicationResourceDeleteRequest) ProtoMessage()    {}
func (*ApplicationResourceDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{19}
}
func (m *ApplicationResourceDeleteRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationResourceDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationResourceDeleteRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationResourceDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationResourceDeleteRequest.Merge(m, src)
}
func (m *ApplicationResourceDeleteRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationResourceDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationResourceDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationResourceDeleteRequest proto.InternalMessageInfo

func (m *ApplicationResourceDeleteRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationResourceDeleteRequest) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *ApplicationResourceDeleteRequest) GetResourceName() string {
	if m != nil && m.ResourceName != nil {
		return *m.ResourceName
	}
	return ""
}

func (m *ApplicationResourceDeleteRequest) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

func (m *ApplicationResourceDeleteRequest) GetGroup() string {
	if m != nil && m.Group != nil {
		return *m.Group
	}
	return ""
}

func (m *ApplicationResourceDeleteRequest) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

func (m *ApplicationResourceDeleteRequest) GetForce() bool {
	if m != nil && m.Force != nil {
		return *m.Force
	}
	return false
}

func (m *ApplicationResourceDeleteRequest) GetOrphan() bool {
	if m != nil && m.Orphan != nil {
		return *m.Orphan
	}
	return false
}

func (m *ApplicationResourceDeleteRequest) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationResourceDeleteRequest) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type ResourceActionRunRequest struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Namespace            *string  `protobuf:"bytes,2,opt,name=namespace" json:"namespace,omitempty"`
	ResourceName         *string  `protobuf:"bytes,3,req,name=resourceName" json:"resourceName,omitempty"`
	Version              *string  `protobuf:"bytes,4,req,name=version" json:"version,omitempty"`
	Group                *string  `protobuf:"bytes,5,opt,name=group" json:"group,omitempty"`
	Kind                 *string  `protobuf:"bytes,6,req,name=kind" json:"kind,omitempty"`
	Action               *string  `protobuf:"bytes,7,req,name=action" json:"action,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,8,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,9,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourceActionRunRequest) Reset()         { *m = ResourceActionRunRequest{} }
func (m *ResourceActionRunRequest) String() string { return proto.CompactTextString(m) }
func (*ResourceActionRunRequest) ProtoMessage()    {}
func (*ResourceActionRunRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{20}
}
func (m *ResourceActionRunRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceActionRunRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceActionRunRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceActionRunRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceActionRunRequest.Merge(m, src)
}
func (m *ResourceActionRunRequest) XXX_Size() int {
	return m.Size()
}
func (m *ResourceActionRunRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceActionRunRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceActionRunRequest proto.InternalMessageInfo

func (m *ResourceActionRunRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ResourceActionRunRequest) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *ResourceActionRunRequest) GetResourceName() string {
	if m != nil && m.ResourceName != nil {
		return *m.ResourceName
	}
	return ""
}

func (m *ResourceActionRunRequest) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

func (m *ResourceActionRunRequest) GetGroup() string {
	if m != nil && m.Group != nil {
		return *m.Group
	}
	return ""
}

func (m *ResourceActionRunRequest) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

func (m *ResourceActionRunRequest) GetAction() string {
	if m != nil && m.Action != nil {
		return *m.Action
	}
	return ""
}

func (m *ResourceActionRunRequest) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ResourceActionRunRequest) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type ResourceActionsListResponse struct {
	Actions              []*v1alpha1.ResourceAction `protobuf:"bytes,1,rep,name=actions" json:"actions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ResourceActionsListResponse) Reset()         { *m = ResourceActionsListResponse{} }
func (m *ResourceActionsListResponse) String() string { return proto.CompactTextString(m) }
func (*ResourceActionsListResponse) ProtoMessage()    {}
func (*ResourceActionsListResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{21}
}
func (m *ResourceActionsListResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceActionsListResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceActionsListResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceActionsListResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceActionsListResponse.Merge(m, src)
}
func (m *ResourceActionsListResponse) XXX_Size() int {
	return m.Size()
}
func (m *ResourceActionsListResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceActionsListResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceActionsListResponse proto.InternalMessageInfo

func (m *ResourceActionsListResponse) GetActions() []*v1alpha1.ResourceAction {
	if m != nil {
		return m.Actions
	}
	return nil
}

type ApplicationResourceResponse struct {
	Manifest             *string  `protobuf:"bytes,1,req,name=manifest" json:"manifest,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationResourceResponse) Reset()         { *m = ApplicationResourceResponse{} }
func (m *ApplicationResourceResponse) String() string { return proto.CompactTextString(m) }
func (*ApplicationResourceResponse) ProtoMessage()    {}
func (*ApplicationResourceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{22}
}
func (m *ApplicationResourceResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationResourceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationResourceResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationResourceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationResourceResponse.Merge(m, src)
}
func (m *ApplicationResourceResponse) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationResourceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationResourceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationResourceResponse proto.InternalMessageInfo

func (m *ApplicationResourceResponse) GetManifest() string {
	if m != nil && m.Manifest != nil {
		return *m.Manifest
	}
	return ""
}

type ApplicationPodLogsQuery struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Namespace            *string  `protobuf:"bytes,2,opt,name=namespace" json:"namespace,omitempty"`
	PodName              *string  `protobuf:"bytes,3,opt,name=podName" json:"podName,omitempty"`
	Container            *string  `protobuf:"bytes,4,opt,name=container" json:"container,omitempty"`
	SinceSeconds         *int64   `protobuf:"varint,5,opt,name=sinceSeconds" json:"sinceSeconds,omitempty"`
	SinceTime            *v1.Time `protobuf:"bytes,6,opt,name=sinceTime" json:"sinceTime,omitempty"`
	TailLines            *int64   `protobuf:"varint,7,opt,name=tailLines" json:"tailLines,omitempty"`
	Follow               *bool    `protobuf:"varint,8,opt,name=follow" json:"follow,omitempty"`
	UntilTime            *string  `protobuf:"bytes,9,opt,name=untilTime" json:"untilTime,omitempty"`
	Filter               *string  `protobuf:"bytes,10,opt,name=filter" json:"filter,omitempty"`
	Kind                 *string  `protobuf:"bytes,11,opt,name=kind" json:"kind,omitempty"`
	Group                *string  `protobuf:"bytes,12,opt,name=group" json:"group,omitempty"`
	ResourceName         *string  `protobuf:"bytes,13,opt,name=resourceName" json:"resourceName,omitempty"`
	Previous             *bool    `protobuf:"varint,14,opt,name=previous" json:"previous,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,15,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,16,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationPodLogsQuery) Reset()         { *m = ApplicationPodLogsQuery{} }
func (m *ApplicationPodLogsQuery) String() string { return proto.CompactTextString(m) }
func (*ApplicationPodLogsQuery) ProtoMessage()    {}
func (*ApplicationPodLogsQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{23}
}
func (m *ApplicationPodLogsQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationPodLogsQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationPodLogsQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationPodLogsQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationPodLogsQuery.Merge(m, src)
}
func (m *ApplicationPodLogsQuery) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationPodLogsQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationPodLogsQuery.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationPodLogsQuery proto.InternalMessageInfo

func (m *ApplicationPodLogsQuery) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationPodLogsQuery) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *ApplicationPodLogsQuery) GetPodName() string {
	if m != nil && m.PodName != nil {
		return *m.PodName
	}
	return ""
}

func (m *ApplicationPodLogsQuery) GetContainer() string {
	if m != nil && m.Container != nil {
		return *m.Container
	}
	return ""
}

func (m *ApplicationPodLogsQuery) GetSinceSeconds() int64 {
	if m != nil && m.SinceSeconds != nil {
		return *m.SinceSeconds
	}
	return 0
}

func (m *ApplicationPodLogsQuery) GetSinceTime() *v1.Time {
	if m != nil {
		return m.SinceTime
	}
	return nil
}

func (m *ApplicationPodLogsQuery) GetTailLines() int64 {
	if m != nil && m.TailLines != nil {
		return *m.TailLines
	}
	return 0
}

func (m *ApplicationPodLogsQuery) GetFollow() bool {
	if m != nil && m.Follow != nil {
		return *m.Follow
	}
	return false
}

func (m *ApplicationPodLogsQuery) GetUntilTime() string {
	if m != nil && m.UntilTime != nil {
		return *m.UntilTime
	}
	return ""
}

func (m *ApplicationPodLogsQuery) GetFilter() string {
	if m != nil && m.Filter != nil {
		return *m.Filter
	}
	return ""
}

func (m *ApplicationPodLogsQuery) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

func (m *ApplicationPodLogsQuery) GetGroup() string {
	if m != nil && m.Group != nil {
		return *m.Group
	}
	return ""
}

func (m *ApplicationPodLogsQuery) GetResourceName() string {
	if m != nil && m.ResourceName != nil {
		return *m.ResourceName
	}
	return ""
}

func (m *ApplicationPodLogsQuery) GetPrevious() bool {
	if m != nil && m.Previous != nil {
		return *m.Previous
	}
	return false
}

func (m *ApplicationPodLogsQuery) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationPodLogsQuery) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type LogEntry struct {
	Content *string `protobuf:"bytes,1,req,name=content" json:"content,omitempty"`
	// deprecated in favor of timeStampStr since meta.v1.Time don't support nano time
	TimeStamp            *v1.Time `protobuf:"bytes,2,req,name=timeStamp" json:"timeStamp,omitempty"`
	Last                 *bool    `protobuf:"varint,3,req,name=last" json:"last,omitempty"`
	TimeStampStr         *string  `protobuf:"bytes,4,req,name=timeStampStr" json:"timeStampStr,omitempty"`
	PodName              *string  `protobuf:"bytes,5,req,name=podName" json:"podName,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogEntry) Reset()         { *m = LogEntry{} }
func (m *LogEntry) String() string { return proto.CompactTextString(m) }
func (*LogEntry) ProtoMessage()    {}
func (*LogEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{24}
}
func (m *LogEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LogEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LogEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LogEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry.Merge(m, src)
}
func (m *LogEntry) XXX_Size() int {
	return m.Size()
}
func (m *LogEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry proto.InternalMessageInfo

func (m *LogEntry) GetContent() string {
	if m != nil && m.Content != nil {
		return *m.Content
	}
	return ""
}

func (m *LogEntry) GetTimeStamp() *v1.Time {
	if m != nil {
		return m.TimeStamp
	}
	return nil
}

func (m *LogEntry) GetLast() bool {
	if m != nil && m.Last != nil {
		return *m.Last
	}
	return false
}

func (m *LogEntry) GetTimeStampStr() string {
	if m != nil && m.TimeStampStr != nil {
		return *m.TimeStampStr
	}
	return ""
}

func (m *LogEntry) GetPodName() string {
	if m != nil && m.PodName != nil {
		return *m.PodName
	}
	return ""
}

type OperationTerminateRequest struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,2,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,3,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OperationTerminateRequest) Reset()         { *m = OperationTerminateRequest{} }
func (m *OperationTerminateRequest) String() string { return proto.CompactTextString(m) }
func (*OperationTerminateRequest) ProtoMessage()    {}
func (*OperationTerminateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{25}
}
func (m *OperationTerminateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OperationTerminateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OperationTerminateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OperationTerminateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationTerminateRequest.Merge(m, src)
}
func (m *OperationTerminateRequest) XXX_Size() int {
	return m.Size()
}
func (m *OperationTerminateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationTerminateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OperationTerminateRequest proto.InternalMessageInfo

func (m *OperationTerminateRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *OperationTerminateRequest) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *OperationTerminateRequest) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type ApplicationSyncWindowsQuery struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,2,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,3,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationSyncWindowsQuery) Reset()         { *m = ApplicationSyncWindowsQuery{} }
func (m *ApplicationSyncWindowsQuery) String() string { return proto.CompactTextString(m) }
func (*ApplicationSyncWindowsQuery) ProtoMessage()    {}
func (*ApplicationSyncWindowsQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{26}
}
func (m *ApplicationSyncWindowsQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationSyncWindowsQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationSyncWindowsQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationSyncWindowsQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationSyncWindowsQuery.Merge(m, src)
}
func (m *ApplicationSyncWindowsQuery) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationSyncWindowsQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationSyncWindowsQuery.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationSyncWindowsQuery proto.InternalMessageInfo

func (m *ApplicationSyncWindowsQuery) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ApplicationSyncWindowsQuery) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ApplicationSyncWindowsQuery) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type ApplicationSyncWindowsResponse struct {
	ActiveWindows        []*ApplicationSyncWindow `protobuf:"bytes,1,rep,name=activeWindows" json:"activeWindows,omitempty"`
	AssignedWindows      []*ApplicationSyncWindow `protobuf:"bytes,2,rep,name=assignedWindows" json:"assignedWindows,omitempty"`
	CanSync              *bool                    `protobuf:"varint,3,req,name=canSync" json:"canSync,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ApplicationSyncWindowsResponse) Reset()         { *m = ApplicationSyncWindowsResponse{} }
func (m *ApplicationSyncWindowsResponse) String() string { return proto.CompactTextString(m) }
func (*ApplicationSyncWindowsResponse) ProtoMessage()    {}
func (*ApplicationSyncWindowsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{27}
}
func (m *ApplicationSyncWindowsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationSyncWindowsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationSyncWindowsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationSyncWindowsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationSyncWindowsResponse.Merge(m, src)
}
func (m *ApplicationSyncWindowsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationSyncWindowsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationSyncWindowsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationSyncWindowsResponse proto.InternalMessageInfo

func (m *ApplicationSyncWindowsResponse) GetActiveWindows() []*ApplicationSyncWindow {
	if m != nil {
		return m.ActiveWindows
	}
	return nil
}

func (m *ApplicationSyncWindowsResponse) GetAssignedWindows() []*ApplicationSyncWindow {
	if m != nil {
		return m.AssignedWindows
	}
	return nil
}

func (m *ApplicationSyncWindowsResponse) GetCanSync() bool {
	if m != nil && m.CanSync != nil {
		return *m.CanSync
	}
	return false
}

type ApplicationSyncWindow struct {
	Kind                 *string  `protobuf:"bytes,1,req,name=kind" json:"kind,omitempty"`
	Schedule             *string  `protobuf:"bytes,2,req,name=schedule" json:"schedule,omitempty"`
	Duration             *string  `protobuf:"bytes,3,req,name=duration" json:"duration,omitempty"`
	ManualSync           *bool    `protobuf:"varint,4,req,name=manualSync" json:"manualSync,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationSyncWindow) Reset()         { *m = ApplicationSyncWindow{} }
func (m *ApplicationSyncWindow) String() string { return proto.CompactTextString(m) }
func (*ApplicationSyncWindow) ProtoMessage()    {}
func (*ApplicationSyncWindow) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{28}
}
func (m *ApplicationSyncWindow) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplicationSyncWindow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplicationSyncWindow.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplicationSyncWindow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationSyncWindow.Merge(m, src)
}
func (m *ApplicationSyncWindow) XXX_Size() int {
	return m.Size()
}
func (m *ApplicationSyncWindow) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationSyncWindow.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationSyncWindow proto.InternalMessageInfo

func (m *ApplicationSyncWindow) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

func (m *ApplicationSyncWindow) GetSchedule() string {
	if m != nil && m.Schedule != nil {
		return *m.Schedule
	}
	return ""
}

func (m *ApplicationSyncWindow) GetDuration() string {
	if m != nil && m.Duration != nil {
		return *m.Duration
	}
	return ""
}

func (m *ApplicationSyncWindow) GetManualSync() bool {
	if m != nil && m.ManualSync != nil {
		return *m.ManualSync
	}
	return false
}

type OperationTerminateResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OperationTerminateResponse) Reset()         { *m = OperationTerminateResponse{} }
func (m *OperationTerminateResponse) String() string { return proto.CompactTextString(m) }
func (*OperationTerminateResponse) ProtoMessage()    {}
func (*OperationTerminateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{29}
}
func (m *OperationTerminateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OperationTerminateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OperationTerminateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OperationTerminateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationTerminateResponse.Merge(m, src)
}
func (m *OperationTerminateResponse) XXX_Size() int {
	return m.Size()
}
func (m *OperationTerminateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationTerminateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_OperationTerminateResponse proto.InternalMessageInfo

type ResourcesQuery struct {
	ApplicationName      *string  `protobuf:"bytes,1,req,name=applicationName" json:"applicationName,omitempty"`
	Namespace            *string  `protobuf:"bytes,2,opt,name=namespace" json:"namespace,omitempty"`
	Name                 *string  `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	Version              *string  `protobuf:"bytes,4,opt,name=version" json:"version,omitempty"`
	Group                *string  `protobuf:"bytes,5,opt,name=group" json:"group,omitempty"`
	Kind                 *string  `protobuf:"bytes,6,opt,name=kind" json:"kind,omitempty"`
	AppNamespace         *string  `protobuf:"bytes,7,opt,name=appNamespace" json:"appNamespace,omitempty"`
	Project              *string  `protobuf:"bytes,8,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourcesQuery) Reset()         { *m = ResourcesQuery{} }
func (m *ResourcesQuery) String() string { return proto.CompactTextString(m) }
func (*ResourcesQuery) ProtoMessage()    {}
func (*ResourcesQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{30}
}
func (m *ResourcesQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourcesQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourcesQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourcesQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourcesQuery.Merge(m, src)
}
func (m *ResourcesQuery) XXX_Size() int {
	return m.Size()
}
func (m *ResourcesQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourcesQuery.DiscardUnknown(m)
}

var xxx_messageInfo_ResourcesQuery proto.InternalMessageInfo

func (m *ResourcesQuery) GetApplicationName() string {
	if m != nil && m.ApplicationName != nil {
		return *m.ApplicationName
	}
	return ""
}

func (m *ResourcesQuery) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *ResourcesQuery) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ResourcesQuery) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

func (m *ResourcesQuery) GetGroup() string {
	if m != nil && m.Group != nil {
		return *m.Group
	}
	return ""
}

func (m *ResourcesQuery) GetKind() string {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return ""
}

func (m *ResourcesQuery) GetAppNamespace() string {
	if m != nil && m.AppNamespace != nil {
		return *m.AppNamespace
	}
	return ""
}

func (m *ResourcesQuery) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

type ManagedResourcesResponse struct {
	Items                []*v1alpha1.ResourceDiff `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ManagedResourcesResponse) Reset()         { *m = ManagedResourcesResponse{} }
func (m *ManagedResourcesResponse) String() string { return proto.CompactTextString(m) }
func (*ManagedResourcesResponse) ProtoMessage()    {}
func (*ManagedResourcesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{31}
}
func (m *ManagedResourcesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ManagedResourcesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ManagedResourcesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ManagedResourcesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedResourcesResponse.Merge(m, src)
}
func (m *ManagedResourcesResponse) XXX_Size() int {
	return m.Size()
}
func (m *ManagedResourcesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedResourcesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedResourcesResponse proto.InternalMessageInfo

func (m *ManagedResourcesResponse) GetItems() []*v1alpha1.ResourceDiff {
	if m != nil {
		return m.Items
	}
	return nil
}

type LinkInfo struct {
	Title                *string  `protobuf:"bytes,1,req,name=title" json:"title,omitempty"`
	Url                  *string  `protobuf:"bytes,2,req,name=url" json:"url,omitempty"`
	Description          *string  `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	IconClass            *string  `protobuf:"bytes,4,opt,name=iconClass" json:"iconClass,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinkInfo) Reset()         { *m = LinkInfo{} }
func (m *LinkInfo) String() string { return proto.CompactTextString(m) }
func (*LinkInfo) ProtoMessage()    {}
func (*LinkInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{32}
}
func (m *LinkInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinkInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinkInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinkInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinkInfo.Merge(m, src)
}
func (m *LinkInfo) XXX_Size() int {
	return m.Size()
}
func (m *LinkInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LinkInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LinkInfo proto.InternalMessageInfo

func (m *LinkInfo) GetTitle() string {
	if m != nil && m.Title != nil {
		return *m.Title
	}
	return ""
}

func (m *LinkInfo) GetUrl() string {
	if m != nil && m.Url != nil {
		return *m.Url
	}
	return ""
}

func (m *LinkInfo) GetDescription() string {
	if m != nil && m.Description != nil {
		return *m.Description
	}
	return ""
}

func (m *LinkInfo) GetIconClass() string {
	if m != nil && m.IconClass != nil {
		return *m.IconClass
	}
	return ""
}

type LinksResponse struct {
	Items                []*LinkInfo `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *LinksResponse) Reset()         { *m = LinksResponse{} }
func (m *LinksResponse) String() string { return proto.CompactTextString(m) }
func (*LinksResponse) ProtoMessage()    {}
func (*LinksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{33}
}
func (m *LinksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LinksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LinksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LinksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinksResponse.Merge(m, src)
}
func (m *LinksResponse) XXX_Size() int {
	return m.Size()
}
func (m *LinksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LinksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LinksResponse proto.InternalMessageInfo

func (m *LinksResponse) GetItems() []*LinkInfo {
	if m != nil {
		return m.Items
	}
	return nil
}

type ListAppLinksRequest struct {
	Name                 *string  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Namespace            *string  `protobuf:"bytes,3,opt,name=namespace" json:"namespace,omitempty"`
	Project              *string  `protobuf:"bytes,4,opt,name=project" json:"project,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAppLinksRequest) Reset()         { *m = ListAppLinksRequest{} }
func (m *ListAppLinksRequest) String() string { return proto.CompactTextString(m) }
func (*ListAppLinksRequest) ProtoMessage()    {}
func (*ListAppLinksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_df6e82b174b5eaec, []int{34}
}
func (m *ListAppLinksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListAppLinksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListAppLinksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListAppLinksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAppLinksRequest.Merge(m, src)
}
func (m *ListAppLinksRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListAppLinksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAppLinksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAppLinksRequest proto.InternalMessageInfo

func (m *ListAppLinksRequest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ListAppLinksRequest) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *ListAppLinksRequest) GetProject() string {
	if m != nil && m.Project != nil {
		return *m.Project
	}
	return ""
}

func init() {
	proto.RegisterType((*ApplicationQuery)(nil), "application.ApplicationQuery")
	proto.RegisterType((*NodeQuery)(nil), "application.NodeQuery")
	proto.RegisterType((*RevisionMetadataQuery)(nil), "application.RevisionMetadataQuery")
	proto.RegisterType((*ApplicationResourceEventsQuery)(nil), "application.ApplicationResourceEventsQuery")
	proto.RegisterType((*ApplicationManifestQuery)(nil), "application.ApplicationManifestQuery")
	proto.RegisterType((*FileChunk)(nil), "application.FileChunk")
	proto.RegisterType((*ApplicationManifestQueryWithFiles)(nil), "application.ApplicationManifestQueryWithFiles")
	proto.RegisterType((*ApplicationManifestQueryWithFilesWrapper)(nil), "application.ApplicationManifestQueryWithFilesWrapper")
	proto.RegisterType((*ApplicationResponse)(nil), "application.ApplicationResponse")
	proto.RegisterType((*ApplicationCreateRequest)(nil), "application.ApplicationCreateRequest")
	proto.RegisterType((*ApplicationUpdateRequest)(nil), "application.ApplicationUpdateRequest")
	proto.RegisterType((*ApplicationDeleteRequest)(nil), "application.ApplicationDeleteRequest")
	proto.RegisterType((*SyncOptions)(nil), "application.SyncOptions")
	proto.RegisterType((*ApplicationSyncRequest)(nil), "application.ApplicationSyncRequest")
	proto.RegisterType((*ApplicationUpdateSpecRequest)(nil), "application.ApplicationUpdateSpecRequest")
	proto.RegisterType((*ApplicationPatchRequest)(nil), "application.ApplicationPatchRequest")
	proto.RegisterType((*ApplicationRollbackRequest)(nil), "application.ApplicationRollbackRequest")
	proto.RegisterType((*ApplicationResourceRequest)(nil), "application.ApplicationResourceRequest")
	proto.RegisterType((*ApplicationResourcePatchRequest)(nil), "application.ApplicationResourcePatchRequest")
	proto.RegisterType((*ApplicationResourceDeleteRequest)(nil), "application.ApplicationResourceDeleteRequest")
	proto.RegisterType((*ResourceActionRunRequest)(nil), "application.ResourceActionRunRequest")
	proto.RegisterType((*ResourceActionsListResponse)(nil), "application.ResourceActionsListResponse")
	proto.RegisterType((*ApplicationResourceResponse)(nil), "application.ApplicationResourceResponse")
	proto.RegisterType((*ApplicationPodLogsQuery)(nil), "application.ApplicationPodLogsQuery")
	proto.RegisterType((*LogEntry)(nil), "application.LogEntry")
	proto.RegisterType((*OperationTerminateRequest)(nil), "application.OperationTerminateRequest")
	proto.RegisterType((*ApplicationSyncWindowsQuery)(nil), "application.ApplicationSyncWindowsQuery")
	proto.RegisterType((*ApplicationSyncWindowsResponse)(nil), "application.ApplicationSyncWindowsResponse")
	proto.RegisterType((*ApplicationSyncWindow)(nil), "application.ApplicationSyncWindow")
	proto.RegisterType((*OperationTerminateResponse)(nil), "application.OperationTerminateResponse")
	proto.RegisterType((*ResourcesQuery)(nil), "application.ResourcesQuery")
	proto.RegisterType((*ManagedResourcesResponse)(nil), "application.ManagedResourcesResponse")
	proto.RegisterType((*LinkInfo)(nil), "application.LinkInfo")
	proto.RegisterType((*LinksResponse)(nil), "application.LinksResponse")
	proto.RegisterType((*ListAppLinksRequest)(nil), "application.ListAppLinksRequest")
}

func init() {
	proto.RegisterFile("server/application/application.proto", fileDescriptor_df6e82b174b5eaec)
}

var fileDescriptor_df6e82b174b5eaec = []byte{
	// 2704 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xcd, 0x8f, 0x1b, 0x49,
	0x15, 0xa7, 0xec, 0xb1, 0xc7, 0xf3, 0x3c, 0x93, 0x8f, 0xda, 0x64, 0xe8, 0x75, 0x66, 0x83, 0xd3,
	0xf9, 0x9a, 0x4c, 0x32, 0x76, 0x62, 0x02, 0xca, 0xce, 0xee, 0x0a, 0x92, 0xc9, 0x27, 0x4c, 0xb2,
	0xa1, 0x27, 0x21, 0x68, 0x39, 0x40, 0x6d, 0xbb, 0xc6, 0xd3, 0x4c, 0xbb, 0xbb, 0xd3, 0xdd, 0x76,
	0x34, 0x0a, 0xb9, 0x2c, 0xca, 0x05, 0xad, 0x40, 0xc0, 0x1e, 0x10, 0x42, 0x80, 0x16, 0xad, 0x84,
	0x10, 0x88, 0x0b, 0x5a, 0x21, 0x21, 0x24, 0xb8, 0x20, 0x38, 0x20, 0xad, 0xe0, 0xc8, 0x05, 0x45,
	0x88, 0x23, 0x5c, 0xf6, 0x0f, 0x40, 0x55, 0x5d, 0xd5, 0x5d, 0xed, 0x8f, 0xb6, 0x07, 0x1b, 0x6d,
	0x6e, 0xfd, 0xca, 0xdd, 0xef, 0xfd, 0xde, 0xab, 0x5f, 0xbd, 0x57, 0xf5, 0xca, 0x70, 0x22, 0xa0,
	0x7e, 0x97, 0xfa, 0x75, 0xe2, 0x79, 0xb6, 0x65, 0x92, 0xd0, 0x72, 0x1d, 0xf5, 0xb9, 0xe6, 0xf9,
	0x6e, 0xe8, 0xe2, 0xb2, 0x32, 0x54, 0x59, 0x6a, 0xb9, 0x6e, 0xcb, 0xa6, 0x75, 0xe2, 0x59, 0x75,
	0xe2, 0x38, 0x6e, 0xc8, 0x87, 0x83, 0xe8, 0xd5, 0x8a, 0xbe, 0x73, 0x29, 0xa8, 0x59, 0x2e, 0xff,
	0xd5, 0x74, 0x7d, 0x5a, 0xef, 0x5e, 0xa8, 0xb7, 0xa8, 0x43, 0x7d, 0x12, 0xd2, 0xa6, 0x78, 0xe7,
	0x62, 0xf2, 0x4e, 0x9b, 0x98, 0xdb, 0x96, 0x43, 0xfd, 0xdd, 0xba, 0xb7, 0xd3, 0x62, 0x03, 0x41,
	0xbd, 0x4d, 0x43, 0x32, 0xe8, 0xab, 0x8d, 0x96, 0x15, 0x6e, 0x77, 0xde, 0xac, 0x99, 0x6e, 0xbb,
	0x4e, 0xfc, 0x96, 0xeb, 0xf9, 0xee, 0xd7, 0xf8, 0xc3, 0xaa, 0xd9, 0xac, 0x77, 0x1b, 0x89, 0x02,
	0xd5, 0x97, 0xee, 0x05, 0x62, 0x7b, 0xdb, 0xa4, 0x5f, 0xdb, 0xb5, 0x11, 0xda, 0x7c, 0xea, 0xb9,
	0x22, 0x36, 0xfc, 0xd1, 0x0a, 0x5d, 0x7f, 0x57, 0x79, 0x8c, 0xd4, 0xe8, 0x1f, 0x22, 0x38, 0x70,
	0x39, 0xb1, 0xf7, 0x85, 0x0e, 0xf5, 0x77, 0x31, 0x86, 0x19, 0x87, 0xb4, 0xa9, 0x86, 0xaa, 0x68,
	0x79, 0xce, 0xe0, 0xcf, 0x58, 0x83, 0x59, 0x9f, 0x6e, 0xf9, 0x34, 0xd8, 0xd6, 0x72, 0x7c, 0x58,
	0x8a, 0xb8, 0x02, 0x25, 0x66, 0x9c, 0x9a, 0x61, 0xa0, 0xe5, 0xab, 0xf9, 0xe5, 0x39, 0x23, 0x96,
	0xf1, 0x32, 0xec, 0xf7, 0x69, 0xe0, 0x76, 0x7c, 0x93, 0x7e, 0x91, 0xfa, 0x81, 0xe5, 0x3a, 0xda,
	0x0c, 0xff, 0xba, 0x77, 0x98, 0x69, 0x09, 0xa8, 0x4d, 0xcd, 0xd0, 0xf5, 0xb5, 0x02, 0x7f, 0x25,
	0x96, 0x19, 0x1e, 0x06, 0x5c, 0x2b, 0x46, 0x78, 0xd8, 0x33, 0xd6, 0x61, 0x9e, 0x78, 0xde, 0x1d,
	0xd2, 0xa6, 0x81, 0x47, 0x4c, 0xaa, 0xcd, 0xf2, 0xdf, 0x52, 0x63, 0x0c, 0xb3, 0x40, 0xa2, 0x95,
	0x38, 0x30, 0x29, 0xea, 0xeb, 0x30, 0x77, 0xc7, 0x6d, 0xd2, 0xe1, 0xee, 0xf6, 0xaa, 0xcf, 0xf5,
	0xab, 0xd7, 0x9f, 0x22, 0x38, 0x6c, 0xd0, 0xae, 0xc5, 0xf0, 0xdf, 0xa6, 0x21, 0x69, 0x92, 0x90,
	0xf4, 0x6a, 0xcc, 0xc5, 0x1a, 0x2b, 0x50, 0xf2, 0xc5, 0xcb, 0x5a, 0x8e, 0x8f, 0xc7, 0x72, 0x9f,
	0xb5, 0x7c, 0xb6, 0x33, 0x51, 0x08, 0x63, 0x67, 0xfe, 0x85, 0xe0, 0xa8, 0x32, 0x87, 0x86, 0x88,
	0xec, 0xb5, 0x2e, 0x75, 0xc2, 0x60, 0x38, 0xa0, 0x73, 0x70, 0x50, 0x4e, 0x42, 0xaf, 0x9f, 0xfd,
	0x3f, 0x30, 0x88, 0xea, 0xa0, 0x84, 0xa8, 0x8e, 0xe1, 0x2a, 0x94, 0xa5, 0x7c, 0xff, 0xd6, 0x55,
	0x01, 0x53, 0x1d, 0xea, 0x73, 0xb4, 0x90, 0xed, 0x68, 0x31, 0xed, 0xe8, 0x07, 0x08, 0x34, 0xc5,
	0xd1, 0xdb, 0xc4, 0xb1, 0xb6, 0x68, 0x10, 0x8e, 0x1b, 0x73, 0x34, 0xbd, 0x98, 0x33, 0x62, 0x47,
	0x5e, 0xdd, 0x65, 0xeb, 0x89, 0xe5, 0x0f, 0xad, 0x50, 0xcd, 0x2f, 0xe7, 0x8d, 0xde, 0x61, 0xbc,
	0x04, 0x73, 0xd2, 0x66, 0xa0, 0x15, 0x39, 0x0d, 0x93, 0x01, 0xfd, 0x18, 0xcc, 0x5d, 0xb7, 0x6c,
	0xba, 0xbe, 0xdd, 0x71, 0x76, 0xf0, 0x21, 0x28, 0x98, 0xec, 0x81, 0xfb, 0x30, 0x6f, 0x44, 0x82,
	0xfe, 0x1d, 0x04, 0xc7, 0x86, 0x79, 0xfd, 0xc0, 0x0a, 0xb7, 0xd9, 0xf7, 0xc1, 0x30, 0xf7, 0xcd,
	0x6d, 0x6a, 0xee, 0x04, 0x9d, 0xb6, 0xa4, 0x9c, 0x94, 0x27, 0xa4, 0xdc, 0xcf, 0x11, 0x2c, 0x8f,
	0xc4, 0xf4, 0xc0, 0x27, 0x9e, 0x47, 0x7d, 0x7c, 0x1d, 0x0a, 0x0f, 0xd9, 0x0f, 0x7c, 0x81, 0x95,
	0x1b, 0xb5, 0x9a, 0x9a, 0xa0, 0x47, 0x6a, 0xb9, 0xf9, 0x31, 0x23, 0xfa, 0x1c, 0xd7, 0x64, 0x78,
	0x72, 0x5c, 0xcf, 0x62, 0x4a, 0x4f, 0x1c, 0x45, 0xf6, 0x3e, 0x7f, 0xed, 0x4a, 0x11, 0x66, 0x3c,
	0xe2, 0x87, 0xfa, 0x61, 0x78, 0x21, 0xbd, 0x3c, 0x3c, 0xd7, 0x09, 0xa8, 0xfe, 0xdb, 0x34, 0x9b,
	0xd6, 0x7d, 0x4a, 0x42, 0x6a, 0xd0, 0x87, 0x1d, 0x1a, 0x84, 0x78, 0x07, 0xd4, 0x9a, 0xc1, 0xa3,
	0x5a, 0x6e, 0xdc, 0xaa, 0x25, 0x49, 0xb7, 0x26, 0x93, 0x2e, 0x7f, 0xf8, 0x8a, 0xd9, 0xac, 0x75,
	0x1b, 0x35, 0x6f, 0xa7, 0x55, 0x63, 0x29, 0x3c, 0x85, 0x4c, 0xa6, 0x70, 0xd5, 0x55, 0x43, 0xd5,
	0x8e, 0x17, 0xa1, 0xd8, 0xf1, 0x02, 0xea, 0x87, 0xdc, 0xb3, 0x92, 0x21, 0x24, 0x36, 0x7f, 0x5d,
	0x62, 0x5b, 0x4d, 0x12, 0x46, 0xf3, 0x53, 0x32, 0x62, 0x59, 0xff, 0x5d, 0x1a, 0xfd, 0x7d, 0xaf,
	0xf9, 0x51, 0xa1, 0x57, 0x51, 0xe6, 0xd2, 0x28, 0x55, 0x06, 0xe5, 0xd3, 0x0c, 0xfa, 0x75, 0x1a,
	0xff, 0x55, 0x6a, 0xd3, 0x04, 0xff, 0x20, 0x32, 0x6b, 0x30, 0x6b, 0x92, 0xc0, 0x24, 0x4d, 0x69,
	0x45, 0x8a, 0x2c, 0x91, 0x79, 0xbe, 0xeb, 0x91, 0x16, 0xd7, 0x74, 0xd7, 0xb5, 0x2d, 0x73, 0x57,
	0x98, 0xeb, 0xff, 0xa1, 0x8f, 0xf8, 0x33, 0xd9, 0xc4, 0x2f, 0xa4, 0x61, 0x1f, 0x87, 0xf2, 0xe6,
	0xae, 0x63, 0xbe, 0xee, 0x45, 0x8b, 0xfb, 0x10, 0x14, 0xac, 0x90, 0xb6, 0x03, 0x0d, 0xf1, 0x85,
	0x1d, 0x09, 0xfa, 0xfb, 0x05, 0x58, 0x54, 0x7c, 0x63, 0x1f, 0x64, 0x79, 0x96, 0x95, 0xa5, 0x16,
	0xa1, 0xd8, 0xf4, 0x77, 0x8d, 0x8e, 0x23, 0x08, 0x20, 0x24, 0x66, 0xd8, 0xf3, 0x3b, 0x4e, 0x04,
	0xbf, 0x64, 0x44, 0x02, 0xde, 0x82, 0x52, 0x10, 0xb2, 0x5d, 0x42, 0x6b, 0x97, 0x03, 0x2f, 0x37,
	0x3e, 0x37, 0xd9, 0xa4, 0x33, 0xe8, 0x9b, 0x42, 0xa3, 0x11, 0xeb, 0xc6, 0x0f, 0x59, 0x4e, 0x8b,
	0x12, 0x5d, 0xa0, 0xcd, 0x56, 0xf3, 0xcb, 0xe5, 0xc6, 0xe6, 0xe4, 0x86, 0x5e, 0xf7, 0xd8, 0x0e,
	0x47, 0xa9, 0x60, 0x46, 0x62, 0x85, 0xa5, 0xd1, 0xb6, 0xc8, 0x0f, 0x81, 0xa8, 0xe6, 0xc9, 0x00,
	0xfe, 0x12, 0x14, 0x2c, 0x67, 0xcb, 0x0d, 0xb4, 0x39, 0x0e, 0xe6, 0xca, 0x64, 0x60, 0x6e, 0x39,
	0x5b, 0xae, 0x11, 0x29, 0xc4, 0x0f, 0x61, 0xc1, 0xa7, 0xa1, 0xbf, 0x2b, 0xa3, 0xa0, 0x01, 0x8f,
	0xeb, 0xe7, 0x27, 0xb3, 0x60, 0xa8, 0x2a, 0x8d, 0xb4, 0x05, 0xbc, 0x06, 0xe5, 0x20, 0xe1, 0x98,
	0x56, 0xe6, 0x06, 0xb5, 0x94, 0x22, 0x85, 0x83, 0x86, 0xfa, 0x72, 0x1f, 0xbb, 0xe7, 0xb3, 0xd9,
	0xbd, 0x90, 0x66, 0xf7, 0x7f, 0x10, 0x2c, 0xf5, 0x25, 0x95, 0x4d, 0x8f, 0x66, 0xd2, 0x97, 0xc0,
	0x4c, 0xe0, 0x51, 0x93, 0x57, 0x98, 0x72, 0xe3, 0xf6, 0xd4, 0xb2, 0x0c, 0xb7, 0xcb, 0x55, 0x67,
	0x25, 0xc2, 0x09, 0xd7, 0xf3, 0x8f, 0x11, 0x7c, 0x5c, 0xb1, 0x79, 0x97, 0x84, 0xe6, 0x76, 0x96,
	0xb3, 0x6c, 0xdd, 0xb1, 0x77, 0x44, 0x3d, 0x8d, 0x04, 0x46, 0x4e, 0xfe, 0x70, 0x6f, 0xd7, 0x63,
	0x00, 0xd9, 0x2f, 0xc9, 0xc0, 0x84, 0x9b, 0x9e, 0x5f, 0x20, 0xa8, 0xa8, 0xb9, 0xd7, 0xb5, 0xed,
	0x37, 0x89, 0xb9, 0x93, 0x05, 0x72, 0x1f, 0xe4, 0xac, 0x26, 0x47, 0x98, 0x37, 0x72, 0x56, 0x73,
	0x8f, 0x49, 0xa4, 0x17, 0x6e, 0x31, 0x1b, 0xee, 0x6c, 0x1a, 0xee, 0x87, 0x3d, 0x70, 0xe5, 0x52,
	0xce, 0x80, 0xbb, 0x04, 0x73, 0x4e, 0xcf, 0x06, 0x34, 0x19, 0x18, 0xb0, 0xf1, 0xcc, 0xf5, 0x6d,
	0x3c, 0x35, 0x98, 0xed, 0xc6, 0xc7, 0x0b, 0xf6, 0xb3, 0x14, 0x99, 0x8b, 0x2d, 0xdf, 0xed, 0x78,
	0x22, 0xe8, 0x91, 0xc0, 0x50, 0xec, 0x58, 0x4e, 0x53, 0x2b, 0x46, 0x28, 0xd8, 0xf3, 0xde, 0x0f,
	0x14, 0x29, 0xb7, 0x7f, 0x99, 0x83, 0x4f, 0x0c, 0x70, 0x7b, 0x24, 0x9f, 0x9e, 0x0f, 0xdf, 0x63,
	0x56, 0xcf, 0x0e, 0x65, 0x75, 0x69, 0x14, 0xab, 0xe7, 0xb2, 0xe3, 0x05, 0xe9, 0x78, 0xfd, 0x2c,
	0x07, 0xd5, 0x01, 0xf1, 0x1a, 0xbd, 0x0d, 0x78, 0x6e, 0x02, 0xb6, 0xe5, 0xfa, 0x82, 0x25, 0x25,
	0x23, 0x12, 0xd8, 0x3a, 0x73, 0x7d, 0x6f, 0x9b, 0x38, 0x9c, 0x1d, 0x25, 0x43, 0x48, 0x13, 0x86,
	0xea, 0x9b, 0x39, 0xd0, 0x64, 0x7c, 0x2e, 0x9b, 0x3c, 0x5a, 0x1d, 0xe7, 0xf9, 0x0f, 0xd1, 0x22,
	0x14, 0x09, 0x47, 0x2b, 0x48, 0x25, 0xa4, 0xbe, 0x60, 0x94, 0xb2, 0x83, 0x31, 0x97, 0x0e, 0xc6,
	0x53, 0x04, 0x47, 0xd2, 0xc1, 0x08, 0x36, 0xac, 0x20, 0x94, 0x9b, 0x7a, 0xbc, 0x05, 0xb3, 0x91,
	0x9d, 0x68, 0x4b, 0x56, 0x6e, 0x6c, 0x4c, 0x5a, 0xa8, 0x53, 0x81, 0x97, 0xca, 0xf5, 0x97, 0xe1,
	0xc8, 0xc0, 0x2c, 0x27, 0x60, 0x54, 0xa0, 0x24, 0x37, 0x27, 0x62, 0x6a, 0x62, 0x59, 0x7f, 0x3a,
	0x93, 0x2e, 0x39, 0x6e, 0x73, 0xc3, 0x6d, 0x65, 0x9c, 0xd3, 0xb3, 0xa7, 0x93, 0x85, 0xca, 0x6d,
	0x2a, 0x47, 0x72, 0x29, 0xb2, 0xef, 0x4c, 0xd7, 0x09, 0x89, 0xe5, 0x50, 0x5f, 0x54, 0xc5, 0x64,
	0x80, 0x4d, 0x43, 0x60, 0x39, 0x26, 0xdd, 0xa4, 0xa6, 0xeb, 0x34, 0x03, 0x3e, 0x9f, 0x79, 0x23,
	0x35, 0x86, 0x6f, 0xc2, 0x1c, 0x97, 0xef, 0x59, 0xed, 0xa8, 0x0c, 0x94, 0x1b, 0x2b, 0xb5, 0xa8,
	0xf7, 0x55, 0x53, 0x7b, 0x5f, 0x49, 0x0c, 0xdb, 0x34, 0x24, 0xb5, 0xee, 0x85, 0x1a, 0xfb, 0xc2,
	0x48, 0x3e, 0x66, 0x58, 0x42, 0x62, 0xd9, 0x1b, 0x96, 0xc3, 0x37, 0x8c, 0xcc, 0x54, 0x32, 0xc0,
	0xa8, 0xb2, 0xe5, 0xda, 0xb6, 0xfb, 0x48, 0xae, 0x9b, 0x48, 0x62, 0x5f, 0x75, 0x9c, 0xd0, 0xb2,
	0xb9, 0xfd, 0x88, 0x08, 0xc9, 0x00, 0xff, 0xca, 0xb2, 0x43, 0xea, 0x8b, 0x05, 0x23, 0xa4, 0x98,
	0x8c, 0xe5, 0xa8, 0x9d, 0x23, 0xd7, 0x6b, 0x44, 0xdb, 0x79, 0x95, 0xb6, 0xbd, 0x4b, 0x61, 0x61,
	0x40, 0x4f, 0x83, 0x77, 0xb7, 0x68, 0xd7, 0x72, 0x3b, 0x81, 0xb6, 0x2f, 0xda, 0x7a, 0x48, 0xb9,
	0x8f, 0xca, 0xfb, 0xb3, 0xa9, 0x7c, 0x20, 0x4d, 0xe5, 0xdf, 0x23, 0x28, 0x6d, 0xb8, 0xad, 0x6b,
	0x4e, 0xe8, 0xef, 0xf2, 0xd3, 0x8d, 0xeb, 0x84, 0xd4, 0x91, 0x7c, 0x91, 0x22, 0x9b, 0x84, 0xd0,
	0x6a, 0xd3, 0xcd, 0x90, 0xb4, 0x3d, 0xb1, 0xc7, 0xda, 0xd3, 0x24, 0xc4, 0x1f, 0xb3, 0xc0, 0xd8,
	0x24, 0x08, 0xf9, 0x8a, 0x2f, 0x19, 0xfc, 0x99, 0xb9, 0x10, 0xbf, 0xb0, 0x19, 0xfa, 0x62, 0xb9,
	0xa7, 0xc6, 0x54, 0x8a, 0x15, 0x22, 0x6c, 0x42, 0xd4, 0xdb, 0xf0, 0x62, 0xbc, 0x69, 0xbf, 0x47,
	0xfd, 0xb6, 0xe5, 0x90, 0xec, 0xec, 0x3d, 0x46, 0x5b, 0x2d, 0xe3, 0xcc, 0xe8, 0xa6, 0x16, 0x1d,
	0xdb, 0x03, 0x3f, 0xb0, 0x9c, 0xa6, 0xfb, 0x28, 0x63, 0xf1, 0x4c, 0x66, 0xf0, 0xaf, 0xe9, 0xce,
	0x9a, 0x62, 0x31, 0x5e, 0xe9, 0x37, 0x61, 0x81, 0xe5, 0x84, 0x2e, 0x15, 0x3f, 0x88, 0xb4, 0xa3,
	0x0f, 0x6b, 0x72, 0x24, 0x3a, 0x8c, 0xf4, 0x87, 0x78, 0x03, 0xf6, 0x93, 0x20, 0xb0, 0x5a, 0x0e,
	0x6d, 0x4a, 0x5d, 0xb9, 0xb1, 0x75, 0xf5, 0x7e, 0x1a, 0x1d, 0x97, 0xf9, 0x1b, 0x62, 0xbe, 0xa5,
	0xa8, 0x7f, 0x03, 0xc1, 0xe1, 0x81, 0x4a, 0xe2, 0x95, 0x83, 0x94, 0x34, 0x5e, 0x81, 0x52, 0x60,
	0x6e, 0xd3, 0x66, 0xc7, 0xa6, 0xb2, 0x87, 0x24, 0x65, 0xf6, 0x5b, 0xb3, 0x13, 0xcd, 0xbe, 0x28,
	0x23, 0xb1, 0x8c, 0x8f, 0x02, 0xb4, 0x89, 0xd3, 0x21, 0x36, 0x87, 0x30, 0xc3, 0x21, 0x28, 0x23,
	0xfa, 0x12, 0x54, 0x06, 0x51, 0x47, 0xf4, 0x66, 0xfe, 0x8d, 0x60, 0x9f, 0x4c, 0xaa, 0x62, 0x76,
	0x97, 0x61, 0xbf, 0x12, 0x86, 0x3b, 0xc9, 0x44, 0xf7, 0x0e, 0x8f, 0x48, 0x98, 0x92, 0x25, 0xf9,
	0x74, 0x73, 0xbb, 0x9b, 0x6a, 0x4f, 0x8f, 0x5d, 0xef, 0xd0, 0x94, 0xf6, 0x8f, 0x5f, 0x07, 0xed,
	0x36, 0x71, 0x48, 0x8b, 0x36, 0x63, 0xb7, 0x63, 0x8a, 0x7d, 0x55, 0x6d, 0x32, 0x4c, 0x7c, 0xa4,
	0x8f, 0xb7, 0x5a, 0xd6, 0xd6, 0x96, 0x6c, 0x58, 0xf8, 0x50, 0xda, 0xb0, 0x9c, 0x1d, 0x76, 0xee,
	0x65, 0x1e, 0x87, 0x56, 0x68, 0xcb, 0xe8, 0x46, 0x02, 0x3e, 0x00, 0xf9, 0x8e, 0x6f, 0x0b, 0x06,
	0xb0, 0x47, 0x5c, 0x85, 0x72, 0x93, 0x06, 0xa6, 0x6f, 0x79, 0x62, 0xfe, 0x79, 0xb3, 0x57, 0x19,
	0x62, 0xf3, 0x60, 0x99, 0xae, 0xb3, 0x6e, 0x93, 0x20, 0x90, 0x05, 0x28, 0x1e, 0xd0, 0x5f, 0x85,
	0x05, 0x66, 0x33, 0x71, 0xf3, 0x6c, 0xda, 0xcd, 0xc3, 0x29, 0xf8, 0x12, 0x9e, 0x44, 0x4c, 0xe0,
	0x05, 0x56, 0xf7, 0x2f, 0x7b, 0x9e, 0x50, 0x32, 0xe6, 0x76, 0x28, 0x3f, 0xa8, 0x7e, 0x0e, 0xec,
	0x71, 0x36, 0xfe, 0x7e, 0x1c, 0xb0, 0xba, 0x4e, 0xa8, 0xdf, 0xb5, 0x4c, 0x8a, 0xbf, 0x8b, 0x60,
	0x86, 0x99, 0xc6, 0x2f, 0x0d, 0x5b, 0x96, 0x9c, 0xaf, 0x95, 0xe9, 0x1d, 0x84, 0x99, 0x35, 0x7d,
	0xe9, 0xad, 0xbf, 0xfd, 0xf3, 0x7b, 0xb9, 0x45, 0x7c, 0x88, 0xdf, 0x4c, 0x75, 0x2f, 0xa8, 0xb7,
	0x44, 0x01, 0x7e, 0x1b, 0x01, 0x16, 0xfb, 0x20, 0xa5, 0xf7, 0x8f, 0xcf, 0x0e, 0x83, 0x38, 0xe0,
	0x8e, 0xa0, 0xf2, 0x92, 0x52, 0x55, 0x6a, 0xa6, 0xeb, 0x53, 0x56, 0x43, 0xf8, 0x0b, 0x1c, 0xc0,
	0x0a, 0x07, 0x70, 0x02, 0xeb, 0x83, 0x00, 0xd4, 0x1f, 0xb3, 0x88, 0x3e, 0xa9, 0xd3, 0xc8, 0xee,
	0xbb, 0x08, 0x0a, 0x0f, 0xf8, 0x19, 0x62, 0x44, 0x90, 0x36, 0xa7, 0x16, 0x24, 0x6e, 0x8e, 0xa3,
	0xd5, 0x8f, 0x73, 0xa4, 0x2f, 0xe1, 0x23, 0x12, 0x69, 0x10, 0xfa, 0x94, 0xb4, 0x53, 0x80, 0xcf,
	0x23, 0xfc, 0x1e, 0x82, 0x62, 0xd4, 0xf4, 0xc5, 0x27, 0x87, 0xa1, 0x4c, 0x35, 0x85, 0x2b, 0xd3,
	0xeb, 0xa0, 0xea, 0x67, 0x38, 0xc6, 0xe3, 0xfa, 0xc0, 0xe9, 0x5c, 0x4b, 0xf5, 0x57, 0xdf, 0x41,
	0x90, 0xbf, 0x41, 0x47, 0xf2, 0x6d, 0x8a, 0xe0, 0xfa, 0x02, 0x38, 0x60, 0xaa, 0xf1, 0x4f, 0x11,
	0xbc, 0x78, 0x83, 0x86, 0x83, 0xcb, 0x23, 0x5e, 0x1e, 0x5d, 0xb3, 0x04, 0xed, 0xce, 0x8e, 0xf1,
	0x66, 0x5c, 0x17, 0xea, 0x1c, 0xd9, 0x19, 0x7c, 0x3a, 0x8b, 0x84, 0xc1, 0xae, 0x63, 0x3e, 0x12,
	0x38, 0xfe, 0x8c, 0xe0, 0x40, 0xef, 0x1d, 0x1d, 0x4e, 0x17, 0xd4, 0x81, 0x57, 0x78, 0x95, 0x3b,
	0x93, 0x66, 0xd9, 0xb4, 0x52, 0xfd, 0x32, 0x47, 0xfe, 0x0a, 0x7e, 0x39, 0x0b, 0x79, 0x7c, 0x2f,
	0x54, 0x7f, 0x2c, 0x1f, 0x9f, 0xf0, 0xfb, 0x64, 0x0e, 0xfb, 0x2f, 0x08, 0x0e, 0x49, 0xbd, 0xeb,
	0xdb, 0xc4, 0x0f, 0xaf, 0x52, 0xb6, 0x87, 0x0e, 0xc6, 0xf2, 0x67, 0xc2, 0xaa, 0xa1, 0xda, 0xd3,
	0xaf, 0x71, 0x5f, 0x3e, 0x83, 0x5f, 0xdb, 0xb3, 0x2f, 0x26, 0x53, 0xd3, 0x14, 0xb0, 0xdf, 0x42,
	0x30, 0x7f, 0x83, 0x86, 0xb7, 0xe3, 0x2e, 0xee, 0xc9, 0xb1, 0x6e, 0x86, 0x2a, 0x4b, 0x35, 0xe5,
	0x1a, 0x5b, 0xfe, 0x14, 0x53, 0x64, 0x95, 0x83, 0x3b, 0x8d, 0x4f, 0x66, 0x81, 0x4b, 0x3a, 0xc7,
	0xef, 0x22, 0x38, 0xac, 0x82, 0x48, 0x6e, 0xd4, 0x3e, 0xb5, 0xb7, 0x7b, 0x2a, 0x71, 0xdb, 0x35,
	0x02, 0x5d, 0x83, 0xa3, 0x3b, 0xa7, 0x0f, 0x26, 0x70, 0xbb, 0x0f, 0xc5, 0x1a, 0x5a, 0x59, 0x46,
	0xf8, 0x0f, 0x08, 0x8a, 0x51, 0x33, 0x76, 0x78, 0x8c, 0x52, 0x37, 0x40, 0xd3, 0xcc, 0x06, 0x62,
	0xb6, 0x2b, 0xe7, 0x07, 0x07, 0x54, 0xfd, 0x5e, 0x52, 0xb5, 0xc6, 0xa3, 0x9c, 0x4e, 0x63, 0xef,
	0x23, 0x80, 0xa4, 0xa1, 0x8c, 0xcf, 0x64, 0xfb, 0xa1, 0x34, 0x9d, 0x2b, 0xd3, 0x6d, 0x29, 0xeb,
	0x35, 0xee, 0xcf, 0x72, 0xa5, 0x9a, 0x99, 0x43, 0x3c, 0x6a, 0xae, 0x45, 0xcd, 0xe7, 0x9f, 0x20,
	0x28, 0xf0, 0x3e, 0x1e, 0x3e, 0x31, 0x0c, 0xb3, 0xda, 0xe6, 0x9b, 0x66, 0xe8, 0x4f, 0x71, 0xa8,
	0xd5, 0x46, 0x56, 0x22, 0x5e, 0x43, 0x2b, 0xb8, 0x0b, 0xc5, 0xa8, 0x73, 0x36, 0x9c, 0x1e, 0xa9,
	0xce, 0x5a, 0xa5, 0x9a, 0xb1, 0x31, 0x88, 0x88, 0x2a, 0x6a, 0xc0, 0xca, 0xa8, 0x1a, 0x30, 0xc3,
	0xd2, 0x34, 0x3e, 0x9e, 0x95, 0xc4, 0xff, 0x0f, 0x81, 0x39, 0xcb, 0xd1, 0x9d, 0xd4, 0xab, 0xa3,
	0xea, 0x00, 0x8b, 0xce, 0xf7, 0x11, 0x1c, 0xe8, 0xdd, 0x5c, 0xe3, 0x23, 0x3d, 0x39, 0x53, 0x3d,
	0x6b, 0x54, 0xd2, 0x51, 0x1c, 0xb6, 0x31, 0xd7, 0x3f, 0xcb, 0x51, 0xac, 0xe1, 0x4b, 0x23, 0x57,
	0xc6, 0x1d, 0x99, 0x75, 0x98, 0xa2, 0xd5, 0xe4, 0x56, 0xeb, 0x37, 0x08, 0xe6, 0xa5, 0xde, 0x7b,
	0x3e, 0xa5, 0xd9, 0xb0, 0xa6, 0xb7, 0x10, 0x98, 0x2d, 0xfd, 0x55, 0x0e, 0xff, 0xd3, 0xf8, 0xe2,
	0x98, 0xf0, 0x25, 0xec, 0xd5, 0x90, 0x21, 0xfd, 0x23, 0x82, 0x83, 0x0f, 0x22, 0xde, 0x7f, 0x44,
	0xf8, 0xd7, 0x39, 0xfe, 0xd7, 0xf0, 0x2b, 0x19, 0xfb, 0xbc, 0x51, 0x6e, 0x9c, 0x47, 0xf8, 0x57,
	0x08, 0x4a, 0xf2, 0x56, 0x05, 0x9f, 0x1e, 0xba, 0x30, 0xd2, 0xf7, 0x2e, 0xd3, 0x24, 0xb3, 0xd8,
	0xd4, 0xe8, 0x27, 0x32, 0xcb, 0xa9, 0xb0, 0xcf, 0x08, 0xfd, 0x0e, 0x02, 0x1c, 0x9f, 0x99, 0xe3,
	0x53, 0x34, 0x3e, 0x95, 0x32, 0x35, 0xb4, 0x31, 0x53, 0x39, 0x3d, 0xf2, 0xbd, 0x74, 0x29, 0x5d,
	0xc9, 0x2c, 0xa5, 0x6e, 0x6c, 0xff, 0x5b, 0x08, 0xca, 0x37, 0x68, 0x7c, 0x06, 0xc9, 0x88, 0x65,
	0xfa, 0x52, 0xa8, 0xb2, 0x3c, 0xfa, 0x45, 0x81, 0xe8, 0x1c, 0x47, 0x74, 0x0a, 0x67, 0x87, 0x4a,
	0x02, 0xf8, 0x21, 0x82, 0x85, 0xbb, 0x2a, 0x45, 0xf1, 0xb9, 0x51, 0x96, 0x52, 0x99, 0x7c, 0x7c,
	0x5c, 0x9f, 0xe4, 0xb8, 0x56, 0xf5, 0xb1, 0x70, 0xad, 0x89, 0xfb, 0x95, 0x1f, 0xa1, 0xe8, 0x10,
	0xdb, 0xd3, 0xcf, 0xfe, 0x5f, 0xe3, 0x96, 0xd1, 0x16, 0xd7, 0x2f, 0x72, 0x7c, 0x35, 0x7c, 0x6e,
	0x1c, 0x7c, 0x75, 0xd1, 0xe4, 0xc6, 0x3f, 0x40, 0x70, 0x90, 0xdf, 0x35, 0xa8, 0x8a, 0x7b, 0x4a,
	0xcc, 0xb0, 0x9b, 0x89, 0x31, 0x4a, 0x8c, 0xc8, 0x3f, 0xfa, 0x9e, 0x40, 0xad, 0xc9, 0x7b, 0x84,
	0x6f, 0x23, 0xd8, 0x27, 0x8b, 0x9a, 0x98, 0xdd, 0xd5, 0x51, 0x81, 0xdb, 0x6b, 0x11, 0x14, 0x74,
	0x5b, 0x19, 0x8f, 0x6e, 0xef, 0x21, 0x98, 0x15, 0xdd, 0xfc, 0x8c, 0xad, 0x82, 0xd2, 0xee, 0xaf,
	0xf4, 0xf4, 0x38, 0x44, 0x33, 0x58, 0xff, 0x32, 0x37, 0x7b, 0x1f, 0xd7, 0xb3, 0xcc, 0x7a, 0x6e,
	0x33, 0xa8, 0x3f, 0x16, 0x9d, 0xd8, 0x27, 0x75, 0xdb, 0x6d, 0x05, 0x6f, 0xe8, 0x38, 0xb3, 0x20,
	0xb2, 0x77, 0xce, 0x23, 0x1c, 0xc2, 0x1c, 0x23, 0x07, 0x6f, 0x9c, 0xe0, 0x6a, 0x4f, 0x9b, 0xa5,
	0xaf, 0xa7, 0x52, 0xa9, 0xf4, 0x35, 0x62, 0x92, 0x0a, 0x28, 0x8e, 0xb1, 0xf8, 0x58, 0xa6, 0x59,
	0x6e, 0xe8, 0x6d, 0x04, 0x07, 0x55, 0xb6, 0x47, 0xe6, 0xc7, 0xe6, 0x7a, 0x16, 0x0a, 0xb1, 0xa9,
	0xc6, 0x2b, 0x63, 0x11, 0x89, 0xc3, 0xb9, 0x72, 0xfd, 0x4f, 0xcf, 0x8e, 0xa2, 0x0f, 0x9e, 0x1d,
	0x45, 0xff, 0x78, 0x76, 0x14, 0xbd, 0x71, 0x69, 0xbc, 0xff, 0xe6, 0x9a, 0xb6, 0x45, 0x9d, 0x50,
	0x55, 0xff, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x7f, 0x21, 0xe8, 0x81, 0x2c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ApplicationServiceClient is the client API for ApplicationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ApplicationServiceClient interface {
	// List returns list of applications
	List(ctx context.Context, in *ApplicationQuery, opts ...grpc.CallOption) (*v1alpha1.ApplicationList, error)
	// ListResourceEvents returns a list of event resources
	ListResourceEvents(ctx context.Context, in *ApplicationResourceEventsQuery, opts ...grpc.CallOption) (*v11.EventList, error)
	// Watch returns stream of application change events
	Watch(ctx context.Context, in *ApplicationQuery, opts ...grpc.CallOption) (ApplicationService_WatchClient, error)
	// Create creates an application
	Create(ctx context.Context, in *ApplicationCreateRequest, opts ...grpc.CallOption) (*v1alpha1.Application, error)
	// Get returns an application by name
	Get(ctx context.Context, in *ApplicationQuery, opts ...grpc.CallOption) (*v1alpha1.Application, error)
	// Get returns sync windows of the application
	GetApplicationSyncWindows(ctx context.Context, in *ApplicationSyncWindowsQuery, opts ...grpc.CallOption) (*ApplicationSyncWindowsResponse, error)
	// Get the meta-data (author, date, tags, message) for a specific revision of the application
	RevisionMetadata(ctx context.Context, in *RevisionMetadataQuery, opts ...grpc.CallOption) (*v1alpha1.RevisionMetadata, error)
	// Get the chart metadata (description, maintainers, home) for a specific revision of the application
	RevisionChartDetails(ctx context.Context, in *RevisionMetadataQuery, opts ...grpc.CallOption) (*v1alpha1.ChartDetails, error)
	// GetManifests returns application manifests
	GetManifests(ctx context.Context, in *ApplicationManifestQuery, opts ...grpc.CallOption) (*apiclient.ManifestResponse, error)
	// GetManifestsWithFiles returns application manifests using provided files to generate them
	GetManifestsWithFiles(ctx context.Context, opts ...grpc.CallOption) (ApplicationService_GetManifestsWithFilesClient, error)
	// Update updates an application
	Update(ctx context.Context, in *ApplicationUpdateRequest, opts ...grpc.CallOption) (*v1alpha1.Application, error)
	// UpdateSpec updates an application spec
	UpdateSpec(ctx context.Context, in *ApplicationUpdateSpecRequest, opts ...grpc.CallOption) (*v1alpha1.ApplicationSpec, error)
	// Patch patch an application
	Patch(ctx context.Context, in *ApplicationPatchRequest, opts ...grpc.CallOption) (*v1alpha1.Application, error)
	// Delete deletes an application
	Delete(ctx context.Context, in *ApplicationDeleteRequest, opts ...grpc.CallOption) (*ApplicationResponse, error)
	// Sync syncs an application to its target state
	Sync(ctx context.Context, in *ApplicationSyncRequest, opts ...grpc.CallOption) (*v1alpha1.Application, error)
	// ManagedResources returns list of managed resources
	ManagedResources(ctx context.Context, in *ResourcesQuery, opts ...grpc.CallOption) (*ManagedResourcesResponse, error)
	// ResourceTree returns resource tree
	ResourceTree(ctx context.Context, in *ResourcesQuery, opts ...grpc.CallOption) (*v1alpha1.ApplicationTree, error)
	// Watch returns stream of application resource tree
	WatchResourceTree(ctx context.Context, in *ResourcesQuery, opts ...grpc.CallOption) (ApplicationService_WatchResourceTreeClient, error)
	// Rollback syncs an application to its target state
	Rollback(ctx context.Context, in *ApplicationRollbackRequest, opts ...grpc.CallOption) (*v1alpha1.Application, error)
	// TerminateOperation terminates the currently running operation
	TerminateOperation(ctx context.Context, in *OperationTerminateRequest, opts ...grpc.CallOption) (*OperationTerminateResponse, error)
	// GetResource returns single application resource
	GetResource(ctx context.Context, in *ApplicationResourceRequest, opts ...grpc.CallOption) (*ApplicationResourceResponse, error)
	// PatchResource patch single application resource
	PatchResource(ctx context.Context, in *ApplicationResourcePatchRequest, opts ...grpc.CallOption) (*ApplicationResourceResponse, error)
	// ListResourceActions returns list of resource actions
	ListResourceActions(ctx context.Context, in *ApplicationResourceRequest, opts ...grpc.CallOption) (*ResourceActionsListResponse, error)
	// RunResourceAction run resource action
	RunResourceAction(ctx context.Context, in *ResourceActionRunRequest, opts ...grpc.CallOption) (*ApplicationResponse, error)
	// DeleteResource deletes a single application resource
	DeleteResource(ctx context.Context, in *ApplicationResourceDeleteRequest, opts ...grpc.CallOption) (*ApplicationResponse, error)
	// PodLogs returns stream of log entries for the specified pod. Pod
	PodLogs(ctx context.Context, in *ApplicationPodLogsQuery, opts ...grpc.CallOption) (ApplicationService_PodLogsClient, error)
	// ListLinks returns the list of all application deep links
	ListLinks(ctx context.Context, in *ListAppLinksRequest, opts ...grpc.CallOption) (*LinksResponse, error)
	// ListResourceLinks returns the list of all resource deep links
	ListResourceLinks(ctx context.Context, in *ApplicationResourceRequest, opts ...grpc.CallOption) (*LinksResponse, error)
}

type applicationServiceClient struct {
	cc *grpc.ClientConn
}

func NewApplicationServiceClient(cc *grpc.ClientConn) ApplicationServiceClient {
	return &applicationServiceClient{cc}
}

func (c *applicationServiceClient) List(ctx context.Context, in *ApplicationQuery, opts ...grpc.CallOption) (*v1alpha1.ApplicationList, error) {
	out := new(v1alpha1.ApplicationList)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) ListResourceEvents(ctx context.Context, in *ApplicationResourceEventsQuery, opts ...grpc.CallOption) (*v11.EventList, error) {
	out := new(v11.EventList)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/ListResourceEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) Watch(ctx context.Context, in *ApplicationQuery, opts ...grpc.CallOption) (ApplicationService_WatchClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ApplicationService_serviceDesc.Streams[0], "/application.ApplicationService/Watch", opts...)
	if err != nil {
		return nil, err
	}
	x := &applicationServiceWatchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ApplicationService_WatchClient interface {
	Recv() (*v1alpha1.ApplicationWatchEvent, error)
	grpc.ClientStream
}

type applicationServiceWatchClient struct {
	grpc.ClientStream
}

func (x *applicationServiceWatchClient) Recv() (*v1alpha1.ApplicationWatchEvent, error) {
	m := new(v1alpha1.ApplicationWatchEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *applicationServiceClient) Create(ctx context.Context, in *ApplicationCreateRequest, opts ...grpc.CallOption) (*v1alpha1.Application, error) {
	out := new(v1alpha1.Application)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) Get(ctx context.Context, in *ApplicationQuery, opts ...grpc.CallOption) (*v1alpha1.Application, error) {
	out := new(v1alpha1.Application)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) GetApplicationSyncWindows(ctx context.Context, in *ApplicationSyncWindowsQuery, opts ...grpc.CallOption) (*ApplicationSyncWindowsResponse, error) {
	out := new(ApplicationSyncWindowsResponse)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/GetApplicationSyncWindows", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) RevisionMetadata(ctx context.Context, in *RevisionMetadataQuery, opts ...grpc.CallOption) (*v1alpha1.RevisionMetadata, error) {
	out := new(v1alpha1.RevisionMetadata)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/RevisionMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) RevisionChartDetails(ctx context.Context, in *RevisionMetadataQuery, opts ...grpc.CallOption) (*v1alpha1.ChartDetails, error) {
	out := new(v1alpha1.ChartDetails)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/RevisionChartDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) GetManifests(ctx context.Context, in *ApplicationManifestQuery, opts ...grpc.CallOption) (*apiclient.ManifestResponse, error) {
	out := new(apiclient.ManifestResponse)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/GetManifests", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) GetManifestsWithFiles(ctx context.Context, opts ...grpc.CallOption) (ApplicationService_GetManifestsWithFilesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ApplicationService_serviceDesc.Streams[1], "/application.ApplicationService/GetManifestsWithFiles", opts...)
	if err != nil {
		return nil, err
	}
	x := &applicationServiceGetManifestsWithFilesClient{stream}
	return x, nil
}

type ApplicationService_GetManifestsWithFilesClient interface {
	Send(*ApplicationManifestQueryWithFilesWrapper) error
	CloseAndRecv() (*apiclient.ManifestResponse, error)
	grpc.ClientStream
}

type applicationServiceGetManifestsWithFilesClient struct {
	grpc.ClientStream
}

func (x *applicationServiceGetManifestsWithFilesClient) Send(m *ApplicationManifestQueryWithFilesWrapper) error {
	return x.ClientStream.SendMsg(m)
}

func (x *applicationServiceGetManifestsWithFilesClient) CloseAndRecv() (*apiclient.ManifestResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(apiclient.ManifestResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *applicationServiceClient) Update(ctx context.Context, in *ApplicationUpdateRequest, opts ...grpc.CallOption) (*v1alpha1.Application, error) {
	out := new(v1alpha1.Application)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) UpdateSpec(ctx context.Context, in *ApplicationUpdateSpecRequest, opts ...grpc.CallOption) (*v1alpha1.ApplicationSpec, error) {
	out := new(v1alpha1.ApplicationSpec)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/UpdateSpec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) Patch(ctx context.Context, in *ApplicationPatchRequest, opts ...grpc.CallOption) (*v1alpha1.Application, error) {
	out := new(v1alpha1.Application)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/Patch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) Delete(ctx context.Context, in *ApplicationDeleteRequest, opts ...grpc.CallOption) (*ApplicationResponse, error) {
	out := new(ApplicationResponse)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) Sync(ctx context.Context, in *ApplicationSyncRequest, opts ...grpc.CallOption) (*v1alpha1.Application, error) {
	out := new(v1alpha1.Application)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/Sync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) ManagedResources(ctx context.Context, in *ResourcesQuery, opts ...grpc.CallOption) (*ManagedResourcesResponse, error) {
	out := new(ManagedResourcesResponse)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/ManagedResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) ResourceTree(ctx context.Context, in *ResourcesQuery, opts ...grpc.CallOption) (*v1alpha1.ApplicationTree, error) {
	out := new(v1alpha1.ApplicationTree)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/ResourceTree", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) WatchResourceTree(ctx context.Context, in *ResourcesQuery, opts ...grpc.CallOption) (ApplicationService_WatchResourceTreeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ApplicationService_serviceDesc.Streams[2], "/application.ApplicationService/WatchResourceTree", opts...)
	if err != nil {
		return nil, err
	}
	x := &applicationServiceWatchResourceTreeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ApplicationService_WatchResourceTreeClient interface {
	Recv() (*v1alpha1.ApplicationTree, error)
	grpc.ClientStream
}

type applicationServiceWatchResourceTreeClient struct {
	grpc.ClientStream
}

func (x *applicationServiceWatchResourceTreeClient) Recv() (*v1alpha1.ApplicationTree, error) {
	m := new(v1alpha1.ApplicationTree)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *applicationServiceClient) Rollback(ctx context.Context, in *ApplicationRollbackRequest, opts ...grpc.CallOption) (*v1alpha1.Application, error) {
	out := new(v1alpha1.Application)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/Rollback", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) TerminateOperation(ctx context.Context, in *OperationTerminateRequest, opts ...grpc.CallOption) (*OperationTerminateResponse, error) {
	out := new(OperationTerminateResponse)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/TerminateOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) GetResource(ctx context.Context, in *ApplicationResourceRequest, opts ...grpc.CallOption) (*ApplicationResourceResponse, error) {
	out := new(ApplicationResourceResponse)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/GetResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) PatchResource(ctx context.Context, in *ApplicationResourcePatchRequest, opts ...grpc.CallOption) (*ApplicationResourceResponse, error) {
	out := new(ApplicationResourceResponse)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/PatchResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) ListResourceActions(ctx context.Context, in *ApplicationResourceRequest, opts ...grpc.CallOption) (*ResourceActionsListResponse, error) {
	out := new(ResourceActionsListResponse)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/ListResourceActions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) RunResourceAction(ctx context.Context, in *ResourceActionRunRequest, opts ...grpc.CallOption) (*ApplicationResponse, error) {
	out := new(ApplicationResponse)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/RunResourceAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) DeleteResource(ctx context.Context, in *ApplicationResourceDeleteRequest, opts ...grpc.CallOption) (*ApplicationResponse, error) {
	out := new(ApplicationResponse)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/DeleteResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) PodLogs(ctx context.Context, in *ApplicationPodLogsQuery, opts ...grpc.CallOption) (ApplicationService_PodLogsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ApplicationService_serviceDesc.Streams[3], "/application.ApplicationService/PodLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &applicationServicePodLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ApplicationService_PodLogsClient interface {
	Recv() (*LogEntry, error)
	grpc.ClientStream
}

type applicationServicePodLogsClient struct {
	grpc.ClientStream
}

func (x *applicationServicePodLogsClient) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *applicationServiceClient) ListLinks(ctx context.Context, in *ListAppLinksRequest, opts ...grpc.CallOption) (*LinksResponse, error) {
	out := new(LinksResponse)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/ListLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) ListResourceLinks(ctx context.Context, in *ApplicationResourceRequest, opts ...grpc.CallOption) (*LinksResponse, error) {
	out := new(LinksResponse)
	err := c.cc.Invoke(ctx, "/application.ApplicationService/ListResourceLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationServiceServer is the server API for ApplicationService service.
type ApplicationServiceServer interface {
	// List returns list of applications
	List(context.Context, *ApplicationQuery) (*v1alpha1.ApplicationList, error)
	// ListResourceEvents returns a list of event resources
	ListResourceEvents(context.Context, *ApplicationResourceEventsQuery) (*v11.EventList, error)
	// Watch returns stream of application change events
	Watch(*ApplicationQuery, ApplicationService_WatchServer) error
	// Create creates an application
	Create(context.Context, *ApplicationCreateRequest) (*v1alpha1.Application, error)
	// Get returns an application by name
	Get(context.Context, *ApplicationQuery) (*v1alpha1.Application, error)
	// Get returns sync windows of the application
	GetApplicationSyncWindows(context.Context, *ApplicationSyncWindowsQuery) (*ApplicationSyncWindowsResponse, error)
	// Get the meta-data (author, date, tags, message) for a specific revision of the application
	RevisionMetadata(context.Context, *RevisionMetadataQuery) (*v1alpha1.RevisionMetadata, error)
	// Get the chart metadata (description, maintainers, home) for a specific revision of the application
	RevisionChartDetails(context.Context, *RevisionMetadataQuery) (*v1alpha1.ChartDetails, error)
	// GetManifests returns application manifests
	GetManifests(context.Context, *ApplicationManifestQuery) (*apiclient.ManifestResponse, error)
	// GetManifestsWithFiles returns application manifests using provided files to generate them
	GetManifestsWithFiles(ApplicationService_GetManifestsWithFilesServer) error
	// Update updates an application
	Update(context.Context, *ApplicationUpdateRequest) (*v1alpha1.Application, error)
	// UpdateSpec updates an application spec
	UpdateSpec(context.Context, *ApplicationUpdateSpecRequest) (*v1alpha1.ApplicationSpec, error)
	// Patch patch an application
	Patch(context.Context, *ApplicationPatchRequest) (*v1alpha1.Application, error)
	// Delete deletes an application
	Delete(context.Context, *ApplicationDeleteRequest) (*ApplicationResponse, error)
	// Sync syncs an application to its target state
	Sync(context.Context, *ApplicationSyncRequest) (*v1alpha1.Application, error)
	// ManagedResources returns list of managed resources
	ManagedResources(context.Context, *ResourcesQuery) (*ManagedResourcesResponse, error)
	// ResourceTree returns resource tree
	ResourceTree(context.Context, *ResourcesQuery) (*v1alpha1.ApplicationTree, error)
	// Watch returns stream of application resource tree
	WatchResourceTree(*ResourcesQuery, ApplicationService_WatchResourceTreeServer) error
	// Rollback syncs an application to its target state
	Rollback(context.Context, *ApplicationRollbackRequest) (*v1alpha1.Application, error)
	// TerminateOperation terminates the currently running operation
	TerminateOperation(context.Context, *OperationTerminateRequest) (*OperationTerminateResponse, error)
	// GetResource returns single application resource
	GetResource(context.Context, *ApplicationResourceRequest) (*ApplicationResourceResponse, error)
	// PatchResource patch single application resource
	PatchResource(context.Context, *ApplicationResourcePatchRequest) (*ApplicationResourceResponse, error)
	// ListResourceActions returns list of resource actions
	ListResourceActions(context.Context, *ApplicationResourceRequest) (*ResourceActionsListResponse, error)
	// RunResourceAction run resource action
	RunResourceAction(context.Context, *ResourceActionRunRequest) (*ApplicationResponse, error)
	// DeleteResource deletes a single application resource
	DeleteResource(context.Context, *ApplicationResourceDeleteRequest) (*ApplicationResponse, error)
	// PodLogs returns stream of log entries for the specified pod. Pod
	PodLogs(*ApplicationPodLogsQuery, ApplicationService_PodLogsServer) error
	// ListLinks returns the list of all application deep links
	ListLinks(context.Context, *ListAppLinksRequest) (*LinksResponse, error)
	// ListResourceLinks returns the list of all resource deep links
	ListResourceLinks(context.Context, *ApplicationResourceRequest) (*LinksResponse, error)
}

// UnimplementedApplicationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedApplicationServiceServer struct {
}

func (*UnimplementedApplicationServiceServer) List(ctx context.Context, req *ApplicationQuery) (*v1alpha1.ApplicationList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedApplicationServiceServer) ListResourceEvents(ctx context.Context, req *ApplicationResourceEventsQuery) (*v11.EventList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListResourceEvents not implemented")
}
func (*UnimplementedApplicationServiceServer) Watch(req *ApplicationQuery, srv ApplicationService_WatchServer) error {
	return status.Errorf(codes.Unimplemented, "method Watch not implemented")
}
func (*UnimplementedApplicationServiceServer) Create(ctx context.Context, req *ApplicationCreateRequest) (*v1alpha1.Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedApplicationServiceServer) Get(ctx context.Context, req *ApplicationQuery) (*v1alpha1.Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedApplicationServiceServer) GetApplicationSyncWindows(ctx context.Context, req *ApplicationSyncWindowsQuery) (*ApplicationSyncWindowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApplicationSyncWindows not implemented")
}
func (*UnimplementedApplicationServiceServer) RevisionMetadata(ctx context.Context, req *RevisionMetadataQuery) (*v1alpha1.RevisionMetadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevisionMetadata not implemented")
}
func (*UnimplementedApplicationServiceServer) RevisionChartDetails(ctx context.Context, req *RevisionMetadataQuery) (*v1alpha1.ChartDetails, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevisionChartDetails not implemented")
}
func (*UnimplementedApplicationServiceServer) GetManifests(ctx context.Context, req *ApplicationManifestQuery) (*apiclient.ManifestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetManifests not implemented")
}
func (*UnimplementedApplicationServiceServer) GetManifestsWithFiles(srv ApplicationService_GetManifestsWithFilesServer) error {
	return status.Errorf(codes.Unimplemented, "method GetManifestsWithFiles not implemented")
}
func (*UnimplementedApplicationServiceServer) Update(ctx context.Context, req *ApplicationUpdateRequest) (*v1alpha1.Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedApplicationServiceServer) UpdateSpec(ctx context.Context, req *ApplicationUpdateSpecRequest) (*v1alpha1.ApplicationSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSpec not implemented")
}
func (*UnimplementedApplicationServiceServer) Patch(ctx context.Context, req *ApplicationPatchRequest) (*v1alpha1.Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (*UnimplementedApplicationServiceServer) Delete(ctx context.Context, req *ApplicationDeleteRequest) (*ApplicationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedApplicationServiceServer) Sync(ctx context.Context, req *ApplicationSyncRequest) (*v1alpha1.Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Sync not implemented")
}
func (*UnimplementedApplicationServiceServer) ManagedResources(ctx context.Context, req *ResourcesQuery) (*ManagedResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ManagedResources not implemented")
}
func (*UnimplementedApplicationServiceServer) ResourceTree(ctx context.Context, req *ResourcesQuery) (*v1alpha1.ApplicationTree, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResourceTree not implemented")
}
func (*UnimplementedApplicationServiceServer) WatchResourceTree(req *ResourcesQuery, srv ApplicationService_WatchResourceTreeServer) error {
	return status.Errorf(codes.Unimplemented, "method WatchResourceTree not implemented")
}
func (*UnimplementedApplicationServiceServer) Rollback(ctx context.Context, req *ApplicationRollbackRequest) (*v1alpha1.Application, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Rollback not implemented")
}
func (*UnimplementedApplicationServiceServer) TerminateOperation(ctx context.Context, req *OperationTerminateRequest) (*OperationTerminateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TerminateOperation not implemented")
}
func (*UnimplementedApplicationServiceServer) GetResource(ctx context.Context, req *ApplicationResourceRequest) (*ApplicationResourceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetResource not implemented")
}
func (*UnimplementedApplicationServiceServer) PatchResource(ctx context.Context, req *ApplicationResourcePatchRequest) (*ApplicationResourceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchResource not implemented")
}
func (*UnimplementedApplicationServiceServer) ListResourceActions(ctx context.Context, req *ApplicationResourceRequest) (*ResourceActionsListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListResourceActions not implemented")
}
func (*UnimplementedApplicationServiceServer) RunResourceAction(ctx context.Context, req *ResourceActionRunRequest) (*ApplicationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunResourceAction not implemented")
}
func (*UnimplementedApplicationServiceServer) DeleteResource(ctx context.Context, req *ApplicationResourceDeleteRequest) (*ApplicationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteResource not implemented")
}
func (*UnimplementedApplicationServiceServer) PodLogs(req *ApplicationPodLogsQuery, srv ApplicationService_PodLogsServer) error {
	return status.Errorf(codes.Unimplemented, "method PodLogs not implemented")
}
func (*UnimplementedApplicationServiceServer) ListLinks(ctx context.Context, req *ListAppLinksRequest) (*LinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLinks not implemented")
}
func (*UnimplementedApplicationServiceServer) ListResourceLinks(ctx context.Context, req *ApplicationResourceRequest) (*LinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListResourceLinks not implemented")
}

func RegisterApplicationServiceServer(s *grpc.Server, srv ApplicationServiceServer) {
	s.RegisterService(&_ApplicationService_serviceDesc, srv)
}

func _ApplicationService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).List(ctx, req.(*ApplicationQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_ListResourceEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationResourceEventsQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).ListResourceEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/ListResourceEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).ListResourceEvents(ctx, req.(*ApplicationResourceEventsQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_Watch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ApplicationQuery)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ApplicationServiceServer).Watch(m, &applicationServiceWatchServer{stream})
}

type ApplicationService_WatchServer interface {
	Send(*v1alpha1.ApplicationWatchEvent) error
	grpc.ServerStream
}

type applicationServiceWatchServer struct {
	grpc.ServerStream
}

func (x *applicationServiceWatchServer) Send(m *v1alpha1.ApplicationWatchEvent) error {
	return x.ServerStream.SendMsg(m)
}

func _ApplicationService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationCreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).Create(ctx, req.(*ApplicationCreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).Get(ctx, req.(*ApplicationQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_GetApplicationSyncWindows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationSyncWindowsQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).GetApplicationSyncWindows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/GetApplicationSyncWindows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).GetApplicationSyncWindows(ctx, req.(*ApplicationSyncWindowsQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_RevisionMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevisionMetadataQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).RevisionMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/RevisionMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).RevisionMetadata(ctx, req.(*RevisionMetadataQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_RevisionChartDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevisionMetadataQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).RevisionChartDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/RevisionChartDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).RevisionChartDetails(ctx, req.(*RevisionMetadataQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_GetManifests_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationManifestQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).GetManifests(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/GetManifests",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).GetManifests(ctx, req.(*ApplicationManifestQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_GetManifestsWithFiles_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ApplicationServiceServer).GetManifestsWithFiles(&applicationServiceGetManifestsWithFilesServer{stream})
}

type ApplicationService_GetManifestsWithFilesServer interface {
	SendAndClose(*apiclient.ManifestResponse) error
	Recv() (*ApplicationManifestQueryWithFilesWrapper, error)
	grpc.ServerStream
}

type applicationServiceGetManifestsWithFilesServer struct {
	grpc.ServerStream
}

func (x *applicationServiceGetManifestsWithFilesServer) SendAndClose(m *apiclient.ManifestResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *applicationServiceGetManifestsWithFilesServer) Recv() (*ApplicationManifestQueryWithFilesWrapper, error) {
	m := new(ApplicationManifestQueryWithFilesWrapper)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ApplicationService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).Update(ctx, req.(*ApplicationUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_UpdateSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationUpdateSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).UpdateSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/UpdateSpec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).UpdateSpec(ctx, req.(*ApplicationUpdateSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationPatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/Patch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).Patch(ctx, req.(*ApplicationPatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).Delete(ctx, req.(*ApplicationDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_Sync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationSyncRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).Sync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/Sync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).Sync(ctx, req.(*ApplicationSyncRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_ManagedResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourcesQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).ManagedResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/ManagedResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).ManagedResources(ctx, req.(*ResourcesQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_ResourceTree_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourcesQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).ResourceTree(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/ResourceTree",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).ResourceTree(ctx, req.(*ResourcesQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_WatchResourceTree_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ResourcesQuery)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ApplicationServiceServer).WatchResourceTree(m, &applicationServiceWatchResourceTreeServer{stream})
}

type ApplicationService_WatchResourceTreeServer interface {
	Send(*v1alpha1.ApplicationTree) error
	grpc.ServerStream
}

type applicationServiceWatchResourceTreeServer struct {
	grpc.ServerStream
}

func (x *applicationServiceWatchResourceTreeServer) Send(m *v1alpha1.ApplicationTree) error {
	return x.ServerStream.SendMsg(m)
}

func _ApplicationService_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationRollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/Rollback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).Rollback(ctx, req.(*ApplicationRollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_TerminateOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OperationTerminateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).TerminateOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/TerminateOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).TerminateOperation(ctx, req.(*OperationTerminateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_GetResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).GetResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/GetResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).GetResource(ctx, req.(*ApplicationResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_PatchResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationResourcePatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).PatchResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/PatchResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).PatchResource(ctx, req.(*ApplicationResourcePatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_ListResourceActions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).ListResourceActions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/ListResourceActions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).ListResourceActions(ctx, req.(*ApplicationResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_RunResourceAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceActionRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).RunResourceAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/RunResourceAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).RunResourceAction(ctx, req.(*ResourceActionRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_DeleteResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationResourceDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).DeleteResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/DeleteResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).DeleteResource(ctx, req.(*ApplicationResourceDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_PodLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ApplicationPodLogsQuery)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ApplicationServiceServer).PodLogs(m, &applicationServicePodLogsServer{stream})
}

type ApplicationService_PodLogsServer interface {
	Send(*LogEntry) error
	grpc.ServerStream
}

type applicationServicePodLogsServer struct {
	grpc.ServerStream
}

func (x *applicationServicePodLogsServer) Send(m *LogEntry) error {
	return x.ServerStream.SendMsg(m)
}

func _ApplicationService_ListLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAppLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).ListLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/ListLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).ListLinks(ctx, req.(*ListAppLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_ListResourceLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplicationResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).ListResourceLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/application.ApplicationService/ListResourceLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).ListResourceLinks(ctx, req.(*ApplicationResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ApplicationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "application.ApplicationService",
	HandlerType: (*ApplicationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _ApplicationService_List_Handler,
		},
		{
			MethodName: "ListResourceEvents",
			Handler:    _ApplicationService_ListResourceEvents_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ApplicationService_Create_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ApplicationService_Get_Handler,
		},
		{
			MethodName: "GetApplicationSyncWindows",
			Handler:    _ApplicationService_GetApplicationSyncWindows_Handler,
		},
		{
			MethodName: "RevisionMetadata",
			Handler:    _ApplicationService_RevisionMetadata_Handler,
		},
		{
			MethodName: "RevisionChartDetails",
			Handler:    _ApplicationService_RevisionChartDetails_Handler,
		},
		{
			MethodName: "GetManifests",
			Handler:    _ApplicationService_GetManifests_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ApplicationService_Update_Handler,
		},
		{
			MethodName: "UpdateSpec",
			Handler:    _ApplicationService_UpdateSpec_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _ApplicationService_Patch_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ApplicationService_Delete_Handler,
		},
		{
			MethodName: "Sync",
			Handler:    _ApplicationService_Sync_Handler,
		},
		{
			MethodName: "ManagedResources",
			Handler:    _ApplicationService_ManagedResources_Handler,
		},
		{
			MethodName: "ResourceTree",
			Handler:    _ApplicationService_ResourceTree_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _ApplicationService_Rollback_Handler,
		},
		{
			MethodName: "TerminateOperation",
			Handler:    _ApplicationService_TerminateOperation_Handler,
		},
		{
			MethodName: "GetResource",
			Handler:    _ApplicationService_GetResource_Handler,
		},
		{
			MethodName: "PatchResource",
			Handler:    _ApplicationService_PatchResource_Handler,
		},
		{
			MethodName: "ListResourceActions",
			Handler:    _ApplicationService_ListResourceActions_Handler,
		},
		{
			MethodName: "RunResourceAction",
			Handler:    _ApplicationService_RunResourceAction_Handler,
		},
		{
			MethodName: "DeleteResource",
			Handler:    _ApplicationService_DeleteResource_Handler,
		},
		{
			MethodName: "ListLinks",
			Handler:    _ApplicationService_ListLinks_Handler,
		},
		{
			MethodName: "ListResourceLinks",
			Handler:    _ApplicationService_ListResourceLinks_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Watch",
			Handler:       _ApplicationService_Watch_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetManifestsWithFiles",
			Handler:       _ApplicationService_GetManifestsWithFiles_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "WatchResourceTree",
			Handler:       _ApplicationService_WatchResourceTree_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PodLogs",
			Handler:       _ApplicationService_PodLogs_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "server/application/application.proto",
}

func (m *ApplicationQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Project) > 0 {
		for iNdEx := len(m.Project) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Project[iNdEx])
			copy(dAtA[i:], m.Project[iNdEx])
			i = encodeVarintApplication(dAtA, i, uint64(len(m.Project[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Repo != nil {
		i -= len(*m.Repo)
		copy(dAtA[i:], *m.Repo)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Repo)))
		i--
		dAtA[i] = 0x32
	}
	if m.Selector != nil {
		i -= len(*m.Selector)
		copy(dAtA[i:], *m.Selector)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Selector)))
		i--
		dAtA[i] = 0x2a
	}
	if m.ResourceVersion != nil {
		i -= len(*m.ResourceVersion)
		copy(dAtA[i:], *m.ResourceVersion)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.ResourceVersion)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Projects) > 0 {
		for iNdEx := len(m.Projects) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Projects[iNdEx])
			copy(dAtA[i:], m.Projects[iNdEx])
			i = encodeVarintApplication(dAtA, i, uint64(len(m.Projects[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Refresh != nil {
		i -= len(*m.Refresh)
		copy(dAtA[i:], *m.Refresh)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Refresh)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name != nil {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NodeQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name != nil {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RevisionMetadataQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RevisionMetadataQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RevisionMetadataQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x22
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Revision == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("revision")
	} else {
		i -= len(*m.Revision)
		copy(dAtA[i:], *m.Revision)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Revision)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationResourceEventsQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationResourceEventsQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationResourceEventsQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x32
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x2a
	}
	if m.ResourceUID != nil {
		i -= len(*m.ResourceUID)
		copy(dAtA[i:], *m.ResourceUID)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.ResourceUID)))
		i--
		dAtA[i] = 0x22
	}
	if m.ResourceName != nil {
		i -= len(*m.ResourceName)
		copy(dAtA[i:], *m.ResourceName)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.ResourceName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ResourceNamespace != nil {
		i -= len(*m.ResourceNamespace)
		copy(dAtA[i:], *m.ResourceNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.ResourceNamespace)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationManifestQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationManifestQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationManifestQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Revisions) > 0 {
		for iNdEx := len(m.Revisions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Revisions[iNdEx])
			copy(dAtA[i:], m.Revisions[iNdEx])
			i = encodeVarintApplication(dAtA, i, uint64(len(m.Revisions[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.SourcePositions) > 0 {
		for iNdEx := len(m.SourcePositions) - 1; iNdEx >= 0; iNdEx-- {
			i = encodeVarintApplication(dAtA, i, uint64(m.SourcePositions[iNdEx]))
			i--
			dAtA[i] = 0x28
		}
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x22
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Revision != nil {
		i -= len(*m.Revision)
		copy(dAtA[i:], *m.Revision)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Revision)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FileChunk) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FileChunk) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FileChunk) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Chunk == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("chunk")
	} else {
		i -= len(m.Chunk)
		copy(dAtA[i:], m.Chunk)
		i = encodeVarintApplication(dAtA, i, uint64(len(m.Chunk)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationManifestQueryWithFiles) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationManifestQueryWithFiles) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationManifestQueryWithFiles) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x22
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Checksum == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("checksum")
	} else {
		i -= len(*m.Checksum)
		copy(dAtA[i:], *m.Checksum)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Checksum)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationManifestQueryWithFilesWrapper) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationManifestQueryWithFilesWrapper) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationManifestQueryWithFilesWrapper) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Part != nil {
		{
			size := m.Part.Size()
			i -= size
			if _, err := m.Part.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationManifestQueryWithFilesWrapper_Query) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationManifestQueryWithFilesWrapper_Query) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Query != nil {
		{
			size, err := m.Query.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApplication(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *ApplicationManifestQueryWithFilesWrapper_Chunk) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationManifestQueryWithFilesWrapper_Chunk) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Chunk != nil {
		{
			size, err := m.Chunk.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApplication(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *ApplicationResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationCreateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationCreateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationCreateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Validate != nil {
		i--
		if *m.Validate {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Upsert != nil {
		i--
		if *m.Upsert {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Application == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("application")
	} else {
		{
			size, err := m.Application.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApplication(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationUpdateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationUpdateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationUpdateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Validate != nil {
		i--
		if *m.Validate {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Application == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("application")
	} else {
		{
			size, err := m.Application.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApplication(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationDeleteRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationDeleteRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationDeleteRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x2a
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x22
	}
	if m.PropagationPolicy != nil {
		i -= len(*m.PropagationPolicy)
		copy(dAtA[i:], *m.PropagationPolicy)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.PropagationPolicy)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Cascade != nil {
		i--
		if *m.Cascade {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SyncOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SyncOptions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SyncOptions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Items[iNdEx])
			copy(dAtA[i:], m.Items[iNdEx])
			i = encodeVarintApplication(dAtA, i, uint64(len(m.Items[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationSyncRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationSyncRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationSyncRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x6a
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x62
	}
	if m.SyncOptions != nil {
		{
			size, err := m.SyncOptions.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApplication(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.RetryStrategy != nil {
		{
			size, err := m.RetryStrategy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApplication(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.Infos) > 0 {
		for iNdEx := len(m.Infos) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Infos[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApplication(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Manifests) > 0 {
		for iNdEx := len(m.Manifests) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Manifests[iNdEx])
			copy(dAtA[i:], m.Manifests[iNdEx])
			i = encodeVarintApplication(dAtA, i, uint64(len(m.Manifests[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Resources) > 0 {
		for iNdEx := len(m.Resources) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Resources[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApplication(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Strategy != nil {
		{
			size, err := m.Strategy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApplication(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Prune != nil {
		i--
		if *m.Prune {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.DryRun != nil {
		i--
		if *m.DryRun {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Revision != nil {
		i -= len(*m.Revision)
		copy(dAtA[i:], *m.Revision)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Revision)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationUpdateSpecRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationUpdateSpecRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationUpdateSpecRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x2a
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x22
	}
	if m.Validate != nil {
		i--
		if *m.Validate {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Spec == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("spec")
	} else {
		{
			size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApplication(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationPatchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationPatchRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationPatchRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x32
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x2a
	}
	if m.PatchType == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("patchType")
	} else {
		i -= len(*m.PatchType)
		copy(dAtA[i:], *m.PatchType)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.PatchType)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Patch == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("patch")
	} else {
		i -= len(*m.Patch)
		copy(dAtA[i:], *m.Patch)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Patch)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationRollbackRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationRollbackRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationRollbackRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x3a
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x32
	}
	if m.Prune != nil {
		i--
		if *m.Prune {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.DryRun != nil {
		i--
		if *m.DryRun {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Id == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	} else {
		i = encodeVarintApplication(dAtA, i, uint64(*m.Id))
		i--
		dAtA[i] = 0x10
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationResourceRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationResourceRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationResourceRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x42
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Kind == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("kind")
	} else {
		i -= len(*m.Kind)
		copy(dAtA[i:], *m.Kind)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Kind)))
		i--
		dAtA[i] = 0x32
	}
	if m.Group != nil {
		i -= len(*m.Group)
		copy(dAtA[i:], *m.Group)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Group)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Version == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("version")
	} else {
		i -= len(*m.Version)
		copy(dAtA[i:], *m.Version)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Version)))
		i--
		dAtA[i] = 0x22
	}
	if m.ResourceName == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("resourceName")
	} else {
		i -= len(*m.ResourceName)
		copy(dAtA[i:], *m.ResourceName)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.ResourceName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Namespace != nil {
		i -= len(*m.Namespace)
		copy(dAtA[i:], *m.Namespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationResourcePatchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationResourcePatchRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationResourcePatchRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x52
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x4a
	}
	if m.PatchType == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("patchType")
	} else {
		i -= len(*m.PatchType)
		copy(dAtA[i:], *m.PatchType)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.PatchType)))
		i--
		dAtA[i] = 0x42
	}
	if m.Patch == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("patch")
	} else {
		i -= len(*m.Patch)
		copy(dAtA[i:], *m.Patch)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Patch)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Kind == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("kind")
	} else {
		i -= len(*m.Kind)
		copy(dAtA[i:], *m.Kind)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Kind)))
		i--
		dAtA[i] = 0x32
	}
	if m.Group != nil {
		i -= len(*m.Group)
		copy(dAtA[i:], *m.Group)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Group)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Version == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("version")
	} else {
		i -= len(*m.Version)
		copy(dAtA[i:], *m.Version)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Version)))
		i--
		dAtA[i] = 0x22
	}
	if m.ResourceName == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("resourceName")
	} else {
		i -= len(*m.ResourceName)
		copy(dAtA[i:], *m.ResourceName)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.ResourceName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Namespace != nil {
		i -= len(*m.Namespace)
		copy(dAtA[i:], *m.Namespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationResourceDeleteRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationResourceDeleteRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationResourceDeleteRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x52
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x4a
	}
	if m.Orphan != nil {
		i--
		if *m.Orphan {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.Force != nil {
		i--
		if *m.Force {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.Kind == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("kind")
	} else {
		i -= len(*m.Kind)
		copy(dAtA[i:], *m.Kind)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Kind)))
		i--
		dAtA[i] = 0x32
	}
	if m.Group != nil {
		i -= len(*m.Group)
		copy(dAtA[i:], *m.Group)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Group)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Version == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("version")
	} else {
		i -= len(*m.Version)
		copy(dAtA[i:], *m.Version)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Version)))
		i--
		dAtA[i] = 0x22
	}
	if m.ResourceName == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("resourceName")
	} else {
		i -= len(*m.ResourceName)
		copy(dAtA[i:], *m.ResourceName)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.ResourceName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Namespace != nil {
		i -= len(*m.Namespace)
		copy(dAtA[i:], *m.Namespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResourceActionRunRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceActionRunRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceActionRunRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x4a
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x42
	}
	if m.Action == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("action")
	} else {
		i -= len(*m.Action)
		copy(dAtA[i:], *m.Action)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Action)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Kind == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("kind")
	} else {
		i -= len(*m.Kind)
		copy(dAtA[i:], *m.Kind)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Kind)))
		i--
		dAtA[i] = 0x32
	}
	if m.Group != nil {
		i -= len(*m.Group)
		copy(dAtA[i:], *m.Group)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Group)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Version == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("version")
	} else {
		i -= len(*m.Version)
		copy(dAtA[i:], *m.Version)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Version)))
		i--
		dAtA[i] = 0x22
	}
	if m.ResourceName == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("resourceName")
	} else {
		i -= len(*m.ResourceName)
		copy(dAtA[i:], *m.ResourceName)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.ResourceName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Namespace != nil {
		i -= len(*m.Namespace)
		copy(dAtA[i:], *m.Namespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResourceActionsListResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceActionsListResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceActionsListResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Actions) > 0 {
		for iNdEx := len(m.Actions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Actions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApplication(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationResourceResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationResourceResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationResourceResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Manifest == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("manifest")
	} else {
		i -= len(*m.Manifest)
		copy(dAtA[i:], *m.Manifest)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Manifest)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationPodLogsQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationPodLogsQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationPodLogsQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x7a
	}
	if m.Previous != nil {
		i--
		if *m.Previous {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x70
	}
	if m.ResourceName != nil {
		i -= len(*m.ResourceName)
		copy(dAtA[i:], *m.ResourceName)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.ResourceName)))
		i--
		dAtA[i] = 0x6a
	}
	if m.Group != nil {
		i -= len(*m.Group)
		copy(dAtA[i:], *m.Group)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Group)))
		i--
		dAtA[i] = 0x62
	}
	if m.Kind != nil {
		i -= len(*m.Kind)
		copy(dAtA[i:], *m.Kind)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Kind)))
		i--
		dAtA[i] = 0x5a
	}
	if m.Filter != nil {
		i -= len(*m.Filter)
		copy(dAtA[i:], *m.Filter)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Filter)))
		i--
		dAtA[i] = 0x52
	}
	if m.UntilTime != nil {
		i -= len(*m.UntilTime)
		copy(dAtA[i:], *m.UntilTime)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.UntilTime)))
		i--
		dAtA[i] = 0x4a
	}
	if m.Follow != nil {
		i--
		if *m.Follow {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.TailLines != nil {
		i = encodeVarintApplication(dAtA, i, uint64(*m.TailLines))
		i--
		dAtA[i] = 0x38
	}
	if m.SinceTime != nil {
		{
			size, err := m.SinceTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApplication(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.SinceSeconds != nil {
		i = encodeVarintApplication(dAtA, i, uint64(*m.SinceSeconds))
		i--
		dAtA[i] = 0x28
	}
	if m.Container != nil {
		i -= len(*m.Container)
		copy(dAtA[i:], *m.Container)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Container)))
		i--
		dAtA[i] = 0x22
	}
	if m.PodName != nil {
		i -= len(*m.PodName)
		copy(dAtA[i:], *m.PodName)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.PodName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Namespace != nil {
		i -= len(*m.Namespace)
		copy(dAtA[i:], *m.Namespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LogEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogEntry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LogEntry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.PodName == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("podName")
	} else {
		i -= len(*m.PodName)
		copy(dAtA[i:], *m.PodName)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.PodName)))
		i--
		dAtA[i] = 0x2a
	}
	if m.TimeStampStr == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("timeStampStr")
	} else {
		i -= len(*m.TimeStampStr)
		copy(dAtA[i:], *m.TimeStampStr)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.TimeStampStr)))
		i--
		dAtA[i] = 0x22
	}
	if m.Last == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("last")
	} else {
		i--
		if *m.Last {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.TimeStamp == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("timeStamp")
	} else {
		{
			size, err := m.TimeStamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApplication(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Content == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("content")
	} else {
		i -= len(*m.Content)
		copy(dAtA[i:], *m.Content)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Content)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OperationTerminateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OperationTerminateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OperationTerminateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x1a
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationSyncWindowsQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationSyncWindowsQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationSyncWindowsQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x1a
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x12
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationSyncWindowsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationSyncWindowsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationSyncWindowsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CanSync == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("canSync")
	} else {
		i--
		if *m.CanSync {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.AssignedWindows) > 0 {
		for iNdEx := len(m.AssignedWindows) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AssignedWindows[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApplication(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ActiveWindows) > 0 {
		for iNdEx := len(m.ActiveWindows) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ActiveWindows[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApplication(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ApplicationSyncWindow) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplicationSyncWindow) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplicationSyncWindow) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ManualSync == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("manualSync")
	} else {
		i--
		if *m.ManualSync {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Duration == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("duration")
	} else {
		i -= len(*m.Duration)
		copy(dAtA[i:], *m.Duration)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Duration)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Schedule == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("schedule")
	} else {
		i -= len(*m.Schedule)
		copy(dAtA[i:], *m.Schedule)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Schedule)))
		i--
		dAtA[i] = 0x12
	}
	if m.Kind == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("kind")
	} else {
		i -= len(*m.Kind)
		copy(dAtA[i:], *m.Kind)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Kind)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OperationTerminateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OperationTerminateResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OperationTerminateResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ResourcesQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourcesQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourcesQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x42
	}
	if m.AppNamespace != nil {
		i -= len(*m.AppNamespace)
		copy(dAtA[i:], *m.AppNamespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.AppNamespace)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Kind != nil {
		i -= len(*m.Kind)
		copy(dAtA[i:], *m.Kind)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Kind)))
		i--
		dAtA[i] = 0x32
	}
	if m.Group != nil {
		i -= len(*m.Group)
		copy(dAtA[i:], *m.Group)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Group)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Version != nil {
		i -= len(*m.Version)
		copy(dAtA[i:], *m.Version)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Version)))
		i--
		dAtA[i] = 0x22
	}
	if m.Name != nil {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Namespace != nil {
		i -= len(*m.Namespace)
		copy(dAtA[i:], *m.Namespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if m.ApplicationName == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("applicationName")
	} else {
		i -= len(*m.ApplicationName)
		copy(dAtA[i:], *m.ApplicationName)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.ApplicationName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ManagedResourcesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ManagedResourcesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ManagedResourcesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApplication(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *LinkInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinkInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinkInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IconClass != nil {
		i -= len(*m.IconClass)
		copy(dAtA[i:], *m.IconClass)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.IconClass)))
		i--
		dAtA[i] = 0x22
	}
	if m.Description != nil {
		i -= len(*m.Description)
		copy(dAtA[i:], *m.Description)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Description)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Url == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("url")
	} else {
		i -= len(*m.Url)
		copy(dAtA[i:], *m.Url)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if m.Title == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("title")
	} else {
		i -= len(*m.Title)
		copy(dAtA[i:], *m.Title)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Title)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LinksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LinksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LinksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApplication(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListAppLinksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListAppLinksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAppLinksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Project != nil {
		i -= len(*m.Project)
		copy(dAtA[i:], *m.Project)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Project)))
		i--
		dAtA[i] = 0x22
	}
	if m.Namespace != nil {
		i -= len(*m.Namespace)
		copy(dAtA[i:], *m.Namespace)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Namespace)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		i -= len(*m.Name)
		copy(dAtA[i:], *m.Name)
		i = encodeVarintApplication(dAtA, i, uint64(len(*m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintApplication(dAtA []byte, offset int, v uint64) int {
	offset -= sovApplication(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ApplicationQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Refresh != nil {
		l = len(*m.Refresh)
		n += 1 + l + sovApplication(uint64(l))
	}
	if len(m.Projects) > 0 {
		for _, s := range m.Projects {
			l = len(s)
			n += 1 + l + sovApplication(uint64(l))
		}
	}
	if m.ResourceVersion != nil {
		l = len(*m.ResourceVersion)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Selector != nil {
		l = len(*m.Selector)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Repo != nil {
		l = len(*m.Repo)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if len(m.Project) > 0 {
		for _, s := range m.Project {
			l = len(s)
			n += 1 + l + sovApplication(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RevisionMetadataQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Revision != nil {
		l = len(*m.Revision)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationResourceEventsQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.ResourceNamespace != nil {
		l = len(*m.ResourceNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.ResourceName != nil {
		l = len(*m.ResourceName)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.ResourceUID != nil {
		l = len(*m.ResourceUID)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationManifestQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Revision != nil {
		l = len(*m.Revision)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if len(m.SourcePositions) > 0 {
		for _, e := range m.SourcePositions {
			n += 1 + sovApplication(uint64(e))
		}
	}
	if len(m.Revisions) > 0 {
		for _, s := range m.Revisions {
			l = len(s)
			n += 1 + l + sovApplication(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FileChunk) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Chunk != nil {
		l = len(m.Chunk)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationManifestQueryWithFiles) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Checksum != nil {
		l = len(*m.Checksum)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationManifestQueryWithFilesWrapper) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Part != nil {
		n += m.Part.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationManifestQueryWithFilesWrapper_Query) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Query != nil {
		l = m.Query.Size()
		n += 1 + l + sovApplication(uint64(l))
	}
	return n
}
func (m *ApplicationManifestQueryWithFilesWrapper_Chunk) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Chunk != nil {
		l = m.Chunk.Size()
		n += 1 + l + sovApplication(uint64(l))
	}
	return n
}
func (m *ApplicationResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationCreateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Application != nil {
		l = m.Application.Size()
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Upsert != nil {
		n += 2
	}
	if m.Validate != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationUpdateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Application != nil {
		l = m.Application.Size()
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Validate != nil {
		n += 2
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationDeleteRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Cascade != nil {
		n += 2
	}
	if m.PropagationPolicy != nil {
		l = len(*m.PropagationPolicy)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SyncOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, s := range m.Items {
			l = len(s)
			n += 1 + l + sovApplication(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationSyncRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Revision != nil {
		l = len(*m.Revision)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.DryRun != nil {
		n += 2
	}
	if m.Prune != nil {
		n += 2
	}
	if m.Strategy != nil {
		l = m.Strategy.Size()
		n += 1 + l + sovApplication(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovApplication(uint64(l))
		}
	}
	if len(m.Manifests) > 0 {
		for _, s := range m.Manifests {
			l = len(s)
			n += 1 + l + sovApplication(uint64(l))
		}
	}
	if len(m.Infos) > 0 {
		for _, e := range m.Infos {
			l = e.Size()
			n += 1 + l + sovApplication(uint64(l))
		}
	}
	if m.RetryStrategy != nil {
		l = m.RetryStrategy.Size()
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.SyncOptions != nil {
		l = m.SyncOptions.Size()
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationUpdateSpecRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Spec != nil {
		l = m.Spec.Size()
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Validate != nil {
		n += 2
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationPatchRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Patch != nil {
		l = len(*m.Patch)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.PatchType != nil {
		l = len(*m.PatchType)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationRollbackRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Id != nil {
		n += 1 + sovApplication(uint64(*m.Id))
	}
	if m.DryRun != nil {
		n += 2
	}
	if m.Prune != nil {
		n += 2
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationResourceRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Namespace != nil {
		l = len(*m.Namespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.ResourceName != nil {
		l = len(*m.ResourceName)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Version != nil {
		l = len(*m.Version)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Group != nil {
		l = len(*m.Group)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Kind != nil {
		l = len(*m.Kind)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationResourcePatchRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Namespace != nil {
		l = len(*m.Namespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.ResourceName != nil {
		l = len(*m.ResourceName)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Version != nil {
		l = len(*m.Version)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Group != nil {
		l = len(*m.Group)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Kind != nil {
		l = len(*m.Kind)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Patch != nil {
		l = len(*m.Patch)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.PatchType != nil {
		l = len(*m.PatchType)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationResourceDeleteRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Namespace != nil {
		l = len(*m.Namespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.ResourceName != nil {
		l = len(*m.ResourceName)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Version != nil {
		l = len(*m.Version)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Group != nil {
		l = len(*m.Group)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Kind != nil {
		l = len(*m.Kind)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Force != nil {
		n += 2
	}
	if m.Orphan != nil {
		n += 2
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceActionRunRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Namespace != nil {
		l = len(*m.Namespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.ResourceName != nil {
		l = len(*m.ResourceName)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Version != nil {
		l = len(*m.Version)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Group != nil {
		l = len(*m.Group)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Kind != nil {
		l = len(*m.Kind)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Action != nil {
		l = len(*m.Action)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceActionsListResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Actions) > 0 {
		for _, e := range m.Actions {
			l = e.Size()
			n += 1 + l + sovApplication(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationResourceResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Manifest != nil {
		l = len(*m.Manifest)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationPodLogsQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Namespace != nil {
		l = len(*m.Namespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.PodName != nil {
		l = len(*m.PodName)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Container != nil {
		l = len(*m.Container)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.SinceSeconds != nil {
		n += 1 + sovApplication(uint64(*m.SinceSeconds))
	}
	if m.SinceTime != nil {
		l = m.SinceTime.Size()
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.TailLines != nil {
		n += 1 + sovApplication(uint64(*m.TailLines))
	}
	if m.Follow != nil {
		n += 2
	}
	if m.UntilTime != nil {
		l = len(*m.UntilTime)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Filter != nil {
		l = len(*m.Filter)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Kind != nil {
		l = len(*m.Kind)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Group != nil {
		l = len(*m.Group)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.ResourceName != nil {
		l = len(*m.ResourceName)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Previous != nil {
		n += 2
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 2 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LogEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Content != nil {
		l = len(*m.Content)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.TimeStamp != nil {
		l = m.TimeStamp.Size()
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Last != nil {
		n += 2
	}
	if m.TimeStampStr != nil {
		l = len(*m.TimeStampStr)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.PodName != nil {
		l = len(*m.PodName)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OperationTerminateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationSyncWindowsQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationSyncWindowsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ActiveWindows) > 0 {
		for _, e := range m.ActiveWindows {
			l = e.Size()
			n += 1 + l + sovApplication(uint64(l))
		}
	}
	if len(m.AssignedWindows) > 0 {
		for _, e := range m.AssignedWindows {
			l = e.Size()
			n += 1 + l + sovApplication(uint64(l))
		}
	}
	if m.CanSync != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplicationSyncWindow) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Kind != nil {
		l = len(*m.Kind)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Schedule != nil {
		l = len(*m.Schedule)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Duration != nil {
		l = len(*m.Duration)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.ManualSync != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OperationTerminateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourcesQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ApplicationName != nil {
		l = len(*m.ApplicationName)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Namespace != nil {
		l = len(*m.Namespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Version != nil {
		l = len(*m.Version)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Group != nil {
		l = len(*m.Group)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Kind != nil {
		l = len(*m.Kind)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.AppNamespace != nil {
		l = len(*m.AppNamespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ManagedResourcesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovApplication(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinkInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Title != nil {
		l = len(*m.Title)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Url != nil {
		l = len(*m.Url)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Description != nil {
		l = len(*m.Description)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.IconClass != nil {
		l = len(*m.IconClass)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LinksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovApplication(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListAppLinksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Namespace != nil {
		l = len(*m.Namespace)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.Project != nil {
		l = len(*m.Project)
		n += 1 + l + sovApplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovApplication(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozApplication(x uint64) (n int) {
	return sovApplication(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ApplicationQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Refresh", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Refresh = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Projects", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Projects = append(m.Projects, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ResourceVersion = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selector", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Selector = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Repo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Repo = &s
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Project = append(m.Project, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RevisionMetadataQuery) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RevisionMetadataQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RevisionMetadataQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revision", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Revision = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("revision")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationResourceEventsQuery) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationResourceEventsQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationResourceEventsQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ResourceNamespace = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ResourceName = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceUID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ResourceUID = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationManifestQuery) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationManifestQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationManifestQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revision", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Revision = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		case 5:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApplication
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.SourcePositions = append(m.SourcePositions, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowApplication
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthApplication
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthApplication
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.SourcePositions) == 0 {
					m.SourcePositions = make([]int64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowApplication
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.SourcePositions = append(m.SourcePositions, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field SourcePositions", wireType)
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revisions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Revisions = append(m.Revisions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FileChunk) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FileChunk: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FileChunk: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Chunk", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Chunk = append(m.Chunk[:0], dAtA[iNdEx:postIndex]...)
			if m.Chunk == nil {
				m.Chunk = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("chunk")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationManifestQueryWithFiles) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationManifestQueryWithFiles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationManifestQueryWithFiles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checksum", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Checksum = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("checksum")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationManifestQueryWithFilesWrapper) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationManifestQueryWithFilesWrapper: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationManifestQueryWithFilesWrapper: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ApplicationManifestQueryWithFiles{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Part = &ApplicationManifestQueryWithFilesWrapper_Query{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Chunk", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &FileChunk{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Part = &ApplicationManifestQueryWithFilesWrapper_Chunk{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationCreateRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationCreateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationCreateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Application", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Application == nil {
				m.Application = &v1alpha1.Application{}
			}
			if err := m.Application.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Upsert", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Upsert = &b
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validate", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Validate = &b
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("application")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationUpdateRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationUpdateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationUpdateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Application", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Application == nil {
				m.Application = &v1alpha1.Application{}
			}
			if err := m.Application.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validate", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Validate = &b
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("application")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationDeleteRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationDeleteRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationDeleteRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cascade", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Cascade = &b
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PropagationPolicy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.PropagationPolicy = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SyncOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SyncOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SyncOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationSyncRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationSyncRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationSyncRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revision", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Revision = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DryRun", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.DryRun = &b
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prune", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Prune = &b
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Strategy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Strategy == nil {
				m.Strategy = &v1alpha1.SyncStrategy{}
			}
			if err := m.Strategy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &v1alpha1.SyncOperationResource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Manifests", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Manifests = append(m.Manifests, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Infos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Infos = append(m.Infos, &v1alpha1.Info{})
			if err := m.Infos[len(m.Infos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryStrategy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryStrategy == nil {
				m.RetryStrategy = &v1alpha1.RetryStrategy{}
			}
			if err := m.RetryStrategy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SyncOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SyncOptions == nil {
				m.SyncOptions = &SyncOptions{}
			}
			if err := m.SyncOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationUpdateSpecRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationUpdateSpecRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationUpdateSpecRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Spec == nil {
				m.Spec = &v1alpha1.ApplicationSpec{}
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validate", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Validate = &b
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("spec")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationPatchRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationPatchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationPatchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Patch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Patch = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PatchType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.PatchType = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("patch")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("patchType")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationRollbackRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationRollbackRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationRollbackRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Id = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DryRun", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.DryRun = &b
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prune", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Prune = &b
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationResourceRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationResourceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationResourceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Namespace = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ResourceName = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Version = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Group = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Kind = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000008)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("resourceName")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("version")
	}
	if hasFields[0]&uint64(0x00000008) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("kind")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationResourcePatchRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationResourcePatchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationResourcePatchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Namespace = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ResourceName = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Version = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Group = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Kind = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000008)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Patch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Patch = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000010)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PatchType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.PatchType = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000020)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("resourceName")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("version")
	}
	if hasFields[0]&uint64(0x00000008) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("kind")
	}
	if hasFields[0]&uint64(0x00000010) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("patch")
	}
	if hasFields[0]&uint64(0x00000020) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("patchType")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationResourceDeleteRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationResourceDeleteRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationResourceDeleteRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Namespace = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ResourceName = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Version = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Group = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Kind = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000008)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Force = &b
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Orphan", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Orphan = &b
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("resourceName")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("version")
	}
	if hasFields[0]&uint64(0x00000008) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("kind")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceActionRunRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceActionRunRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceActionRunRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Namespace = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ResourceName = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Version = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Group = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Kind = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000008)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Action = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000010)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("resourceName")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("version")
	}
	if hasFields[0]&uint64(0x00000008) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("kind")
	}
	if hasFields[0]&uint64(0x00000010) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("action")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceActionsListResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceActionsListResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceActionsListResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Actions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Actions = append(m.Actions, &v1alpha1.ResourceAction{})
			if err := m.Actions[len(m.Actions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationResourceResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationResourceResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationResourceResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Manifest", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Manifest = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("manifest")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationPodLogsQuery) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationPodLogsQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationPodLogsQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Namespace = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.PodName = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Container = &s
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SinceSeconds", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SinceSeconds = &v
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SinceTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SinceTime == nil {
				m.SinceTime = &v1.Time{}
			}
			if err := m.SinceTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TailLines", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TailLines = &v
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Follow", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Follow = &b
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UntilTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.UntilTime = &s
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Filter = &s
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Kind = &s
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Group = &s
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ResourceName = &s
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Previous", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Previous = &b
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogEntry) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Content", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Content = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeStamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeStamp == nil {
				m.TimeStamp = &v1.Time{}
			}
			if err := m.TimeStamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Last", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Last = &b
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeStampStr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.TimeStampStr = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000008)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.PodName = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000010)
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("content")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("timeStamp")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("last")
	}
	if hasFields[0]&uint64(0x00000008) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("timeStampStr")
	}
	if hasFields[0]&uint64(0x00000010) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("podName")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OperationTerminateRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OperationTerminateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OperationTerminateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationSyncWindowsQuery) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationSyncWindowsQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationSyncWindowsQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationSyncWindowsResponse) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationSyncWindowsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationSyncWindowsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveWindows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActiveWindows = append(m.ActiveWindows, &ApplicationSyncWindow{})
			if err := m.ActiveWindows[len(m.ActiveWindows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AssignedWindows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AssignedWindows = append(m.AssignedWindows, &ApplicationSyncWindow{})
			if err := m.AssignedWindows[len(m.AssignedWindows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CanSync", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.CanSync = &b
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("canSync")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplicationSyncWindow) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplicationSyncWindow: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplicationSyncWindow: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Kind = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schedule", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Schedule = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Duration = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ManualSync", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ManualSync = &b
			hasFields[0] |= uint64(0x00000008)
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("kind")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("schedule")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("duration")
	}
	if hasFields[0]&uint64(0x00000008) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("manualSync")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OperationTerminateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OperationTerminateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OperationTerminateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourcesQuery) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourcesQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourcesQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplicationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ApplicationName = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Namespace = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Version = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Group = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Kind = &s
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.AppNamespace = &s
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("applicationName")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManagedResourcesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManagedResourcesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManagedResourcesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &v1alpha1.ResourceDiff{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinkInfo) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinkInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinkInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Title", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Title = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Url = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Description = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IconClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.IconClass = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("title")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("url")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LinksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LinksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LinksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &LinkInfo{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListAppLinksRequest) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListAppLinksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListAppLinksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Namespace = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Project", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Project = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipApplication(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowApplication
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApplication
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthApplication
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupApplication
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthApplication
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthApplication        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowApplication          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupApplication = fmt.Errorf("proto: unexpected end of group")
)
