# v2.3 to 2.4

## KSonnet support is removed

Ksonnet was deprecated in [2019](https://github.com/ksonnet/ksonnet/pull/914/files) and is no longer maintained.
The time has come to remove it from the Argo CD.

## Helm 2 support is removed

Helm 2 has not been officially supported since [Nov 2020](https://helm.sh/blog/helm-2-becomes-unsupported/). In order to ensure a smooth transition,
Helm 2 support was preserved in the Argo CD. We feel that Helm 3 is stable, and it is time to drop Helm 2 support.

## Configure RBAC to account for new `exec` resource

2.4 introduces a new `exec` [RBAC resource](https://argo-cd.readthedocs.io/en/stable/operator-manual/rbac/#rbac-resources-and-actions).

When you upgrade to 2.4, RBAC policies with `*` in the resource field and `create` or `*` in the action field will automatically grant the `exec` privilege.

To avoid granting the new privilege, replace the existing policy with a list of new policies explicitly listing the old resources.

The exec feature is [disabled by default](https://argo-cd.readthedocs.io/en/stable/operator-manual/rbac/#exec-resource), 
but it is still a good idea to double-check your RBAC configuration to enforce least necessary privileges.

### Example

Old:

```csv
p, role:org-admin, *, create, my-proj/*, allow
```

New:

```csv
p, role: org-admin, clusters, create, my-proj/*, allow
p, role: org-admin, projects, create, my-proj/*, allow
p, role: org-admin, applications, create, my-proj/*, allow
p, role: org-admin, repositories, create, my-proj/*, allow
p, role: org-admin, certificates, create, my-proj/*, allow
p, role: org-admin, accounts, create, my-proj/*, allow
p, role: org-admin, gpgkeys, create, my-proj/*, allow
```

## Enable logs RBAC enforcement

2.4 introduced `logs` as a new RBAC resource. In 2.3, users with `applications, get` access automatically get logs
access. In 2.5, you will have to explicitly grant `logs, get` access. Logs RBAC enforcement can be enabled with a flag
in 2.4. We recommend enabling the flag now for an easier upgrade experience in 2.5.

To enabled logs RBAC enforcement, add this to your argocd-cm ConfigMap:

```yaml
server.rbac.log.enforce.enable: "true"
```

If you want to allow the same users to continue to have logs access, just find every line that grants 
`applications, get` access and also grant `logs, get`. 

### Example

Old:

```csv
p, role:staging-db-admins, applications, get, staging-db-admins/*, allow

p, role:test-db-admins, applications, *, staging-db-admins/*, allow
```

New:

```csv
p, role:staging-db-admins, applications, get, staging-db-admins/*, allow
p, role:staging-db-admins, logs, get, staging-db-admins/*, allow

p, role:test-db-admins, applications, *, staging-db-admins/*, allow
p, role:test-db-admins, logs, get, staging-db-admins/*, allow
```

## Known UI issue

Currently, upon pressing the "LOGS" tab in pod view by users who don't have an explicit allow get logs policy, the red "unable to load data: Internal error" is received in the bottom of the screen, and "Failed to load data, please try again" is displayed.

## Test repo-server with its new dedicated Service Account

As a security enhancement, the argocd-repo-server Deployment uses its own Service Account instead of `default`.

If you have a custom environment that might depend on repo-server using the `default` Service Account (such as a plugin
that uses the Service Account for auth), be sure to test before deploying the 2.4 upgrade to production.

## Plugins

### Remove the shared volume from any sidecar plugins

As a security enhancement, [sidecar plugins](../../user-guide/config-management-plugins.md#option-2-configure-plugin-via-sidecar)
no longer share the /tmp directory with the repo-server.

If you have one or more sidecar plugins enabled, replace the /tmp volume mount for each sidecar to use a volume specific 
to each plugin.

```yaml
apiVersion: apps/v1
kind: Deployment
metadata:
  name: argocd-repo-server
spec:
  template:
    spec:
      containers:
      - name: your-plugin-name
        volumeMounts:
        - mountPath: /tmp
          name: your-plugin-name-tmp
      volumes:
        # Add this volume.
        - name: your-plugin-name-tmp
          emptyDir: {}
```

### Update plugins to use newly-prefixed environment variables

If you use plugins that depend on user-supplied environment variables, then they must be updated to be compatible with
Argo CD 2.4. Here is an example of user-supplied environment variables in the `plugin` section of an Application spec:

```yaml
apiVersion: argoproj.io/v1alpha1
kind: Application
spec:
  source:
    plugin:
      env:
        - name: FOO
          value: bar
```

Going forward, all user-supplied environment variables will be prefixed with `ARGOCD_ENV_` before being sent to the 
plugin's `init`, `generate`, or `discover` commands. This prevents users from setting potentially-sensitive environment
variables.

If you have written a custom plugin which handles user-provided environment variables, update it to handle the new
prefix.

If you use a third-party plugin which does not explicitly advertise Argo CD 2.4 support, it might not handle the 
prefixed environment variables. Open an issue with the plugin's authors and confirm support before upgrading to Argo CD 
2.4.

### Confirm sidecar plugins have all necessary environment variables

A bug in < 2.4 caused `init` and `generate` commands to receive environment variables from the main repo-server
container, taking precedence over environment variables from the plugin's sidecar.

Starting in 2.4, sidecar plugins will not receive environment variables from the main repo-server container. Make sure
that any environment variables necessary for the sidecar plugin to function are set on the sidecar plugin.

argocd-cm plugins will continue to receive environment variables from the main repo-server container.
